/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2016-07-02 08:58:20 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `slug` varchar(30) NOT NULL,
  `description` text NOT NULL,
  `thumbnail` longtext NOT NULL,
  `thumbwidth` int(11) DEFAULT NULL,
  `thumbheight` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery_images` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `imagePath` longtext NOT NULL,
  `title` varchar(50) NOT NULL,
  `description` longtext NOT NULL,
  `sortOrder` int(11) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gallery_albums` (
  `album_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `album_name` text,
  `author` varchar(100) DEFAULT NULL,
  `album_date` date DEFAULT NULL,
  `description` text,
  `album_order` int(10) DEFAULT NULL,
  PRIMARY KEY (`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master` (
  `gallery_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) DEFAULT NULL,
  `type` varchar(100) NOT NULL,
  `sorting_order` int(10) NOT NULL,
  PRIMARY KEY (`gallery_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master_licensing` (
  `licensing_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(10) NOT NULL,
  `type` varchar(100) NOT NULL,
  `url` text NOT NULL,
  `api_key` text,
  `order_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`licensing_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master_meta` (
  `gallery_meta_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gallery_id` int(10) NOT NULL,
  `gallery_meta_key` varchar(100) NOT NULL,
  `gallery_meta_value` longtext NOT NULL,
  PRIMARY KEY (`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master_settings` (
  `setting_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_pics` (
  `pic_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `album_id` int(10) unsigned NOT NULL,
  `title` text,
  `description` text,
  `thumbnail_url` text NOT NULL,
  `sorting_order` int(20) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `video` int(10) NOT NULL,
  `tags` text,
  `pic_name` text NOT NULL,
  `album_cover` int(1) NOT NULL,
  PRIMARY KEY (`pic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_settings` (
  `setting_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `albumdesc` mediumtext COLLATE utf8mb4_unicode_ci,
  `sortorder` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` mediumtext COLLATE utf8mb4_unicode_ci,
  `title` mediumtext COLLATE utf8mb4_unicode_ci,
  `galdesc` mediumtext COLLATE utf8mb4_unicode_ci,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `author` bigint(20) NOT NULL DEFAULT '0',
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `galleryid` bigint(20) NOT NULL DEFAULT '0',
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `alttext` mediumtext COLLATE utf8mb4_unicode_ci,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT '0',
  `sortorder` bigint(20) NOT NULL DEFAULT '0',
  `meta_data` longtext COLLATE utf8mb4_unicode_ci,
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=1133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1263 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=437 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Mr WordPress", "", "https://wordpress.org/", "", "2016-06-21 09:05:54", "2016-06-21 07:05:54", "Hi, das ist ein Kommentar.\nUm einen Kommentar zu löschen, melde dich einfach an und gehe zur Übersicht der Beiträge oder Kommentare. Dort hast du die Möglichkeit, sie zu löschen oder zu bearbeiten.", "0", "post-trashed", "", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("14", "20160702_meinkleineryogakurs", "5777820f180fc8846160702085751", "20", "2016-07-02 08:58:20", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-02 08:57:51\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.5.49\";s:10:\"VersionPHP\";s:15:\"5.4.45-0+deb7u4\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:14;s:4:\"Name\";s:28:\"20160702_meinkleineryogakurs\";s:4:\"Hash\";s:29:\"5777820f180fc8846160702085751\";s:8:\"NameHash\";s:58:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/var/www/clients/client9/web13/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://student11.wpstore.d-hosting.de/wp-snapshots/\";s:8:\"ScanFile\";s:68:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:70:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/var/www/clients/client9/web13/web\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-02 08:57:51\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.5.49\";s:10:\"VersionPHP\";s:15:\"5.4.45-0+deb7u4\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20160702_meinkleineryogakurs\";s:4:\"Hash\";s:29:\"5777820f180fc8846160702085751\";s:8:\"NameHash\";s:58:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/var/www/clients/client9/web13/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://student11.wpstore.d-hosting.de/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:72:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:71:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_gallery_master_licensing */
INSERT INTO `wp_gallery_master_licensing` VALUES("1", "1.0", "Gallery Master", "http://student11.wpstore.d-hosting.de", NULL, NULL);

/* INSERT TABLE DATA: wp_gallery_settings */
INSERT INTO `wp_gallery_settings` VALUES("1", "thumbnails_custom_enable", "1");
INSERT INTO `wp_gallery_settings` VALUES("2", "thumbnails_width", "160");
INSERT INTO `wp_gallery_settings` VALUES("3", "thumbnails_height", "120");
INSERT INTO `wp_gallery_settings` VALUES("4", "thumbnails_opacity", "1");
INSERT INTO `wp_gallery_settings` VALUES("5", "thumbnails_border_size", "2");
INSERT INTO `wp_gallery_settings` VALUES("6", "thumbnails_border_radius", "2");
INSERT INTO `wp_gallery_settings` VALUES("7", "thumbnails_border_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("8", "margin_btw_thumbnails", "5");
INSERT INTO `wp_gallery_settings` VALUES("9", "thumbnail_text_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("10", "thumbnail_text_align", "center");
INSERT INTO `wp_gallery_settings` VALUES("11", "thumbnail_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("12", "heading_font_size", "16");
INSERT INTO `wp_gallery_settings` VALUES("13", "text_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("14", "thumbnail_desc_length", "60");
INSERT INTO `wp_gallery_settings` VALUES("15", "cover_custom_enable", "1");
INSERT INTO `wp_gallery_settings` VALUES("16", "cover_thumbnail_width", "160");
INSERT INTO `wp_gallery_settings` VALUES("17", "cover_thumbnail_height", "120");
INSERT INTO `wp_gallery_settings` VALUES("18", "cover_thumbnail_opacity", "1");
INSERT INTO `wp_gallery_settings` VALUES("19", "cover_thumbnail_border_size", "2");
INSERT INTO `wp_gallery_settings` VALUES("20", "cover_thumbnail_border_radius", "2");
INSERT INTO `wp_gallery_settings` VALUES("21", "cover_thumbnail_border_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("22", "margin_btw_cover_thumbnails", "5");
INSERT INTO `wp_gallery_settings` VALUES("23", "album_text_align", "left");
INSERT INTO `wp_gallery_settings` VALUES("24", "album_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("25", "album_heading_font_size", "16");
INSERT INTO `wp_gallery_settings` VALUES("26", "album_text_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("27", "album_desc_length", "400");
INSERT INTO `wp_gallery_settings` VALUES("28", "lightbox_type", "pretty_photo");
INSERT INTO `wp_gallery_settings` VALUES("29", "lightbox_overlay_opacity", "0.6");
INSERT INTO `wp_gallery_settings` VALUES("30", "lightbox_overlay_border_size", "5");
INSERT INTO `wp_gallery_settings` VALUES("31", "lightbox_overlay_border_radius", "5");
INSERT INTO `wp_gallery_settings` VALUES("32", "lightbox_text_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("33", "lightbox_overlay_border_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("34", "lightbox_inline_bg_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("35", "lightbox_overlay_bg_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("36", "lightbox_fade_in_time", "500");
INSERT INTO `wp_gallery_settings` VALUES("37", "lightbox_fade_out_time", "500");
INSERT INTO `wp_gallery_settings` VALUES("38", "lightbox_text_align", "left");
INSERT INTO `wp_gallery_settings` VALUES("39", "lightbox_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("40", "lightbox_heading_font_size", "16");
INSERT INTO `wp_gallery_settings` VALUES("41", "lightbox_text_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("42", "facebook_comments", "0");
INSERT INTO `wp_gallery_settings` VALUES("43", "social_sharing", "0");
INSERT INTO `wp_gallery_settings` VALUES("44", "image_title_setting", "1");
INSERT INTO `wp_gallery_settings` VALUES("45", "image_desc_setting", "1");
INSERT INTO `wp_gallery_settings` VALUES("46", "autoplay_setting", "0");
INSERT INTO `wp_gallery_settings` VALUES("47", "slide_interval", "5");
INSERT INTO `wp_gallery_settings` VALUES("48", "pagination_setting", "0");
INSERT INTO `wp_gallery_settings` VALUES("49", "images_per_page", "10");
INSERT INTO `wp_gallery_settings` VALUES("50", "filters_setting", "0");
INSERT INTO `wp_gallery_settings` VALUES("51", "filter_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("52", "filter_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("53", "back_button_text", "Back to Albums");
INSERT INTO `wp_gallery_settings` VALUES("54", "album_click_text", "Click to View Album");
INSERT INTO `wp_gallery_settings` VALUES("55", "album_text_color", "#C0C0C0");
INSERT INTO `wp_gallery_settings` VALUES("56", "button_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("57", "button_text_color", "#CCCCCC");
INSERT INTO `wp_gallery_settings` VALUES("58", "filters_color", "#2a83ed");
INSERT INTO `wp_gallery_settings` VALUES("59", "filters_text_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("60", "album_seperator", "1");
INSERT INTO `wp_gallery_settings` VALUES("61", "back_button_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("62", "back_button_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("63", "admin_full_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("64", "admin_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("65", "admin_write_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("66", "editor_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("67", "editor_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("68", "editor_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("69", "author_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("70", "author_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("71", "author_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("72", "contributor_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("73", "contributor_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("74", "contributor_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("75", "subscriber_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("76", "subscriber_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("77", "subscriber_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("78", "language_direction", "inherit");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://student11.wpstore.d-hosting.de", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://student11.wpstore.d-hosting.de", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "mein kleiner yogakurs", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "freefeeling@web.de", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j. F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j. F Y G:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:89:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=6&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:5:{i:0;s:29:\"antispam-bee/antispam_bee.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:78:\"/var/www/clients/client9/web13/web/wp-content/plugins/simple-lightbox/main.php\";i:1;s:73:\"/var/www/clients/client9/web13/web/wp-content/themes/tiny-forge/style.css\";i:2;s:83:\"/var/www/clients/client9/web13/web/wp-content/plugins/antispam-bee/antispam_bee.php\";i:4;s:98:\"/var/www/clients/client9/web13/web/wp-content/plugins/nextgen-cooliris-gallery/cooliris-plugin.php\";i:5;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "tiny-framework", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "tiny-framework", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "36686", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:3:{s:29:\"antispam-bee/antispam_bee.php\";a:2:{i:0;s:12:\"Antispam_Bee\";i:1;s:9:\"uninstall\";}s:29:\"gallery-bank/gallery-bank.php\";s:40:\"plugin_uninstall_script_for_gallery_bank\";s:33:\"gallery-master/gallery-master.php\";s:42:\"plugin_uninstall_script_for_gallery_master\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Europe/Berlin", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "12", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "6", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "36686", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:72:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:24:\"NextGEN Gallery overview\";b:1;s:19:\"NextGEN Use TinyMCE\";b:1;s:21:\"NextGEN Upload images\";b:1;s:22:\"NextGEN Manage gallery\";b:1;s:19:\"NextGEN Manage tags\";b:1;s:29:\"NextGEN Manage others gallery\";b:1;s:18:\"NextGEN Edit album\";b:1;s:20:\"NextGEN Change style\";b:1;s:22:\"NextGEN Change options\";b:1;s:24:\"NextGEN Attach Interface\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "WPLANG", "de_DE", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:12:\"categories-2\";i:1;s:8:\"search-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:4:{i:1467451808;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1467486355;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1467529598;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("113", "can_compress_scripts", "1", "yes");
INSERT INTO `wp_options` VALUES("126", "recently_activated", "a:15:{s:24:\"simple-lightbox/main.php\";i:1467363743;s:55:\"final-tiles-grid-gallery-lite/FinalTilesGalleryLite.php\";i:1467116769;s:55:\"lazyest-gallery-hide-menu/lazyest-gallery-hide-menu.php\";i:1467108965;s:51:\"simple-lightbox-gallery/simple-lightbox-gallery.php\";i:1467106176;s:51:\"wiloke-gallery-lightbox/wiloke-gallery-lightbox.php\";i:1467105957;s:35:\"wp-easy-gallery/wp-easy-gallery.php\";i:1467105877;s:29:\"nextgen-gallery/nggallery.php\";i:1467104502;s:27:\"gallery-pro/gallery-pro.php\";i:1467104218;s:44:\"nextgen-cooliris-gallery/cooliris-plugin.php\";i:1467103716;s:33:\"gallery-master/gallery-master.php\";i:1467103699;s:28:\"cpm-gallery/code_gallery.php\";i:1467102660;s:29:\"gallery-bank/gallery-bank.php\";i:1467100684;s:31:\"gallery-theme/gallery-theme.php\";i:1467100049;s:21:\"fotorama/fotorama.php\";i:1467099867;s:61:\"all-meta-stats-yoast-seo-addon/meta-stats-yoast-seo-addon.php\";i:1467031842;}", "yes");
INSERT INTO `wp_options` VALUES("127", "wpcf7", "a:2:{s:7:\"version\";s:5:\"4.4.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1466508362;s:7:\"version\";s:5:\"4.4.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("130", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1466501299;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("131", "current_theme", "Tiny Framework", "yes");
INSERT INTO `wp_options` VALUES("132", "theme_mods_tiny-forge", "a:9:{i:0;b:0;s:16:\"header_textcolor\";s:6:\"751cb5\";s:16:\"background_color\";s:6:\"e5e1f2\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:26;}s:12:\"header_image\";s:73:\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:114;s:3:\"url\";s:73:\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg\";s:13:\"thumbnail_url\";s:73:\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg\";s:6:\"height\";i:1428;s:5:\"width\";i:4288;}s:16:\"background_image\";s:0:\"\";s:14:\"notice-dismiss\";b:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467270684;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:12:\"categories-2\";i:1;s:8:\"search-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("133", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("141", "theme_mods_darkorange", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:26;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467270585;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"primary\";a:2:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-2\";}s:8:\"homepage\";N;s:12:\"footer-right\";N;s:11:\"footer-left\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("142", "widget_hemingway_dribbble_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("143", "widget_hemingway_video_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("144", "theme_mods_sela", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1466504781;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";N;s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;s:9:\"sidebar-7\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("147", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("159", "theme_mods_solon", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1466504843;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("209", "widget_sensiblewp_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("210", "widget_sensiblewp_video_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("241", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:18:\"freefeeling@web.de\";s:7:\"version\";s:5:\"4.5.3\";s:9:\"timestamp\";i:1466664493;}", "yes");
INSERT INTO `wp_options` VALUES("295", "duplicator_version_plugin", "1.1.12", "yes");
INSERT INTO `wp_options` VALUES("334", "antispam_bee", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("466", "wpseo", "a:14:{s:14:\"blocking_files\";a:0:{}s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:5:\"3.3.2\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("467", "wpseo_permalinks", "a:9:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("468", "wpseo_titles", "a:55:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:23:\"content-analysis-active\";b:1;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Autor auf %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:67:\"Du hast nach %%searchphrase%% gesucht %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:48:\"Seite wurde nicht gefunden. %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:52:\"%%term_title%% Archive %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:52:\"%%term_title%% Archive %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:52:\"%%term_title%% Archive %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("469", "wpseo_social", "a:20:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"99e6c0a5c2b00f5bc7765c3cf18e1e2d\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("470", "wpseo_rss", "a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:58:\"Der Beitrag %%POSTLINK%% erschien zuerst auf %%BLOGLINK%%.\";}", "yes");
INSERT INTO `wp_options` VALUES("471", "wpseo_internallinks", "a:10:{s:20:\"breadcrumbs-404crumb\";s:38:\"Fehler 404: Seite wurde nicht gefunden\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archive für\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:10:\"Startseite\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"Du suchtest nach\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("472", "wpseo_xml", "a:16:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("473", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("474", "wpseo_sitemap_1_cache_validator", "3liYP", "no");
INSERT INTO `wp_options` VALUES("475", "wpseo_sitemap_page_cache_validator", "3liYR", "no");
INSERT INTO `wp_options` VALUES("476", "wpseo_sitemap_revision_cache_validator", "5WXSN", "no");
INSERT INTO `wp_options` VALUES("511", "wpseo_sitemap_nav_menu_cache_validator", "2Nogr", "no");
INSERT INTO `wp_options` VALUES("512", "wpseo_sitemap_nav_menu_item_cache_validator", "2Nogt", "no");
INSERT INTO `wp_options` VALUES("522", "wpseo_sitemap_28_cache_validator", "2WHDQ", "no");
INSERT INTO `wp_options` VALUES("523", "wpseo_sitemap_29_cache_validator", "2WHE6", "no");
INSERT INTO `wp_options` VALUES("524", "wpseo_sitemap_87_cache_validator", "2WHEl", "no");
INSERT INTO `wp_options` VALUES("525", "wpseo_sitemap_22_cache_validator", "2WHEp", "no");
INSERT INTO `wp_options` VALUES("526", "wpseo_sitemap_19_cache_validator", "2WHEt", "no");
INSERT INTO `wp_options` VALUES("527", "wpseo_sitemap_137_cache_validator", "2WHEx", "no");
INSERT INTO `wp_options` VALUES("533", "wpseo_sitemap_wpcf7_contact_form_cache_validator", "2YyQA", "no");
INSERT INTO `wp_options` VALUES("548", "wpseo_sitemap_cache_validator_global", "33Os3", "no");
INSERT INTO `wp_options` VALUES("551", "wpseo_sitemap_category_cache_validator", "4IDDP", "no");
INSERT INTO `wp_options` VALUES("556", "gallery-bank-updation-check-url", "http://tech-banker.com/wp-admin/admin-ajax.php", "yes");
INSERT INTO `wp_options` VALUES("557", "gallery-bank-pro-edition", "3.1", "yes");
INSERT INTO `wp_options` VALUES("558", "gallery-bank-automatic_update", "1", "yes");
INSERT INTO `wp_options` VALUES("562", "wpseo_sitemap_post_cache_validator", "4KT2u", "no");
INSERT INTO `wp_options` VALUES("574", "wpseo_sitemap_attachment_cache_validator", "2D6Gx", "no");
INSERT INTO `wp_options` VALUES("576", "gallery-master-updation-check-url", "http://tech-prodigy.org/wp-admin/admin-ajax.php", "yes");
INSERT INTO `wp_options` VALUES("577", "gallery-master-key", "1.0", "yes");
INSERT INTO `wp_options` VALUES("582", "easy_gallery_db_version", "1.1", "yes");
INSERT INTO `wp_options` VALUES("583", "wp_easy_gallery_defaults", "a:12:{s:7:\"version\";s:4:\"free\";s:15:\"thumbnail_width\";s:4:\"auto\";s:16:\"thumbnail_height\";s:4:\"auto\";s:12:\"hide_overlay\";s:5:\"false\";s:11:\"hide_social\";s:5:\"false\";s:12:\"custom_style\";s:0:\"\";s:17:\"use_default_style\";s:4:\"true\";s:11:\"drop_shadow\";s:4:\"true\";s:12:\"display_mode\";s:15:\"wp_easy_gallery\";s:11:\"num_columns\";i:3;s:17:\"show_gallery_name\";s:4:\"true\";s:22:\"gallery_name_alignment\";s:4:\"left\";}", "yes");
INSERT INTO `wp_options` VALUES("596", "widget_ngg-images", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("597", "widget_ngg-mrssw", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("598", "widget_slideshow", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("599", "ngg_transient_groups", "a:3:{s:9:\"__counter\";i:3;s:3:\"MVC\";a:2:{s:2:\"id\";i:2;s:7:\"enabled\";b:1;}s:15:\"col_in_wp_posts\";a:2:{s:2:\"id\";i:3;s:7:\"enabled\";b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("600", "ngg_options", "a:69:{s:11:\"gallerypath\";s:19:\"wp-content/gallery/\";s:11:\"wpmuCSSfile\";s:13:\"nggallery.css\";s:9:\"wpmuStyle\";b:0;s:9:\"wpmuRoles\";b:0;s:16:\"wpmuImportFolder\";b:0;s:13:\"wpmuZipUpload\";b:0;s:14:\"wpmuQuotaCheck\";b:0;s:17:\"datamapper_driver\";s:22:\"custom_post_datamapper\";s:21:\"gallerystorage_driver\";s:25:\"ngglegacy_gallery_storage\";s:20:\"maximum_entity_count\";i:500;s:17:\"router_param_slug\";s:9:\"nggallery\";s:22:\"router_param_separator\";s:2:\"--\";s:19:\"router_param_prefix\";s:0:\"\";s:9:\"deleteImg\";b:1;s:9:\"swfUpload\";b:1;s:13:\"usePermalinks\";b:0;s:13:\"permalinkSlug\";s:9:\"nggallery\";s:14:\"graphicLibrary\";s:2:\"gd\";s:14:\"imageMagickDir\";s:15:\"/usr/local/bin/\";s:11:\"useMediaRSS\";b:0;s:18:\"galleries_in_feeds\";b:0;s:12:\"activateTags\";i:0;s:10:\"appendType\";s:4:\"tags\";s:9:\"maxImages\";i:7;s:14:\"relatedHeading\";s:24:\"<h3>Related Images:</h3>\";s:10:\"thumbwidth\";i:240;s:11:\"thumbheight\";i:160;s:8:\"thumbfix\";b:1;s:12:\"thumbquality\";i:100;s:8:\"imgWidth\";i:800;s:9:\"imgHeight\";i:600;s:10:\"imgQuality\";i:100;s:9:\"imgBackup\";b:1;s:13:\"imgAutoResize\";b:0;s:9:\"galImages\";s:2:\"20\";s:17:\"galPagedGalleries\";i:0;s:10:\"galColumns\";i:0;s:12:\"galShowSlide\";b:1;s:12:\"galTextSlide\";s:22:\"[Zeige eine Slideshow]\";s:14:\"galTextGallery\";s:22:\"[Zeige Vorschaubilder]\";s:12:\"galShowOrder\";s:7:\"gallery\";s:7:\"galSort\";s:9:\"sortorder\";s:10:\"galSortDir\";s:3:\"ASC\";s:10:\"galNoPages\";b:1;s:13:\"galImgBrowser\";i:0;s:12:\"galHiddenImg\";i:0;s:10:\"galAjaxNav\";i:0;s:11:\"thumbEffect\";s:8:\"fancybox\";s:9:\"thumbCode\";s:41:\"class=\"ngg-fancybox\" rel=\"%GALLERY_NAME%\"\";s:18:\"thumbEffectContext\";s:14:\"nextgen_images\";s:5:\"wmPos\";s:8:\"botRight\";s:6:\"wmXpos\";i:5;s:6:\"wmYpos\";i:5;s:6:\"wmType\";s:5:\"image\";s:6:\"wmPath\";s:0:\"\";s:6:\"wmFont\";s:9:\"arial.ttf\";s:6:\"wmSize\";i:10;s:6:\"wmText\";s:21:\"mein kleiner yogakurs\";s:7:\"wmColor\";s:6:\"000000\";s:8:\"wmOpaque\";s:3:\"100\";s:7:\"slideFX\";s:4:\"fade\";s:7:\"irWidth\";i:600;s:8:\"irHeight\";i:400;s:12:\"irRotatetime\";i:10;s:11:\"activateCSS\";i:1;s:7:\"CSSfile\";s:13:\"nggallery.css\";s:28:\"always_enable_frontend_logic\";b:0;s:22:\"dynamic_thumbnail_slug\";s:13:\"nextgen-image\";s:23:\"dynamic_stylesheet_slug\";s:12:\"nextgen-dcss\";}", "yes");
INSERT INTO `wp_options` VALUES("602", "photocrati_auto_update_admin_update_list", "", "yes");
INSERT INTO `wp_options` VALUES("603", "photocrati_auto_update_admin_check_date", "", "yes");
INSERT INTO `wp_options` VALUES("604", "ngg_db_version", "1.8.1", "yes");
INSERT INTO `wp_options` VALUES("607", "pope_module_list", "a:34:{i:0;s:17:\"photocrati-fs|0.4\";i:1;s:19:\"photocrati-i18n|0.1\";i:2;s:25:\"photocrati-validation|0.1\";i:3;s:21:\"photocrati-router|0.7\";i:4;s:32:\"photocrati-wordpress_routing|0.6\";i:5;s:23:\"photocrati-security|0.2\";i:6;s:31:\"photocrati-nextgen_settings|0.9\";i:7;s:18:\"photocrati-mvc|0.6\";i:8;s:19:\"photocrati-ajax|0.8\";i:9;s:25:\"photocrati-datamapper|0.9\";i:10;s:30:\"photocrati-nextgen-legacy|0.14\";i:11;s:28:\"photocrati-nextgen-data|0.10\";i:12;s:33:\"photocrati-dynamic_thumbnails|0.6\";i:13;s:28:\"photocrati-nextgen_admin|0.9\";i:14;s:39:\"photocrati-nextgen_gallery_display|0.13\";i:15;s:34:\"photocrati-frame_communication|0.4\";i:16;s:30:\"photocrati-attach_to_post|0.11\";i:17;s:38:\"photocrati-nextgen_addgallery_page|0.6\";i:18;s:36:\"photocrati-nextgen_other_options|0.8\";i:19;s:33:\"photocrati-nextgen_pagination|0.3\";i:20;s:33:\"photocrati-dynamic_stylesheet|0.3\";i:21;s:34:\"photocrati-nextgen_pro_upgrade|0.4\";i:22;s:20:\"photocrati-cache|0.2\";i:23;s:24:\"photocrati-lightbox|0.15\";i:24;s:38:\"photocrati-nextgen_basic_templates|0.5\";i:25;s:37:\"photocrati-nextgen_basic_gallery|0.13\";i:26;s:42:\"photocrati-nextgen_basic_imagebrowser|0.10\";i:27;s:39:\"photocrati-nextgen_basic_singlepic|0.11\";i:28;s:38:\"photocrati-nextgen_basic_tagcloud|0.11\";i:29;s:35:\"photocrati-nextgen_basic_album|0.10\";i:30;s:21:\"photocrati-widget|0.5\";i:31;s:33:\"photocrati-third_party_compat|0.4\";i:32;s:29:\"photocrati-nextgen_xmlrpc|0.4\";i:33;s:20:\"photocrati-wpcli|0.1\";}", "yes");
INSERT INTO `wp_options` VALUES("610", "wpseo_sitemap_display_type_cache_validator", "3lKEg", "no");
INSERT INTO `wp_options` VALUES("653", "FinalTiles_gallery_options", "a:42:{s:6:\"margin\";i:10;s:11:\"defaultSize\";s:6:\"medium\";s:5:\"width\";s:4:\"100%\";s:12:\"minTileWidth\";s:3:\"100\";s:12:\"gridCellSize\";s:2:\"25\";s:8:\"lightbox\";s:8:\"lightbox\";s:18:\"recentPostsCaption\";s:5:\"title\";s:11:\"captionIcon\";s:4:\"zoom\";s:12:\"reverseOrder\";b:0;s:16:\"captionIconColor\";s:7:\"#ffffff\";s:22:\"captionBackgroundColor\";s:7:\"#000000\";s:12:\"captionColor\";s:7:\"#ffffff\";s:21:\"captionEffectDuration\";i:250;s:14:\"captionOpacity\";i:80;s:10:\"borderSize\";i:0;s:12:\"borderRadius\";i:0;s:10:\"shadowSize\";i:0;s:15:\"imageSizeFactor\";i:90;s:30:\"imageSizeFactorTabletLandscape\";i:80;s:29:\"imageSizeFactorTabletPortrait\";i:70;s:29:\"imageSizeFactorPhoneLandscape\";i:60;s:28:\"imageSizeFactorPhonePortrait\";i:50;s:21:\"imageSizeFactorCustom\";s:0:\"\";s:13:\"enlargeImages\";s:1:\"T\";s:16:\"wp_field_caption\";s:11:\"description\";s:15:\"captionBehavior\";s:6:\"hidden\";s:17:\"captionFullHeight\";s:1:\"T\";s:12:\"captionEmpty\";s:4:\"hide\";s:13:\"captionEffect\";s:4:\"fade\";s:13:\"captionEasing\";s:6:\"linear\";s:21:\"captionMobileBehavior\";s:7:\"desktop\";s:12:\"scrollEffect\";s:4:\"none\";s:9:\"hoverZoom\";i:100;s:13:\"hoverRotation\";i:0;s:6:\"source\";s:6:\"images\";s:5:\"delay\";i:0;s:15:\"socialIconColor\";s:7:\"#ffffff\";s:7:\"support\";s:1:\"F\";s:11:\"loadedScale\";i:100;s:12:\"loadedRotate\";i:0;s:12:\"loadedHSlide\";i:0;s:12:\"loadedVSlide\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("661", "slb_version", "2.5.3", "yes");
INSERT INTO `wp_options` VALUES("662", "slb_options", "a:25:{s:7:\"enabled\";b:1;s:12:\"enabled_home\";b:1;s:12:\"enabled_post\";b:1;s:12:\"enabled_page\";b:1;s:15:\"enabled_archive\";b:1;s:14:\"enabled_widget\";b:0;s:11:\"group_links\";b:1;s:10:\"group_post\";b:1;s:13:\"group_gallery\";b:0;s:12:\"group_widget\";b:0;s:10:\"ui_autofit\";b:1;s:10:\"ui_animate\";b:1;s:19:\"slideshow_autostart\";b:1;s:18:\"slideshow_duration\";s:1:\"6\";s:10:\"group_loop\";b:1;s:18:\"ui_overlay_opacity\";s:3:\"0.8\";s:16:\"ui_title_default\";b:0;s:11:\"txt_loading\";s:7:\"Loading\";s:9:\"txt_close\";s:5:\"Close\";s:12:\"txt_nav_next\";s:4:\"Next\";s:12:\"txt_nav_prev\";s:8:\"Previous\";s:19:\"txt_slideshow_start\";s:15:\"Start slideshow\";s:18:\"txt_slideshow_stop\";s:14:\"Stop slideshow\";s:16:\"txt_group_status\";s:25:\"Item %current% of %total%\";s:13:\"theme_default\";s:11:\"slb_default\";}", "yes");
INSERT INTO `wp_options` VALUES("670", "responsive_lightbox_lite_version", "1.0.0", "yes");
INSERT INTO `wp_options` VALUES("671", "responsive_lightbox_lite_settings", "a:10:{s:6:\"script\";s:13:\"nivo_lightbox\";s:8:\"selector\";s:8:\"lightbox\";s:9:\"galleries\";b:1;s:6:\"videos\";b:1;s:11:\"image_links\";b:1;s:17:\"images_as_gallery\";b:0;s:19:\"deactivation_delete\";b:0;s:13:\"loading_place\";s:6:\"header\";s:20:\"enable_custom_events\";b:0;s:13:\"custom_events\";s:12:\"ajaxComplete\";}", "no");
INSERT INTO `wp_options` VALUES("697", "wpseo_sitemap_234_cache_validator", "5M7uo", "no");
INSERT INTO `wp_options` VALUES("698", "wpseo_sitemap_237_cache_validator", "5M7ur", "no");
INSERT INTO `wp_options` VALUES("729", "wpseo_sitemap_248_cache_validator", "2SOcH", "no");
INSERT INTO `wp_options` VALUES("761", "wpseo_sitemap_259_cache_validator", "2T8M6", "no");
INSERT INTO `wp_options` VALUES("781", "wpseo_sitemap_264_cache_validator", "2X1J9", "no");
INSERT INTO `wp_options` VALUES("791", "wpseo_sitemap_269_cache_validator", "2YMrF", "no");
INSERT INTO `wp_options` VALUES("807", "wpseo_sitemap_279_cache_validator", "39u9d", "no");
INSERT INTO `wp_options` VALUES("810", "wpseo_sitemap_275_cache_validator", "3aYJw", "no");
INSERT INTO `wp_options` VALUES("815", "wpseo_sitemap_285_cache_validator", "eA24", "no");
INSERT INTO `wp_options` VALUES("820", "wpseo_taxonomy_meta", "a:1:{s:8:\"category\";a:1:{i:10;a:1:{s:13:\"wpseo_linkdex\";s:2:\"15\";}}}", "yes");
INSERT INTO `wp_options` VALUES("823", "wpseo_sitemap_290_cache_validator", "3gFbB", "no");
INSERT INTO `wp_options` VALUES("830", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("831", "wpseo_sitemap_296_cache_validator", "3kBn8", "no");
INSERT INTO `wp_options` VALUES("835", "wpseo_sitemap_303_cache_validator", "3mTCM", "no");
INSERT INTO `wp_options` VALUES("861", "wpseo_sitemap_247_cache_validator", "4sz4U", "no");
INSERT INTO `wp_options` VALUES("874", "wpseo_sitemap_213_cache_validator", "4E7dQ", "no");
INSERT INTO `wp_options` VALUES("911", "wpseo_sitemap_311_cache_validator", "24BNL", "no");
INSERT INTO `wp_options` VALUES("991", "theme_mods_tiny-framework", "a:6:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:26;}s:12:\"header_image\";s:73:\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:114;s:3:\"url\";s:73:\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg\";s:13:\"thumbnail_url\";s:73:\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg\";s:6:\"height\";i:1428;s:5:\"width\";i:4288;}s:16:\"header_textcolor\";s:6:\"7609e2\";s:16:\"background_color\";s:6:\"d1c9e8\";}", "yes");
INSERT INTO `wp_options` VALUES("1062", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.12\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1087", "_transient_timeout_plugin_slugs", "1467450151", "no");
INSERT INTO `wp_options` VALUES("1088", "_transient_plugin_slugs", "a:6:{i:0;s:29:\"antispam-bee/antispam_bee.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";i:4;s:24:\"simple-lightbox/main.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `wp_options` VALUES("1091", "_site_transient_timeout_browser_551db59e6025301116bdd9bdea784024", "1467968514", "yes");
INSERT INTO `wp_options` VALUES("1092", "_site_transient_browser_551db59e6025301116bdd9bdea784024", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"47.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("1107", "_transient_is_multi_author", "0", "yes");
INSERT INTO `wp_options` VALUES("1108", "_transient_tinyframework_categories", "2", "yes");
INSERT INTO `wp_options` VALUES("1109", "_site_transient_timeout_theme_roots", "1467451590", "yes");
INSERT INTO `wp_options` VALUES("1110", "_site_transient_theme_roots", "a:5:{s:22:\"tiny-framework - kopie\";s:7:\"/themes\";s:14:\"tiny-framework\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("1111", "_transient_timeout_wpseo-dashboard-totals", "1467536201", "no");
INSERT INTO `wp_options` VALUES("1112", "_transient_wpseo-dashboard-totals", "a:1:{i:1;a:1:{i:3;a:5:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"title\";s:35:\"Beiträge ohne Fokus-Schlüsselwort\";s:5:\"class\";s:15:\"wpseo-glance-na\";s:10:\"icon_class\";s:2:\"na\";s:5:\"count\";s:2:\"18\";}}}", "no");
INSERT INTO `wp_options` VALUES("1113", "_transient_timeout_feed_e5132d2944a7be60661ee809629a6d9c", "1467493009", "no");
INSERT INTO `wp_options` VALUES("1114", "_transient_feed_e5132d2944a7be60661ee809629a6d9c", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Releases – Deutsch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://de.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress auf Deutsch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jun 2016 18:03:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"de-DE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.6-beta1-37941\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.6 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://de.wordpress.org/2016/06/wordpress-4-6-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jun 2016 05:45:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1912\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"Die erste Beta-Version von WordPress 4.6 ist nun verfügbar. Wie der Name schon sagt, handelt es sich dabei nicht um die finale Version und sollte daher nur in einer lokalen oder abgesicherten Testumgebung installiert werden. WordPress 4.6 Beta 1 kann entweder über das Plugin WordPress Beta Tester installiert oder als Zip-Archiv heruntergeladen werden. Es ist [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5176:\"<p>Die erste<a href=\"https://wordpress.org/news/2016/06/wordpress-4-6-beta-1/\"> Beta-Version von WordPress 4.6</a> ist nun verfügbar. Wie der Name schon sagt, handelt es sich dabei nicht um die finale Version und sollte daher nur in einer lokalen oder abgesicherten Testumgebung installiert werden. WordPress 4.6 Beta 1 kann entweder über das Plugin<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> installiert oder als<a href=\"https://wordpress.org/wordpress-4.6-beta1.zip\"> Zip-Archiv</a> heruntergeladen werden.</p>\n<p><span id=\"more-1912\"></span></p>\n<p>Es ist geplant, die finale Version am 16. August zu veröffentlichen, aber bis dahin benötigen die Entwickler eure Hilfe beim Testen der Änderungen, an denen sie derzeit arbeiten:</p>\n<ul>\n<li><b>Shiny Updates v2</b> (<a href=\"https://core.trac.wordpress.org/changeset/37714\">[37714]</a>) – <a href=\"https://make.wordpress.org/core/features/shiny-updates/\">Shiny Updates</a> ersetzt den Update-Prozess mit einer einfacheren Methode beim Installieren, Aktualisieren und Entfernen von Plugins und Themes.</li>\n<li><b>Native Fonts im Admin</b> (<a href=\"https://core.trac.wordpress.org/ticket/36753\">#36753</a>) – Schnellere Ladezeiten insbesondere beim Offline-Arbeiten ohne Abhängigkeit von Drittanbietern.</li>\n<li><b>Verbesserungen am Editor </b>– Höhere Zuverlässigkeit des Recovery-Modus (<a href=\"https://core.trac.wordpress.org/ticket/37025\">#37025</a>) und die Erkennung defekter URLs während sie eingetippt werden (<a href=\"https://core.trac.wordpress.org/ticket/36638\">#36638</a>).</li>\n</ul>\n<p>Für die Entwickler unter euch existieren ebenfalls Veränderungen, die Tests benötigen:</p>\n<ul>\n<li><b>Resource Hints</b> (<a href=\"https://core.trac.wordpress.org/ticket/34292\">#34292</a>) – erlaubt Browsern spezielle Seiten im Voraus zu laden, sie im Hintergrund zu rendern, DNS-Lookups auszuführen oder einen Handshake mit (DNS, TCP, TLS) im Hintergrund zu starten.</li>\n<li>Neue WP_Site_Query (<a href=\"https://core.trac.wordpress.org/ticket/35791\">#35791</a>) und WP_Network_Query (<a href=\"https://core.trac.wordpress.org/ticket/32504\">#32504</a>) Klassen.</li>\n<li><b>Requests</b> (<a href=\"https://core.trac.wordpress.org/ticket/33055\">#33055</a>) – Eine neue PHP Bibliothek für HTTP Requests die parallele Requests und mehr unterstützt.</li>\n<li>WP_Term_Query (<a href=\"https://core.trac.wordpress.org/ticket/35381\">#35381</a>).</li>\n<li><b>Sprachpakete</b> (<a href=\"https://core.trac.wordpress.org/ticket/34114\">#34114</a>, <a href=\"https://core.trac.wordpress.org/ticket/34213\">#34213</a>) – Übersetzungen, die über<a href=\"https://translate.wordpress.org\"> translate.wordpress.org</a> gemanagt werden, haben nun eine höhere Priorität und laden bedarfsorientiert.</li>\n<li>WP_Post_Type (<a href=\"https://core.trac.wordpress.org/ticket/36217\">#36217</a>) bringt einfacheren Zugriff auf &#8222;Post Type&#8220;-Objekte und deren dazugehörigen Eigenschaften.</li>\n<li>Die <b>Widgets API</b> (<a href=\"https://core.trac.wordpress.org/ticket/28216\">#28216</a>) wurde hinsichtlich der Registrierung von vor-instanzierten Widgets verbessert.</li>\n<li>Index-Definitionen werden jetzt von dbDelta() standardisiert (<a href=\"https://core.trac.wordpress.org/changeset/37583\">[37583]</a>).</li>\n<li><b>Kommentare</b> können nun in einem permanenten Objekt-Cache gespeichert werden (<a href=\"https://core.trac.wordpress.org/ticket/36906\">#36906</a>).</li>\n<li><b>Externe Bibliotheken </b>wurden auf die neuesten Versionen aktualisiert – Masonry auf 3.3.2 und imagesLoaded auf 3.2.0 (<a href=\"https://core.trac.wordpress.org/ticket/32802\">#32802</a>), MediaElement.js auf 2.21.2 (<a href=\"https://core.trac.wordpress.org/ticket/36759\">#36759</a>) und TinyMCE auf 4.3.13 (<a href=\"https://core.trac.wordpress.org/ticket/37225\">#37225</a>).</li>\n<li><b>REST API</b> Antworten beinhalten einen “auto-discovery header” (<a href=\"https://core.trac.wordpress.org/ticket/35580\">#35580</a>) und eine neu geladene Nonce (<a href=\"https://core.trac.wordpress.org/ticket/35662\">#35662</a>).</li>\n<li>Erweiterte <b>Meta Registration API</b> via register_meta() (<a href=\"https://core.trac.wordpress.org/ticket/35658\">#35658</a>).</li>\n</ul>\n<p>Wer einen tieferen Blick auf alle Änderungen in der Version 4.6 Beta 1 werfen möchte, sollte sich die mit<a href=\"https://make.wordpress.org/core/tag/4-6/\"> 4.6 getaggten Beiträge</a> anzeigen lassen oder <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.6&amp;group=component&amp;order=priority\">diese Liste</a> ansehen.</p>\n<h2>So kannst du mithelfen</h2>\n<p><b>Wenn du denkst, dass du einen Bug gefunden hast</b>, poste den bitte in den<a href=\"https://wordpress.org/support/forum/alphabeta\"> Alpha/Beta Bereich</a> der Support-Foren. Oder wenn du damit vertraut bist, einen reproduzierbaren Bug-Report zu schreiben, erstell bitte ein Ticket im<a href=\"https://make.wordpress.org/core/reports/\"> WordPress Trac</a>. Dort kannst du außerdem eine <a href=\"https://make.wordpress.org/core/reports/\">Liste aller bereits bekannten Fehler</a> einsehen.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 4.5.3 Sicherheits- und Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://de.wordpress.org/2016/06/wordpress-4-5-3-sicherheits-und-wartungs-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jun 2016 18:37:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Sicherheit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1889\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:438:\"WordPress 4.5.3 steht ab sofort zum Download bereit. Da die Version 4.5.3 ein Sicherheits-Release ist, wird die sofortige Aktualisierung dringend empfohlen. WordPress ab Version 4.5.2 sowie alle früheren Versionen sind von verschiedenen Sicherheitslücken betroffen: Enthaltene Änderungen Ein Redirect Bypass im Customizer, gemeldet von Yassine Aboukir; zwei unterschiedliche XSS Probleme via Namen von Anhängen, gemeldet von [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4956:\"<p>WordPress 4.5.3 steht ab sofort zum Download bereit. Da die Version <strong>4.5.3 ein Sicherheits-Release</strong> ist, wird die <strong>sofortige Aktualisierung dringend empfohlen</strong>.</p>\n<p>WordPress ab Version 4.5.2 sowie alle früheren Versionen sind von verschiedenen Sicherheitslücken betroffen:</p>\n<p><span id=\"more-1889\"></span></p>\n<h3>Enthaltene Änderungen</h3>\n<p>Ein Redirect Bypass im Customizer, gemeldet von <a href=\"http://yassineaboukir.com\">Yassine Aboukir</a>; zwei unterschiedliche <a href=\"https://de.wikipedia.org/wiki/Cross-Site-Scripting\">XSS Probleme</a> via Namen von Anhängen, gemeldet von <a href=\"https://klikki.fi/\">Jouko Pynnönen</a> und <a href=\"https://twitter.com/divy_er\">Divyesh Prajapati</a>; Offenlegung von Informationen der Revisions-History, gemeldet (unabhängig voneinander) von <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a> des WordPress Security Teams sowie von Dan Moen; oEmbed <a href=\"https://de.wikipedia.org/wiki/Denial_of_Service\">Denial of Service</a>, gemeldet von Jennifer Dodd (Automattic); nicht autorisiertes Entfernen von Kategorien aus einem Beitrag, gemeldet von <a href=\"https://blogwaffe.com/\">Michael Adams</a> des WordPress Security Teams; und einige als minor eingestufte sanitize_file_name <a href=\"https://en.wikipedia.org/wiki/Edge_case\">edge cases</a>, gemeldet von <a href=\"http://peter.westwood.name/\">Peter Westwood</a> des WordPress Security Teams.</p>\n<p>Danke an alle, die mit der Meldung der Sicherheitslücken <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">verantwortungsvoll umgegangen sind</a>.</p>\n<p>Zusätzlich zu den oben genannten Sicherheitslücken, wurden mit WordPress 4.5.3 insgesamt 17 Bugs aus 4.5, 4.5.1 und 4.5.2 behoben. Weitere Informationen findest du in den offiziellen <a href=\"https://codex.wordpress.org/Version_4.5.3\">release notes</a> oder siehe auch diese <a href=\"https://core.trac.wordpress.org/query?milestone=4.5.3\">Liste der Änderungen</a>.</p>\n<h3>Aktualisieren</h3>\n<p>WordPress 4.5.3 kannst du entweder <a href=\"https://wordpress.org/download/\">hier downloaden</a> oder im Adminbereich deiner Website, Dashboard -&gt; Aktualisierungen -&gt; „Bitte aktualisiere jetzt“. WordPress-Installationen, bei denen die automatischen Hintergrund-Updates aktiviert sind, <a href=\"https://de.wordpress.org/2015/04/die-hintergrund-updates-von-wordpress-was-genau-passiert-da-eigentlich/\">werden automatisch mit der WordPress-Aktualisierung versorgt</a>.</p>\n<h3>Download &#8211; auch für ältere Versionszweige</h3>\n<p>Sollte das automatische Hintergrund-Update nicht funktionieren, kann das Updatepaket auch manuell heruntergeladen werden. Seit der Einführung der automatischen Hintergrund-Updates – also seit der WordPress-Version 3.7 – werden ältere Versionszweige mit Sicherheitsupdates versorgt. Automatisch im Hintergrund, oder zur manuellen Aktualisierung als Download. Das entsprechende Paket (4.4.4, 4.3.5, 4.2.9, 4.1.12, 4.0.12, 3.9.13, 3.8.15 oder 3.7.15 sowie natürlich 4.5.3) kannst du im <a href=\"https://wordpress.org/download/release-archive/\">Release-Archive</a> herunterladen. Eine Auflistung sämtlicher Releases findest du im <a href=\"https://codex.wordpress.org/WordPress_Versions\">WordPress Codex</a> – inklusive Datum der Veröffentlichung.</p>\n<h3>Danksagung</h3>\n<p>Vielen Dank an alle, die an der Version 4.5.3 mitgewirkt haben:</p>\n<p><a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/neverything\">Silvan Hagen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>,  <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> und <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.5.2 Sicherheits-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://de.wordpress.org/2016/05/wordpress-4-5-2-sicherheits-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 20:07:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Sicherheit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1846\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Soeben wurde WordPress 4.5.2 veröffentlicht. Dabei handelt es sich um ein Sicherheits-Update für alle bisherigen Versionen und die Entwickler raten dringend dazu, WordPress schnell zu aktualisieren. WordPress 4.5.1 sowie vorherige Versionen sind von einigen Schwachstellen durch die Third-Party-Bibliothek Plupload betroffen, die WordPress nutzt, um Dateien hochzuladen. WordPress 4.2 bis 4.5.1 haben eine XSS-Sicherheitslücke, die durch [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2481:\"<p>Soeben wurde <a href=\"https://wordpress.org/news/2016/05/wordpress-4-5-2/\">WordPress 4.5.2 veröffentlicht</a>. Dabei handelt es sich um ein <strong>Sicherheits-Update für alle bisherigen Versionen</strong> und die Entwickler raten dringend dazu, WordPress schnell zu aktualisieren.</p>\n<p><span id=\"more-1846\"></span></p>\n<p>WordPress 4.5.1 sowie vorherige Versionen sind von einigen Schwachstellen durch die Third-Party-Bibliothek Plupload betroffen, die WordPress nutzt, um Dateien hochzuladen. WordPress 4.2 bis 4.5.1 haben eine XSS-Sicherheitslücke, die durch spezielle, von der Third-Party-Bibliothek MediaElement.js erstellten URIs hervorgebracht wird. MediaElement.js und Plupload haben ebenfalls Sicherheits-Updates veröffentlicht, die diese Lücken schließen.</p>\n<p>Beide Lücken wurden analysiert und gemeldet von Mario Heiderich, Masato Kinugawa, und Filedescriptor von <a href=\"https://cure53.de/\">Cure53</a>. Danke an dieses Team, das <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">verantwortungsvoll damit umgegangen ist</a> und an die Teams von Plupload und MediaElement.js für die Zusammenarbeit und Koordination zur Schließung dieser Lücken.</p>\n<p>WordPress 4.5.2 kannst du entweder <a href=\"https://wordpress.org/download/\">hier downloaden</a> oder im Adminbereich deiner Website, Dashboard -&gt;  Aktualisierungen -&gt; &#8222;Bitte aktualisiere jetzt&#8220;. WordPress-Installationen, bei denen die automatischen Hintergrund-Updates aktiviert sind, <a href=\"https://de.wordpress.org/2015/04/die-hintergrund-updates-von-wordpress-was-genau-passiert-da-eigentlich/\">werden automatisch mit der WordPress-Aktualisierung versorgt</a>. Die Updates für ältere Versions-Zweige (zum Beispiel: 4.4, 4.3, usw.) zur manuellen Aktualisierung befinden sich wie immer im <a href=\"https://de.wordpress.org/releases/\">Release-Archiv</a>.</p>\n<p>Außerdem existieren weit verbreitete Sicherheitslücken in ImageMagick, das auf vielen Servern eingesetzt und von WordPress unterstützt wird. Eine aktuelle Stellungnahme zu dieser Problematik findest du in diesem <a href=\"https://make.wordpress.org/core/2016/05/06/imagemagick-vulnerability-information/\">Beitrag der WordPress-Core-Entwickler</a>.</p>\n<hr />\n<p><strong>Wenn du Fragen zu oder Probleme mit dem Release hast, </strong>dann wende dich bitte einfach an eins der WordPress-Foren: <a href=\"https://de.wordpress.org/hilfe/\">de.wordpress.org/hilfe/</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.5.1 Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://de.wordpress.org/2016/04/wordpress-4-5-1-wartungs-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Apr 2016 20:21:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1788\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:416:\"Vor Kurzem wurde WordPress 4.5.1 veröffentlicht. Dabei handelt es sich um einen Wartungs-Release, der zwölf Bugs behebt – unter anderem einen, der Fehlfunktionen bei Websites mit Twenty Eleven hervorruft, eine Inkompatibilität zwischen Chrome und dem visuellen Editor sowie einen Imagick-Bug, der eventuell das Hochladen von Dateien verhindert. Mehr Informationen findet ihr in den Release-Notizen und [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2166:\"<p>Vor Kurzem wurde WordPress 4.5.1 veröffentlicht. Dabei handelt es sich um einen Wartungs-Release, der zwölf Bugs behebt – unter anderem einen, der Fehlfunktionen bei Websites mit Twenty Eleven hervorruft, eine Inkompatibilität zwischen Chrome und dem visuellen Editor sowie einen Imagick-Bug, der eventuell das Hochladen von Dateien verhindert.</p>\n<p><span id=\"more-1788\"></span></p>\n<p>Mehr Informationen findet ihr in den <a href=\"https://codex.wordpress.org/Version_4.5.1\">Release-Notizen</a> und der <a href=\"https://core.trac.wordpress.org/log/branches/4.5?rev=37295&amp;stop_rev=37182\">Liste aller Änderungen</a>.</p>\n<p>Ihr könnt WordPress 4.5.1 entweder als ZIP herunterladen (sollte bald auch hier auf de.wordpress.org auftauchen), oder einfach im Backend auf die neue Version aktualisieren. Falls bei eurer Site automatische Updates nicht deaktiviert sind, könnte der Release bereits bei euch angekommen sein.</p>\n<p><strong>Danke an alle, die an 4.5.1 mitgearbeitet haben:</strong><br />\n<a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,<a href=\"https://profiles.wordpress.org/afercia\"> Andrea Fercia</a>,<a href=\"https://profiles.wordpress.org/azaozz\"> Andrew Ozz</a>,<a href=\"https://profiles.wordpress.org/boonebgorges\"> Boone Gorges</a>,<a href=\"https://profiles.wordpress.org/ocean90\"> Dominik Schilling</a>,<a href=\"https://profiles.wordpress.org/flixos90\"> Felix Arntz</a>,<a href=\"https://profiles.wordpress.org/pento\"> Gary Pendergast</a>,<a href=\"https://profiles.wordpress.org/gblsm\"> gblsm</a>,<a href=\"https://profiles.wordpress.org/helen\"> Helen Hou-Sandi</a>,<a href=\"https://profiles.wordpress.org/joemcgill\"> Joe McGill</a>,<a href=\"https://profiles.wordpress.org/johnbillion\"> John Blackbourn</a>,<a href=\"https://profiles.wordpress.org/celloexpressions\"> Nick Halsey</a>,<a href=\"https://profiles.wordpress.org/swissspidy\"> Pascal Birchler</a> und <a href=\"https://profiles.wordpress.org/WiZZarD_\">Pieter</a>.</p>\n<p><strong>Ihr habt Fragen zu/Probleme mit dem Release?</strong> Dann wendet euch einfach an eins der WordPress-Foren: <a href=\"https://de.wordpress.org/hilfe/\">de.wordpress.org/hilfe/</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WordPress 4.5.1 Release Candidate 1 und 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://de.wordpress.org/2016/04/wordpress-4-5-1-release-candidate-1-und-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://de.wordpress.org/2016/04/wordpress-4-5-1-release-candidate-1-und-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Apr 2016 07:27:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1780\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Heute wurden zwei Release Candidates für WordPress 4.5.1 veröffentlicht. Damit werden zwölf Probleme behoben, die bei 4.5 gemeldet wurden – der finale Release ist für den 26. April geplant. Helft mit, den zweiten RC zu testen, um sicherzustellen, dass nur die gemeldeten Probleme behoben werden und keine neuen entstehen. Erwähnenswerte Bugfixes Die Tabs und Toolbar [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2581:\"<p>Heute wurden zwei Release Candidates für WordPress 4.5.1 veröffentlicht. Damit werden zwölf Probleme behoben, die bei 4.5 gemeldet wurden – der finale Release ist für den 26. April geplant. Helft mit, den zweiten RC zu testen, um sicherzustellen, dass nur die gemeldeten Probleme behoben werden und keine neuen entstehen.</p>\n<p><span id=\"more-1780\"></span></p>\n<h2>Erwähnenswerte Bugfixes</h2>\n<ul>\n<li>Die Tabs und Toolbar des TinyMCE sind in Chrome 50.0.2661.75 beta-m (64-bit) nicht responsive (<a href=\"https://core.trac.wordpress.org/ticket/36545\">#36545</a>).</li>\n<li>Bei Twenty Eleven sind Seiten-Templates mit Widgets nicht richtig gestylt (<a href=\"https://core.trac.wordpress.org/ticket/36510\">#36510</a>).</li>\n</ul>\n<h2>Die weiteren Änderungen</h2>\n<ul>\n<li>Shrinkwrap npm-Abhängigkeiten für 4.5 (<a href=\"https://core.trac.wordpress.org/ticket/36498\">#36498</a>).</li>\n<li>Pixel-Werte für die Tablet-Vorschau in der Responsive-Design-Vorschau des Customizers nutzen (<a href=\"https://core.trac.wordpress.org/ticket/36457\">#36457</a>).</li>\n<li>Funktionen zur Datenbankverbindung können Warnung ausgeben, auch wenn <code>WP_DEBUG</code> nicht aktiv ist – dieser Fehler wurde im zweiten Release Candidate behoben (<a href=\"https://core.trac.wordpress.org/ticket/36629\">#36629</a>).</li>\n<li>Unterstützung für Safari+VoiceOver bei der Bearbeitung von Inline-Links (<a href=\"https://core.trac.wordpress.org/ticket/36458\">#36458</a>).</li>\n<li>Test auf Unterstützung von Emoji-Hautfarben im Chrome fälschlicherweise positiv (<a href=\"https://core.trac.wordpress.org/ticket/36604\">#36604</a>).</li>\n<li>Feeds mit rss-http als Content-Type werden jetzt als <code>application/octet-stream</code> ausgeliefert (<a href=\"https://core.trac.wordpress.org/ticket/36620\">#36620</a>).</li>\n<li>Fatal error: Undefined class constant &#8218;ALPHACHANNEL_UNDEFINED&#8216; (<a href=\"https://core.trac.wordpress.org/ticket/36501\">#36501</a>).</li>\n<li><code>wp_ajax_send_attachment_to_editor()</code>-Bug (<a href=\"https://core.trac.wordpress.org/ticket/36578\">#36578</a>).</li>\n<li>Ergebnisse von <code>wp_mkdir_p()</code> nicht in persistentem Cache speichern (<a href=\"https://core.trac.wordpress.org/ticket/36621\">#36621</a>).</li>\n<li>Doppelte Richtlinien in web.config nach WordPress-4.5-Installation auf Windows (<a href=\"https://core.trac.wordpress.org/ticket/36506\">#36506</a>).</li>\n</ul>\n<p>Wenn ihr den zweiten Release Candidate testen möchtet, könnt ihr ihn euch als <a href=\"https://wordpress.org/wordpress-4.5.1-RC2.zip\">ZIP herunterladen</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://de.wordpress.org/2016/04/wordpress-4-5-1-release-candidate-1-und-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.5 „Coleman“\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://de.wordpress.org/2016/04/wordpress-4-5-coleman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://de.wordpress.org/2016/04/wordpress-4-5-coleman/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Apr 2016 19:20:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Sicherheit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1743\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"Vor Kurzem wurde WordPress 4.5 „Coleman“ veröffentlicht – benannt nach dem Jazz-Musiker Coleman Hawkins. Die neue Version bringt unter anderem eine Theme-Funktion für Logos sowie einen Inline-Link-Dialog für den visuellen Editor mit. Außerdem wurden 3 als minor eingestufte Sicherheitslücken behoben: SSRF Bypass using Octal &#38; Hexedecimal IP addresses, reported by Yu Wang &#38; Tong Shi [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:27059:\"<p>Vor Kurzem wurde WordPress 4.5 „Coleman“ veröffentlicht – benannt nach dem Jazz-Musiker Coleman Hawkins. Die neue Version bringt unter anderem eine Theme-Funktion für Logos sowie einen Inline-Link-Dialog für den visuellen Editor mit.</p>\n<p>Außerdem wurden <a href=\"https://codex.wordpress.org/index.php?title=Version_4.5#Security\">3 als minor eingestufte Sicherheitslücken behoben</a>:</p>\n<ul>\n<li>SSRF Bypass using Octal &amp; Hexedecimal IP addresses, reported by Yu Wang &amp; Tong Shi from <a class=\"external text\" href=\"http://xteam.baidu.com\">BAIDU XTeam</a></li>\n<li>Reflected XSS on the network settings page, reported by <a class=\"external text\" href=\"https://twitter.com/e3amn2l\">Emanuel Bronshtein (@e3amn2l)</a></li>\n<li>Script compression option CSRF, reported by <a class=\"external text\" href=\"https://www.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a></li>\n</ul>\n<p>&nbsp;</p>\n<p><span id=\"more-1743\"></span></p>\n<h2>WordPress 4.5 bringt Verbesserungen am Editor und im Customizer mit</h2>\n<p><iframe width=\'692\' height=\'388\' src=\'https://videopress.com/embed/scFdjVo6?hd=1&amp;defaultLangCode=de\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<p>Im visuellen Modus des Editors könnt ihr mit der neuen Version Links über einen Inline-Dialog einfügen. Dabei stehen euch die erweiterten Funktionen weiterhin zur Verfügung, wenn ihr auf das Zahnrad klickt. Als weitere Verbesserung im Editor wurden zwei neue Markdown-ähnliche Kürzel für Formatierungen eingeführt. So könnt ihr über <code>`Quellcode`</code> das Wort „Quellcode“ als Code formatieren, und durch Schreiben von drei Bindestrichen eine horizontale Linie erzeugen.</p>\n<figure id=\"attachment_1745\" style=\"width: 560px\" class=\"wp-caption alignnone\"><img class=\"size-full wp-image-1745\" src=\"https://de.wordpress.org/files/2016/04/wordpress-4-5-inline-link.png\" alt=\"Der neue Inline-Link-Dialog. (Screenshot: WordPress-About-Seite)\" width=\"560\" height=\"336\" srcset=\"https://de.wordpress.org/files/2016/04/wordpress-4-5-inline-link.png 560w, https://de.wordpress.org/files/2016/04/wordpress-4-5-inline-link-300x180.png 300w\" sizes=\"(max-width: 560px) 100vw, 560px\" /><figcaption class=\"wp-caption-text\">Der neue Inline-Link-Dialog. (Screenshot: WordPress-About-Seite)</figcaption></figure>\n<p>Neben den offensichtlichen Neuerungen im Editor gibt es für die Endanwender noch interessante Funktionen im Customizer, die in 4.5 dazugekommen sind. So könnt ihr über Icons am unteren Ende der Customizer-Sidebar die Vorschau auf eine Tablet- und eine Smartphone-Größe umstellen und so grob testen, wie sich eure Website auf unterschiedlichen Viewports macht. Diese Funktion ist auch bei der Vorschau während der Theme-Installation vorhanden. Daneben kann von Theme-Autoren eine Funktion aktiviert werden, mit der ihr im Customizer ein Logo für eure Website festlegen könnt.</p>\n<h2>Unter der Haube …</h2>\n<p>Das neu eingeführte <a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\">Selective-Refresh-Framework</a> ermöglicht es, Bereiche im Customizer festzulegen, die unabhängig von der gesamten Vorschau neu geladen werden, damit die Aktualisierung schneller ablaufen kann. Zudem werden Bilder besser komprimiert, sodass <a href=\"https://make.wordpress.org/core/2016/03/12/performance-improvements-for-images-in-wordpress-4-5/\">ohne spürbare visuelle Veränderung bis zu 50 Prozent kleinere Dateien erreicht werden können</a>.</p>\n<p>Eine weitere Neuerung ist die <a href=\"https://make.wordpress.org/core/2016/03/08/enhanced-script-loader-in-wordpress-4-5/\"><code>wp_add_inline_script()</code>-Funktion</a>, mit der endlich einfach Inline-Skripte eingefügt werden können. Neben dieser neuen Funktion wurden einige Verbesserungen im Skript-Loader vorgenommen, beispielsweise bei der Behandlung von Abhängigkeiten. Und wo wir gerade bei Skripten sind: Die JavaScript-Bibliotheken jQuery, jQuery Migrate, Backbone und Underscore wurden aktualisiert.</p>\n<p>Zu guter Letzt könnt ihr über <a href=\"https://make.wordpress.org/core/2016/03/11/embeds-changes-in-wordpress-4-5/\">neu eingeführte Template-Dateien das Aussehen der Embeds anpassen</a>, die angezeigt werden, wenn andere eure Inhalte durch Einfügen des Links in ihre WordPress-Installation einbetten.</p>\n<p>Wie immer könnt ihr eure Website bequem über das Backend auf die neue Version aktualisieren, sofern das automatische Update noch nicht bei euch angekommen ist. Alternativ könnt ihr euch WordPress 4.5 auch als ZIP-Archiv herunterladen.</p>\n<h2>Danke!</h2>\n<h3><strong>Die Übersetzer, die WordPress auf Deutsch ermöglicht haben</strong></h3>\n<p><a class=\"web\" href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling (ocean90)</a>, <a class=\"web\" href=\"https://profiles.wordpress.org/fstaude\">Frank Staude</a>, <a class=\"web\" href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a class=\"web\" href=\"https://profiles.wordpress.org/coachbirgit\">Birgit Olzem</a>, <a class=\"web\" href=\"https://profiles.wordpress.org/arkonisus\">Christian Rüggeberg</a>, <a href=\"https://profiles.wordpress.org/albrechtboucher\">albrechtboucher</a>, <a href=\"https://profiles.wordpress.org/akirk\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/anchises\">anchises</a>, <a href=\"https://profiles.wordpress.org/pixolin\">Bego Mario Garde</a>, <a href=\"https://profiles.wordpress.org/bkleine\">bkleine</a>, <a href=\"https://profiles.wordpress.org/electrosmog\">Electrosmog</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/flowdee\">flowdee</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/let-me-see\">let me see…</a>, <a href=\"https://profiles.wordpress.org/lukasbesch\">lukasbesch</a>, <a href=\"https://profiles.wordpress.org/martiniq\">MartinIQ</a>, <a href=\"https://profiles.wordpress.org/mobotter\">Moritz Kern</a>, <a href=\"https://profiles.wordpress.org/patrickrobrecht\">Patrick Robrecht</a>, <a href=\"https://profiles.wordpress.org/pixelverbieger\">pixelverbieger</a>, <a href=\"https://profiles.wordpress.org/reitermarkus\">reitermarkus</a>, <a href=\"https://profiles.wordpress.org/soean\">Sören Wrede</a>, <a href=\"https://profiles.wordpress.org/sajonara\">sajonara</a>, <a href=\"https://profiles.wordpress.org/krafit\">Simon Kraft</a>, <a href=\"https://profiles.wordpress.org/sinn-it-mit-emotion\">Sinn – IT mit Emotion</a>, <a href=\"https://profiles.wordpress.org/pixelstrolch\">Stefan Brechbuehl</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a> und <a href=\"https://profiles.wordpress.org/tyrannous\">tyrann0us</a></p>\n<h3><strong>Die Entwickler, die zum WordPress-Core beigetragen haben</strong></h3>\n<p><strong>Projektleiter</strong>: <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a> (Leitender Entwickler), <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a> (Mitgründer, Projektleitung), <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí­</a> (Leitende Entwicklerin), <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a> (Leitender Entwickler), <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a> (Leitender Entwickler) und <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a> (Leitender Entwickler).</p>\n<p><strong>Mitwirkende Entwickler:</strong> <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> (Release-Leitung), <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a> (Stellvertretende Release-Leitung), <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a> (Release-Leitung Design), <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a> (Entwickler), <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a> (Entwickler), <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a> (Entwickler), <a href=\"https://profiles.wordpress.org/DrewAPicture\">Drew Jaynes</a> (Entwickler), <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a> (Entwickler), <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a> (Entwickler), <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a> (Entwickler), <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a> (Entwickler), <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a> (Entwickler), <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/Ipstenu\">Mika Epstein</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/rockwell15\">Andrew Rockwell</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/dnewton\">David Newton</a>, <a href=\"https://profiles.wordpress.org/grantpalin\">Grant Palin</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a> und <a href=\"https://profiles.wordpress.org/gitlost\">Martin Burke</a>.</p>\n<p><strong>Mitwirkende am Code von WordPress 4.5:</strong> <a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/ahockley\">Aaron Hockley</a>, <a href=\"https://profiles.wordpress.org/abiralneupane\">Abiral Neupane</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/aidanlane\">aidanlane</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/ambrosey\">ambrosey</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/apaliku\">apaliku</a>, <a href=\"https://profiles.wordpress.org/aramzs\">Aram Zucker-Scharff</a>, <a href=\"https://profiles.wordpress.org/ashmatadeen\">ash.matadeen</a>, <a href=\"https://profiles.wordpress.org/bappidgreat\">Ashok Kumar Nath</a>, <a href=\"https://profiles.wordpress.org/barryceelen\">Barry Ceelen</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/berengerzyla\">berengerzyla</a>, <a href=\"https://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"https://profiles.wordpress.org/thisisit\">Bhushan S. Jawle</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/williamsba1\">Brad Williams</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/thebrandonallen\">Brandon Allen</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/borgesbruno\">Bruno Borges</a>, <a href=\"https://profiles.wordpress.org/chmac\">Callum Macdonald</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chetanchauhan\">Chetan Chauhan</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrico\">ChriCo</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/chris_dev\">chris_dev</a>, <a href=\"https://profiles.wordpress.org/ckoerner\">ckoerner</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/compute\">Compute</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">d4z_c0nf</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/scarinessreported\">Daniel Bailey</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/diddledan\">Daniel Llewellyn</a>, <a href=\"https://profiles.wordpress.org/danielpataki\">danielpataki</a>, <a href=\"https://profiles.wordpress.org/dvankooten\">Danny van Kooten</a>, <a href=\"https://profiles.wordpress.org/thewanderingbrit\">Dave Clements</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dbrumbaugh10up\">David Brumbaugh</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide ‚Folletto‘ Casali</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/dossy\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/drebbitsweb\">Dreb Bits</a>, <a href=\"https://profiles.wordpress.org/duaneblake\">duaneblake</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/codex-m\">Emerson Maningo</a>, <a href=\"https://profiles.wordpress.org/enej\">enej</a>, <a href=\"https://profiles.wordpress.org/ericdaams\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/ethitter\">Erick Hitter</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/faishal\">faishal</a>, <a href=\"https://profiles.wordpress.org/fantasyworld\">fantasyworld</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/finnj\">finnj</a>, <a href=\"https://profiles.wordpress.org/firebird75\">firebird75</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/garusky\">Giuseppe Mamone</a>, <a href=\"https://profiles.wordpress.org/groovecoder\">groovecoder</a>, <a href=\"https://profiles.wordpress.org/wido\">Guido Scialfa</a>, <a href=\"https://profiles.wordpress.org/bordoni\">Gustavo Bordoni</a>, <a href=\"https://profiles.wordpress.org/hakre\">hakre</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/iamntz\">Ionut Staicu</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jamesdigioia\">James DiGioia</a>, <a href=\"https://profiles.wordpress.org/jaspermdegroot\">Jasper de Groot</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeffpyebrookcom\">Jeffrey Schutzman</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/ardathksheyna\">Jess G.</a>, <a href=\"https://profiles.wordpress.org/boluda\">Joan Boluda</a>, <a href=\"https://profiles.wordpress.org/joelerr\">joelerr</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnnypea\">JohnnyPea</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/keraweb\">Jory Hogeveen</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/jrchamp\">jrchamp</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/katieburch\">katieburch</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kiranpotphode\">Kiran Potphode</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/krissiev\">KrissieV</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/luan-ramos\">Luan Ramos</a>, <a href=\"https://profiles.wordpress.org/luciole135\">luciole135</a>, <a href=\"https://profiles.wordpress.org/lpawlik\">Lukas Pawlik</a>, <a href=\"https://profiles.wordpress.org/latz\">Lutz Schröer</a>, <a href=\"https://profiles.wordpress.org/madvic\">madvic</a>, <a href=\"https://profiles.wordpress.org/marcochiesi\">Marco Chiesi</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/mark8barnes\">Mark Barnes</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/mattfelten\">mattfelten</a>, <a href=\"https://profiles.wordpress.org/mattgeri\">MattGeri</a>, <a href=\"https://profiles.wordpress.org/wp-architect\">Matthew Ell</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/maweder\">maweder</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mcapybara\">mcapybara</a>, <a href=\"https://profiles.wordpress.org/mehulkaklotar\">Mehul Kaklotar</a>, <a href=\"https://profiles.wordpress.org/meitar\">Meitar</a>, <a href=\"https://profiles.wordpress.org/mensmaximus\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikejolley\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan DiniÄ‡</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/usermrpapa\">Mr Papa</a>, <a href=\"https://profiles.wordpress.org/mwidmann\">mwidmann</a>, <a href=\"https://profiles.wordpress.org/nexurium\">nexurium</a>, <a href=\"https://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"https://profiles.wordpress.org/nicdford\">Nic Ford</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/ninos-ego\">Ninos</a>, <a href=\"https://profiles.wordpress.org/oaron\">oaron</a>, <a href=\"https://profiles.wordpress.org/overclokk\">overclokk</a>, <a href=\"https://profiles.wordpress.org/obrienlabs\">Pat O’Brien</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pauldewouters\">Paul de Wouters</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/perezlabs\">Perez Labs</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/cadeyrn\">petermolnar</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/wizzard_\">Pieter</a>, <a href=\"https://profiles.wordpress.org/ptahdunbar\">Pirate Dunbar</a>, <a href=\"https://profiles.wordpress.org/prettyboymp\">prettyboymp</a>, <a href=\"https://profiles.wordpress.org/profforg\">Profforg</a>, <a href=\"https://profiles.wordpress.org/programmin\">programmin</a>, <a href=\"https://profiles.wordpress.org/rahalaboulfeth\">rahal.aboulfeth</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/ritteshpatel\">Ritesh Patel</a>, <a href=\"https://profiles.wordpress.org/rob\">rob</a>, <a href=\"https://profiles.wordpress.org/rogerhub\">Roger Chen</a>, <a href=\"https://profiles.wordpress.org/romsocial\">RomSocial</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sagarjadhav\">Sagar Jadhav</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla\">salvoaranzulla</a>, <a href=\"https://profiles.wordpress.org/samhotchkiss\">Sam Hotchkiss</a>, <a href=\"https://profiles.wordpress.org/rosso99\">Sara Rosso</a>, <a href=\"https://profiles.wordpress.org/sarciszewski\">sarciszewski</a>, <a href=\"https://profiles.wordpress.org/scottbrownconsulting\">scottbrownconsulting</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergejmueller\">Sergej Müller</a>, <a href=\"https://profiles.wordpress.org/shamess\">Shane</a>, <a href=\"https://profiles.wordpress.org/shinichin\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/sidati\">sidati</a>, <a href=\"https://profiles.wordpress.org/aargh-a-knot\">sky</a>, <a href=\"https://profiles.wordpress.org/slushman\">slushman</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Spacedmonkey</a>, <a href=\"https://profiles.wordpress.org/stephanethomas\">stephanethomas</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/charlestonsw\">Store Locator Plus</a>, <a href=\"https://profiles.wordpress.org/subharanjan\">Subharanjan</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/5um17\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/tacoverdo\">Taco Verdo</a>, <a href=\"https://profiles.wordpress.org/tahteche\">tahteche</a>, <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie</a>, <a href=\"https://profiles.wordpress.org/takayukister\">Takayuki Miyoshi</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/themiked\">theMikeD</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tmuikku\">tmuikku</a>, <a href=\"https://profiles.wordpress.org/skithund\">Toni Viemerö</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/rilwis\">Tran Ngoc Tuan Anh</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/vhomenko\">vhomenko</a>, <a href=\"https://profiles.wordpress.org/virgodesign\">virgodesign</a>, <a href=\"https://profiles.wordpress.org/vladolaru\">vlad.olaru</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vtieu\">vtieu</a>, <a href=\"https://profiles.wordpress.org/webaware\">webaware</a>, <a href=\"https://profiles.wordpress.org/wesleye\">Wesley Elfring</a>, <a href=\"https://profiles.wordpress.org/wisdmlabs\">WisdmLabs</a>, <a href=\"https://profiles.wordpress.org/wpdelighter\">WP Delighter</a>, <a href=\"https://profiles.wordpress.org/xavortm\">xavortm</a>, <a href=\"https://profiles.wordpress.org/yetanotherdaniel\">yetAnotherDaniel</a> und <a href=\"https://profiles.wordpress.org/zinigor\">zinigor</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://de.wordpress.org/2016/04/wordpress-4-5-coleman/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"40\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress 4.5 RC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://de.wordpress.org/2016/04/wordpress-4-5-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://de.wordpress.org/2016/04/wordpress-4-5-rc2/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Apr 2016 07:55:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1740\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"Heute wurde der zweite Release Candidate für WordPress 4.5 veröffentlicht. Seit dem ersten RC wurden 91 Änderungen vorgenommen und die finale Version ist nach wie vor für Dienstag, den 12. April, geplant. Wenn ihr WordPress 4.5 noch nicht getestet habt, solltet ihr das jetzt nachholen. Dafür könnt ihr euch entweder das ZIP-Archiv herunterladen oder den [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2683:\"<p>Heute wurde der zweite Release Candidate für WordPress 4.5 veröffentlicht. Seit dem ersten RC wurden <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37171&amp;stop_rev=37078&amp;limit=120&amp;verbose=on\">91 Änderungen</a> vorgenommen und die finale Version ist nach wie vor für Dienstag, den 12. April, geplant.</p>\n<p><span id=\"more-1740\"></span></p>\n<p>Wenn ihr WordPress 4.5 noch nicht getestet habt, solltet ihr das jetzt nachholen. Dafür könnt ihr euch entweder das <a href=\"https://wordpress.org/wordpress-4.5-RC2.zip\">ZIP-Archiv</a> herunterladen oder den RC über das <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress-Beta-Tester-Plugin</a> installieren. <strong>Wenn ihr meint, einen Bug gefunden zu haben, meldet ihn bitte im <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta-Bereich des englischsprachigen Forums</a></strong>. Sofern welche auftauchen, könnt ihr eine Liste <a href=\"https://core.trac.wordpress.org/report/5\">bekannter Probleme im Trac</a> einsehen.</p>\n<p>Für Informationen zu den Neuerungen von WordPress 4.5 könnt ihr einen Blick in den jeweiligen Beitrag zu <a href=\"https://de.wordpress.org/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-3/\">Beta 3</a> und <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-4/\">Beta 4</a> werfen.</p>\n<p><strong>An alle Entwickler</strong>: Bitte testet eure Plugins und Themes mit 4.5 und aktualisiert im Fall von Plugins das <em>Tested up to</em> auf 4.5, wenn es keine Probleme gibt. Wenn ihr Kompatibilitätsprobleme findet, schreibt sie in das englische Support-Forum.</p>\n<p><strong>An die Übersetzer</strong>: Alle Strings von 4.5, auch die von der About-Seite, sind jetzt im Hard Freeze – es wird sich also nichts mehr daran ändern.</p>\n<p>Ein paar erwähnenswerte Änderungen seit dem ersten Release Candidate:</p>\n<ul>\n<li>„non-slashing“ von Daten in der REST-API-Infrastruktur normalisiert. Falls ihr die REST API nutzt, schaut euch <a href=\"https://make.wordpress.org/core/2016/04/06/rest-api-slashed-data-in-wordpress-4-4-and-4-5/\">den Beitrag zu der Änderung an</a>.</li>\n<li>Customizer-Settings für Widget-Instanzen werden ein bisschen später registriert, damit die Widget-Instanz eine Chance hat, sich selbst zuerst zu registrieren (<a href=\"https://core.trac.wordpress.org/ticket/36431\">#36431</a>).</li>\n<li>Verschiedene Probleme beim Zuschneiden in der Funktion für das eigene Logo und Twenty Fifteen/Twenty Sixteen behoben.</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://de.wordpress.org/2016/04/wordpress-4-5-rc2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.5 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://de.wordpress.org/2016/03/wordpress-4-5-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://de.wordpress.org/2016/03/wordpress-4-5-release-candidate/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 09:35:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1704\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"Heute wurde der Release Candidate für WordPress 4.5 veröffentlicht. Die Entwickler haben 49 Änderungen seit der Beta 4 vorgenommen und sind nun an dem Punkt angelangt, an dem die neue Version fertig sein sollte. Mit Millionen von Nutzern und der großen Anzahl Plugins und Themes kann es allerdings sein, dass sie etwas übersehen haben, deshalb [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2295:\"<p>Heute wurde der Release Candidate für WordPress 4.5 veröffentlicht.</p>\n<p>Die Entwickler haben <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37077&amp;stop_rev=37026&amp;limit=120&amp;verbose=on\">49 Änderungen</a> seit der Beta 4 vorgenommen und sind nun an dem Punkt angelangt, an dem die neue Version fertig sein sollte. Mit Millionen von Nutzern und der großen Anzahl Plugins und Themes kann es allerdings sein, dass sie etwas übersehen haben, deshalb brauchen sie eure Hilfe, um die finale Version, die für den 12. April geplant ist, veröffentlichen zu können.</p>\n<p><span id=\"more-1704\"></span></p>\n<p>Wenn ihr WordPress 4.5 also noch nicht getestet habt, solltet ihr es jetzt tun. Ihr könnt euch die neue Version über das <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress-Beta-Tester</a>-Plugin installieren oder das <a href=\"https://wordpress.org/wordpress-4.5-RC1.zip\">ZIP-Archiv</a> herunterladen. Wenn ihr glaubt, einen Bug gefunden zu haben, könnt ihr ihn im <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta-Bereich</a> des Forums melden – die bereits bekannten Fehler findet ihr <a href=\"https://core.trac.wordpress.org/report/5\">im Trac</a>.</p>\n<p>Informationen zu den Neuerungen von WordPress 4.5 gibt es in den Beiträge zur <a href=\"https://de.wordpress.org/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-3/\">Beta 3</a> und <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-4/\">Beta 4</a>.</p>\n<p><strong>Wenn ihr ein Theme oder Plugin entwickelt habt, testet es mit dem Release Candidate und setzt im Erfolgsfall bei Plugins vor nächster Woche die Version bei <em>Tested up to</em> auf 4.5.</strong> Wenn ihr Kompatibilitätsprobleme findet, schreibt es in das englische Support-Forum, damit sich das vor dem finalen Release angeschaut werden kann.</p>\n<p>Interessant in dem Zusammenhang ist das <a href=\"https://make.wordpress.org/core/\">Make/Core-Blog</a>, wo weiterhin Beiträge zu 4.5 mit <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-5/\">Informationen für Entwickler</a> veröffentlicht werden.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://de.wordpress.org/2016/03/wordpress-4-5-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-4/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 08:53:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1696\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"Die vierte Beta-Version von WordPress 4.5 ist nun verfügbar. Wie der Name schon sagt, handelt es sich dabei nicht um die finale Version und sollte daher nur in einer lokalen oder abgesicherten Testumgebung installiert werden. WordPress 4.5 Beta 4 kannst du entweder über das Plugin WordPress Beta Tester installieren oder als Zip-Archiv herunterladen. Einige der [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3376:\"<p>Die vierte <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\">Beta-Version von WordPress 4.5</a> ist nun verfügbar. Wie der Name schon sagt, handelt es sich dabei nicht um die finale Version und sollte daher nur in einer lokalen oder abgesicherten Testumgebung installiert werden. WordPress 4.5 Beta 4 kannst du entweder über das Plugin<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> installieren oder als<a href=\"https://wordpress.org/wordpress-4.5-beta4.zip\"> Zip-Archiv</a> herunterladen.</p>\n<p><span id=\"more-1696\"></span></p>\n<p>Einige der Änderungen in der Beta 4 sind:</p>\n<ul>\n<li>Unterstützung für oEmbed <b>Moments und Timeline von Twitter</b> (<a href=\"https://core.trac.wordpress.org/ticket/36197\">#36197</a>).</li>\n<li>Verbesserte Unterstützung für HHVM mit Imagick. <b>Bitte teste die HHVM Einstellungen und das Ändern der Größe sowie das Drehen von Bildern</b> (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li>Weitere Änderungen an dem <b>Inline Link</b> Feature (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>,<a href=\"https://core.trac.wordpress.org/ticket/30468\"> #30468</a>).</li>\n<li>Support für den &lt;hr&gt; <b>Editor-Shortcut </b>mit 3 oder mehr Bindestrichen (<code>---</code>); ohne Leerzeichen dazwischen. Um die besten Shortcuts für Benutzer zu erarbeiten, wurden die Text Patterns für bold und italic entfernt und somit nicht mit 4.5 ausgeliefert (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>).</li>\n<li>Fixes für <b>SSL mit Responsive Images</b>. Bitte teste SSL, besonders auf Websites mit gemischten HTTP/HTTPS Einstellungen (<a href=\"https://core.trac.wordpress.org/ticket/34945\">#34945</a>).</li>\n<li>Rewrite Rules sind nun erlaubt für eingebettete <b>WordPress Installationen auf IIS</b> (<a href=\"https://core.trac.wordpress.org/ticket/35558\">#35558</a>).</li>\n<li><b>Unterschiedliche Bug fixes</b>. In der letzten Woche wurden knapp<a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37025&amp;stop_rev=36932&amp;limit=200&amp;verbose=on\"> 100 Änderungen</a> vorgenommen.</li>\n</ul>\n<p>Für weitere Informationen darüber, was neu in 4.5 ist, lies bitte die<a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\"> Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, und <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a> Blogeinträge, zusammen mit den „<a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">Dev-Notes</a>“ auf Make WordPress Core. WordPress 4.5 Beta 4 ist die letzte <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\">geplante Beta-Version</a>, nächste Woche wird voraussichtlich ein Release Candidate veröffentlicht.</p>\n<p><b>Wenn du denkst, dass du einen Bug gefunden hast</b>, poste den bitte in den<a href=\"https://wordpress.org/support/forum/alphabeta\"> Alpha/Beta Bereich</a> der Support-Foren. Oder wenn du damit vertraut bist, einen reproduzierbaren Bug-Report zu schreiben, erstell bitte ein Ticket im<a href=\"https://make.wordpress.org/core/reports/\"> WordPress Trac</a>. Dort kannst du außerdem eine <a href=\"https://make.wordpress.org/core/reports/\">Liste aller bereits bekannten Fehler</a> einsehen.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-3/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 09:46:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=1676\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"Heute wurde die dritte Beta-Version für WordPress 4.5 veröffentlicht. Da es sich dabei nicht um einen finalen Release handelt, solltet ihr ihn nur zu Testzwecken einsetzen, und nicht auf einer Live-Website. Ihr könnt euch die Beta entweder über das WordPress-Beta-Tester-Plugin installieren, oder direkt das ZIP-Archiv herunterladen. Mehr Informationen zu den Neuheiten in WordPress 4.5 gibt [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3223:\"<p>Heute wurde die dritte Beta-Version für WordPress 4.5 veröffentlicht. Da es sich dabei nicht um einen finalen Release handelt, solltet ihr ihn nur zu Testzwecken einsetzen, und nicht auf einer Live-Website. Ihr könnt euch die Beta entweder über das <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress-Beta-Tester-Plugin</a> installieren, oder direkt das <a href=\"https://wordpress.org/wordpress-4.5-beta3.zip\">ZIP-Archiv</a> herunterladen.</p>\n<p><span id=\"more-1676\"></span></p>\n<p>Mehr Informationen zu den Neuheiten in WordPress 4.5 gibt es in den Artikeln zu <a href=\"https://de.wordpress.org/2016/02/wordpress-4-5-beta-1/\">Beta 1</a> und <a href=\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, sowie englischsprachig in den <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">detaillierteren Beiträgen zu größeren Änderungen auf Make/Core</a>. Einige der Verbesserungen in der dritten Beta:</p>\n<ul>\n<li>Fixes im Bereich des <a href=\"https://core.trac.wordpress.org/ticket/33755\">Theme-Logo-Supports</a>, inklusive der Logo-Unterstützung für <a href=\"https://core.trac.wordpress.org/ticket/35944\">Twenty Fifteen</a>.</li>\n<li>Die Responsive-Design-Vorschau gibt es jetzt auch in der <a href=\"https://core.trac.wordpress.org/ticket/36017\">Vorschau eines Themes bei der Installation</a>.</li>\n<li>Unterstützung von <a href=\"https://core.trac.wordpress.org/ticket/35973\">Imagick in HHVM</a>.</li>\n<li>IPTC, XMP und EXIF-Profile werden nicht mehr mit <code>strip_meta()</code> entfernt, um Urheberschaft, Copyright, die Lizenz und Bildausrichtung <a href=\"https://core.trac.wordpress.org/ticket/28634\">in den Meta-Daten zu erhalten</a>.</li>\n<li><a href=\"https://core.trac.wordpress.org/ticket/35996\">Windows-Freigaben/DFS-Roots</a> werden nun in <code>wp_normalize_path()</code> unterstützt.</li>\n<li>Neue Installationen <a href=\"https://core.trac.wordpress.org/ticket/35290\">generieren die Secret Keys und Salts lokal</a>, statt die WordPress.org-API zu nutzen. Testet die Installation von WordPress also in Situationen ohne Internetverbindung.</li>\n<li>OPTIONS-Anfragen an die REST API <a href=\"https://core.trac.wordpress.org/ticket/35975\">sollten Allow-Header zurückgeben</a>.</li>\n<li><a href=\"https://core.trac.wordpress.org/ticket/36059\">twemoji.js auf Version 2 aktualisiert</a> und <a href=\"https://core.trac.wordpress.org/ticket/35977\">bessere IE11-Kompatibilität für Emojis hinzugefügt</a> (betrifft seltsames Verhalten von YouTube-Untertiteln).</li>\n<li>Verschiedene Bug-Fixes – Die Entwickler haben in der letzten Woche <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36931&amp;stop_rev=36814&amp;limit=200&amp;verbose=on\">mehr als 100 Änderungen</a> vorgenommen.</li>\n</ul>\n<p>Wenn ihr meint, einen Bug gefunden zu haben, könnt ihr ihn im <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta-Bereich des Forums</a> melden, oder ein Ticket <a href=\"https://make.wordpress.org/core/reports/\">im Trac</a> erstellen, wenn ihr euch damit auskennt. Dort findet ihr auch eine <a href=\"https://core.trac.wordpress.org/tickets/major\">Liste aller bereits bekannter Fehler</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://de.wordpress.org/2016/03/wordpress-4-5-beta-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:47:\"https://de.wordpress.org/category/release/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 02 Jul 2016 08:56:50 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 30 Jun 2016 18:03:09 GMT\";s:4:\"link\";s:61:\"<https://de.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20160701074030\";}", "no");
INSERT INTO `wp_options` VALUES("1115", "_transient_timeout_feed_mod_e5132d2944a7be60661ee809629a6d9c", "1467493009", "no");
INSERT INTO `wp_options` VALUES("1116", "_transient_feed_mod_e5132d2944a7be60661ee809629a6d9c", "1467449809", "no");
INSERT INTO `wp_options` VALUES("1117", "_transient_timeout_feed_8d5c87fbe8c82bb2500f5d58f08a433a", "1467493009", "no");
INSERT INTO `wp_options` VALUES("1118", "_transient_feed_8d5c87fbe8c82bb2500f5d58f08a433a", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:2:\"\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:4:\"0.92\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:37:\"\n	\n	\n	\n	\n	\n	\n\n	\n\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Deutschsprachiger Channel – WordPress Deutsch Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"http://de.planetwp.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Der Planet listet Inhalte ausgewählter Blogs auf, die regelmäßig Beiträge zu WordPress publizieren.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jun 2016 08:21:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"docs\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"http://backend.userland.com/rss092\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"de-DE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.6: vieles wird schöner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://www.perun.net/?p=8648\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Antispam Bee richtig konfigurieren\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://torstenlandsiedel.de/2016/06/27/antispam-bee-richtig-konfigurieren/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WordPress News #180 / WordCamp Europe 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://tracking.feedpress.it/link/14399/3725859\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"PW017 – WordCamp Europe 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://presswerk.net/pw017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Webschale: [WS06] Theme Review: Ulrich Pogson im Gespräch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://webschale.de/podcasts/webschale-06/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WordPress-Wochenrückblick KW 25: Update zur Codex-Migration und mehr\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://florianbrinkmann.de/2571/wordpress-wochenrueckblick-kw-25-update-zur-codex-migration-und-mehr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WP Sofa: 5 Seconds of Fame (Folge 10)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://wp-sofa.de/podcasts/5-seconds-of-fame-folge-10/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"PW016 – Wie finde ich das richtige WordPress Theme?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://presswerk.net/pw016/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 4.5.3 Sicherheits- und Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://de.wordpress.org/2016/06/wordpress-4-5-3-sicherheits-und-wartungs-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress News #179 / WooCommerce Meetup in Frankfurt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://tracking.feedpress.it/link/14399/3662136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:8;s:7:\"headers\";a:8:{s:4:\"date\";s:29:\"Sat, 02 Jul 2016 08:56:51 GMT\";s:6:\"server\";s:6:\"Apache\";s:12:\"x-powered-by\";s:9:\"PHP/7.0.0\";s:4:\"etag\";s:34:\"\"fb34f4440f90142b3358aef0d08a10d3\"\";s:4:\"link\";s:59:\"<http://de.planetwp.org/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"last-modified\";s:29:\"Thu, 30 Jun 2016 08:21:00 GMT\";s:10:\"connection\";s:5:\"close\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";}s:5:\"build\";s:14:\"20160701074030\";}", "no");
INSERT INTO `wp_options` VALUES("1119", "_transient_timeout_feed_mod_8d5c87fbe8c82bb2500f5d58f08a433a", "1467493009", "no");
INSERT INTO `wp_options` VALUES("1120", "_transient_feed_mod_8d5c87fbe8c82bb2500f5d58f08a433a", "1467449809", "no");
INSERT INTO `wp_options` VALUES("1121", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1467493010", "no");
INSERT INTO `wp_options` VALUES("1122", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 02 Jul 2016 08:29:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 15 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"The most downloaded plugin for WordPress (almost 30 million downloads). Use All in One SEO Pack to automatically optimize your site for Search Engines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Analytics by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Easy to use WordPress Slider plugin. Create responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 02 Jul 2016 08:56:52 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Sat, 02 Jul 2016 09:04:02 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Sat, 02 Jul 2016 08:29:02 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20160701074030\";}", "no");
INSERT INTO `wp_options` VALUES("1123", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1467493011", "no");
INSERT INTO `wp_options` VALUES("1124", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1467449811", "no");
INSERT INTO `wp_options` VALUES("1125", "_transient_timeout_dash_898c881de4a92ca37616885905bba3b7", "1467493011", "no");
INSERT INTO `wp_options` VALUES("1126", "_transient_dash_898c881de4a92ca37616885905bba3b7", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://de.wordpress.org/2016/06/wordpress-4-6-beta-1/\'>WordPress 4.6 Beta 1</a> <span class=\"rss-date\">30. Juni 2016</span><div class=\"rssSummary\">Die erste Beta-Version von WordPress 4.6 ist nun verfügbar. Wie der Name schon sagt, handelt es sich dabei nicht um die finale Version und sollte daher nur in einer lokalen oder abgesicherten Testumgebung installiert werden. WordPress 4.6 Beta 1 kann entweder über das Plugin WordPress Beta Tester installiert oder als Zip-Archiv heruntergeladen werden. Es ist [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://www.perun.net/?p=8648\'>WordPress 4.6: vieles wird schöner</a></li><li><a class=\'rsswidget\' href=\'http://torstenlandsiedel.de/2016/06/27/antispam-bee-richtig-konfigurieren/\'>Antispam Bee richtig konfigurieren</a></li><li><a class=\'rsswidget\' href=\'http://tracking.feedpress.it/link/14399/3725859\'>WordPress News #180 / WordCamp Europe 2016</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Beliebtes Plugin:</span> Clef Two-Factor Authentication&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=wpclef&amp;_wpnonce=2daf0681f4&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Installiere Clef Two-Factor Authentication\">(Installieren)</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("1127", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-02 08:57:51\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.5.49\";s:10:\"VersionPHP\";s:15:\"5.4.45-0+deb7u4\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20160702_meinkleineryogakurs\";s:4:\"Hash\";s:29:\"5777820f180fc8846160702085751\";s:8:\"NameHash\";s:58:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/var/www/clients/client9/web13/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://student11.wpstore.d-hosting.de/wp-snapshots/\";s:8:\"ScanFile\";s:68:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/var/www/clients/client9/web13/web\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-02 08:57:51\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.5.49\";s:10:\"VersionPHP\";s:15:\"5.4.45-0+deb7u4\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20160702_meinkleineryogakurs\";s:4:\"Hash\";s:29:\"5777820f180fc8846160702085751\";s:8:\"NameHash\";s:58:\"20160702_meinkleineryogakurs_5777820f180fc8846160702085751\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:51:\"/var/www/clients/client9/web13/web/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://student11.wpstore.d-hosting.de/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");
INSERT INTO `wp_options` VALUES("1130", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/de_DE/wordpress-4.5.3.zip\";s:6:\"locale\";s:5:\"de_DE\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/de_DE/wordpress-4.5.3.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.3\";s:7:\"version\";s:5:\"4.5.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1467449895;s:15:\"version_checked\";s:5:\"4.5.3\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1131", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1467449898;s:7:\"checked\";a:5:{s:22:\"tiny-framework - kopie\";s:5:\"2.1.1\";s:14:\"tiny-framework\";s:5:\"2.1.1\";s:13:\"twentyfifteen\";s:3:\"1.5\";s:14:\"twentyfourteen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1132", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1467449896;s:8:\"response\";a:1:{s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"3.3.4\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.3.4.zip\";s:6:\"tested\";s:5:\"4.5.3\";s:13:\"compatibility\";O:8:\"stdClass\":1:{s:6:\"scalar\";O:8:\"stdClass\":1:{s:6:\"scalar\";b:0;}}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:29:\"antispam-bee/antispam_bee.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"6050\";s:4:\"slug\";s:12:\"antispam-bee\";s:6:\"plugin\";s:29:\"antispam-bee/antispam_bee.php\";s:11:\"new_version\";s:5:\"2.6.8\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/antispam-bee/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/antispam-bee.2.6.8.zip\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"4.4.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.2.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.1.12\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.1.12.zip\";}s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"52040\";s:4:\"slug\";s:24:\"responsive-lightbox-lite\";s:6:\"plugin\";s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/responsive-lightbox-lite/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/responsive-lightbox-lite.1.3.2.zip\";}s:24:\"simple-lightbox/main.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"14990\";s:4:\"slug\";s:15:\"simple-lightbox\";s:6:\"plugin\";s:24:\"simple-lightbox/main.php\";s:11:\"new_version\";s:5:\"2.5.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/simple-lightbox/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/simple-lightbox.zip\";}}}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("2", "4", "_form", "<p> Name <br />\n    [text* your-name] </p>\n\n<p> Email <br />\n    [email* your-email] </p>\n\n<p>Betreff<br />\n    [text your-subject] </p>\n\n<p>Mitteilung<br />\n    [textarea your-message] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO `wp_postmeta` VALUES("3", "4", "_mail", "a:8:{s:7:\"subject\";s:38:\"mein kleiner yogakurs \"[your-subject]\"\";s:6:\"sender\";s:32:\"[your-name] <freefeeling@web.de>\";s:4:\"body\";s:196:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://student11.wpstore.d-hosting.de)\";s:9:\"recipient\";s:18:\"freefeeling@web.de\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("4", "4", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:38:\"mein kleiner yogakurs \"[your-subject]\"\";s:6:\"sender\";s:42:\"mein kleiner yogakurs <freefeeling@web.de>\";s:4:\"body\";s:138:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://student11.wpstore.d-hosting.de)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:28:\"Reply-To: freefeeling@web.de\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("5", "4", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:31:\"Das Datumsformat ist ungültig.\";s:14:\"date_too_early\";s:47:\"Das Datum liegt vor dem ersten erlaubten Datum.\";s:13:\"date_too_late\";s:48:\"Das Datum liegt nach dem letzen erlaubten Datum.\";s:13:\"upload_failed\";s:57:\"Ein unbekannter Fehler trat beim Hochladen der Datei auf.\";s:24:\"upload_file_type_invalid\";s:64:\"Du hast nicht die Berechtigung, Dateien dieses Typs hochzuladen.\";s:21:\"upload_file_too_large\";s:23:\"Die Datei ist zu groß.\";s:23:\"upload_failed_php_error\";s:48:\"Es trat ein Fehler beim Hochladen der Datei auf.\";s:14:\"invalid_number\";s:31:\"Das Zahlenformat ist ungültig.\";s:16:\"number_too_small\";s:48:\"Die Zahl ist niedriger als das erlaubte Minimum.\";s:16:\"number_too_large\";s:47:\"Die Zahl ist größer als das erlaubte Maximum.\";s:23:\"quiz_answer_not_correct\";s:35:\"Die Antwort zu dem Quiz ist falsch.\";s:17:\"captcha_not_match\";s:33:\"Ihr eingegebener Code ist falsch.\";s:13:\"invalid_email\";s:45:\"Die eingegebene E-Mail-Adresse ist ungültig.\";s:11:\"invalid_url\";s:22:\"Die URL ist ungültig.\";s:11:\"invalid_tel\";s:32:\"Die Telefonnummer ist ungültig.\";}");
INSERT INTO `wp_postmeta` VALUES("6", "4", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("7", "4", "_locale", "de_DE");
INSERT INTO `wp_postmeta` VALUES("11", "6", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("12", "6", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("13", "6", "_edit_lock", "1467279495:1");
INSERT INTO `wp_postmeta` VALUES("17", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("18", "12", "_edit_lock", "1467279511:1");
INSERT INTO `wp_postmeta` VALUES("21", "12", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("22", "1", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("23", "1", "_wp_trash_meta_time", "1466503185");
INSERT INTO `wp_postmeta` VALUES("24", "1", "_wp_desired_post_slug", "hallo-welt");
INSERT INTO `wp_postmeta` VALUES("25", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("26", "18", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27", "18", "_edit_lock", "1467401508:1");
INSERT INTO `wp_postmeta` VALUES("28", "18", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("37", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("38", "21", "_edit_lock", "1467279464:1");
INSERT INTO `wp_postmeta` VALUES("39", "21", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("48", "24", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("49", "24", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("50", "24", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("51", "24", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("52", "24", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("53", "24", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("54", "24", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("55", "24", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("56", "24", "_menu_item_orphaned", "1466503878");
INSERT INTO `wp_postmeta` VALUES("57", "25", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("58", "25", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("59", "25", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("60", "25", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("61", "25", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("62", "25", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("63", "25", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("64", "25", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("65", "25", "_menu_item_orphaned", "1466503878");
INSERT INTO `wp_postmeta` VALUES("66", "26", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("67", "26", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("68", "26", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("69", "26", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("70", "26", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("71", "26", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("72", "26", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("73", "26", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("74", "26", "_menu_item_orphaned", "1466503878");
INSERT INTO `wp_postmeta` VALUES("75", "27", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("76", "27", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("77", "27", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("78", "27", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("79", "27", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("80", "27", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("81", "27", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("82", "27", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("83", "27", "_menu_item_orphaned", "1466503878");
INSERT INTO `wp_postmeta` VALUES("102", "30", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("103", "30", "_edit_lock", "1467280737:1");
INSERT INTO `wp_postmeta` VALUES("107", "32", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("108", "32", "_edit_lock", "1467280667:1");
INSERT INTO `wp_postmeta` VALUES("180", "69", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("181", "69", "_edit_lock", "1467280617:1");
INSERT INTO `wp_postmeta` VALUES("208", "86", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("209", "86", "_edit_lock", "1467360822:1");
INSERT INTO `wp_postmeta` VALUES("210", "86", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("245", "95", "_wp_attached_file", "2016/06/yoga-1.png");
INSERT INTO `wp_postmeta` VALUES("246", "95", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:180;s:6:\"height\";i:180;s:4:\"file\";s:18:\"2016/06/yoga-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"yoga-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("247", "96", "_wp_attached_file", "2016/06/titelbild.png");
INSERT INTO `wp_postmeta` VALUES("248", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:170;s:4:\"file\";s:21:\"2016/06/titelbild.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"titelbild-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("249", "101", "_wp_attached_file", "2016/06/titel_spiegel-e1466675769263.png");
INSERT INTO `wp_postmeta` VALUES("250", "101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:170;s:4:\"file\";s:40:\"2016/06/titel_spiegel-e1466675769263.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"titel_spiegel-e1466675769263-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("251", "101", "_wp_attachment_backup_sizes", "a:2:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:165;s:6:\"height\";i:170;s:4:\"file\";s:17:\"titel_spiegel.png\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:25:\"titel_spiegel-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}");
INSERT INTO `wp_postmeta` VALUES("257", "114", "_wp_attached_file", "2016/06/head.jpg");
INSERT INTO `wp_postmeta` VALUES("258", "114", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:4288;s:6:\"height\";i:1428;s:4:\"file\";s:16:\"2016/06/head.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"head-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"head-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"head-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"head-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"head-960x320.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("259", "114", "_wp_attachment_custom_header_last_used_tiny-forge", "1467119052");
INSERT INTO `wp_postmeta` VALUES("260", "114", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("261", "116", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("262", "116", "_edit_lock", "1466789464:1");
INSERT INTO `wp_postmeta` VALUES("263", "117", "_wp_attached_file", "2016/06/ARM-1.png");
INSERT INTO `wp_postmeta` VALUES("264", "117", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:182;s:4:\"file\";s:17:\"2016/06/ARM-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"ARM-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("265", "118", "_wp_attached_file", "2016/06/AUF.png");
INSERT INTO `wp_postmeta` VALUES("266", "118", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:246;s:6:\"height\";i:120;s:4:\"file\";s:15:\"2016/06/AUF.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"AUF-150x120.png\";s:5:\"width\";i:150;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("267", "119", "_wp_attached_file", "2016/06/AUGEN-1.png");
INSERT INTO `wp_postmeta` VALUES("268", "119", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:302;s:6:\"height\";i:96;s:4:\"file\";s:19:\"2016/06/AUGEN-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"AUGEN-1-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"AUGEN-1-300x95.png\";s:5:\"width\";i:300;s:6:\"height\";i:95;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("269", "120", "_wp_attached_file", "2016/06/BAUM.png");
INSERT INTO `wp_postmeta` VALUES("270", "120", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:135;s:6:\"height\";i:274;s:4:\"file\";s:16:\"2016/06/BAUM.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"BAUM-135x150.png\";s:5:\"width\";i:135;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("271", "121", "_wp_attached_file", "2016/06/BEIN.png");
INSERT INTO `wp_postmeta` VALUES("272", "121", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:232;s:6:\"height\";i:255;s:4:\"file\";s:16:\"2016/06/BEIN.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"BEIN-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("275", "123", "_wp_attached_file", "2016/06/BRUEXPA.png");
INSERT INTO `wp_postmeta` VALUES("276", "123", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:183;s:4:\"file\";s:19:\"2016/06/BRUEXPA.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"BRUEXPA-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("277", "124", "_wp_attached_file", "2016/06/GESPREI.png");
INSERT INTO `wp_postmeta` VALUES("278", "124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:109;s:4:\"file\";s:19:\"2016/06/GESPREI.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"GESPREI-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"GESPREI-300x86.png\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("279", "125", "_wp_attached_file", "2016/06/HALTUNG.png");
INSERT INTO `wp_postmeta` VALUES("280", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:205;s:4:\"file\";s:19:\"2016/06/HALTUNG.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"HALTUNG-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("281", "126", "_wp_attached_file", "2016/06/JAPSITZ.png");
INSERT INTO `wp_postmeta` VALUES("282", "126", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:152;s:6:\"height\";i:233;s:4:\"file\";s:19:\"2016/06/JAPSITZ.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"JAPSITZ-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("285", "128", "_wp_attached_file", "2016/06/KOBRA.png");
INSERT INTO `wp_postmeta` VALUES("286", "128", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:191;s:4:\"file\";s:17:\"2016/06/KOBRA.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"KOBRA-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"KOBRA-300x151.png\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("289", "130", "_wp_attached_file", "2016/06/NACKEN.png");
INSERT INTO `wp_postmeta` VALUES("290", "130", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:379;s:6:\"height\";i:92;s:4:\"file\";s:18:\"2016/06/NACKEN.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"NACKEN-150x92.png\";s:5:\"width\";i:150;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"NACKEN-300x73.png\";s:5:\"width\";i:300;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("291", "131", "_wp_attached_file", "2016/06/PFLUG.png");
INSERT INTO `wp_postmeta` VALUES("292", "131", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:255;s:6:\"height\";i:156;s:4:\"file\";s:17:\"2016/06/PFLUG.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"PFLUG-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("295", "133", "_wp_attached_file", "2016/06/ZUBLATT.png");
INSERT INTO `wp_postmeta` VALUES("296", "133", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:239;s:6:\"height\";i:88;s:4:\"file\";s:19:\"2016/06/ZUBLATT.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ZUBLATT-150x88.png\";s:5:\"width\";i:150;s:6:\"height\";i:88;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("297", "116", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("306", "116", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("307", "116", "_wp_trash_meta_time", "1466789614");
INSERT INTO `wp_postmeta` VALUES("308", "116", "_wp_desired_post_slug", "galerie");
INSERT INTO `wp_postmeta` VALUES("309", "136", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("310", "136", "_edit_lock", "1467208608:1");
INSERT INTO `wp_postmeta` VALUES("311", "136", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("335", "145", "_wp_attached_file", "2016/06/jungfer-im-grünen.jpg");
INSERT INTO `wp_postmeta` VALUES("336", "145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:31:\"2016/06/jungfer-im-grünen.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"jungfer-im-grünen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"jungfer-im-grünen-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("337", "146", "_wp_attached_file", "2016/06/küchenshcelle.jpg");
INSERT INTO `wp_postmeta` VALUES("338", "146", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:210;s:6:\"height\";i:149;s:4:\"file\";s:27:\"2016/06/küchenshcelle.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"küchenshcelle-150x149.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:149;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("343", "149", "_wp_attached_file", "2016/06/jungfer-im-grünen-1.jpg");
INSERT INTO `wp_postmeta` VALUES("344", "149", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-1-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("345", "150", "_wp_attached_file", "2016/06/küchenshcelle-1.jpg");
INSERT INTO `wp_postmeta` VALUES("346", "150", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:210;s:6:\"height\";i:149;s:4:\"file\";s:29:\"2016/06/küchenshcelle-1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"küchenshcelle-1-150x149.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:149;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("351", "146", "_wp_attachment_image_alt", "küchenschelle");
INSERT INTO `wp_postmeta` VALUES("354", "157", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("355", "157", "_edit_lock", "1467280557:1");
INSERT INTO `wp_postmeta` VALUES("356", "158", "_wp_attached_file", "2016/06/BAUM-1.png");
INSERT INTO `wp_postmeta` VALUES("357", "158", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:135;s:6:\"height\";i:274;s:4:\"file\";s:18:\"2016/06/BAUM-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"BAUM-1-135x150.png\";s:5:\"width\";i:135;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("358", "158", "_wp_attachment_image_alt", "baum");
INSERT INTO `wp_postmeta` VALUES("371", "164", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("372", "164", "_edit_lock", "1467280546:1");
INSERT INTO `wp_postmeta` VALUES("375", "166", "_wp_attached_file", "2016/06/BEIN-1.png");
INSERT INTO `wp_postmeta` VALUES("376", "166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:232;s:6:\"height\";i:255;s:4:\"file\";s:18:\"2016/06/BEIN-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"BEIN-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("377", "166", "_wp_attachment_image_alt", "beinüberschlag");
INSERT INTO `wp_postmeta` VALUES("392", "30", "_wp_old_slug", "arm-heben");
INSERT INTO `wp_postmeta` VALUES("403", "157", "_wp_old_slug", "baum");
INSERT INTO `wp_postmeta` VALUES("408", "170", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("409", "170", "_edit_lock", "1467020929:1");
INSERT INTO `wp_postmeta` VALUES("444", "170", "_wp_trash_meta_status", "draft");
INSERT INTO `wp_postmeta` VALUES("445", "170", "_wp_trash_meta_time", "1467021076");
INSERT INTO `wp_postmeta` VALUES("446", "170", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("447", "189", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("448", "189", "_edit_lock", "1467280531:1");
INSERT INTO `wp_postmeta` VALUES("458", "192", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("459", "192", "_edit_lock", "1467280472:1");
INSERT INTO `wp_postmeta` VALUES("487", "21", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("488", "209", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("489", "209", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("490", "209", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("491", "209", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("492", "209", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("493", "209", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("494", "209", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("495", "209", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("497", "210", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("498", "210", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("499", "210", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("500", "210", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("501", "210", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("502", "210", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("503", "210", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("504", "210", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("506", "211", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("507", "211", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("508", "211", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("509", "211", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("510", "211", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("511", "211", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("512", "211", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("513", "211", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("514", "211", "_menu_item_orphaned", "1467098308");
INSERT INTO `wp_postmeta` VALUES("515", "212", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("516", "212", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("517", "212", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("518", "212", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("519", "212", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("520", "212", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("521", "212", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("522", "212", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("523", "212", "_menu_item_orphaned", "1467098308");
INSERT INTO `wp_postmeta` VALUES("533", "214", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("534", "214", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("535", "214", "_menu_item_object_id", "86");
INSERT INTO `wp_postmeta` VALUES("536", "214", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("537", "214", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("538", "214", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("539", "214", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("540", "214", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("542", "215", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("543", "215", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("544", "215", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("545", "215", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("546", "215", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("547", "215", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("548", "215", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("549", "215", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("551", "216", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("552", "216", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("553", "216", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("554", "216", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("555", "216", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("556", "216", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("557", "216", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("558", "216", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("560", "217", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("561", "217", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("562", "217", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("563", "217", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("564", "217", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("565", "217", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("566", "217", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("567", "217", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("569", "218", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("570", "218", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("571", "218", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("572", "218", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("573", "218", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("574", "218", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("575", "218", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("576", "218", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("578", "86", "_yoast_wpseo_content_score", "90");
INSERT INTO `wp_postmeta` VALUES("579", "4", "_config_errors", "a:1:{s:11:\"mail.sender\";i:103;}");
INSERT INTO `wp_postmeta` VALUES("582", "222", "title", "NextGEN Basic Thumbnails");
INSERT INTO `wp_postmeta` VALUES("583", "222", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_gallery/static/thumb_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("584", "222", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("585", "222", "view_order", "10000");
INSERT INTO `wp_postmeta` VALUES("586", "222", "name", "photocrati-nextgen_basic_thumbnails");
INSERT INTO `wp_postmeta` VALUES("587", "222", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("588", "222", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("589", "222", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("590", "222", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("591", "222", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("592", "222", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("593", "222", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJpbWFnZXNfcGVyX3BhZ2UiOiIyMCIsIm51bWJlcl9vZl9jb2x1bW5zIjowLCJ0aHVtYm5haWxfd2lkdGgiOjI0MCwidGh1bWJuYWlsX2hlaWdodCI6MTYwLCJzaG93X2FsbF9pbl9saWdodGJveCI6MCwiYWpheF9wYWdpbmF0aW9uIjowLCJ1c2VfaW1hZ2Vicm93c2VyX2VmZmVjdCI6MCwidGVtcGxhdGUiOiIiLCJkaXNwbGF5X25vX2ltYWdlc19lcnJvciI6MSwiZGlzYWJsZV9wYWdpbmF0aW9uIjowLCJzaG93X3NsaWRlc2hvd19saW5rIjoxLCJzbGlkZXNob3dfbGlua190ZXh0IjoiW1plaWdlIGVpbmUgU2xpZGVzaG93XSIsIm92ZXJyaWRlX3RodW1ibmFpbF9zZXR0aW5ncyI6MCwidGh1bWJuYWlsX3F1YWxpdHkiOiIxMDAiLCJ0aHVtYm5haWxfY3JvcCI6MSwidGh1bWJuYWlsX3dhdGVybWFyayI6MCwibmdnX3RyaWdnZXJzX2Rpc3BsYXkiOiJuZXZlciJ9");
INSERT INTO `wp_postmeta` VALUES("594", "223", "title", "NextGEN Basic Slideshow");
INSERT INTO `wp_postmeta` VALUES("595", "223", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_gallery/static/slideshow_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("596", "223", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("597", "223", "view_order", "10010");
INSERT INTO `wp_postmeta` VALUES("598", "223", "name", "photocrati-nextgen_basic_slideshow");
INSERT INTO `wp_postmeta` VALUES("599", "223", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("600", "223", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("601", "223", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("602", "223", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("603", "223", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("604", "223", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("605", "223", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJ5X3dpZHRoIjo2MDAsImdhbGxlcnlfaGVpZ2h0Ijo0MDAsInRodW1ibmFpbF93aWR0aCI6MjQwLCJ0aHVtYm5haWxfaGVpZ2h0IjoxNjAsImN5Y2xlX2ludGVydmFsIjoxMCwiY3ljbGVfZWZmZWN0IjpudWxsLCJlZmZlY3RfY29kZSI6ImNsYXNzPVwibmdnLWZhbmN5Ym94XCIgcmVsPVwiJUdBTExFUllfTkFNRSVcIiIsInNob3dfdGh1bWJuYWlsX2xpbmsiOjEsInRodW1ibmFpbF9saW5rX3RleHQiOiJbWmVpZ2UgVm9yc2NoYXViaWxkZXJdIiwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("606", "224", "title", "NextGEN Basic ImageBrowser");
INSERT INTO `wp_postmeta` VALUES("607", "224", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_imagebrowser/static/preview.jpg");
INSERT INTO `wp_postmeta` VALUES("608", "224", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("609", "224", "view_order", "10020");
INSERT INTO `wp_postmeta` VALUES("610", "224", "name", "photocrati-nextgen_basic_imagebrowser");
INSERT INTO `wp_postmeta` VALUES("611", "224", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("612", "224", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("613", "224", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("614", "224", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("615", "224", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("616", "224", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("617", "224", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJ0ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifQ==");
INSERT INTO `wp_postmeta` VALUES("618", "225", "title", "NextGEN Basic SinglePic");
INSERT INTO `wp_postmeta` VALUES("619", "225", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_singlepic/static/preview.gif");
INSERT INTO `wp_postmeta` VALUES("620", "225", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("621", "225", "view_order", "10060");
INSERT INTO `wp_postmeta` VALUES("622", "225", "hidden_from_ui", "1");
INSERT INTO `wp_postmeta` VALUES("623", "225", "name", "photocrati-nextgen_basic_singlepic");
INSERT INTO `wp_postmeta` VALUES("624", "225", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("625", "225", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("626", "225", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("627", "225", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("628", "225", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("629", "225", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJ3aWR0aCI6IiIsImhlaWdodCI6IiIsIm1vZGUiOiIiLCJkaXNwbGF5X3dhdGVybWFyayI6MCwiZGlzcGxheV9yZWZsZWN0aW9uIjowLCJmbG9hdCI6IiIsImxpbmsiOiIiLCJsaW5rX3RhcmdldCI6Il9ibGFuayIsInF1YWxpdHkiOjEwMCwiY3JvcCI6MCwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("630", "226", "title", "NextGEN Basic TagCloud");
INSERT INTO `wp_postmeta` VALUES("631", "226", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_tagcloud/static/preview.gif");
INSERT INTO `wp_postmeta` VALUES("632", "226", "default_source", "tags");
INSERT INTO `wp_postmeta` VALUES("633", "226", "view_order", "10100");
INSERT INTO `wp_postmeta` VALUES("634", "226", "name", "photocrati-nextgen_basic_tagcloud");
INSERT INTO `wp_postmeta` VALUES("635", "226", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("636", "226", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("637", "226", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("638", "226", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("639", "226", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("640", "226", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("641", "226", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJkaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsIm51bWJlciI6NDUsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifQ==");
INSERT INTO `wp_postmeta` VALUES("642", "227", "title", "NextGEN Basic Compact Album");
INSERT INTO `wp_postmeta` VALUES("643", "227", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_album/static/compact_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("644", "227", "default_source", "albums");
INSERT INTO `wp_postmeta` VALUES("645", "227", "view_order", "10200");
INSERT INTO `wp_postmeta` VALUES("646", "227", "name", "photocrati-nextgen_basic_compact_album");
INSERT INTO `wp_postmeta` VALUES("647", "227", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("648", "227", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("649", "227", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("650", "227", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("651", "227", "entity_types", "WyJhbGJ1bSIsImdhbGxlcnkiXQ==");
INSERT INTO `wp_postmeta` VALUES("652", "227", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("653", "227", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJpZXNfcGVyX3BhZ2UiOjAsImVuYWJsZV9icmVhZGNydW1icyI6MSwiZGlzYWJsZV9wYWdpbmF0aW9uIjowLCJ0ZW1wbGF0ZSI6IiIsImdhbGxlcnlfZGlzcGxheV90eXBlIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3RodW1ibmFpbHMiLCJnYWxsZXJ5X2Rpc3BsYXlfdGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("654", "228", "title", "NextGEN Basic Extended Album");
INSERT INTO `wp_postmeta` VALUES("655", "228", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_album/static/extended_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("656", "228", "default_source", "albums");
INSERT INTO `wp_postmeta` VALUES("657", "228", "view_order", "10210");
INSERT INTO `wp_postmeta` VALUES("658", "228", "name", "photocrati-nextgen_basic_extended_album");
INSERT INTO `wp_postmeta` VALUES("659", "228", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("660", "228", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("661", "228", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("662", "228", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("663", "228", "entity_types", "WyJhbGJ1bSIsImdhbGxlcnkiXQ==");
INSERT INTO `wp_postmeta` VALUES("664", "228", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("665", "228", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJpZXNfcGVyX3BhZ2UiOjAsImVuYWJsZV9icmVhZGNydW1icyI6MSwiZGlzYWJsZV9wYWdpbmF0aW9uIjowLCJ0ZW1wbGF0ZSI6IiIsIm92ZXJyaWRlX3RodW1ibmFpbF9zZXR0aW5ncyI6MCwidGh1bWJuYWlsX3dpZHRoIjoyNDAsInRodW1ibmFpbF9oZWlnaHQiOjE2MCwidGh1bWJuYWlsX3F1YWxpdHkiOjEwMCwidGh1bWJuYWlsX2Nyb3AiOnRydWUsInRodW1ibmFpbF93YXRlcm1hcmsiOjAsImdhbGxlcnlfZGlzcGxheV90eXBlIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3RodW1ibmFpbHMiLCJnYWxsZXJ5X2Rpc3BsYXlfdGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("668", "136", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("673", "149", "_wp_attachment_image_alt", "jungfer im grünen");
INSERT INTO `wp_postmeta` VALUES("677", "233", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("678", "233", "_edit_lock", "1467136024:1");
INSERT INTO `wp_postmeta` VALUES("679", "233", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("689", "233", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("690", "233", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("691", "233", "_wp_trash_meta_time", "1467136243");
INSERT INTO `wp_postmeta` VALUES("692", "233", "_wp_desired_post_slug", "neue-galerie");
INSERT INTO `wp_postmeta` VALUES("693", "236", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("694", "236", "_edit_lock", "1467138013:1");
INSERT INTO `wp_postmeta` VALUES("695", "236", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("705", "236", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("706", "236", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("707", "236", "_wp_trash_meta_time", "1467136645");
INSERT INTO `wp_postmeta` VALUES("711", "241", "_wp_attached_file", "2016/06/jungfer-im-grünen-2.jpg");
INSERT INTO `wp_postmeta` VALUES("712", "241", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-2-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("713", "242", "_wp_attached_file", "2016/06/Küchenschelle.jpg");
INSERT INTO `wp_postmeta` VALUES("714", "242", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:27:\"2016/06/Küchenschelle.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Küchenschelle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"Küchenschelle-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("719", "245", "_wp_attached_file", "2016/06/jungfer-im-grünen-3.jpg");
INSERT INTO `wp_postmeta` VALUES("720", "245", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-3.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-3-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("730", "248", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("731", "248", "_edit_lock", "1467280425:1");
INSERT INTO `wp_postmeta` VALUES("736", "248", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("737", "248", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("742", "192", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("743", "192", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("770", "189", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("771", "189", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("778", "259", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("781", "259", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("782", "259", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("783", "259", "_edit_lock", "1467280370:1");
INSERT INTO `wp_postmeta` VALUES("784", "261", "_wp_attached_file", "2016/06/HALTUNG-2.png");
INSERT INTO `wp_postmeta` VALUES("785", "261", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:205;s:4:\"file\";s:21:\"2016/06/HALTUNG-2.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"HALTUNG-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("786", "261", "_wp_attachment_image_alt", "haltungsgriff");
INSERT INTO `wp_postmeta` VALUES("797", "264", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("800", "264", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("801", "264", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("802", "264", "_edit_lock", "1467280357:1");
INSERT INTO `wp_postmeta` VALUES("816", "269", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("819", "269", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("820", "269", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("821", "269", "_edit_lock", "1467280307:1");
INSERT INTO `wp_postmeta` VALUES("831", "236", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("832", "236", "_wp_trash_meta_time", "1467185905");
INSERT INTO `wp_postmeta` VALUES("833", "236", "_wp_desired_post_slug", "jetzt-reichts");
INSERT INTO `wp_postmeta` VALUES("834", "275", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("837", "275", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("838", "275", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("839", "275", "_edit_lock", "1467382642:1");
INSERT INTO `wp_postmeta` VALUES("845", "279", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("848", "279", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("849", "279", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("850", "279", "_edit_lock", "1467280213:1");
INSERT INTO `wp_postmeta` VALUES("872", "285", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("873", "285", "_edit_lock", "1467280165:1");
INSERT INTO `wp_postmeta` VALUES("876", "285", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("877", "285", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("887", "290", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("888", "290", "_edit_lock", "1467280119:1");
INSERT INTO `wp_postmeta` VALUES("891", "290", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("892", "290", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("902", "296", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("903", "296", "_edit_lock", "1467280067:1");
INSERT INTO `wp_postmeta` VALUES("906", "296", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("907", "296", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("915", "301", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("916", "301", "_edit_lock", "1467190756:1");
INSERT INTO `wp_postmeta` VALUES("917", "301", "_wp_trash_meta_status", "draft");
INSERT INTO `wp_postmeta` VALUES("918", "301", "_wp_trash_meta_time", "1467190788");
INSERT INTO `wp_postmeta` VALUES("919", "301", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("920", "303", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("921", "303", "_edit_lock", "1467383171:1");
INSERT INTO `wp_postmeta` VALUES("924", "303", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("925", "303", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("939", "311", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("940", "311", "_edit_lock", "1467382783:1");
INSERT INTO `wp_postmeta` VALUES("943", "311", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("944", "311", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("984", "30", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("985", "30", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("988", "32", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("989", "32", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("992", "69", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("993", "69", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("996", "157", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("997", "157", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("1002", "164", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("1003", "164", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("1034", "245", "_edit_lock", "1467208415:1");
INSERT INTO `wp_postmeta` VALUES("1035", "123", "_wp_attachment_image_alt", "brustexpander");
INSERT INTO `wp_postmeta` VALUES("1036", "136", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1037", "136", "_wp_trash_meta_time", "1467208757");
INSERT INTO `wp_postmeta` VALUES("1038", "136", "_wp_desired_post_slug", "galerie");
INSERT INTO `wp_postmeta` VALUES("1039", "355", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1040", "355", "_edit_lock", "1467353593:1");
INSERT INTO `wp_postmeta` VALUES("1045", "358", "_wp_attached_file", "2016/06/jungfer-im-grünen-4.jpg");
INSERT INTO `wp_postmeta` VALUES("1046", "358", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-4.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-4-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1047", "359", "_wp_attached_file", "2016/06/küchenschelle.jpg");
INSERT INTO `wp_postmeta` VALUES("1048", "359", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:27:\"2016/06/küchenschelle.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"küchenschelle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"küchenschelle-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1055", "358", "_wp_attachment_image_alt", "jungfer im grünen");
INSERT INTO `wp_postmeta` VALUES("1056", "359", "_wp_attachment_image_alt", "küchenschelle");
INSERT INTO `wp_postmeta` VALUES("1059", "355", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1060", "362", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("1061", "362", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1062", "362", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1063", "362", "_menu_item_object_id", "355");
INSERT INTO `wp_postmeta` VALUES("1064", "362", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1065", "362", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1066", "362", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1067", "362", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1068", "362", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1069", "355", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1114", "6", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("1115", "387", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1116", "387", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1117", "387", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("1118", "387", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1119", "387", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1120", "387", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1121", "387", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1122", "387", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1124", "388", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1125", "388", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1126", "388", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("1127", "388", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1128", "388", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1129", "388", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1130", "388", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1131", "388", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1133", "389", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1134", "389", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1135", "389", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("1136", "389", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1137", "389", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1138", "389", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1139", "389", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1140", "389", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1142", "390", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1143", "390", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1144", "390", "_menu_item_object_id", "86");
INSERT INTO `wp_postmeta` VALUES("1145", "390", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1146", "390", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1147", "390", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1148", "390", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1149", "390", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1151", "391", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1152", "391", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1153", "391", "_menu_item_object_id", "355");
INSERT INTO `wp_postmeta` VALUES("1154", "391", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1155", "391", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1156", "391", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1157", "391", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1158", "391", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1160", "392", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1161", "392", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1162", "392", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("1163", "392", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1164", "392", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1165", "392", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1166", "392", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1167", "392", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1169", "114", "_wp_attachment_custom_header_last_used_tiny-framework", "1467271401");
INSERT INTO `wp_postmeta` VALUES("1170", "394", "_wp_attached_file", "2016/06/ZUBLATT-1.png");
INSERT INTO `wp_postmeta` VALUES("1171", "394", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:239;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2016/06/ZUBLATT-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"ZUBLATT-1-150x88.png\";s:5:\"width\";i:150;s:6:\"height\";i:88;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1172", "394", "_wp_attachment_image_alt", "zusammengerolltes blatt");
INSERT INTO `wp_postmeta` VALUES("1175", "397", "_wp_attached_file", "2016/06/SITHELD.png");
INSERT INTO `wp_postmeta` VALUES("1176", "397", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:200;s:6:\"height\";i:224;s:4:\"file\";s:19:\"2016/06/SITHELD.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"SITHELD-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1177", "397", "_wp_attachment_image_alt", "sitzender held");
INSERT INTO `wp_postmeta` VALUES("1180", "399", "_wp_attached_file", "2016/06/PFLUG-1.png");
INSERT INTO `wp_postmeta` VALUES("1181", "399", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:255;s:6:\"height\";i:156;s:4:\"file\";s:19:\"2016/06/PFLUG-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"PFLUG-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1182", "399", "_wp_attachment_image_alt", "pflug");
INSERT INTO `wp_postmeta` VALUES("1185", "401", "_wp_attached_file", "2016/06/PERSITZ.png");
INSERT INTO `wp_postmeta` VALUES("1186", "401", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:160;s:6:\"height\";i:168;s:4:\"file\";s:19:\"2016/06/PERSITZ.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"PERSITZ-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1187", "401", "_wp_attachment_image_alt", "perfekter sitz");
INSERT INTO `wp_postmeta` VALUES("1190", "403", "_wp_attached_file", "2016/06/NACKEN-1.png");
INSERT INTO `wp_postmeta` VALUES("1191", "403", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:379;s:6:\"height\";i:92;s:4:\"file\";s:20:\"2016/06/NACKEN-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"NACKEN-1-150x92.png\";s:5:\"width\";i:150;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"NACKEN-1-300x73.png\";s:5:\"width\";i:300;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1192", "403", "_wp_attachment_image_alt", "nacken rollen");
INSERT INTO `wp_postmeta` VALUES("1195", "405", "_wp_attached_file", "2016/06/KOPF.png");
INSERT INTO `wp_postmeta` VALUES("1196", "405", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:150;s:6:\"height\";i:278;s:4:\"file\";s:16:\"2016/06/KOPF.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"KOPF-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1199", "407", "_wp_attached_file", "2016/06/KOBRA-1.png");
INSERT INTO `wp_postmeta` VALUES("1200", "407", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:191;s:4:\"file\";s:19:\"2016/06/KOBRA-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"KOBRA-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"KOBRA-1-300x151.png\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1201", "407", "_wp_attachment_image_alt", "kobra");
INSERT INTO `wp_postmeta` VALUES("1204", "409", "_wp_attached_file", "2016/06/KERZE.png");
INSERT INTO `wp_postmeta` VALUES("1205", "409", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:153;s:6:\"height\";i:268;s:4:\"file\";s:17:\"2016/06/KERZE.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"KERZE-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1206", "409", "_wp_attachment_image_alt", "kerze");
INSERT INTO `wp_postmeta` VALUES("1209", "411", "_wp_attached_file", "2016/06/JAPSITZ-1.png");
INSERT INTO `wp_postmeta` VALUES("1210", "411", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:152;s:6:\"height\";i:233;s:4:\"file\";s:21:\"2016/06/JAPSITZ-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"JAPSITZ-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1211", "411", "_wp_attachment_image_alt", "japanischer sitz");
INSERT INTO `wp_postmeta` VALUES("1214", "413", "_wp_attached_file", "2016/06/GESPREI-1.png");
INSERT INTO `wp_postmeta` VALUES("1215", "413", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:109;s:4:\"file\";s:21:\"2016/06/GESPREI-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"GESPREI-1-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"GESPREI-1-300x86.png\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1216", "413", "_wp_attachment_image_alt", "gespreizte beinstreckung");
INSERT INTO `wp_postmeta` VALUES("1219", "415", "_wp_attached_file", "2016/06/BRUEXPA-1.png");
INSERT INTO `wp_postmeta` VALUES("1220", "415", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:183;s:4:\"file\";s:21:\"2016/06/BRUEXPA-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"BRUEXPA-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1221", "415", "_wp_attachment_image_alt", "brustexpander");
INSERT INTO `wp_postmeta` VALUES("1224", "417", "_wp_attached_file", "2016/06/BOGEN.png");
INSERT INTO `wp_postmeta` VALUES("1225", "417", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:228;s:6:\"height\";i:180;s:4:\"file\";s:17:\"2016/06/BOGEN.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BOGEN-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1226", "417", "_wp_attachment_image_alt", "bogen");
INSERT INTO `wp_postmeta` VALUES("1229", "419", "_wp_attached_file", "2016/06/AUGEN.png");
INSERT INTO `wp_postmeta` VALUES("1230", "419", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:302;s:6:\"height\";i:96;s:4:\"file\";s:17:\"2016/06/AUGEN.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"AUGEN-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"AUGEN-300x95.png\";s:5:\"width\";i:300;s:6:\"height\";i:95;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1231", "419", "_wp_attachment_image_alt", "augen rollen");
INSERT INTO `wp_postmeta` VALUES("1234", "421", "_wp_attached_file", "2016/06/AUF-1.png");
INSERT INTO `wp_postmeta` VALUES("1235", "421", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:246;s:6:\"height\";i:120;s:4:\"file\";s:17:\"2016/06/AUF-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"AUF-1-150x120.png\";s:5:\"width\";i:150;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1236", "421", "_wp_attachment_image_alt", "aufsetzen");
INSERT INTO `wp_postmeta` VALUES("1239", "423", "_wp_attached_file", "2016/06/ARM.png");
INSERT INTO `wp_postmeta` VALUES("1240", "423", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:182;s:4:\"file\";s:15:\"2016/06/ARM.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"ARM-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1241", "423", "_wp_attachment_image_alt", "arm heben");
INSERT INTO `wp_postmeta` VALUES("1242", "426", "_wp_attached_file", "2016/06/distel.jpg");
INSERT INTO `wp_postmeta` VALUES("1243", "426", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:396;s:6:\"height\";i:524;s:4:\"file\";s:18:\"2016/06/distel.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"distel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"distel-227x300.jpg\";s:5:\"width\";i:227;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1244", "427", "_wp_attached_file", "2016/06/jacobsleiter.jpg");
INSERT INTO `wp_postmeta` VALUES("1245", "427", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:396;s:6:\"height\";i:524;s:4:\"file\";s:24:\"2016/06/jacobsleiter.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"jacobsleiter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"jacobsleiter-227x300.jpg\";s:5:\"width\";i:227;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1246", "428", "_wp_attached_file", "2016/06/jungfer-im-gruenen.jpg");
INSERT INTO `wp_postmeta` VALUES("1247", "428", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:30:\"2016/06/jungfer-im-gruenen.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"jungfer-im-gruenen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"jungfer-im-gruenen-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1248", "429", "_wp_attached_file", "2016/06/kuechenschelle.jpg");
INSERT INTO `wp_postmeta` VALUES("1249", "429", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:26:\"2016/06/kuechenschelle.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"kuechenschelle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"kuechenschelle-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1250", "430", "_wp_attached_file", "2016/06/mohn.jpg");
INSERT INTO `wp_postmeta` VALUES("1251", "430", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:16:\"2016/06/mohn.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"mohn-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"mohn-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1252", "431", "_wp_attached_file", "2016/06/pfingstose.jpg");
INSERT INTO `wp_postmeta` VALUES("1253", "431", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:396;s:4:\"file\";s:22:\"2016/06/pfingstose.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pfingstose-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pfingstose-300x227.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1254", "426", "_wp_attachment_image_alt", "distel");
INSERT INTO `wp_postmeta` VALUES("1255", "430", "_wp_attachment_image_alt", "mohn");
INSERT INTO `wp_postmeta` VALUES("1256", "429", "_wp_attachment_image_alt", "kuechenschelle");
INSERT INTO `wp_postmeta` VALUES("1257", "428", "_wp_attachment_image_alt", "jungfer-im-gruenen");
INSERT INTO `wp_postmeta` VALUES("1258", "427", "_wp_attachment_image_alt", "jacobsleiter");
INSERT INTO `wp_postmeta` VALUES("1259", "431", "_wp_attachment_image_alt", "pfingstose");
INSERT INTO `wp_postmeta` VALUES("1262", "18", "_yoast_wpseo_content_score", "30");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2016-06-21 09:05:54", "2016-06-21 07:05:54", "Willkommen zur deutschen Version von WordPress. Dies ist der erste Beitrag. Du kannst ihn bearbeiten oder löschen. Und dann starte mit dem Schreiben!", "Hallo Welt!", "", "trash", "open", "open", "", "hallo-welt__trashed", "", "", "2016-06-21 11:59:45", "2016-06-21 09:59:45", "", "0", "http://student11.wpstore.d-hosting.de/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("4", "1", "2016-06-21 11:26:01", "2016-06-21 09:26:01", "<p> Name <br />\r\n    [text* your-name] </p>\r\n\r\n<p> Email <br />\r\n    [email* your-email] </p>\r\n\r\n<p>Betreff<br />\r\n    [text your-subject] </p>\r\n\r\n<p>Mitteilung<br />\r\n    [textarea your-message] </p>\r\n\r\n<p>[submit \"Send\"]</p>\nmein kleiner yogakurs \"[your-subject]\"\n[your-name] <freefeeling@web.de>\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://student11.wpstore.d-hosting.de)\nfreefeeling@web.de\nReply-To: [your-email]\n\n\n\n\nmein kleiner yogakurs \"[your-subject]\"\nmein kleiner yogakurs <freefeeling@web.de>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://student11.wpstore.d-hosting.de)\n[your-email]\nReply-To: freefeeling@web.de\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nDas Datumsformat ist ungültig.\nDas Datum liegt vor dem ersten erlaubten Datum.\nDas Datum liegt nach dem letzen erlaubten Datum.\nEin unbekannter Fehler trat beim Hochladen der Datei auf.\nDu hast nicht die Berechtigung, Dateien dieses Typs hochzuladen.\nDie Datei ist zu groß.\nEs trat ein Fehler beim Hochladen der Datei auf.\nDas Zahlenformat ist ungültig.\nDie Zahl ist niedriger als das erlaubte Minimum.\nDie Zahl ist größer als das erlaubte Maximum.\nDie Antwort zu dem Quiz ist falsch.\nIhr eingegebener Code ist falsch.\nDie eingegebene E-Mail-Adresse ist ungültig.\nDie URL ist ungültig.\nDie Telefonnummer ist ungültig.", "Contact form 1", "", "publish", "closed", "closed", "", "contact-form-1", "", "", "2016-06-28 09:36:03", "2016-06-28 07:36:03", "", "0", "http://student11.wpstore.d-hosting.de/?post_type=wpcf7_contact_form&#038;p=4", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2016-06-21 11:37:56", "2016-06-21 09:37:56", "<img class=\"wp-image-96 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alle", "", "publish", "closed", "closed", "", "yoga-fuer-alle", "", "", "2016-06-30 06:10:53", "2016-06-30 04:10:53", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=6", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2016-06-21 11:30:41", "2016-06-21 09:30:41", "", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:30:41", "2016-06-21 09:30:41", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2016-06-21 11:31:57", "2016-06-21 09:31:57", "<strong>Yoga für alle</strong>\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:31:57", "2016-06-21 09:31:57", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2016-06-21 11:32:51", "2016-06-21 09:32:51", "<strong>Yoga für alle</strong>\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:32:51", "2016-06-21 09:32:51", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2016-06-21 11:36:35", "2016-06-21 09:36:35", "<strong>Yoga für alle</strong>\r\n\r\n<img class=\"alignright wp-image-10 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/yoga.png\" alt=\"schneidersitz\" width=\"180\" height=\"180\" />\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:36:35", "2016-06-21 09:36:35", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2016-06-21 11:47:33", "2016-06-21 09:47:33", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                    </strong><img class=\"wp-image-13 size-full alignnone\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /><strong>                               </strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "publish", "closed", "closed", "", "yoga-uebungen", "", "", "2016-06-30 06:01:54", "2016-06-30 04:01:54", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=12", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2016-06-21 11:44:06", "2016-06-21 09:44:06", "<strong>Arm-Heben </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>festigt Unterarme<img class=\"alignright wp-image-13 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /></li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 11:44:06", "2016-06-21 09:44:06", "", "12", "http://student11.wpstore.d-hosting.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2016-06-21 11:47:33", "2016-06-21 09:47:33", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                                                    Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme<img class=\"alignleft wp-image-13 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" />\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 11:47:33", "2016-06-21 09:47:33", "", "12", "http://student11.wpstore.d-hosting.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2016-06-21 11:49:53", "2016-06-21 09:49:53", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                                                    Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme<img class=\"wp-image-13 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" />\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 11:49:53", "2016-06-21 09:49:53", "", "12", "http://student11.wpstore.d-hosting.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2016-06-21 11:59:45", "2016-06-21 09:59:45", "Willkommen zur deutschen Version von WordPress. Dies ist der erste Beitrag. Du kannst ihn bearbeiten oder löschen. Und dann starte mit dem Schreiben!", "Hallo Welt!", "", "inherit", "closed", "closed", "", "1-revision-v1", "", "", "2016-06-21 11:59:45", "2016-06-21 09:59:45", "", "1", "http://student11.wpstore.d-hosting.de/1-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2016-06-21 12:10:13", "2016-06-21 10:10:13", "Christine Dreßler\r\n\r\nBerlin", "impressum", "", "publish", "closed", "closed", "", "impressum", "", "", "2016-07-01 21:02:13", "2016-07-01 19:02:13", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=18", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2016-06-21 12:10:13", "2016-06-21 10:10:13", "wer\r\n\r\nwarum\r\n\r\nwo", "impressum", "", "inherit", "closed", "closed", "", "18-revision-v1", "", "", "2016-06-21 12:10:13", "2016-06-21 10:10:13", "", "18", "http://student11.wpstore.d-hosting.de/18-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2016-06-21 12:10:53", "2016-06-21 10:10:53", "[contact-form-7 id=\"121\" title=\"Contact form 1\"]\r\n\r\n&nbsp;", "kontakt", "", "publish", "closed", "closed", "", "kontakt", "", "", "2016-06-28 09:36:58", "2016-06-28 07:36:58", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=21", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2016-06-21 12:10:53", "2016-06-21 10:10:53", "formular\r\n\r\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-21 12:10:53", "2016-06-21 10:10:53", "", "21", "http://student11.wpstore.d-hosting.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2016-06-21 12:11:18", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2016-06-21 12:11:18", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=24", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2016-06-21 12:11:18", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2016-06-21 12:11:18", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=25", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2016-06-21 12:11:18", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2016-06-21 12:11:18", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=26", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2016-06-21 12:11:18", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2016-06-21 12:11:18", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=27", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2016-06-21 12:18:10", "2016-06-21 10:18:10", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-423 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png\" alt=\"arm heben\" width=\"165\" height=\"182\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "arm-heben", "", "publish", "closed", "closed", "", "arm-hebung", "", "", "2016-06-30 12:01:03", "2016-06-30 10:01:03", "", "0", "http://student11.wpstore.d-hosting.de/?p=30", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2016-06-21 12:18:10", "2016-06-21 10:18:10", "<strong>Arm-Hebung </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "arm-hebung", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:18:10", "2016-06-21 10:18:10", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2016-06-21 12:20:01", "2016-06-21 10:20:01", "<strong><img class=\"size-full wp-image-421 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF-1.png\" alt=\"aufsetzen\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "aufsetzen", "", "publish", "closed", "closed", "", "aufsetzen", "", "", "2016-06-30 12:00:03", "2016-06-30 10:00:03", "", "0", "http://student11.wpstore.d-hosting.de/?p=32", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2016-06-21 12:20:01", "2016-06-21 10:20:01", "<strong>Aufsetzen </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:20:01", "2016-06-21 10:20:01", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2016-06-21 12:21:51", "2016-06-21 10:21:51", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" />Aufsetzen </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:21:51", "2016-06-21 10:21:51", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2016-06-21 12:22:55", "2016-06-21 10:22:55", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:22:55", "2016-06-21 10:22:55", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2016-06-21 12:23:24", "2016-06-21 10:23:24", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "arm-hebung", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:23:24", "2016-06-21 10:23:24", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2016-06-21 12:33:55", "2016-06-21 10:33:55", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:33:55", "2016-06-21 10:33:55", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2016-06-21 12:35:04", "2016-06-21 10:35:04", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:35:04", "2016-06-21 10:35:04", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2016-06-21 12:36:46", "2016-06-21 10:36:46", "<strong>Yoga für alle</strong>\r\n\r\n<img class=\"alignright wp-image-10 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/yoga.png\" alt=\"schneidersitz\" width=\"180\" height=\"180\" />\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 12:36:46", "2016-06-21 10:36:46", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2016-06-21 12:38:21", "2016-06-21 10:38:21", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                                                    Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme<img class=\"wp-image-13 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" />\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "YOGA ÜBUNGEN", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 12:38:21", "2016-06-21 10:38:21", "", "12", "http://student11.wpstore.d-hosting.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2016-06-21 12:38:59", "2016-06-21 10:38:59", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                    </strong><img class=\"wp-image-13 size-full alignnone\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /><strong>                               </strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "YOGA ÜBUNGEN", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 12:38:59", "2016-06-21 10:38:59", "", "12", "http://student11.wpstore.d-hosting.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2016-06-21 12:51:55", "2016-06-21 10:51:55", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />festigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:51:55", "2016-06-21 10:51:55", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2016-06-21 12:54:00", "2016-06-21 10:54:00", "<img class=\"alignright wp-image-10 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/yoga.png\" alt=\"schneidersitz\" width=\"180\" height=\"180\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 12:54:00", "2016-06-21 10:54:00", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2016-06-21 14:19:12", "2016-06-21 12:19:12", "<img class=\"size-full wp-image-419 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN.png\" alt=\"augen rollen\" width=\"302\" height=\"96\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannendx</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "augen rollen", "", "publish", "closed", "closed", "", "augen-rollen", "", "", "2016-06-30 11:59:15", "2016-06-30 09:59:15", "", "0", "http://student11.wpstore.d-hosting.de/?p=69", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2016-06-21 14:19:12", "2016-06-21 12:19:12", "<strong>Wofür ist das gut? <img class=\"alignnone size-medium wp-image-70\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-1-300x95.gif\" alt=\"augen rollen\" width=\"300\" height=\"95\" /></strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "Augen Rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:19:12", "2016-06-21 12:19:12", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2016-06-21 14:46:05", "2016-06-21 12:46:05", "<img class=\"alignright wp-image-72 size-medium\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" /><strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "Augen Rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:46:05", "2016-06-21 12:46:05", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("75", "1", "2016-06-21 14:49:28", "2016-06-21 12:49:28", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nhilft bei angespannten und übermüdeten Augen\r\n\r\nstärkt die Augenmuskeln\r\n\r\nlindert Kopfschmerzen\r\n\r\nwirkt allgemein entspannend\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "Augen Rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:49:28", "2016-06-21 12:49:28", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("76", "1", "2016-06-21 14:52:46", "2016-06-21 12:52:46", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nhilft bei angespannten und übermüdeten Augen\r\n\r\nstärkt die Augenmuskeln\r\n\r\nlindert Kopfschmerzen\r\n\r\nwirkt allgemein entspannend\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:52:46", "2016-06-21 12:52:46", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2016-06-21 14:56:06", "2016-06-21 12:56:06", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nhilft bei angespannten und übermüdeten Augen\r\n\r\nstärkt die Augenmuskeln\r\n\r\nlindert Kopfschmerzen\r\n\r\nwirkt allgemein entspannend\r\n\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:56:06", "2016-06-21 12:56:06", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2016-06-21 14:56:55", "2016-06-21 12:56:55", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />festigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 14:56:55", "2016-06-21 12:56:55", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("79", "1", "2016-06-21 14:57:39", "2016-06-21 12:57:39", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 14:57:39", "2016-06-21 12:57:39", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("80", "1", "2016-06-21 15:02:51", "2016-06-21 13:02:51", "<strong>Wofür ist das gut? <img class=\"alignnone size-full wp-image-81\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png\" alt=\"ARM\" width=\"165\" height=\"182\" /></strong>\n<ul>\n 	<li>festigt Unterarme</li>\n 	<li>stärkt und festigt Brustmuskulatur</li>\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\n</ul>\n&nbsp;\n\n<strong> </strong>\n\n<strong>Ausführung: </strong>\n\nSetzen Sie sich bequem in den Schneidersitz.\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\nAtmen Sie während der Übung so normal, wie möglich.\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-autosave-v1", "", "", "2016-06-21 15:02:51", "2016-06-21 13:02:51", "", "30", "http://student11.wpstore.d-hosting.de/30-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2016-06-21 15:03:30", "2016-06-21 13:03:30", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-81 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png\" alt=\"ARM\" width=\"165\" height=\"182\" /></strong>\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 15:03:30", "2016-06-21 13:03:30", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("83", "1", "2016-06-21 15:05:32", "2016-06-21 13:05:32", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 15:05:32", "2016-06-21 13:05:32", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("84", "1", "2016-06-21 15:06:08", "2016-06-21 13:06:08", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 15:06:08", "2016-06-21 13:06:08", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2016-06-21 15:06:29", "2016-06-21 13:06:29", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 15:06:29", "2016-06-21 13:06:29", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2016-06-22 08:55:06", "2016-06-22 06:55:06", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier aber nicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur etwas für junge Leute.\r\n\r\nEs ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechniken und körperlichen Übungen. Yoga entspannt und reguliert die Körperfunktionen und gibt Energie. Die Muskeln werden gesdehnt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hier nicht um den Vergleich mit Anderen.\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür! Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen! In der Endstellung verharrt man dann einige Sekunden. Wiederholungen nach einer kurzen Pause.\r\n\r\n<strong>Zeit</strong>\r\n\r\nAm besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn. Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden - es gibt natürlich auch entsprechende einfache yogamatten.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei oder vier Stunden und nach einem leichten Imbiß etwa eine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "publish", "closed", "closed", "", "mehr-zum-thema-yoga", "", "", "2016-06-29 16:17:47", "2016-06-29 14:17:47", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=86", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2016-06-22 08:55:06", "2016-06-22 06:55:06", "links zu ausgewählen seiten", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-22 08:55:06", "2016-06-22 06:55:06", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2016-06-23 09:11:23", "2016-06-23 07:11:23", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-23 09:11:23", "2016-06-23 07:11:23", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2016-06-23 11:26:59", "2016-06-23 09:26:59", "", "yoga", "", "inherit", "open", "closed", "", "yoga-2", "", "", "2016-06-23 11:26:59", "2016-06-23 09:26:59", "", "6", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/yoga-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("96", "1", "2016-06-23 11:28:04", "2016-06-23 09:28:04", "", "titelbild", "", "inherit", "open", "closed", "", "titelbild", "", "", "2016-06-23 11:28:04", "2016-06-23 09:28:04", "", "6", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titelbild.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2016-06-23 11:29:02", "2016-06-23 09:29:02", "<img class=\"wp-image-96 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-23 11:29:02", "2016-06-23 09:29:02", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2016-06-23 11:48:45", "2016-06-23 09:48:45", "<strong>Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um die erste Gruppe.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\n&nbsp;\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nWie sollten Sie die Übungen machen?\r\n\r\n&nbsp;\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\nZeit\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\nOrt\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\nEssen\r\n\r\nNach einer reichhaltigen Mahlzeit bis zwei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n&nbsp;\r\n\r\nHoher Blutdruck\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 11:48:45", "2016-06-23 09:48:45", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2016-06-23 11:54:59", "2016-06-23 09:54:59", "", "titel_spiegel", "", "inherit", "open", "closed", "", "titel_spiegel", "", "", "2016-06-23 11:54:59", "2016-06-23 09:54:59", "", "86", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2016-06-23 11:56:33", "2016-06-23 09:56:33", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um die erste Gruppe.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\n&nbsp;\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nWie sollten Sie die Übungen machen?\r\n\r\n&nbsp;\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\nZeit\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\nOrt\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\nEssen\r\n\r\nNach einer reichhaltigen Mahlzeit bis zwei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n&nbsp;\r\n\r\nHoher Blutdruck\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 11:56:33", "2016-06-23 09:56:33", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2016-06-23 12:10:37", "2016-06-23 10:10:37", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\nOrt\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:10:37", "2016-06-23 10:10:37", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2016-06-23 12:12:48", "2016-06-23 10:12:48", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:12:48", "2016-06-23 10:12:48", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2016-06-23 12:13:09", "2016-06-23 10:13:09", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:13:09", "2016-06-23 10:13:09", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2016-06-23 12:15:39", "2016-06-23 10:15:39", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:15:39", "2016-06-23 10:15:39", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2016-06-23 12:18:32", "2016-06-23 10:18:32", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:18:32", "2016-06-23 10:18:32", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2016-06-23 12:19:28", "2016-06-23 10:19:28", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.<!--more-->\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:19:28", "2016-06-23 10:19:28", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2016-06-23 12:22:34", "2016-06-23 10:22:34", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:22:34", "2016-06-23 10:22:34", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("110", "1", "2016-06-23 12:23:01", "2016-06-23 10:23:01", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:23:01", "2016-06-23 10:23:01", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2016-06-23 12:32:05", "2016-06-23 10:32:05", "<img class=\"alignnone size-medium wp-image-111\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/boot_web-300x225.jpg\" alt=\"boot_web\" width=\"300\" height=\"225\" /><img class=\"wp-image-96 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\n\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-autosave-v1", "", "", "2016-06-23 12:32:05", "2016-06-23 10:32:05", "", "6", "http://student11.wpstore.d-hosting.de/6-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2016-06-23 12:37:29", "2016-06-23 10:37:29", "", "head", "", "inherit", "open", "closed", "", "head", "", "", "2016-06-23 12:37:29", "2016-06-23 10:37:29", "", "0", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/head.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2016-06-24 15:47:42", "2016-06-24 13:47:42", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-24 15:47:42", "2016-06-24 13:47:42", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("116", "1", "2016-06-24 19:31:18", "2016-06-24 17:31:18", "übungen\r\n\r\n[gallery ids=\"117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133\"]", "galerie", "", "trash", "closed", "closed", "", "galerie__trashed", "", "", "2016-06-24 19:33:34", "2016-06-24 17:33:34", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=116", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2016-06-24 19:25:14", "2016-06-24 17:25:14", "", "ARM", "arme heben", "inherit", "open", "closed", "", "arm-3", "", "", "2016-06-24 19:28:04", "2016-06-24 17:28:04", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2016-06-24 19:25:17", "2016-06-24 17:25:17", "", "AUF", "aufsetzen", "inherit", "open", "closed", "", "auf-3", "", "", "2016-06-24 19:28:10", "2016-06-24 17:28:10", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2016-06-24 19:25:18", "2016-06-24 17:25:18", "", "AUGEN", "augenrollen", "inherit", "open", "closed", "", "augen-4", "", "", "2016-06-24 19:28:19", "2016-06-24 17:28:19", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2016-06-24 19:25:20", "2016-06-24 17:25:20", "", "BAUM", "baum", "inherit", "open", "closed", "", "baum-2", "", "", "2016-06-24 19:28:27", "2016-06-24 17:28:27", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2016-06-24 19:25:22", "2016-06-24 17:25:22", "", "BEIN", "beinüberschlag", "inherit", "open", "closed", "", "bein-2", "", "", "2016-06-24 19:28:44", "2016-06-24 17:28:44", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2016-06-24 19:25:24", "2016-06-24 17:25:24", "", "BRUEXPA", "brustexpander", "inherit", "open", "closed", "", "bruexpa-2", "", "", "2016-06-29 15:57:06", "2016-06-29 13:57:06", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2016-06-24 19:25:25", "2016-06-24 17:25:25", "", "GESPREI", "gespreizte beinstreckung", "inherit", "open", "closed", "", "gesprei-2", "", "", "2016-06-24 19:29:21", "2016-06-24 17:29:21", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2016-06-24 19:25:26", "2016-06-24 17:25:26", "", "HALTUNG", "haltungsgriff", "inherit", "open", "closed", "", "haltung-2", "", "", "2016-06-24 19:29:35", "2016-06-24 17:29:35", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2016-06-24 19:25:27", "2016-06-24 17:25:27", "", "JAPSITZ", "japansitz", "inherit", "open", "closed", "", "japsitz-2", "", "", "2016-06-24 19:29:54", "2016-06-24 17:29:54", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2016-06-24 19:25:29", "2016-06-24 17:25:29", "", "KOBRA", "kobra", "inherit", "open", "closed", "", "kobra-2", "", "", "2016-06-24 19:30:07", "2016-06-24 17:30:07", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2016-06-24 19:25:31", "2016-06-24 17:25:31", "", "NACKEN", "nacken rollen", "inherit", "open", "closed", "", "nacken-2", "", "", "2016-06-24 19:30:30", "2016-06-24 17:30:30", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("131", "1", "2016-06-24 19:25:31", "2016-06-24 17:25:31", "", "PFLUG", "pflug", "inherit", "open", "closed", "", "pflug-2", "", "", "2016-06-24 19:30:38", "2016-06-24 17:30:38", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2016-06-24 19:25:33", "2016-06-24 17:25:33", "", "ZUBLATT", "zusammengerolltes blatt", "inherit", "open", "closed", "", "zublatt-2", "", "", "2016-06-24 19:31:09", "2016-06-24 17:31:09", "", "116", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("135", "1", "2016-06-24 19:31:18", "2016-06-24 17:31:18", "übungen\r\n\r\n[gallery ids=\"117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133\"]", "galerie", "", "inherit", "closed", "closed", "", "116-revision-v1", "", "", "2016-06-24 19:31:18", "2016-06-24 17:31:18", "", "116", "http://student11.wpstore.d-hosting.de/116-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2016-06-24 20:00:56", "2016-06-24 18:00:56", "hinter den traumgärten, am ende der zeit ...\r\n\r\n[gallery ids=\"151,230,152,148,147,149\"]", "galerie", "", "trash", "closed", "closed", "", "galerie__trashed-2", "", "", "2016-06-29 15:59:17", "2016-06-29 13:59:17", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=136", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("138", "1", "2016-06-24 20:00:56", "2016-06-24 18:00:56", "hinter den traumgärten, am ende der zeit links ...", "galerie", "", "inherit", "closed", "closed", "", "136-revision-v1", "", "", "2016-06-24 20:00:56", "2016-06-24 18:00:56", "", "136", "http://student11.wpstore.d-hosting.de/136-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2016-06-24 20:25:25", "2016-06-24 18:25:25", "", "jungfer im grünen", "", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen", "", "", "2016-06-24 20:25:25", "2016-06-24 18:25:25", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jungfer-im-grünen.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("146", "1", "2016-06-24 20:25:51", "2016-06-24 18:25:51", "küchenschelle", "küchenschelle", "Küchenschelle", "inherit", "open", "closed", "", "ku%cc%88chenshcelle", "", "", "2016-06-28 20:06:12", "2016-06-28 18:06:12", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/küchenshcelle.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("149", "1", "2016-06-24 20:26:39", "2016-06-24 18:26:39", "jungfer im grünen", "jungfer im grünen", "jungfer im grüne", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-2", "", "", "2016-06-28 19:40:30", "2016-06-28 17:40:30", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jungfer-im-grünen-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("150", "1", "2016-06-24 20:26:40", "2016-06-24 18:26:40", "", "küchenshcelle", "", "inherit", "open", "closed", "", "ku%cc%88chenshcelle-2", "", "", "2016-06-24 20:26:40", "2016-06-24 18:26:40", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/küchenshcelle-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("153", "1", "2016-06-24 20:32:21", "2016-06-24 18:32:21", "hinter den traumgärten, am ende der zeit links ...\r\n\r\n[gallery ids=\"140,141,142,143,144,146\"]", "galerie", "", "inherit", "closed", "closed", "", "136-revision-v1", "", "", "2016-06-24 20:32:21", "2016-06-24 18:32:21", "", "136", "http://student11.wpstore.d-hosting.de/136-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("155", "1", "2016-06-24 22:33:18", "2016-06-24 20:33:18", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-24 22:33:18", "2016-06-24 20:33:18", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("156", "1", "2016-06-27 09:48:23", "0000-00-00 00:00:00", "", "Automatisch gespeicherter Entwurf", "", "auto-draft", "open", "open", "", "", "", "", "2016-06-27 09:48:23", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=156", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2016-06-27 09:51:26", "2016-06-27 07:51:26", "<strong><img class=\"wp-image-158  alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"125\" height=\"266\" /></strong>\r\n\r\n<strong>Wofür ist das gut\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "publish", "closed", "closed", "", "157-2", "", "", "2016-06-30 06:08:33", "2016-06-30 04:08:33", "", "0", "http://student11.wpstore.d-hosting.de/?p=157", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("158", "1", "2016-06-27 09:50:35", "2016-06-27 07:50:35", "baum", "BAUM", "", "inherit", "open", "closed", "", "baum-3", "", "", "2016-06-27 09:51:17", "2016-06-27 07:51:17", "", "157", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2016-06-27 09:51:26", "2016-06-27 07:51:26", "<strong>Wofür ist das gut  <img class=\"alignnone size-thumbnail wp-image-158\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1-135x150.png\" alt=\"baum\" width=\"135\" height=\"150\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:51:26", "2016-06-27 07:51:26", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("160", "1", "2016-06-27 09:52:57", "2016-06-27 07:52:57", "<strong>Wofür ist das gut  <img class=\"alignnone wp-image-158 size-thumbnail\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1-135x150.png\" alt=\"baum\" width=\"135\" height=\"150\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:52:57", "2016-06-27 07:52:57", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("161", "1", "2016-06-27 09:54:26", "2016-06-27 07:54:26", "<strong>Wofür ist das gut  <img class=\"alignnone wp-image-158 size-thumbnail\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1-135x150.png\" alt=\"baum\" width=\"135\" height=\"150\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:54:26", "2016-06-27 07:54:26", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("162", "1", "2016-06-27 09:57:33", "2016-06-27 07:57:33", "<strong>Wofür ist das gut  <img class=\"alignnone wp-image-158 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:57:33", "2016-06-27 07:57:33", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("163", "1", "2016-06-27 09:59:30", "2016-06-27 07:59:30", "<strong>Wofür ist das gut  <img class=\"wp-image-158 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:59:30", "2016-06-27 07:59:30", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("164", "1", "2016-06-27 10:02:46", "2016-06-27 08:02:46", "<strong><img class=\"size-full wp-image-166 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "bein-überschlag", "", "publish", "closed", "closed", "", "bein-ueberschlag", "", "", "2016-06-30 06:08:22", "2016-06-30 04:08:22", "", "0", "http://student11.wpstore.d-hosting.de/?p=164", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("165", "1", "2016-06-27 10:02:46", "2016-06-27 08:02:46", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-revision-v1", "", "", "2016-06-27 10:02:46", "2016-06-27 08:02:46", "", "164", "http://student11.wpstore.d-hosting.de/164-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("166", "1", "2016-06-27 10:03:39", "2016-06-27 08:03:39", "beinüberschlag", "BEIN", "", "inherit", "open", "closed", "", "bein-3", "", "", "2016-06-27 10:04:20", "2016-06-27 08:04:20", "", "164", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("167", "1", "2016-06-27 10:04:48", "2016-06-27 08:04:48", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-166 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\n<ul>\n 	<li>baut Fettpolster ab</li>\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\n 	<li>fördert Verdauung</li>\n 	<li>festigt Unterleibsorgane</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-autosave-v1", "", "", "2016-06-27 10:04:48", "2016-06-27 08:04:48", "", "164", "http://student11.wpstore.d-hosting.de/164-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("168", "1", "2016-06-27 10:05:21", "2016-06-27 08:05:21", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-166 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-revision-v1", "", "", "2016-06-27 10:05:21", "2016-06-27 08:05:21", "", "164", "http://student11.wpstore.d-hosting.de/164-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("169", "1", "2016-06-27 11:45:32", "2016-06-27 09:45:32", "hinter den traumgärten, am ende der zeit ...\r\n\r\n[gallery ids=\"140,141,142,143,144,146\"]", "galerie", "", "inherit", "closed", "closed", "", "136-revision-v1", "", "", "2016-06-27 11:45:32", "2016-06-27 09:45:32", "", "136", "http://student11.wpstore.d-hosting.de/136-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("170", "1", "2016-06-27 11:48:49", "2016-06-27 09:48:49", "", "neue galerie", "", "trash", "closed", "closed", "", "__trashed", "", "", "2016-06-27 11:51:16", "2016-06-27 09:51:16", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=170", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("188", "1", "2016-06-27 11:51:16", "2016-06-27 09:51:16", "", "neue galerie", "", "inherit", "closed", "closed", "", "170-revision-v1", "", "", "2016-06-27 11:51:16", "2016-06-27 09:51:16", "", "170", "http://student11.wpstore.d-hosting.de/170-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("189", "1", "2016-06-27 11:54:05", "2016-06-27 09:54:05", "<strong><img class=\"size-full wp-image-417 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN.png\" alt=\"bogen\" width=\"228\" height=\"180\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "bogen", "", "publish", "closed", "closed", "", "bogen", "", "", "2016-06-30 11:57:49", "2016-06-30 09:57:49", "", "0", "http://student11.wpstore.d-hosting.de/?p=189", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("191", "1", "2016-06-27 11:54:05", "2016-06-27 09:54:05", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-190 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"228\" height=\"180\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "bogen", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-27 11:54:05", "2016-06-27 09:54:05", "", "189", "http://student11.wpstore.d-hosting.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("192", "1", "2016-06-27 12:02:58", "2016-06-27 10:02:58", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-415 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-1.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "publish", "closed", "closed", "", "brust-expander", "", "", "2016-06-30 11:56:50", "2016-06-30 09:56:50", "", "0", "http://student11.wpstore.d-hosting.de/?p=192", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("193", "1", "2016-06-27 12:02:58", "2016-06-27 10:02:58", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:02:58", "2016-06-27 10:02:58", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("196", "1", "2016-06-27 12:04:35", "2016-06-27 10:04:35", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:04:35", "2016-06-27 10:04:35", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("197", "1", "2016-06-27 12:20:22", "2016-06-27 10:20:22", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:20:22", "2016-06-27 10:20:22", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("198", "1", "2016-06-27 12:20:35", "2016-06-27 10:20:35", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-190 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"228\" height=\"180\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BOGEN", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-27 12:20:35", "2016-06-27 10:20:35", "", "189", "http://student11.wpstore.d-hosting.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("199", "1", "2016-06-27 12:28:45", "2016-06-27 10:28:45", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-27 12:28:45", "2016-06-27 10:28:45", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("200", "1", "2016-06-27 12:34:37", "2016-06-27 10:34:37", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:34:37", "2016-06-27 10:34:37", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("201", "1", "2016-06-27 12:35:57", "2016-06-27 10:35:57", "<strong>Wofür ist das gut  <img class=\"wp-image-158 size-full alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 12:35:57", "2016-06-27 10:35:57", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("202", "1", "2016-06-27 12:37:20", "2016-06-27 10:37:20", "<strong><img class=\"wp-image-34  alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-27 12:37:20", "2016-06-27 10:37:20", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("203", "1", "2016-06-27 12:37:54", "2016-06-27 10:37:54", "<strong><img class=\"wp-image-34 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-27 12:37:54", "2016-06-27 10:37:54", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("204", "1", "2016-06-29 15:45:11", "2016-06-29 13:45:11", "<strong><img class=\"aligncenter wp-image-34\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-autosave-v1", "", "", "2016-06-29 15:45:11", "2016-06-29 13:45:11", "", "32", "http://student11.wpstore.d-hosting.de/32-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("205", "1", "2016-06-27 14:43:28", "2016-06-27 12:43:28", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-27 14:43:28", "2016-06-27 12:43:28", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("206", "1", "2016-06-27 14:49:16", "2016-06-27 12:49:16", "Kontakt\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-autosave-v1", "", "", "2016-06-27 14:49:16", "2016-06-27 12:49:16", "", "21", "http://student11.wpstore.d-hosting.de/21-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("207", "1", "2016-06-27 14:52:41", "2016-06-27 12:52:41", "Kontakt\r\n\r\n&nbsp;\r\n\r\n[contact-form-7 id=\"4\" title=\"Contact form 1\"]", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-27 14:52:41", "2016-06-27 12:52:41", "", "21", "http://student11.wpstore.d-hosting.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("208", "1", "2016-06-27 14:56:40", "2016-06-27 12:56:40", "Kontakt\r\n\r\n[contact-form-7 id=\"121\" title=\"Contact form 1\"]\r\n\r\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-27 14:56:40", "2016-06-27 12:56:40", "", "21", "http://student11.wpstore.d-hosting.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("209", "1", "2016-06-28 09:14:28", "2016-06-28 07:14:28", " ", "", "", "publish", "closed", "closed", "", "209", "", "", "2016-06-28 09:17:24", "2016-06-28 07:17:24", "", "0", "http://student11.wpstore.d-hosting.de/?p=209", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("210", "1", "2016-06-28 09:14:28", "2016-06-28 07:14:28", " ", "", "", "publish", "closed", "closed", "", "210", "", "", "2016-06-28 09:17:24", "2016-06-28 07:17:24", "", "0", "http://student11.wpstore.d-hosting.de/?p=210", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("211", "1", "2016-06-28 09:18:28", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 09:18:28", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=211", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("212", "1", "2016-06-28 09:18:28", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 09:18:28", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=212", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("214", "1", "2016-06-28 09:20:14", "2016-06-28 07:20:14", " ", "", "", "publish", "closed", "closed", "", "214", "", "", "2016-06-30 08:53:47", "2016-06-30 06:53:47", "", "0", "http://student11.wpstore.d-hosting.de/?p=214", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("215", "1", "2016-06-28 09:20:14", "2016-06-28 07:20:14", " ", "", "", "publish", "closed", "closed", "", "215", "", "", "2016-06-30 08:53:47", "2016-06-30 06:53:47", "", "0", "http://student11.wpstore.d-hosting.de/?p=215", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("216", "1", "2016-06-28 09:20:14", "2016-06-28 07:20:14", " ", "", "", "publish", "closed", "closed", "", "216", "", "", "2016-06-30 08:53:47", "2016-06-30 06:53:47", "", "0", "http://student11.wpstore.d-hosting.de/?p=216", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("217", "1", "2016-06-28 09:32:04", "2016-06-28 07:32:04", " ", "", "", "publish", "closed", "closed", "", "217", "", "", "2016-06-30 08:53:47", "2016-06-30 06:53:47", "", "0", "http://student11.wpstore.d-hosting.de/?p=217", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("218", "1", "2016-06-28 09:32:04", "2016-06-28 07:32:04", " ", "", "", "publish", "closed", "closed", "", "218", "", "", "2016-06-30 08:53:47", "2016-06-30 06:53:47", "", "0", "http://student11.wpstore.d-hosting.de/?p=218", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("219", "1", "2016-06-28 09:34:14", "2016-06-28 07:34:14", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-28 09:34:14", "2016-06-28 07:34:14", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("220", "1", "2016-06-28 09:36:58", "2016-06-28 07:36:58", "[contact-form-7 id=\"121\" title=\"Contact form 1\"]\r\n\r\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-28 09:36:58", "2016-06-28 07:36:58", "", "21", "http://student11.wpstore.d-hosting.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("222", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGh1bWJuYWlscyIsImVudGl0eV90eXBlcyI6WyJpbWFnZSJdLCJwcmV2aWV3X2ltYWdlX3JlbHBhdGgiOiJcL25leHRnZW4tZ2FsbGVyeVwvcHJvZHVjdHNcL3Bob3RvY3JhdGlfbmV4dGdlblwvbW9kdWxlc1wvbmV4dGdlbl9iYXNpY19nYWxsZXJ5XC9zdGF0aWNcL3RodW1iX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwiaW1hZ2VzX3Blcl9wYWdlIjoiMjAiLCJudW1iZXJfb2ZfY29sdW1ucyI6MCwidGh1bWJuYWlsX3dpZHRoIjoyNDAsInRodW1ibmFpbF9oZWlnaHQiOjE2MCwic2hvd19hbGxfaW5fbGlnaHRib3giOjAsImFqYXhfcGFnaW5hdGlvbiI6MCwidXNlX2ltYWdlYnJvd3Nlcl9lZmZlY3QiOjAsInRlbXBsYXRlIjoiIiwiZGlzcGxheV9ub19pbWFnZXNfZXJyb3IiOjEsImRpc2FibGVfcGFnaW5hdGlvbiI6MCwic2hvd19zbGlkZXNob3dfbGluayI6MSwic2xpZGVzaG93X2xpbmtfdGV4dCI6IltaZWlnZSBlaW5lIFNsaWRlc2hvd10iLCJvdmVycmlkZV90aHVtYm5haWxfc2V0dGluZ3MiOjAsInRodW1ibmFpbF9xdWFsaXR5IjoiMTAwIiwidGh1bWJuYWlsX2Nyb3AiOjEsInRodW1ibmFpbF93YXRlcm1hcmsiOjAsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "NextGEN Basic Thumbnails", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGh1bWJuYWlscyIsImVudGl0eV90eXBlcyI6WyJpbWFnZSJdLCJwcmV2aWV3X2ltYWdlX3JlbHBhdGgiOiJcL25leHRnZW4tZ2FsbGVyeVwvcHJvZHVjdHNcL3Bob3RvY3JhdGlfbmV4dGdlblwvbW9kdWxlc1wvbmV4dGdlbl9iYXNpY19nYWxsZXJ5XC9zdGF0aWNcL3RodW1iX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwiaW1hZ2VzX3Blcl9wYWdlIjoiMjAiLCJudW1iZXJfb2ZfY29sdW1ucyI6MCwidGh1bWJuYWlsX3dpZHRoIjoyNDAsInRodW1ibmFpbF9oZWlnaHQiOjE2MCwic2hvd19hbGxfaW5fbGlnaHRib3giOjAsImFqYXhfcGFnaW5hdGlvbiI6MCwidXNlX2ltYWdlYnJvd3Nlcl9lZmZlY3QiOjAsInRlbXBsYXRlIjoiIiwiZGlzcGxheV9ub19pbWFnZXNfZXJyb3IiOjEsImRpc2FibGVfcGFnaW5hdGlvbiI6MCwic2hvd19zbGlkZXNob3dfbGluayI6MSwic2xpZGVzaG93X2xpbmtfdGV4dCI6IltaZWlnZSBlaW5lIFNsaWRlc2hvd10iLCJvdmVycmlkZV90aHVtYm5haWxfc2V0dGluZ3MiOjAsInRodW1ibmFpbF9xdWFsaXR5IjoiMTAwIiwidGh1bWJuYWlsX2Nyb3AiOjEsInRodW1ibmFpbF93YXRlcm1hcmsiOjAsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=222", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("223", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2xpZGVzaG93IiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2dhbGxlcnlcL3N0YXRpY1wvc2xpZGVzaG93X3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19zbGlkZXNob3ciLCJpbnN0YWxsZWRfYXRfdmVyc2lvbiI6IjIuMS40NiIsImlkX2ZpZWxkIjoiSUQiLCJzZXR0aW5ncyI6eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJ5X3dpZHRoIjo2MDAsImdhbGxlcnlfaGVpZ2h0Ijo0MDAsInRodW1ibmFpbF93aWR0aCI6MjQwLCJ0aHVtYm5haWxfaGVpZ2h0IjoxNjAsImN5Y2xlX2ludGVydmFsIjoxMCwiY3ljbGVfZWZmZWN0IjpudWxsLCJlZmZlY3RfY29kZSI6ImNsYXNzPVwibmdnLWZhbmN5Ym94XCIgcmVsPVwiJUdBTExFUllfTkFNRSVcIiIsInNob3dfdGh1bWJuYWlsX2xpbmsiOjEsInRodW1ibmFpbF9saW5rX3RleHQiOiJbWmVpZ2UgVm9yc2NoYXViaWxkZXJdIiwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "NextGEN Basic Slideshow", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2xpZGVzaG93IiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2dhbGxlcnlcL3N0YXRpY1wvc2xpZGVzaG93X3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19zbGlkZXNob3ciLCJpbnN0YWxsZWRfYXRfdmVyc2lvbiI6IjIuMS40NiIsImlkX2ZpZWxkIjoiSUQiLCJzZXR0aW5ncyI6eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJ5X3dpZHRoIjo2MDAsImdhbGxlcnlfaGVpZ2h0Ijo0MDAsInRodW1ibmFpbF93aWR0aCI6MjQwLCJ0aHVtYm5haWxfaGVpZ2h0IjoxNjAsImN5Y2xlX2ludGVydmFsIjoxMCwiY3ljbGVfZWZmZWN0IjpudWxsLCJlZmZlY3RfY29kZSI6ImNsYXNzPVwibmdnLWZhbmN5Ym94XCIgcmVsPVwiJUdBTExFUllfTkFNRSVcIiIsInNob3dfdGh1bWJuYWlsX2xpbmsiOjEsInRodW1ibmFpbF9saW5rX3RleHQiOiJbWmVpZ2UgVm9yc2NoYXViaWxkZXJdIiwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=223", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("224", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgSW1hZ2VCcm93c2VyIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2ltYWdlYnJvd3Nlclwvc3RhdGljXC9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwMjAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfaW1hZ2Vicm93c2VyIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "NextGEN Basic ImageBrowser", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgSW1hZ2VCcm93c2VyIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2ltYWdlYnJvd3Nlclwvc3RhdGljXC9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwMjAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfaW1hZ2Vicm93c2VyIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=224", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("225", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2luZ2xlUGljIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpY1wvc3RhdGljXC9wcmV2aWV3LmdpZiIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwNjAsImhpZGRlbl9mcm9tX3VpIjp0cnVlLCJuYW1lIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpYyIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsIndpZHRoIjoiIiwiaGVpZ2h0IjoiIiwibW9kZSI6IiIsImRpc3BsYXlfd2F0ZXJtYXJrIjowLCJkaXNwbGF5X3JlZmxlY3Rpb24iOjAsImZsb2F0IjoiIiwibGluayI6IiIsImxpbmtfdGFyZ2V0IjoiX2JsYW5rIiwicXVhbGl0eSI6MTAwLCJjcm9wIjowLCJ0ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "NextGEN Basic SinglePic", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2luZ2xlUGljIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpY1wvc3RhdGljXC9wcmV2aWV3LmdpZiIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwNjAsImhpZGRlbl9mcm9tX3VpIjp0cnVlLCJuYW1lIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpYyIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsIndpZHRoIjoiIiwiaGVpZ2h0IjoiIiwibW9kZSI6IiIsImRpc3BsYXlfd2F0ZXJtYXJrIjowLCJkaXNwbGF5X3JlZmxlY3Rpb24iOjAsImZsb2F0IjoiIiwibGluayI6IiIsImxpbmtfdGFyZ2V0IjoiX2JsYW5rIiwicXVhbGl0eSI6MTAwLCJjcm9wIjowLCJ0ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=225", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("226", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGFnQ2xvdWQiLCJlbnRpdHlfdHlwZXMiOlsiaW1hZ2UiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfdGFnY2xvdWRcL3N0YXRpY1wvcHJldmlldy5naWYiLCJkZWZhdWx0X3NvdXJjZSI6InRhZ3MiLCJ2aWV3X29yZGVyIjoxMDEwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190YWdjbG91ZCIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImRpc3BsYXlfdHlwZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwibnVtYmVyIjo0NSwibmdnX3RyaWdnZXJzX2Rpc3BsYXkiOiJuZXZlciJ9LCJoaWRkZW5fZnJvbV91aSI6ZmFsc2UsIl9fZGVmYXVsdHNfc2V0Ijp0cnVlfQ==", "NextGEN Basic TagCloud", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGFnQ2xvdWQiLCJlbnRpdHlfdHlwZXMiOlsiaW1hZ2UiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfdGFnY2xvdWRcL3N0YXRpY1wvcHJldmlldy5naWYiLCJkZWZhdWx0X3NvdXJjZSI6InRhZ3MiLCJ2aWV3X29yZGVyIjoxMDEwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190YWdjbG91ZCIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImRpc3BsYXlfdHlwZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwibnVtYmVyIjo0NSwibmdnX3RyaWdnZXJzX2Rpc3BsYXkiOiJuZXZlciJ9LCJoaWRkZW5fZnJvbV91aSI6ZmFsc2UsIl9fZGVmYXVsdHNfc2V0Ijp0cnVlfQ==", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=226", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("227", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgQ29tcGFjdCBBbGJ1bSIsImVudGl0eV90eXBlcyI6WyJhbGJ1bSIsImdhbGxlcnkiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfYWxidW1cL3N0YXRpY1wvY29tcGFjdF9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiYWxidW1zIiwidmlld19vcmRlciI6MTAyMDAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfY29tcGFjdF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "NextGEN Basic Compact Album", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgQ29tcGFjdCBBbGJ1bSIsImVudGl0eV90eXBlcyI6WyJhbGJ1bSIsImdhbGxlcnkiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfYWxidW1cL3N0YXRpY1wvY29tcGFjdF9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiYWxidW1zIiwidmlld19vcmRlciI6MTAyMDAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfY29tcGFjdF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=227", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("228", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgRXh0ZW5kZWQgQWxidW0iLCJlbnRpdHlfdHlwZXMiOlsiYWxidW0iLCJnYWxsZXJ5Il0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2FsYnVtXC9zdGF0aWNcL2V4dGVuZGVkX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJhbGJ1bXMiLCJ2aWV3X29yZGVyIjoxMDIxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19leHRlbmRlZF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwib3ZlcnJpZGVfdGh1bWJuYWlsX3NldHRpbmdzIjowLCJ0aHVtYm5haWxfd2lkdGgiOjI0MCwidGh1bWJuYWlsX2hlaWdodCI6MTYwLCJ0aHVtYm5haWxfcXVhbGl0eSI6MTAwLCJ0aHVtYm5haWxfY3JvcCI6dHJ1ZSwidGh1bWJuYWlsX3dhdGVybWFyayI6MCwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "NextGEN Basic Extended Album", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgRXh0ZW5kZWQgQWxidW0iLCJlbnRpdHlfdHlwZXMiOlsiYWxidW0iLCJnYWxsZXJ5Il0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2FsYnVtXC9zdGF0aWNcL2V4dGVuZGVkX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJhbGJ1bXMiLCJ2aWV3X29yZGVyIjoxMDIxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19leHRlbmRlZF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwib3ZlcnJpZGVfdGh1bWJuYWlsX3NldHRpbmdzIjowLCJ0aHVtYm5haWxfd2lkdGgiOjI0MCwidGh1bWJuYWlsX2hlaWdodCI6MTYwLCJ0aHVtYm5haWxfcXVhbGl0eSI6MTAwLCJ0aHVtYm5haWxfY3JvcCI6dHJ1ZSwidGh1bWJuYWlsX3dhdGVybWFyayI6MCwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "0", "http://student11.wpstore.d-hosting.de/?post_type=display_type&p=228", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("229", "1", "2016-06-28 11:37:15", "0000-00-00 00:00:00", "", "Automatisch gespeicherter Entwurf", "", "auto-draft", "open", "open", "", "", "", "", "2016-06-28 11:37:15", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=229", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("231", "1", "2016-06-28 19:24:51", "2016-06-28 17:24:51", "hinter den traumgärten, am ende der zeit ...\r\n\r\n[gallery ids=\"140,141,142,143,144,230\"]", "galerie", "", "inherit", "closed", "closed", "", "136-revision-v1", "", "", "2016-06-28 19:24:51", "2016-06-28 17:24:51", "", "136", "http://student11.wpstore.d-hosting.de/136-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("233", "1", "2016-06-28 19:49:10", "2016-06-28 17:49:10", "jetzt eine neue galerie erstellen\r\n\r\n[gallery ids=\"149,232,151,152,147,148\"]", "neue galerie", "", "trash", "closed", "closed", "", "neue-galerie__trashed", "", "", "2016-06-28 19:50:43", "2016-06-28 17:50:43", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=233", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("235", "1", "2016-06-28 19:49:10", "2016-06-28 17:49:10", "jetzt eine neue galerie erstellen\r\n\r\n[gallery ids=\"149,232,151,152,147,148\"]", "neue galerie", "", "inherit", "closed", "closed", "", "233-revision-v1", "", "", "2016-06-28 19:49:10", "2016-06-28 17:49:10", "", "233", "http://student11.wpstore.d-hosting.de/233-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("236", "1", "2016-06-28 19:54:38", "2016-06-28 17:54:38", "soll endlich klappen\r\n\r\n[gallery ids=\"149,148,147,151,144,230\"]", "jetzt reichts", "", "trash", "closed", "closed", "", "jetzt-reichts__trashed", "", "", "2016-06-29 09:38:25", "2016-06-29 07:38:25", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=236", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("238", "1", "2016-06-28 19:54:38", "2016-06-28 17:54:38", "soll endlich klappen\r\n\r\n[gallery ids=\"149,148,147,151,144,230\"]", "jetzt reichts", "", "inherit", "closed", "closed", "", "236-revision-v1", "", "", "2016-06-28 19:54:38", "2016-06-28 17:54:38", "", "236", "http://student11.wpstore.d-hosting.de/236-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("239", "1", "2016-06-28 19:56:31", "2016-06-28 17:56:31", "soll endlich klappen\r\n\r\n[gallery ids=\"149,148,147,151,144,230\"]", "jetzt reichts", "", "inherit", "closed", "closed", "", "236-autosave-v1", "", "", "2016-06-28 19:56:31", "2016-06-28 17:56:31", "", "236", "http://student11.wpstore.d-hosting.de/236-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("241", "1", "2016-06-28 20:02:58", "2016-06-28 18:02:58", "", "jungfer im grünen", "", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-3", "", "", "2016-06-28 20:02:58", "2016-06-28 18:02:58", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jungfer-im-grünen-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("242", "1", "2016-06-28 20:02:59", "2016-06-28 18:02:59", "", "Küchenschelle", "", "inherit", "open", "closed", "", "ku%cc%88chenschelle", "", "", "2016-06-28 20:02:59", "2016-06-28 18:02:59", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/Küchenschelle.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("245", "1", "2016-06-28 20:14:48", "2016-06-28 18:14:48", "", "jungfer im grünen", "", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-4", "", "", "2016-06-28 20:14:48", "2016-06-28 18:14:48", "", "136", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jungfer-im-grünen-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("246", "1", "2016-06-28 20:17:19", "2016-06-28 18:17:19", "hinter den traumgärten, am ende der zeit ...\r\n\r\n[gallery ids=\"151,230,152,148,147,149\"]", "galerie", "", "inherit", "closed", "closed", "", "136-revision-v1", "", "", "2016-06-28 20:17:19", "2016-06-28 18:17:19", "", "136", "http://student11.wpstore.d-hosting.de/136-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("248", "1", "2016-06-29 08:47:21", "2016-06-29 06:47:21", "<img class=\"size-full wp-image-413 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-1.png\" alt=\"gespreizte beinstreckung\" width=\"380\" height=\"109\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "gespreizte beinstreckung", "", "publish", "closed", "closed", "", "gespreizte-beinstreckung", "", "", "2016-06-30 11:55:56", "2016-06-30 09:55:56", "", "0", "http://student11.wpstore.d-hosting.de/?p=248", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("250", "1", "2016-06-29 08:47:21", "2016-06-29 06:47:21", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone size-full wp-image-249\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"380\" height=\"109\" />\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "gespreizte beinstreckung", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 08:47:21", "2016-06-29 06:47:21", "", "248", "http://student11.wpstore.d-hosting.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("252", "1", "2016-06-29 08:49:44", "2016-06-29 06:49:44", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone size-full wp-image-249\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"380\" height=\"109\" />\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "GESPREIZTE BEINSTRECKUNG", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 08:49:44", "2016-06-29 06:49:44", "", "248", "http://student11.wpstore.d-hosting.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("253", "1", "2016-06-29 08:50:59", "0000-00-00 00:00:00", "", "Automatisch gespeicherter Entwurf", "", "auto-draft", "open", "open", "", "", "", "", "2016-06-29 08:50:59", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=253", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("255", "1", "2016-06-29 09:06:12", "2016-06-29 07:06:12", "<strong>Wofür ist das gut? <img class=\"wp-image-190 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"286\" height=\"212\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BOGEN", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-29 09:06:12", "2016-06-29 07:06:12", "", "189", "http://student11.wpstore.d-hosting.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("256", "1", "2016-06-29 09:06:58", "2016-06-29 07:06:58", "<strong>Wofür ist das gut? <img class=\"wp-image-190 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"286\" height=\"212\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BOGEN", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-29 09:06:58", "2016-06-29 07:06:58", "", "189", "http://student11.wpstore.d-hosting.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("257", "1", "2016-06-29 09:07:29", "2016-06-29 07:07:29", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone  wp-image-249\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"348\" height=\"93\" />\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "GESPREIZTE BEINSTRECKUNG", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 09:07:29", "2016-06-29 07:07:29", "", "248", "http://student11.wpstore.d-hosting.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("258", "1", "2016-06-29 09:08:06", "2016-06-29 07:08:06", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-29 09:08:06", "2016-06-29 07:08:06", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("259", "1", "2016-06-29 09:11:11", "2016-06-29 07:11:11", "<strong><img class=\"wp-image-261 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"178\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "haltungsgriff", "", "publish", "open", "open", "", "haltungsgriff", "", "", "2016-06-30 06:07:22", "2016-06-30 04:07:22", "", "0", "http://student11.wpstore.d-hosting.de/?p=259", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("260", "1", "2016-06-29 09:11:11", "2016-06-29 07:11:11", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-revision-v1", "", "", "2016-06-29 09:11:11", "2016-06-29 07:11:11", "", "259", "http://student11.wpstore.d-hosting.de/259-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("261", "1", "2016-06-29 09:11:28", "2016-06-29 07:11:28", "schneidersitz, hände fassen hinter dem rücken, ein arm von oben einer von unten", "HALTUNG", "", "inherit", "open", "closed", "", "haltung-4", "", "", "2016-06-29 09:13:04", "2016-06-29 07:13:04", "", "259", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("262", "1", "2016-06-29 09:13:14", "2016-06-29 07:13:14", "<strong><img class=\"alignnone size-full wp-image-261\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"190\" height=\"205\" />Wofür ist das gut? </strong>\n<ul>\n 	<li>bringt Erleichterung für verspannte Schultern</li>\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\n 	<li>formt und stärkt die Oberarme</li>\n 	<li>erweitert den Brustkorb</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\n 	<li>Seitenverkehrt wiederholen.</li>\n 	<li>Noch zweimal pro Seite.</li>\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-autosave-v1", "", "", "2016-06-29 09:13:14", "2016-06-29 07:13:14", "", "259", "http://student11.wpstore.d-hosting.de/259-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("263", "1", "2016-06-29 09:13:29", "2016-06-29 07:13:29", "<strong><img class=\"wp-image-261 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"178\" height=\"183\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-revision-v1", "", "", "2016-06-29 09:13:29", "2016-06-29 07:13:29", "", "259", "http://student11.wpstore.d-hosting.de/259-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("264", "1", "2016-06-29 09:22:49", "2016-06-29 07:22:49", "<strong><img class=\"size-full wp-image-411 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-1.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "japanischer sitz", "", "publish", "closed", "closed", "", "japanischer-sitz", "", "", "2016-06-30 11:54:57", "2016-06-30 09:54:57", "", "0", "http://student11.wpstore.d-hosting.de/?p=264", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("265", "1", "2016-06-29 09:22:49", "2016-06-29 07:22:49", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 09:22:49", "2016-06-29 07:22:49", "", "264", "http://student11.wpstore.d-hosting.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("267", "1", "2016-06-29 09:24:16", "2016-06-29 07:24:16", "<strong><img class=\"alignnone size-full wp-image-266\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-2.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 09:24:16", "2016-06-29 07:24:16", "", "264", "http://student11.wpstore.d-hosting.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("268", "1", "2016-06-29 09:24:37", "2016-06-29 07:24:37", "<strong><img class=\"size-full wp-image-266 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-2.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 09:24:37", "2016-06-29 07:24:37", "", "264", "http://student11.wpstore.d-hosting.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("269", "1", "2016-06-29 09:32:12", "2016-06-29 07:32:12", "<img class=\"size-full wp-image-409 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "kerze", "", "publish", "closed", "closed", "", "kerze", "", "", "2016-06-30 11:54:08", "2016-06-30 09:54:08", "", "0", "http://student11.wpstore.d-hosting.de/?p=269", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("270", "1", "2016-06-29 09:32:12", "2016-06-29 07:32:12", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 09:32:12", "2016-06-29 07:32:12", "", "269", "http://student11.wpstore.d-hosting.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("272", "1", "2016-06-29 09:33:15", "2016-06-29 07:33:15", "<strong>Wofür ist das gut? </strong>\n\n&nbsp;\n<ul>\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\n 	<li>mildert Krampfadern und müde Beine</li>\n 	<li>streckt die Wirbelsäule</li>\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\n</ul>\n<strong>Ausführung: </strong>\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\n<ol>\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-autosave-v1", "", "", "2016-06-29 09:33:15", "2016-06-29 07:33:15", "", "269", "http://student11.wpstore.d-hosting.de/269-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("273", "1", "2016-06-29 09:34:06", "2016-06-29 07:34:06", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone size-full wp-image-271\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE-2.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 09:34:06", "2016-06-29 07:34:06", "", "269", "http://student11.wpstore.d-hosting.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("274", "1", "2016-06-29 09:34:18", "2016-06-29 07:34:18", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-271 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE-2.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 09:34:18", "2016-06-29 07:34:18", "", "269", "http://student11.wpstore.d-hosting.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("275", "1", "2016-06-29 09:42:06", "2016-06-29 07:42:06", "<strong><img class=\"size-full wp-image-407 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-1.png\" alt=\"kobra\" width=\"380\" height=\"191\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brustmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "kobra", "", "publish", "closed", "closed", "", "kobra", "", "", "2016-07-01 16:17:21", "2016-07-01 14:17:21", "", "0", "http://student11.wpstore.d-hosting.de/?p=275", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("276", "1", "2016-06-29 09:42:06", "2016-06-29 07:42:06", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "Kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-29 09:42:06", "2016-06-29 07:42:06", "", "275", "http://student11.wpstore.d-hosting.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("278", "1", "2016-06-29 09:43:41", "2016-06-29 07:43:41", "<strong><img class=\"wp-image-277 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-2.png\" alt=\"kobra\" width=\"324\" height=\"176\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "Kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-29 09:43:41", "2016-06-29 07:43:41", "", "275", "http://student11.wpstore.d-hosting.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("279", "1", "2016-06-29 09:44:55", "2016-06-29 07:44:55", "<strong><img class=\"size-full wp-image-405 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF.png\" alt=\"KOPF\" width=\"150\" height=\"278\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "kopfstand", "", "publish", "closed", "closed", "", "kopfstand", "", "", "2016-06-30 11:52:33", "2016-06-30 09:52:33", "", "0", "http://student11.wpstore.d-hosting.de/?p=279", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("280", "1", "2016-06-29 09:44:55", "2016-06-29 07:44:55", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li></li>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 09:44:55", "2016-06-29 07:44:55", "", "279", "http://student11.wpstore.d-hosting.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("282", "1", "2016-06-29 09:45:49", "2016-06-29 07:45:49", "<strong><img class=\"size-full wp-image-281 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF-2.png\" alt=\"kopfstand\" width=\"150\" height=\"278\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li></li>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 09:45:49", "2016-06-29 07:45:49", "", "279", "http://student11.wpstore.d-hosting.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("283", "1", "2016-06-29 09:46:15", "0000-00-00 00:00:00", "", "Automatisch gespeicherter Entwurf", "", "auto-draft", "open", "open", "", "", "", "", "2016-06-29 09:46:15", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?p=283", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("284", "1", "2016-06-29 10:14:16", "2016-06-29 08:14:16", "<strong><img class=\"size-full wp-image-281 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF-2.png\" alt=\"kopfstand\" width=\"150\" height=\"278\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 10:14:16", "2016-06-29 08:14:16", "", "279", "http://student11.wpstore.d-hosting.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("285", "1", "2016-06-29 10:28:09", "2016-06-29 08:28:09", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-403 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN-1.png\" alt=\"nacken rollen\" width=\"379\" height=\"92\" />Wofür ist das gut?  </strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "nacken rollen", "", "publish", "closed", "closed", "", "nacken-rollen", "", "", "2016-06-30 11:51:44", "2016-06-30 09:51:44", "", "0", "http://student11.wpstore.d-hosting.de/?p=285", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("286", "1", "2016-06-29 10:28:09", "2016-06-29 08:28:09", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-29 10:28:09", "2016-06-29 08:28:09", "", "285", "http://student11.wpstore.d-hosting.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("288", "1", "2016-06-29 10:29:11", "2016-06-29 08:29:11", "<strong>Wofür ist das gut?\n</strong>\n<ul>\n 	<li>hilft bei Nackenverspannungen</li>\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\n 	<li>reduziert Doppelkinn</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\n 	<li>Die Übung noch dreimal wiederholen.</li>\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-autosave-v1", "", "", "2016-06-29 10:29:11", "2016-06-29 08:29:11", "", "285", "http://student11.wpstore.d-hosting.de/285-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("289", "1", "2016-06-29 10:30:49", "2016-06-29 08:30:49", "<strong>Wofür ist das gut?  </strong>\r\n<strong><img class=\"wp-image-287 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN-2.png\" alt=\"nacken\" width=\"344\" height=\"75\" /></strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-29 10:30:49", "2016-06-29 08:30:49", "", "285", "http://student11.wpstore.d-hosting.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("290", "1", "2016-06-29 10:35:10", "2016-06-29 08:35:10", "<strong><img class=\"size-full wp-image-401 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"160\" height=\"168\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören und (keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "perfekter sitz", "", "publish", "closed", "closed", "", "perfekter-sitz", "", "", "2016-06-30 11:50:53", "2016-06-30 09:50:53", "", "0", "http://student11.wpstore.d-hosting.de/?p=290", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("291", "1", "2016-06-29 10:35:10", "2016-06-29 08:35:10", "<strong>   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Die Füße sollen möglichst in der Spalte, die sich zwischen Oberschenkel und Wade bildet, liegen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 10:35:10", "2016-06-29 08:35:10", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("293", "1", "2016-06-29 10:37:13", "2016-06-29 08:37:13", "<strong><img class=\"size-full wp-image-292 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"160\" height=\"168\" />   Wofür ist das gut? </strong>\n<ul>\n 	<li>ideal für längeres Sitzen</li>\n 	<li>entspannt den ganzen Körper</li>\n 	<li>streckt und kräftigt die Beine</li>\n 	<li>wohltuend für Blase und Harnwege</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\n 	<li>Die Füße sollen möglichst in der Spalte, die sich zwischen Oberschenkel und Wade bildet, liegen.</li>\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\n 	<li>Mit der anderen Seite wiederholen.</li>\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-autosave-v1", "", "", "2016-06-29 10:37:13", "2016-06-29 08:37:13", "", "290", "http://student11.wpstore.d-hosting.de/290-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("294", "1", "2016-06-29 10:37:37", "2016-06-29 08:37:37", "<strong><img class=\" wp-image-292 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Die Füße sollen möglichst in der Spalte, die sich zwischen Oberschenkel und Wade bildet, liegen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 10:37:37", "2016-06-29 08:37:37", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("295", "1", "2016-06-29 10:39:37", "2016-06-29 08:39:37", "<strong><img class=\" wp-image-292 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 10:39:37", "2016-06-29 08:39:37", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("296", "1", "2016-06-29 10:41:59", "2016-06-29 08:41:59", "<img class=\"size-full wp-image-399 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-1.png\" alt=\"pflug\" width=\"255\" height=\"156\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "pflug", "", "publish", "closed", "closed", "", "pflug", "", "", "2016-06-30 11:50:08", "2016-06-30 09:50:08", "", "0", "http://student11.wpstore.d-hosting.de/?p=296", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("297", "1", "2016-06-29 10:41:59", "2016-06-29 08:41:59", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "PFLUG", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-29 10:41:59", "2016-06-29 08:41:59", "", "296", "http://student11.wpstore.d-hosting.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("300", "1", "2016-06-29 10:45:20", "2016-06-29 08:45:20", "<strong><img class=\" wp-image-298 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-2.png\" alt=\"pflug\" width=\"239\" height=\"146\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "PFLUG", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-29 10:45:20", "2016-06-29 08:45:20", "", "296", "http://student11.wpstore.d-hosting.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("301", "1", "2016-06-29 10:59:16", "2016-06-29 08:59:16", "", "Wofür ist das gut?  •	lindert Beschwerden bei Plattfüßen  •	mildert Reißen in den Knien  •	hebt den Fußspann  •	bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden  Ausführung:  1.	Gehen Sie langsam in den Kniestand.  2.	Grätschen Sie die Unterschenkel und lassen die Knie zusammen.  3.	Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..  4.	Hände auf die Knie legen oder die Fußgelenke umfassen.  5.	Bis zu dreißig Sekunden verharren.", "", "trash", "open", "open", "", "__trashed", "", "", "2016-06-29 10:59:48", "2016-06-29 08:59:48", "", "0", "http://student11.wpstore.d-hosting.de/?p=301", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("302", "1", "2016-06-29 10:59:48", "2016-06-29 08:59:48", "", "Wofür ist das gut?  •	lindert Beschwerden bei Plattfüßen  •	mildert Reißen in den Knien  •	hebt den Fußspann  •	bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden  Ausführung:  1.	Gehen Sie langsam in den Kniestand.  2.	Grätschen Sie die Unterschenkel und lassen die Knie zusammen.  3.	Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..  4.	Hände auf die Knie legen oder die Fußgelenke umfassen.  5.	Bis zu dreißig Sekunden verharren.", "", "inherit", "closed", "closed", "", "301-revision-v1", "", "", "2016-06-29 10:59:48", "2016-06-29 08:59:48", "", "301", "http://student11.wpstore.d-hosting.de/301-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("303", "1", "2016-06-29 11:00:10", "2016-06-29 09:00:10", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-397 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "sitzender held", "", "publish", "closed", "closed", "", "sitzeder-held", "", "", "2016-06-30 11:49:09", "2016-06-30 09:49:09", "", "0", "http://student11.wpstore.d-hosting.de/?p=303", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("304", "1", "2016-06-29 11:00:11", "2016-06-29 09:00:11", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n</ol>", "SITZEDER HELD", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-29 11:00:11", "2016-06-29 09:00:11", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("306", "1", "2016-07-01 16:27:14", "2016-07-01 14:27:14", "&nbsp;\n\n<strong><img class=\"size-full wp-image-397 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\n<ul>\n 	<li>lindert Beschwerden bei Plattfüßen</li>\n 	<li>mildert Reißen in den Knien</li>\n 	<li>hebt den Fußspann</li>\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Gehen Sie langsam in den Kniestand.</li>\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade.</li>\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\n 	<li>Bis zu dreißig Sekunden verharren.</li>\n 	<li>Nach einer kurzen Pause wiederholen</li>\n</ol>\n<strong> </strong>\n\n&nbsp;", "sitzender held", "", "inherit", "closed", "closed", "", "303-autosave-v1", "", "", "2016-07-01 16:27:14", "2016-07-01 14:27:14", "", "303", "http://student11.wpstore.d-hosting.de/303-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("307", "1", "2016-06-29 11:03:14", "2016-06-29 09:03:14", "<strong><img class=\"alignnone size-full wp-image-305\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD-2.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n</ol>", "SITZEnDER HELD", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-29 11:03:14", "2016-06-29 09:03:14", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("308", "1", "2016-06-29 11:05:46", "2016-06-29 09:05:46", "<strong><img class=\"alignnone size-full wp-image-305\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD-2.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "SITZEnDER HELD", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-29 11:05:46", "2016-06-29 09:05:46", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("309", "1", "2016-06-29 11:06:07", "2016-06-29 09:06:07", "<strong><img class=\"size-full wp-image-305 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD-2.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "SITZEnDER HELD", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-29 11:06:07", "2016-06-29 09:06:07", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("310", "1", "2016-06-29 11:07:00", "2016-06-29 09:07:00", "<strong><img class=\"size-full wp-image-305 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD-2.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "SITZENDER HELD", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-29 11:07:00", "2016-06-29 09:07:00", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("311", "1", "2016-06-29 11:07:54", "2016-06-29 09:07:54", "<strong><img class=\"size-full wp-image-394 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-1.png\" alt=\"zusammengerolltes blatt\" width=\"239\" height=\"88\" /></strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "zusammengerolltes blatt", "", "publish", "closed", "closed", "", "zusammengerolltes-blatt", "", "", "2016-06-30 11:48:07", "2016-06-30 09:48:07", "", "0", "http://student11.wpstore.d-hosting.de/?p=311", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("312", "1", "2016-06-29 11:07:54", "2016-06-29 09:07:54", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entspannt vollkommen</li>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "ZUSAMMENGEROLLTES BLATT", "", "inherit", "closed", "closed", "", "311-revision-v1", "", "", "2016-06-29 11:07:54", "2016-06-29 09:07:54", "", "311", "http://student11.wpstore.d-hosting.de/311-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("314", "1", "2016-06-29 11:10:55", "2016-06-29 09:10:55", "<strong>Wofür ist das gut?<img class=\" wp-image-313 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-2.png\" alt=\"zusammengerolltes blatt\" width=\"222\" height=\"100\" /></strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "ZUSAMMENGEROLLTES BLATT", "", "inherit", "closed", "closed", "", "311-revision-v1", "", "", "2016-06-29 11:10:55", "2016-06-29 09:10:55", "", "311", "http://student11.wpstore.d-hosting.de/311-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("315", "1", "2016-06-29 11:12:40", "2016-06-29 09:12:40", "<strong>Wofür ist das gut?<img class=\"wp-image-313 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-2.png\" alt=\"zusammengerolltes blatt\" width=\"222\" height=\"100\" /></strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "ZUSAMMENGEROLLTES BLATT", "", "inherit", "closed", "closed", "", "311-revision-v1", "", "", "2016-06-29 11:12:40", "2016-06-29 09:12:40", "", "311", "http://student11.wpstore.d-hosting.de/311-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("316", "1", "2016-06-29 11:13:18", "2016-06-29 09:13:18", "<strong><img class=\"wp-image-298 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-2.png\" alt=\"pflug\" width=\"239\" height=\"146\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "PFLUG", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-29 11:13:18", "2016-06-29 09:13:18", "", "296", "http://student11.wpstore.d-hosting.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("317", "1", "2016-06-29 11:14:03", "2016-06-29 09:14:03", "<strong><img class=\"wp-image-292 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 11:14:03", "2016-06-29 09:14:03", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("319", "1", "2016-06-29 11:18:32", "2016-06-29 09:18:32", "<strong><img class=\"wp-image-277 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-2.png\" alt=\"kobra\" width=\"297\" height=\"152\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "Kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-29 11:18:32", "2016-06-29 09:18:32", "", "275", "http://student11.wpstore.d-hosting.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("321", "1", "2016-06-29 11:21:46", "2016-06-29 09:21:46", "<strong><img class=\"aligncenter wp-image-313\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-2.png\" alt=\"zusammengerolltes blatt\" width=\"221\" height=\"103\" /></strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "ZUSAMMENGEROLLTES BLATT", "", "inherit", "closed", "closed", "", "311-revision-v1", "", "", "2016-06-29 11:21:46", "2016-06-29 09:21:46", "", "311", "http://student11.wpstore.d-hosting.de/311-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("323", "1", "2016-06-29 11:23:18", "2016-06-29 09:23:18", "<strong><img class=\"aligncenter wp-image-305 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD-2.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "SITZENDER HELD", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-29 11:23:18", "2016-06-29 09:23:18", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("324", "1", "2016-06-29 11:24:20", "2016-06-29 09:24:20", "<strong><img class=\"aligncenter wp-image-298\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-2.png\" alt=\"pflug\" width=\"239\" height=\"146\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "PFLUG", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-29 11:24:20", "2016-06-29 09:24:20", "", "296", "http://student11.wpstore.d-hosting.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("325", "1", "2016-06-29 11:24:26", "2016-06-29 09:24:26", "<strong><img class=\"aligncenter wp-image-298\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-2.png\" alt=\"pflug\" width=\"239\" height=\"146\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "PFLUG", "", "inherit", "closed", "closed", "", "296-autosave-v1", "", "", "2016-06-29 11:24:26", "2016-06-29 09:24:26", "", "296", "http://student11.wpstore.d-hosting.de/296-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("326", "1", "2016-06-29 11:25:13", "2016-06-29 09:25:13", "<strong><img class=\"aligncenter wp-image-292\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 11:25:13", "2016-06-29 09:25:13", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("327", "1", "2016-06-29 11:27:37", "2016-06-29 09:27:37", "<strong><img class=\"aligncenter wp-image-287\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN-2.png\" alt=\"nacken\" width=\"344\" height=\"75\" /></strong>\r\n\r\n<strong>Wofür ist das gut?  </strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-29 11:27:37", "2016-06-29 09:27:37", "", "285", "http://student11.wpstore.d-hosting.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("328", "1", "2016-06-29 11:28:09", "2016-06-29 09:28:09", "<strong><img class=\"aligncenter wp-image-292\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 11:28:09", "2016-06-29 09:28:09", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("329", "1", "2016-06-29 11:30:10", "2016-06-29 09:30:10", "<img class=\"size-full wp-image-271 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE-2.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 11:30:10", "2016-06-29 09:30:10", "", "269", "http://student11.wpstore.d-hosting.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("330", "1", "2016-06-29 11:30:55", "2016-06-29 09:30:55", "<strong><img class=\"size-full wp-image-281 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF-2.png\" alt=\"kopfstand\" width=\"150\" height=\"278\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 11:30:55", "2016-06-29 09:30:55", "", "279", "http://student11.wpstore.d-hosting.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("331", "1", "2016-06-29 11:32:28", "2016-06-29 09:32:28", "<strong><img class=\"size-full wp-image-81 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png\" alt=\"ARM\" width=\"165\" height=\"182\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-29 11:32:28", "2016-06-29 09:32:28", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("332", "1", "2016-06-29 11:35:06", "2016-06-29 09:35:06", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-29 11:35:06", "2016-06-29 09:35:06", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("334", "1", "2016-06-29 11:36:49", "2016-06-29 09:36:49", "<strong><img class=\"wp-image-158 size-full alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />Wofür ist das gut\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-29 11:36:49", "2016-06-29 09:36:49", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("335", "1", "2016-06-29 11:37:58", "2016-06-29 09:37:58", "<strong><img class=\"wp-image-158  alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"125\" height=\"266\" /></strong>\r\n\r\n<strong>Wofür ist das gut\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-29 11:37:58", "2016-06-29 09:37:58", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("336", "1", "2016-06-29 11:38:03", "2016-06-29 09:38:03", "<strong><img class=\"wp-image-158 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"125\" height=\"266\" /></strong>\r\n\r\n<strong>Wofür ist das gut\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-autosave-v1", "", "", "2016-06-29 11:38:03", "2016-06-29 09:38:03", "", "157", "http://student11.wpstore.d-hosting.de/157-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("337", "1", "2016-06-29 11:50:55", "2016-06-29 09:50:55", "<strong><img class=\"size-full wp-image-166 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-revision-v1", "", "", "2016-06-29 11:50:55", "2016-06-29 09:50:55", "", "164", "http://student11.wpstore.d-hosting.de/164-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("338", "1", "2016-06-29 11:53:18", "2016-06-29 09:53:18", "<strong><img class=\"size-full wp-image-266 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-2.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 11:53:18", "2016-06-29 09:53:18", "", "264", "http://student11.wpstore.d-hosting.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("339", "1", "2016-06-29 11:54:58", "2016-06-29 09:54:58", "<strong><img class=\"wp-image-261 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"178\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-revision-v1", "", "", "2016-06-29 11:54:58", "2016-06-29 09:54:58", "", "259", "http://student11.wpstore.d-hosting.de/259-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("340", "1", "2016-06-29 11:58:16", "2016-06-29 09:58:16", "<img class=\"wp-image-249 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"348\" height=\"93\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "GESPREIZTE BEINSTRECKUNG", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 11:58:16", "2016-06-29 09:58:16", "", "248", "http://student11.wpstore.d-hosting.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("341", "1", "2016-06-29 11:58:22", "2016-06-29 09:58:22", "<img class=\"wp-image-249 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"348\" height=\"93\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "GESPREIZTE BEINSTRECKUNG", "", "inherit", "closed", "closed", "", "248-autosave-v1", "", "", "2016-06-29 11:58:22", "2016-06-29 09:58:22", "", "248", "http://student11.wpstore.d-hosting.de/248-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("342", "1", "2016-06-29 11:59:03", "2016-06-29 09:59:03", "<strong><img class=\"size-full wp-image-194 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-29 11:59:03", "2016-06-29 09:59:03", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("344", "1", "2016-06-29 12:00:05", "2016-06-29 10:00:05", "<strong><img class=\"size-full wp-image-194 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-29 12:00:05", "2016-06-29 10:00:05", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("345", "1", "2016-06-29 12:00:49", "2016-06-29 10:00:49", "<strong><img class=\"size-full wp-image-194 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-29 12:00:49", "2016-06-29 10:00:49", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("347", "1", "2016-06-29 12:01:19", "2016-06-29 10:01:19", "<strong><img class=\"size-full wp-image-194 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-29 12:01:19", "2016-06-29 10:01:19", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("348", "1", "2016-06-29 12:01:55", "2016-06-29 10:01:55", "<strong><img class=\"size-full wp-image-194 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-autosave-v1", "", "", "2016-06-29 12:01:55", "2016-06-29 10:01:55", "", "192", "http://student11.wpstore.d-hosting.de/192-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("349", "1", "2016-06-29 15:34:31", "2016-06-29 13:34:31", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier aber nicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur etwas für junge Leute.\r\n\r\nEs ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechniken und körperlichen Übungen. Yoga entspannt und reguliert die Körperfunktionen und gibt Energie. Die Muskeln werden gesdehnt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hier nicht um den Vergleich mit Anderen.\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür! Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen! In der Endstellung verharrt man dann einige Sekunden. Wiederholungen nach einer kurzen Pause.\r\n\r\n<strong>Zeit</strong>\r\n\r\nAm besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn. Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden - es gibt natürlich auch entsprechende einfache yogamatten.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei oder vier Stunden und nach einem leichten Imbiß etwa eine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-29 15:34:31", "2016-06-29 13:34:31", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("350", "1", "2016-06-29 15:39:23", "2016-06-29 13:39:23", "<strong><img class=\"aligncenter wp-image-292\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören und (keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 15:39:23", "2016-06-29 13:39:23", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("351", "1", "2016-06-29 15:41:03", "2016-06-29 13:41:03", "<img class=\"wp-image-72 size-medium aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-29 15:41:03", "2016-06-29 13:41:03", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("352", "1", "2016-06-29 15:42:24", "2016-06-29 13:42:24", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannendx</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-29 15:42:24", "2016-06-29 13:42:24", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("353", "1", "2016-06-29 15:44:00", "2016-06-29 13:44:00", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannendx</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-29 15:44:00", "2016-06-29 13:44:00", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("354", "1", "2016-06-29 15:45:01", "2016-06-29 13:45:01", "<strong><img class=\"aligncenter wp-image-34\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-29 15:45:01", "2016-06-29 13:45:01", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("355", "1", "2016-06-29 16:13:15", "2016-06-29 14:13:15", "[gallery ids=\"426,431,429,430,427,428\"]\r\n\r\nhinter den traumgärten am ende der zeit ...\r\n\r\n&nbsp;", "traumgarten", "", "publish", "closed", "closed", "", "traumgarten", "", "", "2016-07-01 08:15:29", "2016-07-01 06:15:29", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=355", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("358", "1", "2016-06-29 16:09:13", "2016-06-29 14:09:13", "", "jungfer im grünen", "jungfer im grünen", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-5", "", "", "2016-06-29 16:11:38", "2016-06-29 14:11:38", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jungfer-im-grünen-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("359", "1", "2016-06-29 16:09:14", "2016-06-29 14:09:14", "", "küchenschelle", "küchenschelle", "inherit", "open", "closed", "", "ku%cc%88chenschelle-2", "", "", "2016-06-29 16:12:04", "2016-06-29 14:12:04", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/küchenschelle.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("362", "1", "2016-06-29 16:13:15", "2016-06-29 14:13:15", " ", "", "", "publish", "closed", "closed", "", "362", "", "", "2016-06-30 08:53:47", "2016-06-30 06:53:47", "", "0", "http://student11.wpstore.d-hosting.de/362/", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("363", "1", "2016-06-29 16:13:15", "2016-06-29 14:13:15", "hinter den traumgärten am ende der zeit ...\r\n\r\n[gallery ids=\"356,357,358,359,360,361\"]", "traumgarten", "", "inherit", "closed", "closed", "", "355-revision-v1", "", "", "2016-06-29 16:13:15", "2016-06-29 14:13:15", "", "355", "http://student11.wpstore.d-hosting.de/355-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("365", "1", "2016-06-29 16:17:47", "2016-06-29 14:17:47", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier aber nicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur etwas für junge Leute.\r\n\r\nEs ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechniken und körperlichen Übungen. Yoga entspannt und reguliert die Körperfunktionen und gibt Energie. Die Muskeln werden gesdehnt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hier nicht um den Vergleich mit Anderen.\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür! Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen! In der Endstellung verharrt man dann einige Sekunden. Wiederholungen nach einer kurzen Pause.\r\n\r\n<strong>Zeit</strong>\r\n\r\nAm besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn. Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden - es gibt natürlich auch entsprechende einfache yogamatten.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei oder vier Stunden und nach einem leichten Imbiß etwa eine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-29 16:17:47", "2016-06-29 14:17:47", "", "86", "http://student11.wpstore.d-hosting.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("366", "1", "2016-06-30 06:01:31", "2016-06-30 04:01:31", "<img class=\"wp-image-96 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alles", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-30 06:01:31", "2016-06-30 04:01:31", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("367", "1", "2016-06-30 06:01:54", "2016-06-30 04:01:54", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                    </strong><img class=\"wp-image-13 size-full alignnone\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /><strong>                               </strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-30 06:01:54", "2016-06-30 04:01:54", "", "12", "http://student11.wpstore.d-hosting.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("368", "1", "2016-06-30 06:04:23", "2016-06-30 04:04:23", "<strong><img class=\"aligncenter wp-image-313\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-2.png\" alt=\"zusammengerolltes blatt\" width=\"221\" height=\"103\" /></strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "zusammengerolltes blatt", "", "inherit", "closed", "closed", "", "311-revision-v1", "", "", "2016-06-30 06:04:23", "2016-06-30 04:04:23", "", "311", "http://student11.wpstore.d-hosting.de/311-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("369", "1", "2016-06-30 06:05:00", "2016-06-30 04:05:00", "<strong><img class=\"aligncenter wp-image-305 size-full\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD-2.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "sitzender held", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-30 06:05:00", "2016-06-30 04:05:00", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("370", "1", "2016-06-30 06:05:25", "2016-06-30 04:05:25", "<strong><img class=\"aligncenter wp-image-292\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören und (keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "perfekter sitz", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-30 06:05:25", "2016-06-30 04:05:25", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("371", "1", "2016-06-30 06:05:57", "2016-06-30 04:05:57", "<strong><img class=\"aligncenter wp-image-298\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-2.png\" alt=\"pflug\" width=\"239\" height=\"146\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "pflug", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-30 06:05:57", "2016-06-30 04:05:57", "", "296", "http://student11.wpstore.d-hosting.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("372", "1", "2016-06-30 06:06:13", "2016-06-30 04:06:13", "<strong><img class=\"aligncenter wp-image-287\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN-2.png\" alt=\"nacken\" width=\"344\" height=\"75\" /></strong>\r\n\r\n<strong>Wofür ist das gut?  </strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "nacken rollen", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-30 06:06:13", "2016-06-30 04:06:13", "", "285", "http://student11.wpstore.d-hosting.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("373", "1", "2016-06-30 06:06:27", "2016-06-30 04:06:27", "<strong><img class=\"size-full wp-image-281 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF-2.png\" alt=\"kopfstand\" width=\"150\" height=\"278\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "kopfstand", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-30 06:06:27", "2016-06-30 04:06:27", "", "279", "http://student11.wpstore.d-hosting.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("374", "1", "2016-06-30 06:06:40", "2016-06-30 04:06:40", "<strong><img class=\"wp-image-277 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-2.png\" alt=\"kobra\" width=\"297\" height=\"152\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-30 06:06:40", "2016-06-30 04:06:40", "", "275", "http://student11.wpstore.d-hosting.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("375", "1", "2016-06-30 06:06:50", "2016-06-30 04:06:50", "<img class=\"size-full wp-image-271 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE-2.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "kerze", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-30 06:06:50", "2016-06-30 04:06:50", "", "269", "http://student11.wpstore.d-hosting.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("376", "1", "2016-06-30 06:07:07", "2016-06-30 04:07:07", "<strong><img class=\"size-full wp-image-266 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-2.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "japanischer sitz", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-30 06:07:07", "2016-06-30 04:07:07", "", "264", "http://student11.wpstore.d-hosting.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("377", "1", "2016-06-30 06:07:22", "2016-06-30 04:07:22", "<strong><img class=\"wp-image-261 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"178\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "haltungsgriff", "", "inherit", "closed", "closed", "", "259-revision-v1", "", "", "2016-06-30 06:07:22", "2016-06-30 04:07:22", "", "259", "http://student11.wpstore.d-hosting.de/259-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("378", "1", "2016-06-30 06:07:38", "2016-06-30 04:07:38", "<img class=\"wp-image-249 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"348\" height=\"93\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "gespreizte beinstreckung", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-30 06:07:38", "2016-06-30 04:07:38", "", "248", "http://student11.wpstore.d-hosting.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("379", "1", "2016-06-30 06:07:55", "2016-06-30 04:07:55", "<strong><img class=\"size-full wp-image-194 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-30 06:07:55", "2016-06-30 04:07:55", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("380", "1", "2016-06-30 06:08:04", "2016-06-30 04:08:04", "<strong>Wofür ist das gut? <img class=\"wp-image-190 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"286\" height=\"212\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "bogen", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-30 06:08:04", "2016-06-30 04:08:04", "", "189", "http://student11.wpstore.d-hosting.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("381", "1", "2016-06-30 06:08:22", "2016-06-30 04:08:22", "<strong><img class=\"size-full wp-image-166 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "bein-überschlag", "", "inherit", "closed", "closed", "", "164-revision-v1", "", "", "2016-06-30 06:08:22", "2016-06-30 04:08:22", "", "164", "http://student11.wpstore.d-hosting.de/164-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("382", "1", "2016-06-30 06:08:33", "2016-06-30 04:08:33", "<strong><img class=\"wp-image-158  alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"125\" height=\"266\" /></strong>\r\n\r\n<strong>Wofür ist das gut\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-30 06:08:33", "2016-06-30 04:08:33", "", "157", "http://student11.wpstore.d-hosting.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("383", "1", "2016-06-30 06:08:45", "2016-06-30 04:08:45", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannendx</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "augen rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-30 06:08:45", "2016-06-30 04:08:45", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("384", "1", "2016-06-30 06:08:58", "2016-06-30 04:08:58", "<strong><img class=\"aligncenter wp-image-34\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-30 06:08:58", "2016-06-30 04:08:58", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("385", "1", "2016-06-30 06:09:16", "2016-06-30 04:09:16", "<strong><img class=\"size-full wp-image-81 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png\" alt=\"ARM\" width=\"165\" height=\"182\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "arm-heben", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-30 06:09:16", "2016-06-30 04:09:16", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("386", "1", "2016-06-30 06:10:07", "2016-06-30 04:10:07", "<img class=\"wp-image-96 size-full alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-30 06:10:07", "2016-06-30 04:10:07", "", "6", "http://student11.wpstore.d-hosting.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("387", "1", "2016-06-30 08:53:05", "2016-06-30 06:53:05", " ", "", "", "publish", "closed", "closed", "", "387", "", "", "2016-06-30 08:53:05", "2016-06-30 06:53:05", "", "0", "http://student11.wpstore.d-hosting.de/?p=387", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("388", "1", "2016-06-30 08:53:05", "2016-06-30 06:53:05", " ", "", "", "publish", "closed", "closed", "", "388", "", "", "2016-06-30 08:53:05", "2016-06-30 06:53:05", "", "0", "http://student11.wpstore.d-hosting.de/?p=388", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("389", "1", "2016-06-30 08:53:05", "2016-06-30 06:53:05", " ", "", "", "publish", "closed", "closed", "", "389", "", "", "2016-06-30 08:53:05", "2016-06-30 06:53:05", "", "0", "http://student11.wpstore.d-hosting.de/?p=389", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("390", "1", "2016-06-30 08:53:05", "2016-06-30 06:53:05", " ", "", "", "publish", "closed", "closed", "", "390", "", "", "2016-06-30 08:53:05", "2016-06-30 06:53:05", "", "0", "http://student11.wpstore.d-hosting.de/?p=390", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("391", "1", "2016-06-30 08:53:05", "2016-06-30 06:53:05", " ", "", "", "publish", "closed", "closed", "", "391", "", "", "2016-06-30 08:53:05", "2016-06-30 06:53:05", "", "0", "http://student11.wpstore.d-hosting.de/?p=391", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("392", "1", "2016-06-30 08:53:05", "2016-06-30 06:53:05", " ", "", "", "publish", "closed", "closed", "", "392", "", "", "2016-06-30 08:53:05", "2016-06-30 06:53:05", "", "0", "http://student11.wpstore.d-hosting.de/?p=392", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("393", "1", "2016-06-30 11:28:04", "2016-06-30 09:28:04", "hinter den traumgärten am ende der zeit ...\r\n\r\n&nbsp;", "traumgarten", "", "inherit", "closed", "closed", "", "355-revision-v1", "", "", "2016-06-30 11:28:04", "2016-06-30 09:28:04", "", "355", "http://student11.wpstore.d-hosting.de/355-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("394", "1", "2016-06-30 11:47:28", "2016-06-30 09:47:28", "", "ZUBLATT", "", "inherit", "open", "closed", "", "zublatt", "", "", "2016-06-30 11:47:49", "2016-06-30 09:47:49", "", "311", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("395", "1", "2016-07-01 16:25:52", "2016-07-01 14:25:52", "<strong><img class=\"size-full wp-image-394 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-1.png\" alt=\"zusammengerolltes blatt\" width=\"239\" height=\"88\" /></strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen - oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "zusammengerolltes blatt", "", "inherit", "closed", "closed", "", "311-autosave-v1", "", "", "2016-07-01 16:25:52", "2016-07-01 14:25:52", "", "311", "http://student11.wpstore.d-hosting.de/311-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("396", "1", "2016-06-30 11:48:07", "2016-06-30 09:48:07", "<strong><img class=\"size-full wp-image-394 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ZUBLATT-1.png\" alt=\"zusammengerolltes blatt\" width=\"239\" height=\"88\" /></strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n<ul>\r\n 	<li>schafft neue Energie</li>\r\n 	<li>fördert die Durchblutung des Kopfes</li>\r\n 	<li>hilft gegen müde Beine und Krampfadern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien sie sich mit geschlossenen Beinen auf den Boden.</li>\r\n 	<li>Setzen Sie sich auf Ihre Fersen, die Arme dicht neben dem Körper weit nach hinten führen, die Handflächen nach oben.</li>\r\n 	<li>Den Kopf mit der Stirn auf die Erde legen (oder auch seitlich drehen.</li>\r\n 	<li>Das gesamte Gewicht auf die Beine und Fersen legen.</li>\r\n 	<li>Möglichst lange so verharren.</li>\r\n</ol>", "zusammengerolltes blatt", "", "inherit", "closed", "closed", "", "311-revision-v1", "", "", "2016-06-30 11:48:07", "2016-06-30 09:48:07", "", "311", "http://student11.wpstore.d-hosting.de/311-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("397", "1", "2016-06-30 11:48:47", "2016-06-30 09:48:47", "", "SITHELD", "", "inherit", "open", "closed", "", "sitheld", "", "", "2016-06-30 11:48:59", "2016-06-30 09:48:59", "", "303", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("398", "1", "2016-06-30 11:49:09", "2016-06-30 09:49:09", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-397 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/SITHELD.png\" alt=\"sitzender held\" width=\"200\" height=\"224\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>lindert Beschwerden bei Plattfüßen</li>\r\n 	<li>mildert Reißen in den Knien</li>\r\n 	<li>hebt den Fußspann</li>\r\n 	<li>bringt Erleichterung bei Völlegefühl und kann direkt nach dem Essen ausgeführt werden</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Gehen Sie langsam in den Kniestand.</li>\r\n 	<li>Grätschen Sie die Unterschenkel und lassen die Knie zusammen.</li>\r\n 	<li>Senken Sie den Körper (ganz langsam), bis Sie zwischen den Füßen auf dem Boden sitzen - der Rücken bleibt gerade..</li>\r\n 	<li>Hände auf die Knie legen oder die Fußgelenke umfassen.</li>\r\n 	<li>Bis zu dreißig Sekunden verharren.</li>\r\n 	<li>Nach einer kurzen Pause wiederholen</li>\r\n</ol>\r\n<strong> </strong>\r\n\r\n&nbsp;", "sitzender held", "", "inherit", "closed", "closed", "", "303-revision-v1", "", "", "2016-06-30 11:49:09", "2016-06-30 09:49:09", "", "303", "http://student11.wpstore.d-hosting.de/303-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("399", "1", "2016-06-30 11:49:54", "2016-06-30 09:49:54", "", "PFLUG", "", "inherit", "open", "closed", "", "pflug-3", "", "", "2016-06-30 11:50:03", "2016-06-30 09:50:03", "", "296", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("400", "1", "2016-06-30 11:50:08", "2016-06-30 09:50:08", "<img class=\"size-full wp-image-399 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PFLUG-1.png\" alt=\"pflug\" width=\"255\" height=\"156\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "pflug", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-30 11:50:08", "2016-06-30 09:50:08", "", "296", "http://student11.wpstore.d-hosting.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("401", "1", "2016-06-30 11:50:36", "2016-06-30 09:50:36", "", "PERSITZ", "", "inherit", "open", "closed", "", "persitz", "", "", "2016-06-30 11:50:47", "2016-06-30 09:50:47", "", "290", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("402", "1", "2016-06-30 11:50:53", "2016-06-30 09:50:53", "<strong><img class=\"size-full wp-image-401 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"160\" height=\"168\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören und (keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "perfekter sitz", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-30 11:50:53", "2016-06-30 09:50:53", "", "290", "http://student11.wpstore.d-hosting.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("403", "1", "2016-06-30 11:51:25", "2016-06-30 09:51:25", "", "NACKEN", "", "inherit", "open", "closed", "", "nacken", "", "", "2016-06-30 11:51:37", "2016-06-30 09:51:37", "", "285", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("404", "1", "2016-06-30 11:51:44", "2016-06-30 09:51:44", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-403 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/NACKEN-1.png\" alt=\"nacken rollen\" width=\"379\" height=\"92\" />Wofür ist das gut?  </strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "nacken rollen", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-30 11:51:44", "2016-06-30 09:51:44", "", "285", "http://student11.wpstore.d-hosting.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("405", "1", "2016-06-30 11:52:21", "2016-06-30 09:52:21", "", "KOPF", "", "inherit", "open", "closed", "", "kopf", "", "", "2016-06-30 11:52:21", "2016-06-30 09:52:21", "", "279", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("406", "1", "2016-06-30 11:52:33", "2016-06-30 09:52:33", "<strong><img class=\"size-full wp-image-405 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOPF.png\" alt=\"KOPF\" width=\"150\" height=\"278\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "kopfstand", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-30 11:52:33", "2016-06-30 09:52:33", "", "279", "http://student11.wpstore.d-hosting.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("407", "1", "2016-06-30 11:53:05", "2016-06-30 09:53:05", "", "KOBRA", "", "inherit", "open", "closed", "", "kobra-3", "", "", "2016-06-30 11:53:15", "2016-06-30 09:53:15", "", "275", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("408", "1", "2016-06-30 11:53:26", "2016-06-30 09:53:26", "<strong><img class=\"size-full wp-image-407 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-1.png\" alt=\"kobra\" width=\"380\" height=\"191\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-30 11:53:26", "2016-06-30 09:53:26", "", "275", "http://student11.wpstore.d-hosting.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("409", "1", "2016-06-30 11:53:52", "2016-06-30 09:53:52", "", "KERZE", "", "inherit", "open", "closed", "", "kerze-2", "", "", "2016-06-30 11:54:01", "2016-06-30 09:54:01", "", "269", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("410", "1", "2016-06-30 11:54:08", "2016-06-30 09:54:08", "<img class=\"size-full wp-image-409 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KERZE.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "kerze", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-30 11:54:08", "2016-06-30 09:54:08", "", "269", "http://student11.wpstore.d-hosting.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("411", "1", "2016-06-30 11:54:36", "2016-06-30 09:54:36", "", "JAPSITZ", "", "inherit", "open", "closed", "", "japsitz", "", "", "2016-06-30 11:54:45", "2016-06-30 09:54:45", "", "264", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("412", "1", "2016-06-30 11:54:57", "2016-06-30 09:54:57", "<strong><img class=\"size-full wp-image-411 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/JAPSITZ-1.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "japanischer sitz", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-30 11:54:57", "2016-06-30 09:54:57", "", "264", "http://student11.wpstore.d-hosting.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("413", "1", "2016-06-30 11:55:32", "2016-06-30 09:55:32", "", "GESPREI", "", "inherit", "open", "closed", "", "gesprei", "", "", "2016-06-30 11:55:48", "2016-06-30 09:55:48", "", "248", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("414", "1", "2016-06-30 11:55:56", "2016-06-30 09:55:56", "<img class=\"size-full wp-image-413 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/GESPREI-1.png\" alt=\"gespreizte beinstreckung\" width=\"380\" height=\"109\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "gespreizte beinstreckung", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-30 11:55:56", "2016-06-30 09:55:56", "", "248", "http://student11.wpstore.d-hosting.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("415", "1", "2016-06-30 11:56:27", "2016-06-30 09:56:27", "", "BRUEXPA", "", "inherit", "open", "closed", "", "bruexpa", "", "", "2016-06-30 11:56:39", "2016-06-30 09:56:39", "", "192", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("416", "1", "2016-06-30 11:56:50", "2016-06-30 09:56:50", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-415 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BRUEXPA-1.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-30 11:56:50", "2016-06-30 09:56:50", "", "192", "http://student11.wpstore.d-hosting.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("417", "1", "2016-06-30 11:57:24", "2016-06-30 09:57:24", "", "BOGEN", "", "inherit", "open", "closed", "", "bogen-2", "", "", "2016-06-30 11:57:30", "2016-06-30 09:57:30", "", "189", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("418", "1", "2016-06-30 11:57:49", "2016-06-30 09:57:49", "<strong><img class=\"size-full wp-image-417 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/BOGEN.png\" alt=\"bogen\" width=\"228\" height=\"180\" /></strong>\r\n\r\n<strong>Wofür ist das gut?\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "bogen", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-30 11:57:49", "2016-06-30 09:57:49", "", "189", "http://student11.wpstore.d-hosting.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("419", "1", "2016-06-30 11:58:50", "2016-06-30 09:58:50", "", "AUGEN", "", "inherit", "open", "closed", "", "augen", "", "", "2016-06-30 11:58:59", "2016-06-30 09:58:59", "", "69", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("420", "1", "2016-06-30 11:59:15", "2016-06-30 09:59:15", "<img class=\"size-full wp-image-419 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUGEN.png\" alt=\"augen rollen\" width=\"302\" height=\"96\" />\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannendx</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "augen rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-30 11:59:15", "2016-06-30 09:59:15", "", "69", "http://student11.wpstore.d-hosting.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("421", "1", "2016-06-30 11:59:42", "2016-06-30 09:59:42", "", "AUF", "", "inherit", "open", "closed", "", "auf", "", "", "2016-06-30 11:59:51", "2016-06-30 09:59:51", "", "32", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("422", "1", "2016-06-30 12:00:03", "2016-06-30 10:00:03", "<strong><img class=\"size-full wp-image-421 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/AUF-1.png\" alt=\"aufsetzen\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-30 12:00:03", "2016-06-30 10:00:03", "", "32", "http://student11.wpstore.d-hosting.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("423", "1", "2016-06-30 12:00:33", "2016-06-30 10:00:33", "", "ARM", "", "inherit", "open", "closed", "", "arm", "", "", "2016-06-30 12:00:43", "2016-06-30 10:00:43", "", "30", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("424", "1", "2016-06-30 12:01:03", "2016-06-30 10:01:03", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-423 alignright\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/ARM.png\" alt=\"arm heben\" width=\"165\" height=\"182\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "arm-heben", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-30 12:01:03", "2016-06-30 10:01:03", "", "30", "http://student11.wpstore.d-hosting.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("425", "1", "2016-07-01 08:11:57", "0000-00-00 00:00:00", "", "Automatisch gespeicherter Entwurf", "", "auto-draft", "closed", "closed", "", "", "", "", "2016-07-01 08:11:57", "0000-00-00 00:00:00", "", "0", "http://student11.wpstore.d-hosting.de/?page_id=425", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("426", "1", "2016-07-01 08:12:48", "2016-07-01 06:12:48", "distel", "distel", "", "inherit", "open", "closed", "", "distel", "", "", "2016-07-01 08:13:08", "2016-07-01 06:13:08", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/distel.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("427", "1", "2016-07-01 08:12:49", "2016-07-01 06:12:49", "jacobsleiter", "jacobsleiter", "", "inherit", "open", "closed", "", "jacobsleiter", "", "", "2016-07-01 08:14:13", "2016-07-01 06:14:13", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jacobsleiter.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("428", "1", "2016-07-01 08:12:49", "2016-07-01 06:12:49", "jungfer-im-gruenen", "jungfer-im-gruenen", "", "inherit", "open", "closed", "", "jungfer-im-gruenen", "", "", "2016-07-01 08:14:00", "2016-07-01 06:14:00", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/jungfer-im-gruenen.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("429", "1", "2016-07-01 08:12:50", "2016-07-01 06:12:50", "kuechenschelle", "kuechenschelle", "", "inherit", "open", "closed", "", "kuechenschelle", "", "", "2016-07-01 08:13:46", "2016-07-01 06:13:46", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/kuechenschelle.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("430", "1", "2016-07-01 08:12:50", "2016-07-01 06:12:50", "mohn", "mohn", "", "inherit", "open", "closed", "", "mohn", "", "", "2016-07-01 08:13:23", "2016-07-01 06:13:23", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/mohn.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("431", "1", "2016-07-01 08:12:51", "2016-07-01 06:12:51", "pfingstose", "pfingstose", "", "inherit", "open", "closed", "", "pfingstose", "", "", "2016-07-01 08:14:52", "2016-07-01 06:14:52", "", "355", "http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/pfingstose.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("432", "1", "2016-07-01 08:15:29", "2016-07-01 06:15:29", "[gallery ids=\"426,431,429,430,427,428\"]\r\n\r\nhinter den traumgärten am ende der zeit ...\r\n\r\n&nbsp;", "traumgarten", "", "inherit", "closed", "closed", "", "355-revision-v1", "", "", "2016-07-01 08:15:29", "2016-07-01 06:15:29", "", "355", "http://student11.wpstore.d-hosting.de/355-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("433", "1", "2016-07-01 16:17:21", "2016-07-01 14:17:21", "<strong><img class=\"size-full wp-image-407 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-1.png\" alt=\"kobra\" width=\"380\" height=\"191\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brustmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-07-01 16:17:21", "2016-07-01 14:17:21", "", "275", "http://student11.wpstore.d-hosting.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("434", "1", "2016-07-01 16:18:25", "2016-07-01 14:18:25", "<strong><img class=\"size-full wp-image-407 aligncenter\" src=\"http://student11.wpstore.d-hosting.de/wp-content/uploads/2016/06/KOBRA-1.png\" alt=\"kobra\" width=\"380\" height=\"191\" />Wofür ist das gut? </strong>\n<ul>\n 	<li>entwickelt die Brustmuskulatur</li>\n 	<li>hilft bei Bandscheibenschäden</li>\n 	<li>stärkt Bauch- und Rückenmuskulatur\'</li>\n 	<li>festigt und reduziert das Gesäß</li>\n 	<li>stärkt das Nerversystem</li>\n 	<li>fördert die Verdauung</li>\n 	<li>lindert Unterleibsbeschwerden</li>\n 	<li>festigt die Kinngegend</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\n 	<li>Zweimal wiederholen.</li>\n 	<li>Während der Übung normal atmen.</li>\n</ol>", "kobra", "", "inherit", "closed", "closed", "", "275-autosave-v1", "", "", "2016-07-01 16:18:25", "2016-07-01 14:18:25", "", "275", "http://student11.wpstore.d-hosting.de/275-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("435", "1", "2016-07-01 21:02:13", "2016-07-01 19:02:13", "Christine Dreßler\r\n\r\nBerlin", "impressum", "", "inherit", "closed", "closed", "", "18-revision-v1", "", "", "2016-07-01 21:02:13", "2016-07-01 19:02:13", "", "18", "http://student11.wpstore.d-hosting.de/18-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("436", "1", "2016-07-01 21:02:20", "2016-07-01 19:02:20", "Christine Dreßler\r\n\r\nBerlin", "impressum", "", "inherit", "closed", "closed", "", "18-autosave-v1", "", "", "2016-07-01 21:02:20", "2016-07-01 19:02:20", "", "18", "http://student11.wpstore.d-hosting.de/18-autosave-v1/", "0", "revision", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("30", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("30", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("30", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("32", "7", "0");
INSERT INTO `wp_term_relationships` VALUES("32", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("32", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("69", "10", "0");
INSERT INTO `wp_term_relationships` VALUES("69", "11", "0");
INSERT INTO `wp_term_relationships` VALUES("69", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("157", "13", "0");
INSERT INTO `wp_term_relationships` VALUES("157", "14", "0");
INSERT INTO `wp_term_relationships` VALUES("157", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("157", "16", "0");
INSERT INTO `wp_term_relationships` VALUES("164", "17", "0");
INSERT INTO `wp_term_relationships` VALUES("164", "18", "0");
INSERT INTO `wp_term_relationships` VALUES("164", "19", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "7", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "16", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "17", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "18", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "20", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "22", "0");
INSERT INTO `wp_term_relationships` VALUES("189", "23", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "13", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "24", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "25", "0");
INSERT INTO `wp_term_relationships` VALUES("209", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("210", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("214", "26", "0");
INSERT INTO `wp_term_relationships` VALUES("215", "26", "0");
INSERT INTO `wp_term_relationships` VALUES("216", "26", "0");
INSERT INTO `wp_term_relationships` VALUES("217", "26", "0");
INSERT INTO `wp_term_relationships` VALUES("218", "26", "0");
INSERT INTO `wp_term_relationships` VALUES("248", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("248", "13", "0");
INSERT INTO `wp_term_relationships` VALUES("248", "16", "0");
INSERT INTO `wp_term_relationships` VALUES("248", "17", "0");
INSERT INTO `wp_term_relationships` VALUES("248", "20", "0");
INSERT INTO `wp_term_relationships` VALUES("259", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("259", "15", "0");
INSERT INTO `wp_term_relationships` VALUES("259", "20", "0");
INSERT INTO `wp_term_relationships` VALUES("259", "28", "0");
INSERT INTO `wp_term_relationships` VALUES("264", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("264", "29", "0");
INSERT INTO `wp_term_relationships` VALUES("264", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("264", "31", "0");
INSERT INTO `wp_term_relationships` VALUES("264", "32", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "7", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "13", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "16", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "20", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "24", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "25", "0");
INSERT INTO `wp_term_relationships` VALUES("269", "31", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "7", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "18", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "19", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "36", "0");
INSERT INTO `wp_term_relationships` VALUES("275", "37", "0");
INSERT INTO `wp_term_relationships` VALUES("279", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("279", "33", "0");
INSERT INTO `wp_term_relationships` VALUES("279", "34", "0");
INSERT INTO `wp_term_relationships` VALUES("285", "11", "0");
INSERT INTO `wp_term_relationships` VALUES("285", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("285", "33", "0");
INSERT INTO `wp_term_relationships` VALUES("285", "34", "0");
INSERT INTO `wp_term_relationships` VALUES("285", "36", "0");
INSERT INTO `wp_term_relationships` VALUES("285", "38", "0");
INSERT INTO `wp_term_relationships` VALUES("290", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("290", "16", "0");
INSERT INTO `wp_term_relationships` VALUES("290", "39", "0");
INSERT INTO `wp_term_relationships` VALUES("296", "20", "0");
INSERT INTO `wp_term_relationships` VALUES("296", "22", "0");
INSERT INTO `wp_term_relationships` VALUES("296", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("296", "34", "0");
INSERT INTO `wp_term_relationships` VALUES("296", "40", "0");
INSERT INTO `wp_term_relationships` VALUES("296", "41", "0");
INSERT INTO `wp_term_relationships` VALUES("301", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("303", "29", "0");
INSERT INTO `wp_term_relationships` VALUES("303", "32", "0");
INSERT INTO `wp_term_relationships` VALUES("311", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("311", "13", "0");
INSERT INTO `wp_term_relationships` VALUES("311", "24", "0");
INSERT INTO `wp_term_relationships` VALUES("311", "31", "0");
INSERT INTO `wp_term_relationships` VALUES("311", "34", "0");
INSERT INTO `wp_term_relationships` VALUES("362", "26", "0");
INSERT INTO `wp_term_relationships` VALUES("387", "42", "0");
INSERT INTO `wp_term_relationships` VALUES("388", "42", "0");
INSERT INTO `wp_term_relationships` VALUES("389", "42", "0");
INSERT INTO `wp_term_relationships` VALUES("390", "42", "0");
INSERT INTO `wp_term_relationships` VALUES("391", "42", "0");
INSERT INTO `wp_term_relationships` VALUES("392", "42", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "nav_menu", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("3", "3", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("6", "6", "category", "", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("7", "7", "category", "", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("8", "8", "category", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("9", "9", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("10", "10", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("11", "11", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("12", "12", "category", "", "0", "7");
INSERT INTO `wp_term_taxonomy` VALUES("13", "13", "category", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("14", "14", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("15", "15", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("16", "16", "category", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("17", "17", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("18", "18", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("19", "19", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("20", "20", "category", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("21", "21", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("22", "22", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("23", "23", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("24", "24", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("25", "25", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("26", "26", "nav_menu", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("27", "27", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("28", "28", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("29", "29", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("30", "30", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("31", "31", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("32", "32", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("33", "33", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("34", "34", "category", "", "0", "4");
INSERT INTO `wp_term_taxonomy` VALUES("35", "35", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("36", "36", "category", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("37", "37", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("38", "38", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("39", "39", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("40", "40", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("41", "41", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("42", "42", "nav_menu", "", "0", "6");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Allgemein", "allgemein", "0");
INSERT INTO `wp_terms` VALUES("2", "impressum", "impressum", "0");
INSERT INTO `wp_terms` VALUES("3", "Schulter", "schulter", "0");
INSERT INTO `wp_terms` VALUES("4", "Unterarme", "unterarme", "0");
INSERT INTO `wp_terms` VALUES("6", "Brustmuskulatur", "brustmuskulatur", "0");
INSERT INTO `wp_terms` VALUES("7", "Rücken", "ruecken", "0");
INSERT INTO `wp_terms` VALUES("8", "Bauchmuskulatur", "bauchmuskulatur", "0");
INSERT INTO `wp_terms` VALUES("9", "Gesäß", "gesaess", "0");
INSERT INTO `wp_terms` VALUES("10", "Augen", "augen", "0");
INSERT INTO `wp_terms` VALUES("11", "Kopfschmerzen", "kopfschmerzen", "0");
INSERT INTO `wp_terms` VALUES("12", "Entspannung", "entspannung", "0");
INSERT INTO `wp_terms` VALUES("13", "Durchblutung", "durchblutung", "0");
INSERT INTO `wp_terms` VALUES("14", "Gleichgewicht", "gleichgewicht", "0");
INSERT INTO `wp_terms` VALUES("15", "Körperhaltung", "koerperhaltung", "0");
INSERT INTO `wp_terms` VALUES("16", "Beinmuskulatur", "beinmuskulatur", "0");
INSERT INTO `wp_terms` VALUES("17", "Fettpolster abbauen", "fettpolster-abbauen", "0");
INSERT INTO `wp_terms` VALUES("18", "Verdauung", "verdauung", "0");
INSERT INTO `wp_terms` VALUES("19", "Unterleibsorgane", "unterleibsorgane", "0");
INSERT INTO `wp_terms` VALUES("20", "Wirbelsäule", "wirbelsaeule", "0");
INSERT INTO `wp_terms` VALUES("21", "Bandscheiben", "bandscheiben", "0");
INSERT INTO `wp_terms` VALUES("22", "Hüfte", "huefte", "0");
INSERT INTO `wp_terms` VALUES("23", "Arme", "arme", "0");
INSERT INTO `wp_terms` VALUES("24", "Kopf", "kopf", "0");
INSERT INTO `wp_terms` VALUES("25", "Nacken", "nacken", "0");
INSERT INTO `wp_terms` VALUES("26", "mein menü", "mein-menue", "0");
INSERT INTO `wp_terms` VALUES("27", "Oberarme", "oberarme", "0");
INSERT INTO `wp_terms` VALUES("28", "Brustkorb", "brustkorb", "0");
INSERT INTO `wp_terms` VALUES("29", "Fuß", "fuss", "0");
INSERT INTO `wp_terms` VALUES("30", "Schenkel", "schenkel", "0");
INSERT INTO `wp_terms` VALUES("31", "Krampfadern", "krampfadern", "0");
INSERT INTO `wp_terms` VALUES("32", "Kniegelenke", "kniegelenke", "0");
INSERT INTO `wp_terms` VALUES("33", "Schlaflosigkeit", "schlaflosigkeit", "0");
INSERT INTO `wp_terms` VALUES("34", "Energie", "energie", "0");
INSERT INTO `wp_terms` VALUES("35", "Kreislauf", "kreislauf", "0");
INSERT INTO `wp_terms` VALUES("36", "Kinn", "kinn", "0");
INSERT INTO `wp_terms` VALUES("37", "Nervensystem", "nervensystem", "0");
INSERT INTO `wp_terms` VALUES("38", "Hals", "hals", "0");
INSERT INTO `wp_terms` VALUES("39", "Blase", "blase", "0");
INSERT INTO `wp_terms` VALUES("40", "Bauchorgane", "bauchorgane", "0");
INSERT INTO `wp_terms` VALUES("41", "Schilddrüse", "schilddruese", "0");
INSERT INTO `wp_terms` VALUES("42", "main neu", "main-neu", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "christine");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("9", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("10", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("11", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("12", "1", "dismissed_wp_pointers", "");
INSERT INTO `wp_usermeta` VALUES("13", "1", "show_welcome_panel", "1");
INSERT INTO `wp_usermeta` VALUES("15", "1", "wp_dashboard_quick_press_last_post_id", "229");
INSERT INTO `wp_usermeta` VALUES("16", "1", "wp_user-settings", "libraryContent=browse&hidetb=1&editor_plain_text_paste_warning=2&imgsize=full&editor=tinymce&cats=pop");
INSERT INTO `wp_usermeta` VALUES("17", "1", "wp_user-settings-time", "1467382778");
INSERT INTO `wp_usermeta` VALUES("18", "1", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO `wp_usermeta` VALUES("19", "1", "metaboxhidden_nav-menus", "a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}");
INSERT INTO `wp_usermeta` VALUES("20", "1", "nav_menu_recently_edited", "26");
INSERT INTO `wp_usermeta` VALUES("22", "1", "meta-box-order_page", "a:3:{s:4:\"side\";s:36:\"submitdiv,pageparentdiv,postimagediv\";s:6:\"normal\";s:70:\"revisionsdiv,postcustom,commentstatusdiv,commentsdiv,slugdiv,authordiv\";s:8:\"advanced\";s:0:\"\";}");
INSERT INTO `wp_usermeta` VALUES("23", "1", "screen_layout_page", "2");
INSERT INTO `wp_usermeta` VALUES("24", "1", "closedpostboxes_page", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("25", "1", "metaboxhidden_page", "a:6:{i:0;s:12:\"revisionsdiv\";i:1;s:10:\"postcustom\";i:2;s:16:\"commentstatusdiv\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}");
INSERT INTO `wp_usermeta` VALUES("26", "1", "session_tokens", "a:6:{s:64:\"d06af242cbfa55c72286e4a61cd5ffd84656cf287b4cf57fab7791d73f481ac4\";a:4:{s:10:\"expiration\";i:1467459133;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:47.0) Gecko/20100101 Firefox/47.0\";s:5:\"login\";i:1467286333;}s:64:\"4dcd2349db2c82ff61d49cc34954db9a2d0733820e27fa3e406fedcbc58f2ad5\";a:4:{s:10:\"expiration\";i:1467471560;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:47.0) Gecko/20100101 Firefox/47.0\";s:5:\"login\";i:1467298760;}s:64:\"c38a3ddc4859b04e0b34dd6beff2d270067ba654106ee193fb3636307cec6d3b\";a:4:{s:10:\"expiration\";i:1467526299;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:47.0) Gecko/20100101 Firefox/47.0\";s:5:\"login\";i:1467353499;}s:64:\"b848819217c618d53a7ffa229a2e210dac5f4f93dacaff75efd15a15bc408357\";a:4:{s:10:\"expiration\";i:1467531685;s:2:\"ip\";s:13:\"217.92.200.52\";s:2:\"ua\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:47.0) Gecko/20100101 Firefox/47.0\";s:5:\"login\";i:1467358885;}s:64:\"bd02e3f9f918bf46f811241535ba35eb966399d5db9dc75b8f05890ee98651cf\";a:4:{s:10:\"expiration\";i:1467572469;s:2:\"ip\";s:14:\"92.230.121.173\";s:2:\"ua\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:47.0) Gecko/20100101 Firefox/47.0\";s:5:\"login\";i:1467399669;}s:64:\"cdc129d013eb471840449d0417c94fc594b8027d6728a240781fa71d7935f910\";a:4:{s:10:\"expiration\";i:1467622576;s:2:\"ip\";s:13:\"92.230.121.21\";s:2:\"ua\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:47.0) Gecko/20100101 Firefox/47.0\";s:5:\"login\";i:1467449776;}}");
INSERT INTO `wp_usermeta` VALUES("27", "1", "wp_yoast_notifications", "a:1:{i:0;a:2:{s:7:\"message\";s:236:\"Verliere nicht den Überblick über deine Suchmaschineneinträge und -fehler: <a href=\"http://student11.wpstore.d-hosting.de/wp-admin/admin.php?page=wpseo_search_console&tab=settings\">Verbinde Dich hier mit der Google-Such-Konsole: </a>\";s:7:\"options\";a:8:{s:4:\"type\";s:7:\"warning\";s:2:\"id\";s:17:\"wpseo-dismiss-gsc\";s:5:\"nonce\";N;s:8:\"priority\";d:0.5;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";s:14:\"manage_options\";s:16:\"capability_check\";s:3:\"all\";}}}");
INSERT INTO `wp_usermeta` VALUES("28", "1", "closedpostboxes_dashboard", "a:2:{i:0;s:18:\"dashboard_activity\";i:1;s:21:\"dashboard_quick_press\";}");
INSERT INTO `wp_usermeta` VALUES("29", "1", "metaboxhidden_dashboard", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("30", "1", "_yoast_wpseo_profile_updated", "1467270684");
INSERT INTO `wp_usermeta` VALUES("31", "1", "closedpostboxes_post", "a:1:{i:0;s:9:\"submitdiv\";}");
INSERT INTO `wp_usermeta` VALUES("32", "1", "metaboxhidden_post", "a:8:{i:0;s:12:\"revisionsdiv\";i:1;s:11:\"postexcerpt\";i:2;s:13:\"trackbacksdiv\";i:3;s:10:\"postcustom\";i:4;s:16:\"commentstatusdiv\";i:5;s:11:\"commentsdiv\";i:6;s:7:\"slugdiv\";i:7;s:9:\"authordiv\";}");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "christine", "$P$BxMOIxOSp4jRdsge3CpH.LLfNKoPmM0", "christine", "freefeeling@web.de", "", "2016-06-21 07:05:54", "", "0", "christine");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2016-07-02 08:58:20*/
/* DUPLICATOR_MYSQLDUMP_EOF */
