/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2017-08-26 06:01:36 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `slug` varchar(30) NOT NULL,
  `description` text NOT NULL,
  `thumbnail` longtext NOT NULL,
  `thumbwidth` int(11) DEFAULT NULL,
  `thumbheight` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery_images` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `imagePath` longtext NOT NULL,
  `title` varchar(50) NOT NULL,
  `description` longtext NOT NULL,
  `sortOrder` int(11) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gallery_albums` (
  `album_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `album_name` text,
  `author` varchar(100) DEFAULT NULL,
  `album_date` date DEFAULT NULL,
  `description` text,
  `album_order` int(10) DEFAULT NULL,
  PRIMARY KEY (`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master` (
  `gallery_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) DEFAULT NULL,
  `type` varchar(100) NOT NULL,
  `sorting_order` int(10) NOT NULL,
  PRIMARY KEY (`gallery_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master_licensing` (
  `licensing_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(10) NOT NULL,
  `type` varchar(100) NOT NULL,
  `url` text NOT NULL,
  `api_key` text,
  `order_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`licensing_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master_meta` (
  `gallery_meta_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gallery_id` int(10) NOT NULL,
  `gallery_meta_key` varchar(100) NOT NULL,
  `gallery_meta_value` longtext NOT NULL,
  PRIMARY KEY (`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_master_settings` (
  `setting_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_pics` (
  `pic_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `album_id` int(10) unsigned NOT NULL,
  `title` text,
  `description` text,
  `thumbnail_url` text NOT NULL,
  `sorting_order` int(20) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `video` int(10) NOT NULL,
  `tags` text,
  `pic_name` text NOT NULL,
  `album_cover` int(1) NOT NULL,
  PRIMARY KEY (`pic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_gallery_settings` (
  `setting_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `albumdesc` mediumtext COLLATE utf8mb4_unicode_ci,
  `sortorder` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` mediumtext COLLATE utf8mb4_unicode_ci,
  `title` mediumtext COLLATE utf8mb4_unicode_ci,
  `galdesc` mediumtext COLLATE utf8mb4_unicode_ci,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `author` bigint(20) NOT NULL DEFAULT '0',
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `galleryid` bigint(20) NOT NULL DEFAULT '0',
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `alttext` mediumtext COLLATE utf8mb4_unicode_ci,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT '0',
  `sortorder` bigint(20) NOT NULL DEFAULT '0',
  `meta_data` longtext COLLATE utf8mb4_unicode_ci,
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=13659 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2191 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1706 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=553 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "20160710_keepitshortandsimple", "5781e3a83a72a6670160710055656", "100", "2016-07-10 05:57:09", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-10 05:56:56\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:3;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"5781e3a83a72a6670160710055656\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_5781e3a83a72a6670160710055656\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_5781e3a83a72a6670160710055656_scan.json\";s:7:\"Runtime\";s:10:\"27.86 sec.\";s:7:\"ExeSize\";s:8:\"344.24KB\";s:7:\"ZipSize\";s:7:\"37.97MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_5781e3a83a72a6670160710055656_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:39812641;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_5781e3a83a72a6670160710055656_installer.php\";s:4:\"Size\";i:352498;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:792586;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_5781e3a83a72a6670160710055656_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_5781e3a83a72a6670160710055656_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("4", "20160710_keepitshortandsimple", "579dd81be0f8e9447160731105107", "100", "2016-07-31 10:51:29", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-07-31 10:51:07\";s:7:\"Version\";s:6:\"1.1.12\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.5.48\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:4;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"579dd81be0f8e9447160731105107\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_579dd81be0f8e9447160731105107\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_579dd81be0f8e9447160731105107_scan.json\";s:7:\"Runtime\";s:10:\"33.31 sec.\";s:7:\"ExeSize\";s:8:\"344.24KB\";s:7:\"ZipSize\";s:7:\"42.57MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_579dd81be0f8e9447160731105107_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:44633668;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_579dd81be0f8e9447160731105107_installer.php\";s:4:\"Size\";i:352498;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1824463;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_579dd81be0f8e9447160731105107_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_579dd81be0f8e9447160731105107_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("5", "20160710_keepitshortandsimple", "57bb513647fb04752160822192334", "100", "2016-08-22 19:23:59", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-08-22 19:23:34\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.6.31\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:5;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"57bb513647fb04752160822192334\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_57bb513647fb04752160822192334\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_57bb513647fb04752160822192334_scan.json\";s:7:\"Runtime\";s:10:\"41.69 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"50.73MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_57bb513647fb04752160822192334_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:53198404;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_57bb513647fb04752160822192334_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3063169;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_57bb513647fb04752160822192334_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_57bb513647fb04752160822192334_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("6", "20160710_keepitshortandsimple", "57cb3819f0e509444160903205241", "100", "2016-09-03 20:53:01", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-09-03 20:52:41\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.3\";s:9:\"VersionDB\";s:6:\"5.6.31\";s:10:\"VersionPHP\";s:6:\"5.6.22\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:6;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"57cb3819f0e509444160903205241\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_57cb3819f0e509444160903205241\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_57cb3819f0e509444160903205241_scan.json\";s:7:\"Runtime\";s:10:\"36.44 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:6:\"55.3MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_57cb3819f0e509444160903205241_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:57988856;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_57cb3819f0e509444160903205241_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3588648;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_57cb3819f0e509444160903205241_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_57cb3819f0e509444160903205241_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("7", "20160710_keepitshortandsimple", "57dd4f3de40529562160917141213", "100", "2016-09-17 14:12:37", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-09-17 14:12:13\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.31\";s:10:\"VersionPHP\";s:6:\"5.6.25\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:7;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"57dd4f3de40529562160917141213\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_57dd4f3de40529562160917141213\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_57dd4f3de40529562160917141213_scan.json\";s:7:\"Runtime\";s:10:\"46.36 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"55.57MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_57dd4f3de40529562160917141213_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:58272366;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_57dd4f3de40529562160917141213_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4148473;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_57dd4f3de40529562160917141213_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_57dd4f3de40529562160917141213_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("8", "20160710_keepitshortandsimple", "57e12c65f32b63278160920123237", "100", "2016-09-20 12:33:00", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-09-20 12:32:37\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.31\";s:10:\"VersionPHP\";s:6:\"5.6.25\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:8;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"57e12c65f32b63278160920123237\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_57e12c65f32b63278160920123237\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_57e12c65f32b63278160920123237_scan.json\";s:7:\"Runtime\";s:10:\"48.49 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"55.64MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_57e12c65f32b63278160920123237_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:58347811;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_57e12c65f32b63278160920123237_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4330668;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_57e12c65f32b63278160920123237_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_57e12c65f32b63278160920123237_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("9", "20160710_keepitshortandsimple", "57faa012e2e089748161009195250", "100", "2016-10-09 19:53:11", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-10-09 19:52:50\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.31\";s:10:\"VersionPHP\";s:6:\"5.6.26\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:9;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"57faa012e2e089748161009195250\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_57faa012e2e089748161009195250\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_57faa012e2e089748161009195250_scan.json\";s:7:\"Runtime\";s:10:\"47.04 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:4:\"57MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_57faa012e2e089748161009195250_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:59770189;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_57faa012e2e089748161009195250_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4756131;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_57faa012e2e089748161009195250_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_57faa012e2e089748161009195250_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("10", "20160710_keepitshortandsimple", "580b38584e3d15331161022095848", "100", "2016-10-22 09:59:08", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-10-22 09:58:48\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.31\";s:10:\"VersionPHP\";s:6:\"5.6.26\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:10;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"580b38584e3d15331161022095848\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_580b38584e3d15331161022095848\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_580b38584e3d15331161022095848_scan.json\";s:7:\"Runtime\";s:10:\"40.92 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"57.68MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_580b38584e3d15331161022095848_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:60479651;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_580b38584e3d15331161022095848_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:5348683;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_580b38584e3d15331161022095848_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_580b38584e3d15331161022095848_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("11", "20160710_keepitshortandsimple", "58288cfe480008652161113155542", "100", "2016-11-13 15:56:02", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-13 15:55:42\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.33\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:11;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"58288cfe480008652161113155542\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_58288cfe480008652161113155542\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_58288cfe480008652161113155542_scan.json\";s:7:\"Runtime\";s:10:\"42.83 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"60.95MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_58288cfe480008652161113155542_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:63915276;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_58288cfe480008652161113155542_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:6435238;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_58288cfe480008652161113155542_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_58288cfe480008652161113155542_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("12", "20160710_keepitshortandsimple", "583aa4d96c60b9924161127091817", "100", "2016-11-27 09:18:52", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-27 09:18:17\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.33\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:12;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"583aa4d96c60b9924161127091817\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_583aa4d96c60b9924161127091817\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_583aa4d96c60b9924161127091817_scan.json\";s:7:\"Runtime\";s:10:\"52.30 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"61.93MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_583aa4d96c60b9924161127091817_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:64933778;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_583aa4d96c60b9924161127091817_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7602686;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_583aa4d96c60b9924161127091817_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_583aa4d96c60b9924161127091817_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("13", "20160710_keepitshortandsimple", "5853b65c9c0c88255161216093940", "100", "2016-12-16 09:40:04", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-12-16 09:39:40\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.34\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:13;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"5853b65c9c0c88255161216093940\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_5853b65c9c0c88255161216093940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_5853b65c9c0c88255161216093940_scan.json\";s:7:\"Runtime\";s:10:\"49.92 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"62.98MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_5853b65c9c0c88255161216093940_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:66034565;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_5853b65c9c0c88255161216093940_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:8507907;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_5853b65c9c0c88255161216093940_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_5853b65c9c0c88255161216093940_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("14", "20160710_keepitshortandsimple", "5858ee9fe33578500161220084103", "100", "2016-12-20 08:41:27", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-12-20 08:41:03\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:14;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"5858ee9fe33578500161220084103\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_5858ee9fe33578500161220084103\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_5858ee9fe33578500161220084103_scan.json\";s:7:\"Runtime\";s:10:\"50.52 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"71.32MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_5858ee9fe33578500161220084103_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:74784919;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_5858ee9fe33578500161220084103_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:9605155;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_5858ee9fe33578500161220084103_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_5858ee9fe33578500161220084103_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("15", "20160710_keepitshortandsimple", "58680d63d41f65067161231195619", "100", "2016-12-31 19:56:40", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-12-31 19:56:19\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.4\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:15;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"58680d63d41f65067161231195619\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_58680d63d41f65067161231195619\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_58680d63d41f65067161231195619_scan.json\";s:7:\"Runtime\";s:10:\"44.58 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"72.12MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_58680d63d41f65067161231195619_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:75623834;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_58680d63d41f65067161231195619_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10727818;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_58680d63d41f65067161231195619_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_58680d63d41f65067161231195619_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("16", "20160710_keepitshortandsimple", "587a6eee02ee52444170114183318", "100", "2017-01-14 18:33:46", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-14 18:33:18\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.5\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:16;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"587a6eee02ee52444170114183318\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_587a6eee02ee52444170114183318\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_587a6eee02ee52444170114183318_scan.json\";s:7:\"Runtime\";s:10:\"53.60 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"72.12MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_587a6eee02ee52444170114183318_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:75627684;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_587a6eee02ee52444170114183318_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10747920;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_587a6eee02ee52444170114183318_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_587a6eee02ee52444170114183318_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("17", "20160710_keepitshortandsimple", "587f1353297eb2055170118070347", "100", "2017-01-18 07:04:09", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-18 07:03:47\";s:7:\"Version\";s:6:\"1.1.14\";s:9:\"VersionWP\";s:5:\"4.5.5\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.27\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:17;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"587f1353297eb2055170118070347\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_587f1353297eb2055170118070347\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_587f1353297eb2055170118070347_scan.json\";s:7:\"Runtime\";s:10:\"47.67 sec.\";s:7:\"ExeSize\";s:8:\"346.04KB\";s:7:\"ZipSize\";s:7:\"72.13MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_587f1353297eb2055170118070347_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:75630416;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_587f1353297eb2055170118070347_installer.php\";s:4:\"Size\";i:354343;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10792155;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_587f1353297eb2055170118070347_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_587f1353297eb2055170118070347_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("19", "20160710_keepitshortandsimple", "5898dfc0bbb898706170206204240", "100", "2017-02-06 20:43:03", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-06 20:42:40\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:19;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"5898dfc0bbb898706170206204240\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_5898dfc0bbb898706170206204240\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_5898dfc0bbb898706170206204240_scan.json\";s:7:\"Runtime\";s:10:\"48.24 sec.\";s:7:\"ExeSize\";s:8:\"383.03KB\";s:7:\"ZipSize\";s:7:\"76.66MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_5898dfc0bbb898706170206204240_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:80379232;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_5898dfc0bbb898706170206204240_installer.php\";s:4:\"Size\";i:392225;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10916423;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_5898dfc0bbb898706170206204240_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_5898dfc0bbb898706170206204240_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("20", "20160710_keepitshortandsimple", "58b17294e04bf4652170225120332", "100", "2017-02-25 12:03:49", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-25 12:03:32\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:20;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"58b17294e04bf4652170225120332\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_58b17294e04bf4652170225120332\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_58b17294e04bf4652170225120332_scan.json\";s:7:\"Runtime\";s:10:\"52.89 sec.\";s:7:\"ExeSize\";s:8:\"383.03KB\";s:7:\"ZipSize\";s:7:\"77.31MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_58b17294e04bf4652170225120332_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:81060648;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_58b17294e04bf4652170225120332_installer.php\";s:4:\"Size\";i:392225;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:11062625;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_58b17294e04bf4652170225120332_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_58b17294e04bf4652170225120332_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("21", "20160710_keepitshortandsimple", "58cacd06c60e87281170316173606", "100", "2017-03-16 17:36:41", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-16 17:36:06\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.3\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:21;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:29:\"58cacd06c60e87281170316173606\";s:8:\"NameHash\";s:59:\"20160710_keepitshortandsimple_58cacd06c60e87281170316173606\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20160710_keepitshortandsimple_58cacd06c60e87281170316173606_scan.json\";s:7:\"Runtime\";s:10:\"59.15 sec.\";s:7:\"ExeSize\";s:8:\"383.03KB\";s:7:\"ZipSize\";s:4:\"79MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:71:\"20160710_keepitshortandsimple_58cacd06c60e87281170316173606_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:82837402;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:73:\"20160710_keepitshortandsimple_58cacd06c60e87281170316173606_installer.php\";s:4:\"Size\";i:392225;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:11464448;s:4:\"File\";s:72:\"20160710_keepitshortandsimple_58cacd06c60e87281170316173606_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:123:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_58cacd06c60e87281170316173606_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("22", "20160710_keepitshortandsimple", "1e07db9d4bdfbfcf2548170422200343", "100", "2017-04-22 20:04:13", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-04-22 20:03:43\";s:7:\"Version\";s:5:\"1.2.4\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:22;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"1e07db9d4bdfbfcf2548170422200343\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_1e07db9d4bdfbfcf2548170422200343\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_1e07db9d4bdfbfcf2548170422200343_scan.json\";s:7:\"Runtime\";s:10:\"46.36 sec.\";s:7:\"ExeSize\";s:8:\"419.63KB\";s:7:\"ZipSize\";s:7:\"80.95MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_1e07db9d4bdfbfcf2548170422200343_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:84881266;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_1e07db9d4bdfbfcf2548170422200343_installer.php\";s:4:\"Size\";i:429700;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12330679;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_1e07db9d4bdfbfcf2548170422200343_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_1e07db9d4bdfbfcf2548170422200343_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("23", "20160710_keepitshortandsimple", "44277f316f782b1e6150170516122937", "100", "2017-05-16 12:30:04", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-05-16 12:29:37\";s:7:\"Version\";s:5:\"1.2.4\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:23;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"44277f316f782b1e6150170516122937\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_44277f316f782b1e6150170516122937\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_44277f316f782b1e6150170516122937_scan.json\";s:7:\"Runtime\";s:10:\"66.77 sec.\";s:7:\"ExeSize\";s:8:\"419.63KB\";s:7:\"ZipSize\";s:7:\"84.27MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_44277f316f782b1e6150170516122937_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:88365736;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_44277f316f782b1e6150170516122937_installer.php\";s:4:\"Size\";i:429700;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:15015272;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_44277f316f782b1e6150170516122937_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_44277f316f782b1e6150170516122937_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("24", "20160710_keepitshortandsimple", "3d2fd2a98f2267cd7207170606165525", "100", "2017-06-06 16:55:50", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-06-06 16:55:25\";s:7:\"Version\";s:5:\"1.2.8\";s:9:\"VersionWP\";s:5:\"4.7.5\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:24;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"3d2fd2a98f2267cd7207170606165525\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_3d2fd2a98f2267cd7207170606165525\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_3d2fd2a98f2267cd7207170606165525_scan.json\";s:7:\"Runtime\";s:10:\"77.43 sec.\";s:7:\"ExeSize\";s:8:\"428.47KB\";s:7:\"ZipSize\";s:7:\"88.24MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":14:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_3d2fd2a98f2267cd7207170606165525_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:92529209;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_3d2fd2a98f2267cd7207170606165525_installer.php\";s:4:\"Size\";i:438754;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:17819700;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_3d2fd2a98f2267cd7207170606165525_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_3d2fd2a98f2267cd7207170606165525_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("25", "20160710_keepitshortandsimple", "6a6896c0f388528e6337170705185726", "100", "2017-07-05 18:58:18", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-07-05 18:57:26\";s:7:\"Version\";s:5:\"1.2.8\";s:9:\"VersionWP\";s:5:\"4.7.5\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.30\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:25;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"6a6896c0f388528e6337170705185726\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_6a6896c0f388528e6337170705185726\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_6a6896c0f388528e6337170705185726_scan.json\";s:7:\"Runtime\";s:10:\"60.47 sec.\";s:7:\"ExeSize\";s:8:\"428.47KB\";s:7:\"ZipSize\";s:7:\"65.04MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":14:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_6a6896c0f388528e6337170705185726_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:68203512;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_6a6896c0f388528e6337170705185726_installer.php\";s:4:\"Size\";i:438754;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:18926519;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_6a6896c0f388528e6337170705185726_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_6a6896c0f388528e6337170705185726_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("26", "20160710_keepitshortandsimple", "379f51b29c1d17df3599170726100211", "40", "2017-07-26 10:02:47", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-07-26 10:02:11\";s:7:\"Version\";s:5:\"1.2.8\";s:9:\"VersionWP\";s:5:\"4.7.5\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:26;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"379f51b29c1d17df3599170726100211\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":14:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-07-26 10:02:11\";s:7:\"Version\";s:5:\"1.2.8\";s:9:\"VersionWP\";s:5:\"4.7.5\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";N;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"379f51b29c1d17df3599170726100211\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";r:54;s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:20862472;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_379f51b29c1d17df3599170726100211_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}}s:8:\"Database\";r:89;}");
INSERT INTO `wp_duplicator_packages` VALUES("27", "20160710_keepitshortandsimple", "138cf0b97a4d5e9e6010170726100850", "100", "2017-07-26 10:09:03", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-07-26 10:08:50\";s:7:\"Version\";s:5:\"1.2.8\";s:9:\"VersionWP\";s:5:\"4.7.5\";s:9:\"VersionDB\";s:6:\"5.6.36\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:27;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"138cf0b97a4d5e9e6010170726100850\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_138cf0b97a4d5e9e6010170726100850\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_138cf0b97a4d5e9e6010170726100850_scan.json\";s:7:\"Runtime\";s:10:\"51.96 sec.\";s:7:\"ExeSize\";s:8:\"428.47KB\";s:7:\"ZipSize\";s:7:\"92.69MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":14:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_138cf0b97a4d5e9e6010170726100850_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:97188292;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_138cf0b97a4d5e9e6010170726100850_installer.php\";s:4:\"Size\";i:438754;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:20867021;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_138cf0b97a4d5e9e6010170726100850_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:126:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp/20160710_keepitshortandsimple_138cf0b97a4d5e9e6010170726100850_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}");
INSERT INTO `wp_duplicator_packages` VALUES("28", "20160710_keepitshortandsimple", "0bf7643d43d794ce9410170826060100", "20", "2017-08-26 06:01:36", "christine", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-08-26 06:01:00\";s:7:\"Version\";s:6:\"1.2.20\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";i:28;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"0bf7643d43d794ce9410170826060100\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:9:\"christine\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-08-26 06:01:00\";s:7:\"Version\";s:6:\"1.2.20\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";N;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"0bf7643d43d794ce9410170826060100\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:76:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:57;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:75:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:42:\"/mnt/web004/d3/73/57460273/htdocs/wp-admin\";i:1;s:52:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/uploads\";i:2;s:54:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/languages\";i:3;s:52:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/plugins\";i:4;s:51:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/themes\";i:5;s:45:\"/mnt/web004/d3/73/57460273/htdocs/wp-includes\";}}s:9:\"Installer\";r:79;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_gallery_master_licensing */
INSERT INTO `wp_gallery_master_licensing` VALUES("1", "1.0", "Gallery Master", "http://keep-it-short-and-simple.de", NULL, NULL);

/* INSERT TABLE DATA: wp_gallery_settings */
INSERT INTO `wp_gallery_settings` VALUES("1", "thumbnails_custom_enable", "1");
INSERT INTO `wp_gallery_settings` VALUES("2", "thumbnails_width", "160");
INSERT INTO `wp_gallery_settings` VALUES("3", "thumbnails_height", "120");
INSERT INTO `wp_gallery_settings` VALUES("4", "thumbnails_opacity", "1");
INSERT INTO `wp_gallery_settings` VALUES("5", "thumbnails_border_size", "2");
INSERT INTO `wp_gallery_settings` VALUES("6", "thumbnails_border_radius", "2");
INSERT INTO `wp_gallery_settings` VALUES("7", "thumbnails_border_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("8", "margin_btw_thumbnails", "5");
INSERT INTO `wp_gallery_settings` VALUES("9", "thumbnail_text_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("10", "thumbnail_text_align", "center");
INSERT INTO `wp_gallery_settings` VALUES("11", "thumbnail_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("12", "heading_font_size", "16");
INSERT INTO `wp_gallery_settings` VALUES("13", "text_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("14", "thumbnail_desc_length", "60");
INSERT INTO `wp_gallery_settings` VALUES("15", "cover_custom_enable", "1");
INSERT INTO `wp_gallery_settings` VALUES("16", "cover_thumbnail_width", "160");
INSERT INTO `wp_gallery_settings` VALUES("17", "cover_thumbnail_height", "120");
INSERT INTO `wp_gallery_settings` VALUES("18", "cover_thumbnail_opacity", "1");
INSERT INTO `wp_gallery_settings` VALUES("19", "cover_thumbnail_border_size", "2");
INSERT INTO `wp_gallery_settings` VALUES("20", "cover_thumbnail_border_radius", "2");
INSERT INTO `wp_gallery_settings` VALUES("21", "cover_thumbnail_border_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("22", "margin_btw_cover_thumbnails", "5");
INSERT INTO `wp_gallery_settings` VALUES("23", "album_text_align", "left");
INSERT INTO `wp_gallery_settings` VALUES("24", "album_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("25", "album_heading_font_size", "16");
INSERT INTO `wp_gallery_settings` VALUES("26", "album_text_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("27", "album_desc_length", "400");
INSERT INTO `wp_gallery_settings` VALUES("28", "lightbox_type", "pretty_photo");
INSERT INTO `wp_gallery_settings` VALUES("29", "lightbox_overlay_opacity", "0.6");
INSERT INTO `wp_gallery_settings` VALUES("30", "lightbox_overlay_border_size", "5");
INSERT INTO `wp_gallery_settings` VALUES("31", "lightbox_overlay_border_radius", "5");
INSERT INTO `wp_gallery_settings` VALUES("32", "lightbox_text_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("33", "lightbox_overlay_border_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("34", "lightbox_inline_bg_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("35", "lightbox_overlay_bg_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("36", "lightbox_fade_in_time", "500");
INSERT INTO `wp_gallery_settings` VALUES("37", "lightbox_fade_out_time", "500");
INSERT INTO `wp_gallery_settings` VALUES("38", "lightbox_text_align", "left");
INSERT INTO `wp_gallery_settings` VALUES("39", "lightbox_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("40", "lightbox_heading_font_size", "16");
INSERT INTO `wp_gallery_settings` VALUES("41", "lightbox_text_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("42", "facebook_comments", "0");
INSERT INTO `wp_gallery_settings` VALUES("43", "social_sharing", "0");
INSERT INTO `wp_gallery_settings` VALUES("44", "image_title_setting", "1");
INSERT INTO `wp_gallery_settings` VALUES("45", "image_desc_setting", "1");
INSERT INTO `wp_gallery_settings` VALUES("46", "autoplay_setting", "0");
INSERT INTO `wp_gallery_settings` VALUES("47", "slide_interval", "5");
INSERT INTO `wp_gallery_settings` VALUES("48", "pagination_setting", "0");
INSERT INTO `wp_gallery_settings` VALUES("49", "images_per_page", "10");
INSERT INTO `wp_gallery_settings` VALUES("50", "filters_setting", "0");
INSERT INTO `wp_gallery_settings` VALUES("51", "filter_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("52", "filter_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("53", "back_button_text", "Back to Albums");
INSERT INTO `wp_gallery_settings` VALUES("54", "album_click_text", "Click to View Album");
INSERT INTO `wp_gallery_settings` VALUES("55", "album_text_color", "#C0C0C0");
INSERT INTO `wp_gallery_settings` VALUES("56", "button_color", "#000000");
INSERT INTO `wp_gallery_settings` VALUES("57", "button_text_color", "#CCCCCC");
INSERT INTO `wp_gallery_settings` VALUES("58", "filters_color", "#2a83ed");
INSERT INTO `wp_gallery_settings` VALUES("59", "filters_text_color", "#ffffff");
INSERT INTO `wp_gallery_settings` VALUES("60", "album_seperator", "1");
INSERT INTO `wp_gallery_settings` VALUES("61", "back_button_font_family", "Verdana");
INSERT INTO `wp_gallery_settings` VALUES("62", "back_button_font_size", "12");
INSERT INTO `wp_gallery_settings` VALUES("63", "admin_full_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("64", "admin_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("65", "admin_write_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("66", "editor_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("67", "editor_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("68", "editor_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("69", "author_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("70", "author_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("71", "author_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("72", "contributor_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("73", "contributor_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("74", "contributor_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("75", "subscriber_full_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("76", "subscriber_read_control", "1");
INSERT INTO `wp_gallery_settings` VALUES("77", "subscriber_write_control", "0");
INSERT INTO `wp_gallery_settings` VALUES("78", "language_direction", "inherit");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://keep-it-short-and-simple.de", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://keep-it-short-and-simple.de", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "keep it short and simple", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "christine.dressler@googlemail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j. F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j. F Y G:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/%20", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:110:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:86:\"4/U7LMDEXv0piq9mqKOESPbAhuci_RMe3w4F18DALRde8/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:81:\"4/U7LMDEXv0piq9mqKOESPbAhuci_RMe3w4F18DALRde8/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:62:\"4/U7LMDEXv0piq9mqKOESPbAhuci_RMe3w4F18DALRde8/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:74:\"4/U7LMDEXv0piq9mqKOESPbAhuci_RMe3w4F18DALRde8/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:56:\"4/U7LMDEXv0piq9mqKOESPbAhuci_RMe3w4F18DALRde8/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1189&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\"[^/]+/%20/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"[^/]+/%20/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"[^/]+/%20/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"[^/]+/%20/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"[^/]+/%20/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"[^/]+/%20/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"([^/]+)/%20/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:24:\"([^/]+)/%20/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:44:\"([^/]+)/%20/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:39:\"([^/]+)/%20/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:32:\"([^/]+)/%20/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:39:\"([^/]+)/%20/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:28:\"([^/]+)/%20(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:20:\"[^/]+/%20/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\"[^/]+/%20/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\"[^/]+/%20/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"[^/]+/%20/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"[^/]+/%20/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"[^/]+/%20/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:6:{i:0;s:29:\"antispam-bee/antispam_bee.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:37:\"onclick-scroll-to-top-button/init.php\";i:4;s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:82:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/plugins/antispam-bee/antispam_bee.php\";i:2;s:93:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/themes/tiny-framework/template-parts/content.php\";i:3;s:76:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/themes/tiny-framework/style.css\";i:4;s:77:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/themes/tiny-framework/footer.php\";i:5;s:74:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/themes/tiny-framework/404.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "tiny-framework", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "tiny-framework", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "/4/U7LMDEXv0piq9mqKOESPbAhuci_RMe3w4F18DALRde8", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:12:\"yogaübungen\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:3:{i:1;a:0:{}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:53:\"keep it short and simple © 2016. All Rights Reserved\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:3:{s:29:\"antispam-bee/antispam_bee.php\";a:2:{i:0;s:12:\"Antispam_Bee\";i:1;s:9:\"uninstall\";}s:29:\"gallery-bank/gallery-bank.php\";s:40:\"plugin_uninstall_script_for_gallery_bank\";s:33:\"gallery-master/gallery-master.php\";s:42:\"plugin_uninstall_script_for_gallery_master\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Europe/Berlin", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "12", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "1189", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "36686", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:72:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:24:\"NextGEN Gallery overview\";b:1;s:19:\"NextGEN Use TinyMCE\";b:1;s:21:\"NextGEN Upload images\";b:1;s:22:\"NextGEN Manage gallery\";b:1;s:19:\"NextGEN Manage tags\";b:1;s:29:\"NextGEN Manage others gallery\";b:1;s:18:\"NextGEN Edit album\";b:1;s:20:\"NextGEN Change style\";b:1;s:22:\"NextGEN Change options\";b:1;s:24:\"NextGEN Attach Interface\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "WPLANG", "de_DE", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:12:\"categories-2\";i:1;s:8:\"search-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:1:{i:0;s:6:\"text-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:6:{i:1503731155;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1503731198;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1503739808;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1503751559;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1504288693;a:1:{s:18:\"wpstg_weekly_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("126", "recently_activated", "a:1:{s:25:\"wp-staging/wp-staging.php\";i:1503683933;}", "yes");
INSERT INTO `wp_options` VALUES("127", "wpcf7", "a:2:{s:7:\"version\";s:3:\"4.9\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1466508362;s:7:\"version\";s:5:\"4.4.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("130", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1466501299;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("131", "current_theme", "Tiny Framework", "yes");
INSERT INTO `wp_options` VALUES("132", "theme_mods_tiny-forge", "a:9:{i:0;b:0;s:16:\"header_textcolor\";s:6:\"751cb5\";s:16:\"background_color\";s:6:\"e5e1f2\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:26;}s:12:\"header_image\";s:70:\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/head.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:114;s:3:\"url\";s:70:\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/head.jpg\";s:13:\"thumbnail_url\";s:70:\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/head.jpg\";s:6:\"height\";i:1428;s:5:\"width\";i:4288;}s:16:\"background_image\";s:0:\"\";s:14:\"notice-dismiss\";b:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467270684;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:12:\"categories-2\";i:1;s:8:\"search-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("133", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("141", "theme_mods_darkorange", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:26;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1467270585;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"primary\";a:2:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-2\";}s:8:\"homepage\";N;s:12:\"footer-right\";N;s:11:\"footer-left\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("142", "widget_hemingway_dribbble_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("143", "widget_hemingway_video_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("144", "theme_mods_sela", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1466504781;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";N;s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;s:9:\"sidebar-7\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("147", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:1:{i:0;i:26;}}", "yes");
INSERT INTO `wp_options` VALUES("159", "theme_mods_solon", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1466504843;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("209", "widget_sensiblewp_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("210", "widget_sensiblewp_video_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("241", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:33:\"christine.dressler@googlemail.com\";s:7:\"version\";s:5:\"4.7.5\";s:9:\"timestamp\";i:1494984201;}", "no");
INSERT INTO `wp_options` VALUES("295", "duplicator_version_plugin", "1.2.20", "yes");
INSERT INTO `wp_options` VALUES("334", "antispam_bee", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("473", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("474", "wpseo_sitemap_1_cache_validator", "5IXgu", "no");
INSERT INTO `wp_options` VALUES("475", "wpseo_sitemap_page_cache_validator", "5IXgx", "no");
INSERT INTO `wp_options` VALUES("476", "wpseo_sitemap_revision_cache_validator", "68XIl", "no");
INSERT INTO `wp_options` VALUES("511", "wpseo_sitemap_nav_menu_cache_validator", "5UGBF", "no");
INSERT INTO `wp_options` VALUES("512", "wpseo_sitemap_nav_menu_item_cache_validator", "5UGBH", "no");
INSERT INTO `wp_options` VALUES("522", "wpseo_sitemap_28_cache_validator", "2WHDQ", "no");
INSERT INTO `wp_options` VALUES("523", "wpseo_sitemap_29_cache_validator", "2WHE6", "no");
INSERT INTO `wp_options` VALUES("524", "wpseo_sitemap_87_cache_validator", "2WHEl", "no");
INSERT INTO `wp_options` VALUES("525", "wpseo_sitemap_22_cache_validator", "2WHEp", "no");
INSERT INTO `wp_options` VALUES("526", "wpseo_sitemap_19_cache_validator", "2WHEt", "no");
INSERT INTO `wp_options` VALUES("527", "wpseo_sitemap_137_cache_validator", "2WHEx", "no");
INSERT INTO `wp_options` VALUES("533", "wpseo_sitemap_wpcf7_contact_form_cache_validator", "2YyQA", "no");
INSERT INTO `wp_options` VALUES("548", "wpseo_sitemap_cache_validator_global", "5yM9C", "no");
INSERT INTO `wp_options` VALUES("551", "wpseo_sitemap_category_cache_validator", "3tQrp", "no");
INSERT INTO `wp_options` VALUES("556", "gallery-bank-updation-check-url", "http://tech-banker.com/wp-admin/admin-ajax.php", "yes");
INSERT INTO `wp_options` VALUES("557", "gallery-bank-pro-edition", "3.1", "yes");
INSERT INTO `wp_options` VALUES("558", "gallery-bank-automatic_update", "1", "yes");
INSERT INTO `wp_options` VALUES("562", "wpseo_sitemap_post_cache_validator", "67M6Q", "no");
INSERT INTO `wp_options` VALUES("574", "wpseo_sitemap_attachment_cache_validator", "68wDA", "no");
INSERT INTO `wp_options` VALUES("576", "gallery-master-updation-check-url", "http://tech-prodigy.org/wp-admin/admin-ajax.php", "yes");
INSERT INTO `wp_options` VALUES("577", "gallery-master-key", "1.0", "yes");
INSERT INTO `wp_options` VALUES("582", "easy_gallery_db_version", "1.1", "yes");
INSERT INTO `wp_options` VALUES("583", "wp_easy_gallery_defaults", "a:12:{s:7:\"version\";s:4:\"free\";s:15:\"thumbnail_width\";s:4:\"auto\";s:16:\"thumbnail_height\";s:4:\"auto\";s:12:\"hide_overlay\";s:5:\"false\";s:11:\"hide_social\";s:5:\"false\";s:12:\"custom_style\";s:0:\"\";s:17:\"use_default_style\";s:4:\"true\";s:11:\"drop_shadow\";s:4:\"true\";s:12:\"display_mode\";s:15:\"wp_easy_gallery\";s:11:\"num_columns\";i:3;s:17:\"show_gallery_name\";s:4:\"true\";s:22:\"gallery_name_alignment\";s:4:\"left\";}", "yes");
INSERT INTO `wp_options` VALUES("596", "widget_ngg-images", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("597", "widget_ngg-mrssw", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("598", "widget_slideshow", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("599", "ngg_transient_groups", "a:3:{s:9:\"__counter\";i:3;s:3:\"MVC\";a:2:{s:2:\"id\";i:2;s:7:\"enabled\";b:1;}s:15:\"col_in_wp_posts\";a:2:{s:2:\"id\";i:3;s:7:\"enabled\";b:1;}}", "yes");
INSERT INTO `wp_options` VALUES("600", "ngg_options", "a:69:{s:11:\"gallerypath\";s:19:\"wp-content/gallery/\";s:11:\"wpmuCSSfile\";s:13:\"nggallery.css\";s:9:\"wpmuStyle\";b:0;s:9:\"wpmuRoles\";b:0;s:16:\"wpmuImportFolder\";b:0;s:13:\"wpmuZipUpload\";b:0;s:14:\"wpmuQuotaCheck\";b:0;s:17:\"datamapper_driver\";s:22:\"custom_post_datamapper\";s:21:\"gallerystorage_driver\";s:25:\"ngglegacy_gallery_storage\";s:20:\"maximum_entity_count\";i:500;s:17:\"router_param_slug\";s:9:\"nggallery\";s:22:\"router_param_separator\";s:2:\"--\";s:19:\"router_param_prefix\";s:0:\"\";s:9:\"deleteImg\";b:1;s:9:\"swfUpload\";b:1;s:13:\"usePermalinks\";b:0;s:13:\"permalinkSlug\";s:9:\"nggallery\";s:14:\"graphicLibrary\";s:2:\"gd\";s:14:\"imageMagickDir\";s:15:\"/usr/local/bin/\";s:11:\"useMediaRSS\";b:0;s:18:\"galleries_in_feeds\";b:0;s:12:\"activateTags\";i:0;s:10:\"appendType\";s:4:\"tags\";s:9:\"maxImages\";i:7;s:14:\"relatedHeading\";s:24:\"<h3>Related Images:</h3>\";s:10:\"thumbwidth\";i:240;s:11:\"thumbheight\";i:160;s:8:\"thumbfix\";b:1;s:12:\"thumbquality\";i:100;s:8:\"imgWidth\";i:800;s:9:\"imgHeight\";i:600;s:10:\"imgQuality\";i:100;s:9:\"imgBackup\";b:1;s:13:\"imgAutoResize\";b:0;s:9:\"galImages\";s:2:\"20\";s:17:\"galPagedGalleries\";i:0;s:10:\"galColumns\";i:0;s:12:\"galShowSlide\";b:1;s:12:\"galTextSlide\";s:22:\"[Zeige eine Slideshow]\";s:14:\"galTextGallery\";s:22:\"[Zeige Vorschaubilder]\";s:12:\"galShowOrder\";s:7:\"gallery\";s:7:\"galSort\";s:9:\"sortorder\";s:10:\"galSortDir\";s:3:\"ASC\";s:10:\"galNoPages\";b:1;s:13:\"galImgBrowser\";i:0;s:12:\"galHiddenImg\";i:0;s:10:\"galAjaxNav\";i:0;s:11:\"thumbEffect\";s:8:\"fancybox\";s:9:\"thumbCode\";s:41:\"class=\"ngg-fancybox\" rel=\"%GALLERY_NAME%\"\";s:18:\"thumbEffectContext\";s:14:\"nextgen_images\";s:5:\"wmPos\";s:8:\"botRight\";s:6:\"wmXpos\";i:5;s:6:\"wmYpos\";i:5;s:6:\"wmType\";s:5:\"image\";s:6:\"wmPath\";s:0:\"\";s:6:\"wmFont\";s:9:\"arial.ttf\";s:6:\"wmSize\";i:10;s:6:\"wmText\";s:21:\"mein kleiner yogakurs\";s:7:\"wmColor\";s:6:\"000000\";s:8:\"wmOpaque\";s:3:\"100\";s:7:\"slideFX\";s:4:\"fade\";s:7:\"irWidth\";i:600;s:8:\"irHeight\";i:400;s:12:\"irRotatetime\";i:10;s:11:\"activateCSS\";i:1;s:7:\"CSSfile\";s:13:\"nggallery.css\";s:28:\"always_enable_frontend_logic\";b:0;s:22:\"dynamic_thumbnail_slug\";s:13:\"nextgen-image\";s:23:\"dynamic_stylesheet_slug\";s:12:\"nextgen-dcss\";}", "yes");
INSERT INTO `wp_options` VALUES("602", "photocrati_auto_update_admin_update_list", "", "yes");
INSERT INTO `wp_options` VALUES("603", "photocrati_auto_update_admin_check_date", "", "yes");
INSERT INTO `wp_options` VALUES("604", "ngg_db_version", "1.8.1", "yes");
INSERT INTO `wp_options` VALUES("607", "pope_module_list", "a:34:{i:0;s:17:\"photocrati-fs|0.4\";i:1;s:19:\"photocrati-i18n|0.1\";i:2;s:25:\"photocrati-validation|0.1\";i:3;s:21:\"photocrati-router|0.7\";i:4;s:32:\"photocrati-wordpress_routing|0.6\";i:5;s:23:\"photocrati-security|0.2\";i:6;s:31:\"photocrati-nextgen_settings|0.9\";i:7;s:18:\"photocrati-mvc|0.6\";i:8;s:19:\"photocrati-ajax|0.8\";i:9;s:25:\"photocrati-datamapper|0.9\";i:10;s:30:\"photocrati-nextgen-legacy|0.14\";i:11;s:28:\"photocrati-nextgen-data|0.10\";i:12;s:33:\"photocrati-dynamic_thumbnails|0.6\";i:13;s:28:\"photocrati-nextgen_admin|0.9\";i:14;s:39:\"photocrati-nextgen_gallery_display|0.13\";i:15;s:34:\"photocrati-frame_communication|0.4\";i:16;s:30:\"photocrati-attach_to_post|0.11\";i:17;s:38:\"photocrati-nextgen_addgallery_page|0.6\";i:18;s:36:\"photocrati-nextgen_other_options|0.8\";i:19;s:33:\"photocrati-nextgen_pagination|0.3\";i:20;s:33:\"photocrati-dynamic_stylesheet|0.3\";i:21;s:34:\"photocrati-nextgen_pro_upgrade|0.4\";i:22;s:20:\"photocrati-cache|0.2\";i:23;s:24:\"photocrati-lightbox|0.15\";i:24;s:38:\"photocrati-nextgen_basic_templates|0.5\";i:25;s:37:\"photocrati-nextgen_basic_gallery|0.13\";i:26;s:42:\"photocrati-nextgen_basic_imagebrowser|0.10\";i:27;s:39:\"photocrati-nextgen_basic_singlepic|0.11\";i:28;s:38:\"photocrati-nextgen_basic_tagcloud|0.11\";i:29;s:35:\"photocrati-nextgen_basic_album|0.10\";i:30;s:21:\"photocrati-widget|0.5\";i:31;s:33:\"photocrati-third_party_compat|0.4\";i:32;s:29:\"photocrati-nextgen_xmlrpc|0.4\";i:33;s:20:\"photocrati-wpcli|0.1\";}", "yes");
INSERT INTO `wp_options` VALUES("610", "wpseo_sitemap_display_type_cache_validator", "3lKEg", "no");
INSERT INTO `wp_options` VALUES("653", "FinalTiles_gallery_options", "a:42:{s:6:\"margin\";i:10;s:11:\"defaultSize\";s:6:\"medium\";s:5:\"width\";s:4:\"100%\";s:12:\"minTileWidth\";s:3:\"100\";s:12:\"gridCellSize\";s:2:\"25\";s:8:\"lightbox\";s:8:\"lightbox\";s:18:\"recentPostsCaption\";s:5:\"title\";s:11:\"captionIcon\";s:4:\"zoom\";s:12:\"reverseOrder\";b:0;s:16:\"captionIconColor\";s:7:\"#ffffff\";s:22:\"captionBackgroundColor\";s:7:\"#000000\";s:12:\"captionColor\";s:7:\"#ffffff\";s:21:\"captionEffectDuration\";i:250;s:14:\"captionOpacity\";i:80;s:10:\"borderSize\";i:0;s:12:\"borderRadius\";i:0;s:10:\"shadowSize\";i:0;s:15:\"imageSizeFactor\";i:90;s:30:\"imageSizeFactorTabletLandscape\";i:80;s:29:\"imageSizeFactorTabletPortrait\";i:70;s:29:\"imageSizeFactorPhoneLandscape\";i:60;s:28:\"imageSizeFactorPhonePortrait\";i:50;s:21:\"imageSizeFactorCustom\";s:0:\"\";s:13:\"enlargeImages\";s:1:\"T\";s:16:\"wp_field_caption\";s:11:\"description\";s:15:\"captionBehavior\";s:6:\"hidden\";s:17:\"captionFullHeight\";s:1:\"T\";s:12:\"captionEmpty\";s:4:\"hide\";s:13:\"captionEffect\";s:4:\"fade\";s:13:\"captionEasing\";s:6:\"linear\";s:21:\"captionMobileBehavior\";s:7:\"desktop\";s:12:\"scrollEffect\";s:4:\"none\";s:9:\"hoverZoom\";i:100;s:13:\"hoverRotation\";i:0;s:6:\"source\";s:6:\"images\";s:5:\"delay\";i:0;s:15:\"socialIconColor\";s:7:\"#ffffff\";s:7:\"support\";s:1:\"F\";s:11:\"loadedScale\";i:100;s:12:\"loadedRotate\";i:0;s:12:\"loadedHSlide\";i:0;s:12:\"loadedVSlide\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("661", "slb_version", "2.5.3", "yes");
INSERT INTO `wp_options` VALUES("662", "slb_options", "a:25:{s:7:\"enabled\";b:1;s:12:\"enabled_home\";b:1;s:12:\"enabled_post\";b:1;s:12:\"enabled_page\";b:1;s:15:\"enabled_archive\";b:1;s:14:\"enabled_widget\";b:0;s:11:\"group_links\";b:1;s:10:\"group_post\";b:1;s:13:\"group_gallery\";b:0;s:12:\"group_widget\";b:0;s:10:\"ui_autofit\";b:1;s:10:\"ui_animate\";b:1;s:19:\"slideshow_autostart\";b:1;s:18:\"slideshow_duration\";s:1:\"6\";s:10:\"group_loop\";b:1;s:18:\"ui_overlay_opacity\";s:3:\"0.8\";s:16:\"ui_title_default\";b:0;s:11:\"txt_loading\";s:7:\"Loading\";s:9:\"txt_close\";s:5:\"Close\";s:12:\"txt_nav_next\";s:4:\"Next\";s:12:\"txt_nav_prev\";s:8:\"Previous\";s:19:\"txt_slideshow_start\";s:15:\"Start slideshow\";s:18:\"txt_slideshow_stop\";s:14:\"Stop slideshow\";s:16:\"txt_group_status\";s:25:\"Item %current% of %total%\";s:13:\"theme_default\";s:11:\"slb_default\";}", "yes");
INSERT INTO `wp_options` VALUES("670", "responsive_lightbox_lite_version", "1.0.0", "yes");
INSERT INTO `wp_options` VALUES("671", "responsive_lightbox_lite_settings", "a:10:{s:6:\"script\";s:13:\"nivo_lightbox\";s:8:\"selector\";s:8:\"lightbox\";s:9:\"galleries\";b:1;s:6:\"videos\";b:1;s:11:\"image_links\";b:1;s:17:\"images_as_gallery\";b:0;s:19:\"deactivation_delete\";b:0;s:13:\"loading_place\";s:6:\"header\";s:20:\"enable_custom_events\";b:0;s:13:\"custom_events\";s:12:\"ajaxComplete\";}", "no");
INSERT INTO `wp_options` VALUES("697", "wpseo_sitemap_234_cache_validator", "5M7uo", "no");
INSERT INTO `wp_options` VALUES("698", "wpseo_sitemap_237_cache_validator", "5M7ur", "no");
INSERT INTO `wp_options` VALUES("729", "wpseo_sitemap_248_cache_validator", "2SOcH", "no");
INSERT INTO `wp_options` VALUES("761", "wpseo_sitemap_259_cache_validator", "2T8M6", "no");
INSERT INTO `wp_options` VALUES("781", "wpseo_sitemap_264_cache_validator", "2X1J9", "no");
INSERT INTO `wp_options` VALUES("791", "wpseo_sitemap_269_cache_validator", "2YMrF", "no");
INSERT INTO `wp_options` VALUES("807", "wpseo_sitemap_279_cache_validator", "39u9d", "no");
INSERT INTO `wp_options` VALUES("810", "wpseo_sitemap_275_cache_validator", "3aYJw", "no");
INSERT INTO `wp_options` VALUES("815", "wpseo_sitemap_285_cache_validator", "eA24", "no");
INSERT INTO `wp_options` VALUES("820", "wpseo_taxonomy_meta", "a:1:{s:8:\"category\";a:1:{i:10;a:1:{s:13:\"wpseo_linkdex\";s:2:\"15\";}}}", "yes");
INSERT INTO `wp_options` VALUES("823", "wpseo_sitemap_290_cache_validator", "3gFbB", "no");
INSERT INTO `wp_options` VALUES("830", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("831", "wpseo_sitemap_296_cache_validator", "3kBn8", "no");
INSERT INTO `wp_options` VALUES("835", "wpseo_sitemap_303_cache_validator", "3mTCM", "no");
INSERT INTO `wp_options` VALUES("861", "wpseo_sitemap_247_cache_validator", "4sz4U", "no");
INSERT INTO `wp_options` VALUES("874", "wpseo_sitemap_213_cache_validator", "4E7dQ", "no");
INSERT INTO `wp_options` VALUES("911", "wpseo_sitemap_311_cache_validator", "24BNL", "no");
INSERT INTO `wp_options` VALUES("991", "theme_mods_tiny-framework", "a:7:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:26;}s:12:\"header_image\";s:70:\"http://keep-it-short-and-simple.de/wp-content/uploads/2017/08/wein.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:1639;s:3:\"url\";s:70:\"http://keep-it-short-and-simple.de/wp-content/uploads/2017/08/wein.jpg\";s:13:\"thumbnail_url\";s:70:\"http://keep-it-short-and-simple.de/wp-content/uploads/2017/08/wein.jpg\";s:6:\"height\";i:297;s:5:\"width\";i:1000;}s:16:\"header_textcolor\";s:6:\"7609e2\";s:16:\"background_color\";s:6:\"d1c9e8\";s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("1227", "duplicator_settings", "a:10:{s:7:\"version\";s:5:\"1.2.8\";s:18:\"uninstall_settings\";s:1:\"1\";s:15:\"uninstall_files\";s:1:\"1\";s:16:\"uninstall_tables\";s:1:\"0\";s:13:\"package_debug\";s:1:\"1\";s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"1\";s:20:\"storage_htaccess_off\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("1333", "wpseo_sitemap_362_cache_validator", "5aazv", "no");
INSERT INTO `wp_options` VALUES("1422", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-08-26 06:01:00\";s:7:\"Version\";s:6:\"1.2.20\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";N;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"0bf7643d43d794ce9410170826060100\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";s:72:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/mnt/web004/d3/73/57460273/htdocs\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-08-26 06:01:00\";s:7:\"Version\";s:6:\"1.2.20\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"5.6.31\";s:9:\"VersionOS\";s:5:\"SunOS\";s:2:\"ID\";N;s:4:\"Name\";s:29:\"20160710_keepitshortandsimple\";s:4:\"Hash\";s:32:\"0bf7643d43d794ce9410170826060100\";s:8:\"NameHash\";s:62:\"20160710_keepitshortandsimple_0bf7643d43d794ce9410170826060100\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:50:\"/mnt/web004/d3/73/57460273/htdocs/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://keep-it-short-and-simple.de/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:57;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:57;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:42:\"/mnt/web004/d3/73/57460273/htdocs/wp-admin\";i:1;s:52:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/uploads\";i:2;s:54:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/languages\";i:3;s:52:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/plugins\";i:4;s:51:\"/mnt/web004/d3/73/57460273/htdocs/wp-content/themes\";i:5;s:45:\"/mnt/web004/d3/73/57460273/htdocs/wp-includes\";}}s:9:\"Installer\";r:79;s:8:\"Database\";r:87;}", "yes");
INSERT INTO `wp_options` VALUES("1647", "wpseo_sitemap_214_cache_validator", "2diHb", "no");
INSERT INTO `wp_options` VALUES("1678", "wpseo_sitemap_485_cache_validator", "5h4zc", "no");
INSERT INTO `wp_options` VALUES("2307", "wpseo_sitemap_480_cache_validator", "51BU3", "no");
INSERT INTO `wp_options` VALUES("2466", "wpseo_sitemap_301_cache_validator", "3tQrm", "no");
INSERT INTO `wp_options` VALUES("2615", "wpseo_sitemap_615_cache_validator", "466je", "no");
INSERT INTO `wp_options` VALUES("2616", "wpseo_sitemap_621_cache_validator", "466ji", "no");
INSERT INTO `wp_options` VALUES("2657", "wpseo_sitemap_652_cache_validator", "4ohbS", "no");
INSERT INTO `wp_options` VALUES("2821", "wpseo_sitemap_693_cache_validator", "5nUYq", "no");
INSERT INTO `wp_options` VALUES("3084", "wpseo_onpage", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1471155940;}", "yes");
INSERT INTO `wp_options` VALUES("3123", "wpseo_sitemap_633_cache_validator", "59ClZ", "no");
INSERT INTO `wp_options` VALUES("3408", "wpseo_sitemap_764_cache_validator", "261zH", "no");
INSERT INTO `wp_options` VALUES("3698", "wpseo_sitemap_801_cache_validator", "5vji6", "no");
INSERT INTO `wp_options` VALUES("4998", "wpseo", "a:25:{s:14:\"blocking_files\";a:0:{}s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:5:\"5.3.2\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:6:\"person\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:18:\"christine dreßler\";s:12:\"website_name\";s:24:\"keep it short and simple\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:13:\"personalOther\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:7:\"staging\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:20:\"enable_setting_pages\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1483514804;}", "yes");
INSERT INTO `wp_options` VALUES("4999", "wpseo_permalinks", "a:9:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("5000", "wpseo_titles", "a:54:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Autor auf %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:67:\"Du hast nach %%searchphrase%% gesucht %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:48:\"Seite wurde nicht gefunden. %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:52:\"%%term_title%% Archive %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:52:\"%%term_title%% Archive %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:52:\"%%term_title%% Archive %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("5001", "wpseo_social", "a:20:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"e65b23b5fd774c8f387a31276d4b62c0\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("5002", "wpseo_rss", "a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:58:\"Der Beitrag %%POSTLINK%% erschien zuerst auf %%BLOGLINK%%.\";}", "yes");
INSERT INTO `wp_options` VALUES("5003", "wpseo_internallinks", "a:10:{s:20:\"breadcrumbs-404crumb\";s:38:\"Fehler 404: Seite wurde nicht gefunden\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archive für\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:10:\"Startseite\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"Du suchtest nach\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("5004", "wpseo_xml", "a:16:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("5013", "_transient_yoast_i18n_wordpress-seo_promo_hide", "1", "yes");
INSERT INTO `wp_options` VALUES("5091", "wpseo_sitemap_215_cache_validator", "2xPBZ", "no");
INSERT INTO `wp_options` VALUES("6137", "wpseo_sitemap_1044_cache_validator", "3taea", "no");
INSERT INTO `wp_options` VALUES("6883", "wpseo_sitemap_author_cache_validator", "db5N", "no");
INSERT INTO `wp_options` VALUES("6928", "wpseo_sitemap_956_cache_validator", "66nNb", "no");
INSERT INTO `wp_options` VALUES("7342", "wpseo_sitemap_1140_cache_validator", "uWdS", "no");
INSERT INTO `wp_options` VALUES("7813", "_site_transient_timeout_browser_31f0e4613485a91d6c28b7f6eda8c2cb", "1485614824", "yes");
INSERT INTO `wp_options` VALUES("7814", "_site_transient_browser_31f0e4613485a91d6c28b7f6eda8c2cb", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"50.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("7854", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("7857", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("7893", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("8263", "duplicator_ui_view_state", "a:3:{s:29:\"dup-package-dtl-archive-panel\";s:1:\"1\";s:29:\"dup-package-dtl-general-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("9140", "_site_transient_timeout_browser_6849fd7d79494105a5eeda4eaccabf56", "1490083381", "no");
INSERT INTO `wp_options` VALUES("9141", "_site_transient_browser_6849fd7d79494105a5eeda4eaccabf56", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"51.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("9237", "wpseo-gsc", "a:1:{s:7:\"profile\";N;}", "yes");
INSERT INTO `wp_options` VALUES("9242", "wpseo-gsc-refresh_token", "1/0sf5zr4aNZ8b82UdMpzskVbqD6ECUyXtZ9RDSv8WB-I", "yes");
INSERT INTO `wp_options` VALUES("9243", "wpseo-gsc-access_token", "a:5:{s:13:\"refresh_token\";s:45:\"1/0sf5zr4aNZ8b82UdMpzskVbqD6ECUyXtZ9RDSv8WB-I\";s:12:\"access_token\";s:132:\"ya29.Gl1iBCx3zduWz7PRT5W19HpSOGmp51hQ38FxFOePJjhB9NTjK2dK39_Jwovr9ZwcE0Kh5IlSW4Bc4FYDlHEh7MXBt-0FlVKrlLMsCrTSenRc0BUgLTD4kHR-__b4azE\";s:7:\"expires\";d:1496880039;s:10:\"expires_in\";i:3600;s:7:\"created\";i:1496869239;}", "yes");
INSERT INTO `wp_options` VALUES("10195", "_site_transient_timeout_browser_d95afbbcbc7679e4bdc9b822ca5220da", "1493662040", "no");
INSERT INTO `wp_options` VALUES("10196", "_site_transient_browser_d95afbbcbc7679e4bdc9b822ca5220da", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"52.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("11920", "_site_transient_timeout_browser_216106093001b737c31593e994b1a54a", "1498591727", "no");
INSERT INTO `wp_options` VALUES("11921", "_site_transient_browser_216106093001b737c31593e994b1a54a", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"53.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("12988", "_site_transient_timeout_browser_c99fd505b5898ec7d13b183483752241", "1502306118", "no");
INSERT INTO `wp_options` VALUES("12989", "_site_transient_browser_c99fd505b5898ec7d13b183483752241", "a:9:{s:8:\"platform\";s:4:\"iPad\";s:4:\"name\";s:4:\"iPad\";s:7:\"version\";s:3:\"9.0\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("13498", "_site_transient_timeout_browser_15035ac2d483f3f4b647e2409491ff40", "1504121966", "no");
INSERT INTO `wp_options` VALUES("13499", "_site_transient_browser_15035ac2d483f3f4b647e2409491ff40", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"54.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("13525", "_site_transient_timeout_available_translations", "1503529142", "no");
INSERT INTO `wp_options` VALUES("13526", "_site_transient_available_translations", "a:108:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-27 04:32:49\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.5/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:49:08\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-09 11:39:31\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.5/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-16 13:06:08\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-04 16:58:43\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-05 09:44:12\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-04 20:20:28\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-21 20:41:02\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 08:46:26\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:12:\"Čeština‎\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:49:29\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-05 09:50:06\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:40:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:39:59\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/4.7.5/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-24 13:44:46\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.5/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-24 13:44:35\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-08 16:17:30\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:54:30\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:53:43\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-27 00:40:28\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:49:34\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-28 03:10:25\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-04 18:08:49\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:41:31\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-10 16:26:52\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-28 20:09:49\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-23 23:02:31\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:42:28\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 16:37:11\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-12 06:40:28\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-02-02 15:21:03\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:42:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-05 12:10:24\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-02-03 21:08:25\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:40:32\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-09 08:05:00\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-11 12:30:31\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-29 21:21:10\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-17 06:35:04\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-28 13:34:22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:39\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-02 14:01:52\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-13 13:55:54\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-11 10:12:38\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-03 15:15:18\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-05 06:17:00\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:13\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-07 02:07:59\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-07 11:10:31\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:25\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-30 09:46:13\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-17 20:40:40\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:54:41\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-24 06:52:11\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-05 09:45:10\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.18\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.18/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:42:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-02 10:59:56\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-11 15:57:29\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-02-16 13:24:21\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.5/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-07 17:23:35\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:40:57\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-02 13:47:38\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-23 09:31:28\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.18\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.18/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-17 15:02:48\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-08-14 14:19:20\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-06-25 15:01:13\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-20 10:13:53\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-10 13:48:29\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-02-08 17:57:45\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-24 08:35:30\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:41:03\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-03 00:34:10\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:43\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-04-15 09:03:35\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-05 09:23:39\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-17 03:13:31\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-03-27 07:08:07\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-13 09:55:38\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-07-02 09:07:47\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.5/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-05-08 04:16:08\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-07-29 12:51:21\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.7.5\";s:7:\"updated\";s:19:\"2017-01-26 15:54:45\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.5/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "no");
INSERT INTO `wp_options` VALUES("13571", "_transient_timeout_feed_e5132d2944a7be60661ee809629a6d9c", "1503723879", "no");
INSERT INTO `wp_options` VALUES("13572", "_transient_feed_e5132d2944a7be60661ee809629a6d9c", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Releases – Deutsch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://de.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress auf Deutsch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 12 Aug 2017 13:09:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"de-DE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.9-alpha-41314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.8.1 Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://de.wordpress.org/2017/08/wordpress-4-8-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Aug 2017 06:41:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2739\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:421:\"Vor Kurzem wurde WordPress 4.8.1 veröffentlicht. Die neue Version beinhaltet 29 Bugfixes und Verbesserungen – darunter Fehlerbehebungen für das Text-Widget sowie die Einführung eines HTML-Widgets. Alle vorgenommenen Änderungen findet ihr in den Release-Notes, den geschlossenen Tickets und der Liste aller Änderungen. Ihr könnt die neue Version herunterladen oder ein Update für eine bestehende Site im [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2521:\"<p>Vor Kurzem wurde WordPress 4.8.1 veröffentlicht. Die neue Version beinhaltet 29 Bugfixes und Verbesserungen – darunter Fehlerbehebungen für das Text-Widget sowie die Einführung eines HTML-Widgets. Alle vorgenommenen Änderungen findet ihr in den <a href=\"https://codex.wordpress.org/Version_4.8.1\">Release-Notes</a>, den <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.8.1&amp;group=component\">geschlossenen Tickets</a> und der <a href=\"https://core.trac.wordpress.org/log/branches/4.8?rev=41210&amp;stop_rev=40891\">Liste aller Änderungen</a>.<span id=\"more-2739\"></span></p>\n<p>Ihr könnt die <a href=\"https://de.wordpress.org/txt-download/\">neue Version herunterladen</a> oder ein Update für eine bestehende Site im Dashboard durchführen. Falls ihr automatische Updates nicht deaktiviert habt, könnte das Update bereits bei euch angekommen sein.</p>\n<p>Danke an alle, die zu WordPress 4.8.1 beigetragen haben:<br />\n<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>,<a href=\"https://profiles.wordpress.org/afercia/\"> Andrea Fercia</a>,<a href=\"https://profiles.wordpress.org/azaozz/\"> Andrew Ozz</a>,<a href=\"https://profiles.wordpress.org/atanasangelovdev/\"> Atanas Angelov</a>,<a href=\"https://profiles.wordpress.org/gitlost/\"> bonger</a>,<a href=\"https://profiles.wordpress.org/boonebgorges/\"> Boone Gorges</a>,<a href=\"https://profiles.wordpress.org/bor0/\"> Boro Sitnikovski</a>,<a href=\"https://profiles.wordpress.org/dlh/\"> David Herrera</a>,<a href=\"https://profiles.wordpress.org/jnylen0/\"> James Nylen</a>,<a href=\"https://profiles.wordpress.org/jbpaul17/\"> Jeffrey Paul</a>,<a href=\"https://profiles.wordpress.org/jmdodd/\"> Jennifer M. Dodd</a>,<a href=\"https://profiles.wordpress.org/kadamwhite/\"> K. Adam White</a>,<a href=\"https://profiles.wordpress.org/obenland/\"> Konstantin Obenland</a>,<a href=\"https://profiles.wordpress.org/melchoyce/\"> Mel Choyce</a>,<a href=\"https://profiles.wordpress.org/r-a-y/\"> r-a-y</a>,<a href=\"https://profiles.wordpress.org/greuben/\"> Reuben Gunday</a>,<a href=\"https://profiles.wordpress.org/rinkuyadav999/\"> Rinku Y</a>,<a href=\"https://profiles.wordpress.org/sa3idho/\"> Said El Bakkali</a>,<a href=\"https://profiles.wordpress.org/sergeybiryukov/\"> Sergey Biryukov</a>,<a href=\"https://profiles.wordpress.org/nomnom99/\"> Siddharth Thevaril</a>,<a href=\"https://profiles.wordpress.org/timmydcrawford/\"> Timmy Crawford</a> und<a href=\"https://profiles.wordpress.org/westonruter/\"> Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress 4.8 »Evans«\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://de.wordpress.org/2017/06/wordpress-4-8-evans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 15:19:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2676\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:442:\"WordPress 4.8 wurde heute veröffentlicht – benannt nach Jazz-Pianist und Komponist William John »Bill« Evans. Die neue Version bringt drei zusätzliche Widgets mit, über die ihr Bilder, Videos und Audiodateien in Widget-Bereichen anzeigen könnt. Darüber hinaus wurde das Text-Widget um Möglichkeiten zur visuellen Textformatierung erweitert. Daneben gibt es Verbesserungen mit der Handhabung von Inline-Link-Begrenzungen im [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:29368:\"<p>WordPress 4.8 wurde heute veröffentlicht – benannt nach Jazz-Pianist und Komponist William John »Bill« Evans.<span id=\"more-2676\"></span></p>\n<p>Die neue Version bringt drei zusätzliche Widgets mit, über die ihr Bilder, Videos und Audiodateien in Widget-Bereichen anzeigen könnt. Darüber hinaus wurde das Text-Widget um Möglichkeiten zur visuellen Textformatierung erweitert.</p>\n<figure id=\"attachment_2677\" style=\"width: 531px\" class=\"wp-caption alignnone\"><img class=\"wp-image-2677 size-full\" src=\"https://de.wordpress.org/files/2017/06/wordpress-4-8-widgets.png\" alt=\"\" width=\"531\" height=\"366\" srcset=\"https://de.wordpress.org/files/2017/06/wordpress-4-8-widgets.png 531w, https://de.wordpress.org/files/2017/06/wordpress-4-8-widgets-300x207.png 300w\" sizes=\"(max-width: 531px) 100vw, 531px\" /><figcaption class=\"wp-caption-text\">WordPress 4.8 kommt mit drei neuen Medien-Widgets und visuellen Formatierungsmöglichkeiten im Text-Widget. (Screenshot: WordPress-About-Seite)</figcaption></figure>\n<p>Daneben gibt es Verbesserungen mit der Handhabung von Inline-Link-Begrenzungen im Editor. Damit wird durch eine visuelle Hintergrundmarkierung die Bearbeitung von Links vereinfacht, oder genauer: das gezielte Einfügen von weiterem Text direkt vor oder hinter einem Link als Teil oder nicht als Teil des Links. Außerdem zeigt das WordPress-News-Widget im Dashboard jetzt auch anstehende WordCamps und WordPress-Meetups in eurer Nähe an.</p>\n<div id=\"v-8BDWH3QG-1\" class=\"video-player\"><video id=\"v-8BDWH3QG-1-video\" width=\"692\" height=\"374\" poster=\"https://videos.files.wordpress.com/8BDWH3QG/3-link-boundaries_dvd.original.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/8BDWH3QG/3-link-boundaries_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/8BDWH3QG/3-link-boundaries_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Link Boundaries\" src=\"https://videos.files.wordpress.com/8BDWH3QG/3-link-boundaries_dvd.original.jpg\" width=\"692\" height=\"374\" /></div><p>Link Boundaries</p></video></div>\n<p>Auch für Entwickler ist natürlich wieder was dabei. So gibt es Änderungen bei einigen Überschriften im Backend. Bisher gab es in vielen Backend-Headlines noch ein weiteres Element, wie »Erstellen« bei der Beitragsansicht. Diese Elemente wurden aus Gründen der Barrierefreiheit aus den Überschriften-Elementen herausgelöst. Darüber hinaus ist die Customizer-Sidebar in 4.8 auf größeren Viewports breiter als bisher, und es werden keine WMV- und WMA-Dateien mehr unterstützt.</p>\n<p>Außerdem gibt es neue »Capabilities«, die mit dem Ziel eingeführt wurden, <code>is_super_admin()</code>-Aufrufe zu entfernen. Mit dem Hinzufügen des TinyMCE zum Text-Widget gibt es auch eine neue JS-API, über die eine Editor-Instanz nach Laden der Seite erstellt werden kann. Eine Medien-Widgets-API schafft die Voraussetzungen, dass zukünftig weitere Medien-Widgets entwickelt werden können.</p>\n<h2>Danke!</h2>\n<h3>Übersetzung ins Deutsche</h3>\n<p><a href=\"https://profiles.wordpress.org/fstaude\">Frank Neumann-Staude</a>, <a href=\"https://profiles.wordpress.org/pixelverbieger\">Christian Sabo</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/arkonisus\">Christian Rüggeberg</a>, <a href=\"https://profiles.wordpress.org/la-geek\">Angelika</a>,<a href=\"https://profiles.wordpress.org/bluetower\"> bluetower</a>,<a href=\"https://profiles.wordpress.org/glueckpress\"> Caspar Hübinger</a>,<a href=\"https://profiles.wordpress.org/elisa-demonki\"> Elisa</a>,<a href=\"https://profiles.wordpress.org/florianbrinkmann\"> Florian Brinkmann</a>,<a href=\"https://profiles.wordpress.org/gymnatic\"> gymnatic</a>,<a href=\"https://profiles.wordpress.org/julius2001\"> Julius</a>,<a href=\"https://profiles.wordpress.org/travel_girl\"> Maja</a>,<a href=\"https://profiles.wordpress.org/vivamundo\"> Mario Wolf</a>,<a href=\"https://profiles.wordpress.org/mobotter\"> Moritz Kern</a>,<a href=\"https://profiles.wordpress.org/sebastianlaube\"> sebastianlaube</a>,<a href=\"https://profiles.wordpress.org/krafit\"> Simon Kraft</a>,<a href=\"https://profiles.wordpress.org/soean\"> Sören Wrede</a>,<a href=\"https://profiles.wordpress.org/sosere\"> sosere</a>,<a href=\"https://profiles.wordpress.org/timse201\"> timse201</a>,<a href=\"https://profiles.wordpress.org/zodiac1978\"> Torsten Landsiedel</a>,<a href=\"https://profiles.wordpress.org/traduteca\"> traduteca</a> und<a href=\"https://profiles.wordpress.org/ufkcsgn\"> ufkcsgn</a>.</p>\n<h3>Entwicklung</h3>\n<p><strong>Projektleitung:</strong></p>\n<p><a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a> (Leitende Entwicklung), <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a> (Leitende Entwicklung), <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a> (Release-Leitung), <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a> (Leitende Entwicklung), <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a> (Leitende Entwicklung) und <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a> (Leitende Entwicklung).</p>\n<p><strong>Mitwirkende an der Entwicklung:</strong></p>\n<p><a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> (Stellvertretende Release-Leitung), <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/DrewAPicture\">Drew Jaynes</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> (Core-Entwicklung), <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/Joen\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/matveb\">Matias Ventura</a> und <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>.</p>\n<p><strong>Mitwirkende am Core von WordPress 4.8:</strong></p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri\">1naveengiri</a>,<a href=\"https://profiles.wordpress.org/4nickpick\"> 4nickpick</a>,<a href=\"https://profiles.wordpress.org/abhishek\"> abhishek</a>,<a href=\"https://profiles.wordpress.org/abhishekfdd\"> Abhishek Kumar</a>,<a href=\"https://profiles.wordpress.org/abrain\"> abrain</a>,<a href=\"https://profiles.wordpress.org/kawauso\"> Adam Harley (Kawauso)</a>,<a href=\"https://profiles.wordpress.org/adamsoucie\"> Adam Soucie</a>,<a href=\"https://profiles.wordpress.org/afzalmultani\"> Afzal Multani</a>,<a href=\"https://profiles.wordpress.org/mrahmadawais\"> Ahmad Awais</a>,<a href=\"https://profiles.wordpress.org/ajoah\"> ajoah</a>,<a href=\"https://profiles.wordpress.org/xknown\"> Alex Concha</a>,<a href=\"https://profiles.wordpress.org/apmarshall\"> Alex Floyd Marshall</a>,<a href=\"https://profiles.wordpress.org/alexkingorg\"> Alex King</a>,<a href=\"https://profiles.wordpress.org/tellyworth\"> Alex Shiels</a>,<a href=\"https://profiles.wordpress.org/andreamiddleton\"> Andrea Middleton</a>,<a href=\"https://profiles.wordpress.org/rockwell15\"> Andrew Rockwell</a>,<a href=\"https://profiles.wordpress.org/kelderic\"> Andy Mercer</a>,<a href=\"https://profiles.wordpress.org/ankit-k-gupta\"> Ankit K Gupta</a>,<a href=\"https://profiles.wordpress.org/arena94\"> arena94</a>,<a href=\"https://profiles.wordpress.org/arshidkv12\"> Arshid</a>,<a href=\"https://profiles.wordpress.org/aryamaaru\"> Arun</a>,<a href=\"https://profiles.wordpress.org/asalce\"> asalce</a>,<a href=\"https://profiles.wordpress.org/ashokkumar24\"> ashokkumar24</a>,<a href=\"https://profiles.wordpress.org/barryceelen\"> Barry Ceelen</a>,<a href=\"https://profiles.wordpress.org/bcworkz\"> bcworkz</a>,<a href=\"https://profiles.wordpress.org/bharatkambariya\"> Bharat Kambariya</a>,<a href=\"https://profiles.wordpress.org/blobfolio\"> Blobfolio</a>,<a href=\"https://profiles.wordpress.org/gitlost\"> bonger</a>,<a href=\"https://profiles.wordpress.org/bor0\"> Boro Sitnikovski</a>,<a href=\"https://profiles.wordpress.org/bradt\"> Brad Touesnard</a>,<a href=\"https://profiles.wordpress.org/bradyvercher\"> Brady Vercher</a>,<a href=\"https://profiles.wordpress.org/kraftbj\"> Brandon Kraft</a>,<a href=\"https://profiles.wordpress.org/drrobotnik\"> Brandon Lavigne</a>,<a href=\"https://profiles.wordpress.org/bridgetwillard\"> Bridget Willard</a>,<a href=\"https://profiles.wordpress.org/bhargavbhandari90\"> Bunty</a>,<a href=\"https://profiles.wordpress.org/camikaos\"> Cami Kaos</a>,<a href=\"https://profiles.wordpress.org/carl-alberto\"> Carl Alberto</a>,<a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\"> Casey Driscoll</a>,<a href=\"https://profiles.wordpress.org/cazm\"> cazm</a>,<a href=\"https://profiles.wordpress.org/ccprog\"> ccprog</a>,<a href=\"https://profiles.wordpress.org/chandrapatel\"> Chandra Patel</a>,<a href=\"https://profiles.wordpress.org/chesio\"> chesio</a>,<a href=\"https://profiles.wordpress.org/ketuchetan\"> chetansatasiya</a>,<a href=\"https://profiles.wordpress.org/chiragpatel\"> Chirag Patel</a>,<a href=\"https://profiles.wordpress.org/chouby\"> Chouby</a>,<a href=\"https://profiles.wordpress.org/chriseverson\"> chriseverson</a>,<a href=\"https://profiles.wordpress.org/cklosows\"> Chris Klosowski</a>,<a href=\"https://profiles.wordpress.org/chris_dev\"> Chris Mok</a>,<a href=\"https://profiles.wordpress.org/christian1012\"> Christian Chung</a>,<a href=\"https://profiles.wordpress.org/coreymckrill\"> Corey McKrill</a>,<a href=\"https://profiles.wordpress.org/courtneypk\"> Courtney P.K.</a>,<a href=\"https://profiles.wordpress.org/cristianozanca\"> Cristiano Zanca</a>,<a href=\"https://profiles.wordpress.org/csloisel\"> csloisel</a>,<a href=\"https://profiles.wordpress.org/curdin\"> Curdin Krummenacher</a>,<a href=\"https://profiles.wordpress.org/clarinetlord\"> Cyrus Collier</a>,<a href=\"https://profiles.wordpress.org/danielbachhuber\"> Daniel Bachhuber</a>,<a href=\"https://profiles.wordpress.org/mte90\"> Daniele Scasciafratte</a>,<a href=\"https://profiles.wordpress.org/diddledan\"> Daniel Llewellyn</a>,<a href=\"https://profiles.wordpress.org/nerrad\"> Darren Ethier (nerrad)</a>,<a href=\"https://profiles.wordpress.org/darshan02\"> Darshan_dj</a>,<a href=\"https://profiles.wordpress.org/darthaud\"> darthaud</a>,<a href=\"https://profiles.wordpress.org/dllh\"> Daryl L. L. Houston (dllh)</a>,<a href=\"https://profiles.wordpress.org/davidanderson\"> David Anderson</a>,<a href=\"https://profiles.wordpress.org/davidbenton\"> davidbenton</a>,<a href=\"https://profiles.wordpress.org/davidbinda\"> David Binovec</a>,<a href=\"https://profiles.wordpress.org/dlh\"> David Herrera</a>,<a href=\"https://profiles.wordpress.org/dshanske\"> David Shanske</a>,<a href=\"https://profiles.wordpress.org/designsimply\"> designsimply</a>,<a href=\"https://profiles.wordpress.org/dhanendran\"> Dhanendran</a>,<a href=\"https://profiles.wordpress.org/dharm1025\"> Dharmesh Patel</a>,<a href=\"https://profiles.wordpress.org/dhaval-parekh\"> Dhaval Parekh</a>,<a href=\"https://profiles.wordpress.org/dingo_bastard\"> dingo-d</a>,<a href=\"https://profiles.wordpress.org/dotancohen\"> Dotan Cohen</a>,<a href=\"https://profiles.wordpress.org/doublehhh\"> DoubleH</a>,<a href=\"https://profiles.wordpress.org/dreamon11\"> DreamOn11</a>,<a href=\"https://profiles.wordpress.org/drivingralle\"> Drivingralle</a>,<a href=\"https://profiles.wordpress.org/dspilka\"> dspilka</a>,<a href=\"https://profiles.wordpress.org/chopinbach\"> Edwin Cromley</a>,<a href=\"https://profiles.wordpress.org/ejner69\"> Ejner Galaz</a>,<a href=\"https://profiles.wordpress.org/emirpprime\"> emirpprime</a>,<a href=\"https://profiles.wordpress.org/ethitter\"> Erick Hitter</a>,<a href=\"https://profiles.wordpress.org/endif-media\"> Ethan Allen</a>,<a href=\"https://profiles.wordpress.org/fab1en\"> Fabien Quatravaux</a>,<a href=\"https://profiles.wordpress.org/fibonaccina\"> fibonaccina</a>,<a href=\"https://profiles.wordpress.org/mista-flo\"> Florian TIAR</a>,<a href=\"https://profiles.wordpress.org/francina\"> Francesca Marano</a>,<a href=\"https://profiles.wordpress.org/fstaude\"> Frank Neumann-Staude</a>,<a href=\"https://profiles.wordpress.org/f-j-kaiser\"> Franz Josef Kaiser</a>,<a href=\"https://profiles.wordpress.org/gma992\"> Gabriel Maldonado</a>,<a href=\"https://profiles.wordpress.org/voldemortensen\"> Garth Mortensen</a>,<a href=\"https://profiles.wordpress.org/garyc40\"> Gary Cao</a>,<a href=\"https://profiles.wordpress.org/georgestephanis\"> George Stephanis</a>,<a href=\"https://profiles.wordpress.org/ghosttoast\"> Gustave F. Gerhardt</a>,<a href=\"https://profiles.wordpress.org/hedgefield\"> hedgefield</a>,<a href=\"https://profiles.wordpress.org/helgatheviking\"> helgatheviking</a>,<a href=\"https://profiles.wordpress.org/hristo-sg\"> Hristo Pandjarov</a>,<a href=\"https://profiles.wordpress.org/iandunn\"> Ian Dunn</a>,<a href=\"https://profiles.wordpress.org/zinigor\"> Igor Zinovyev</a>,<a href=\"https://profiles.wordpress.org/ig_communitysites\"> ig_communitysites</a>,<a href=\"https://profiles.wordpress.org/imath\"> imath</a>,<a href=\"https://profiles.wordpress.org/ipstenu\"> Ipstenu (Mika Epstein)</a>,<a href=\"https://profiles.wordpress.org/ireneyoast\"> ireneyoast</a>,<a href=\"https://profiles.wordpress.org/iv3rson76\"> Ivan Stefanov</a>,<a href=\"https://profiles.wordpress.org/ivantedja\"> ivantedja</a>,<a href=\"https://profiles.wordpress.org/jdgrimes\"> J.D. Grimes</a>,<a href=\"https://profiles.wordpress.org/jackreichert\"> Jack Reichert</a>,<a href=\"https://profiles.wordpress.org/whyisjake\"> Jake Spurlock</a>,<a href=\"https://profiles.wordpress.org/jaydeep-rami\"> Jaydeep Rami</a>,<a href=\"https://profiles.wordpress.org/jazbek\"> jazbek</a>,<a href=\"https://profiles.wordpress.org/jblz\"> Jeff Bowen</a>,<a href=\"https://profiles.wordpress.org/jfarthing84\"> Jeff Farthing</a>,<a href=\"https://profiles.wordpress.org/cheffheid\"> Jeffrey de Wit</a>,<a href=\"https://profiles.wordpress.org/jenblogs4u\"> Jen Miller</a>,<a href=\"https://profiles.wordpress.org/jpry\"> Jeremy Pry</a>,<a href=\"https://profiles.wordpress.org/jigneshnakrani\"> Jignesh Nakrani</a>,<a href=\"https://profiles.wordpress.org/jipmoors\"> Jip Moors</a>,<a href=\"https://profiles.wordpress.org/jjcomack\"> jjcomack</a>,<a href=\"https://profiles.wordpress.org/joedolson\"> Joe Dolson</a>,<a href=\"https://profiles.wordpress.org/johnjamesjacoby\"> John James Jacoby</a>,<a href=\"https://profiles.wordpress.org/desrosj\"> Jonathan Desrosiers</a>,<a href=\"https://profiles.wordpress.org/spacedmonkey\"> Jonny Harris</a>,<a href=\"https://profiles.wordpress.org/joostdevalk\"> Joost de Valk</a>,<a href=\"https://profiles.wordpress.org/chanthaboune\"> Josepha</a>,<a href=\"https://profiles.wordpress.org/shelob9\"> Josh Pollock</a>,<a href=\"https://profiles.wordpress.org/juhise\"> Juhi Saxena</a>,<a href=\"https://profiles.wordpress.org/kopepasah\"> Justin Kopepasah</a>,<a href=\"https://profiles.wordpress.org/certainstrings\"> Justin Tucker</a>,<a href=\"https://profiles.wordpress.org/kafleg\"> kafleg</a>,<a href=\"https://profiles.wordpress.org/trepmal\"> Kailey (trepmal)</a>,<a href=\"https://profiles.wordpress.org/karinedo\"> karinedo</a>,<a href=\"https://profiles.wordpress.org/zoonini\"> Kathryn</a>,<a href=\"https://profiles.wordpress.org/kaushik\"> kaushik</a>,<a href=\"https://profiles.wordpress.org/kkoppenhaver\"> Keanan Koppenhaver</a>,<a href=\"https://profiles.wordpress.org/keesiemeijer\"> keesiemeijer</a>,<a href=\"https://profiles.wordpress.org/ryelle\"> Kelly Dwan</a>,<a href=\"https://profiles.wordpress.org/ixkaito\"> Kite</a>,<a href=\"https://profiles.wordpress.org/kjellr\"> kjellr</a>,<a href=\"https://profiles.wordpress.org/kostasx\"> kostasx</a>,<a href=\"https://profiles.wordpress.org/kubik-rubik\"> kubik-rubik</a>,<a href=\"https://profiles.wordpress.org/kuck1u\"> KUCKLU</a>,<a href=\"https://profiles.wordpress.org/lancewillett\"> Lance Willett</a>,<a href=\"https://profiles.wordpress.org/laurelfulford\"> laurelfulford</a>,<a href=\"https://profiles.wordpress.org/leemon\"> leemon</a>,<a href=\"https://profiles.wordpress.org/leewillis77\"> Lee Willis</a>,<a href=\"https://profiles.wordpress.org/lewiscowles\"> LewisCowles</a>,<a href=\"https://profiles.wordpress.org/liammcarthur\"> LiamMcArthur</a>,<a href=\"https://profiles.wordpress.org/lucasstark\"> Lucas Stark</a>,<a href=\"https://profiles.wordpress.org/lukasbesch\"> lukasbesch</a>,<a href=\"https://profiles.wordpress.org/lukecavanagh\"> Luke Cavanagh</a>,<a href=\"https://profiles.wordpress.org/maedahbatool\"> maedahbatool</a>,<a href=\"https://profiles.wordpress.org/maguiar\"> maguiar</a>,<a href=\"https://profiles.wordpress.org/mp518\"> Mahesh Prajapati</a>,<a href=\"https://profiles.wordpress.org/mantismamita\"> mantismamita</a>,<a href=\"https://profiles.wordpress.org/tyxla\"> Marin Atanasov</a>,<a href=\"https://profiles.wordpress.org/markoheijnen\"> Marko Heijnen</a>,<a href=\"https://profiles.wordpress.org/mrwweb\"> Mark Root-Wiley</a>,<a href=\"https://profiles.wordpress.org/mapk\"> Mark Uraine</a>,<a href=\"https://profiles.wordpress.org/matheusgimenez\"> MatheusGimenez</a>,<a href=\"https://profiles.wordpress.org/matheusfd\"> Matheus Martins</a>,<a href=\"https://profiles.wordpress.org/mathieuhays\"> mathieuhays</a>,<a href=\"https://profiles.wordpress.org/matias\"> matias</a>,<a href=\"https://profiles.wordpress.org/mboynes\"> Matthew Boynes</a>,<a href=\"https://profiles.wordpress.org/mattheu\"> Matthew Haines-Young</a>,<a href=\"https://profiles.wordpress.org/mattwiebe\"> Matt Wiebe</a>,<a href=\"https://profiles.wordpress.org/mattyrob\"> mattyrob</a>,<a href=\"https://profiles.wordpress.org/maximeculea\"> Maxime Culea</a>,<a href=\"https://profiles.wordpress.org/mayukojpn\"> Mayo Moriyama</a>,<a href=\"https://profiles.wordpress.org/mayurk\"> Mayur Keshwani</a>,<a href=\"https://profiles.wordpress.org/menakas\"> Menaka S.</a>,<a href=\"https://profiles.wordpress.org/michalzuber\"> michalzuber</a>,<a href=\"https://profiles.wordpress.org/michelleweber\"> michelleweber</a>,<a href=\"https://profiles.wordpress.org/stubgo\"> Miina Sikk</a>,<a href=\"https://profiles.wordpress.org/mihai2u\"> Mike Crantea</a>,<a href=\"https://profiles.wordpress.org/mikehansenme\"> Mike Hansen</a>,<a href=\"https://profiles.wordpress.org/mikejolley\"> Mike Jolley</a>,<a href=\"https://profiles.wordpress.org/mikelittle\"> Mike Little</a>,<a href=\"https://profiles.wordpress.org/mnelson4\"> Mike Nelson</a>,<a href=\"https://profiles.wordpress.org/dimadin\"> Milan Dinić</a>,<a href=\"https://profiles.wordpress.org/milindmore22\"> Milind More</a>,<a href=\"https://profiles.wordpress.org/mitraval192\"> Mithun Raval</a>,<a href=\"https://profiles.wordpress.org/mmdeveloper\"> MMDeveloper</a>,<a href=\"https://profiles.wordpress.org/batmoo\"> Mohammad Jangda</a>,<a href=\"https://profiles.wordpress.org/mohanjith\"> mohanjith</a>,<a href=\"https://profiles.wordpress.org/monikarao\"> monikarao</a>,<a href=\"https://profiles.wordpress.org/morganestes\"> Morgan Estes</a>,<a href=\"https://profiles.wordpress.org/mt8biz\"> moto hachi ( mt8.biz )</a>,<a href=\"https://profiles.wordpress.org/mrgregwaugh\"> MrGregWaugh</a>,<a href=\"https://profiles.wordpress.org/mschadegg\"> mschadegg</a>,<a href=\"https://profiles.wordpress.org/codegeass\"> Muhammet Arslan</a>,<a href=\"https://profiles.wordpress.org/dots\"> MULTIDOTS</a>,<a href=\"https://profiles.wordpress.org/nao\"> Naoko Takano</a>,<a href=\"https://profiles.wordpress.org/naomicbush\"> Naomi C. Bush</a>,<a href=\"https://profiles.wordpress.org/natereist\"> Nate Reist</a>,<a href=\"https://profiles.wordpress.org/greatislander\"> Ned Zimmerman</a>,<a href=\"https://profiles.wordpress.org/celloexpressions\"> Nick Halsey</a>,<a href=\"https://profiles.wordpress.org/nikschavan\"> Nikhil Chavan</a>,<a href=\"https://profiles.wordpress.org/nitin-kevadiya\"> Nitin Kevadiya</a>,<a href=\"https://profiles.wordpress.org/kailanitish90\"> Nitish Kaila</a>,<a href=\"https://profiles.wordpress.org/nobremarcos\"> nobremarcos</a>,<a href=\"https://profiles.wordpress.org/nosegraze\"> NoseGraze</a>,<a href=\"https://profiles.wordpress.org/nsundberg\"> nsundberg</a>,<a href=\"https://profiles.wordpress.org/nullvariable\"> nullvariable</a>,<a href=\"https://profiles.wordpress.org/odysseygate\"> odyssey</a>,<a href=\"https://profiles.wordpress.org/iaaxpage\"> page-carbajal</a>,<a href=\"https://profiles.wordpress.org/pbearne\"> Paul Bearne</a>,<a href=\"https://profiles.wordpress.org/pbiron\"> Paul Biron</a>,<a href=\"https://profiles.wordpress.org/pauldewouters\"> Paul de Wouters</a>,<a href=\"https://profiles.wordpress.org/figureone\"> Paul Ryan</a>,<a href=\"https://profiles.wordpress.org/pavelevap\"> pavelevap</a>,<a href=\"https://profiles.wordpress.org/sirbrillig\"> Payton Swick</a>,<a href=\"https://profiles.wordpress.org/pdufour\"> pdufour</a>,<a href=\"https://profiles.wordpress.org/piewp\"> Perdaan</a>,<a href=\"https://profiles.wordpress.org/philipjohn\"> Philip John</a>,<a href=\"https://profiles.wordpress.org/delawski\"> Piotr Delawski</a>,<a href=\"https://profiles.wordpress.org/psoluch\"> Piotr Soluch</a>,<a href=\"https://profiles.wordpress.org/postpostmodern\"> postpostmodern</a>,<a href=\"https://profiles.wordpress.org/pranalipatel\"> Pranali Patel</a>,<a href=\"https://profiles.wordpress.org/pratikshrestha\"> Pratik Shrestha</a>,<a href=\"https://profiles.wordpress.org/presskopp\"> Presskopp</a>,<a href=\"https://profiles.wordpress.org/printsachen1\"> printsachen1</a>,<a href=\"https://profiles.wordpress.org/priyankabehera155\"> Priyanka Behera</a>,<a href=\"https://profiles.wordpress.org/prosti\"> prosti</a>,<a href=\"https://profiles.wordpress.org/ptbello\"> ptbello</a>,<a href=\"https://profiles.wordpress.org/rafaehlers\"> Rafael Ehlers</a>,<a href=\"https://profiles.wordpress.org/raggedrobins\"> raggedrobins</a>,<a href=\"https://profiles.wordpress.org/raisonon\"> raisonon</a>,<a href=\"https://profiles.wordpress.org/ramiabraham\"> ramiabraham</a>,<a href=\"https://profiles.wordpress.org/ramiy\"> Rami Yushuvaev</a>,<a href=\"https://profiles.wordpress.org/ranh\"> ranh</a>,<a href=\"https://profiles.wordpress.org/rclations\"> RC Lations</a>,<a href=\"https://profiles.wordpress.org/redrambles\"> redrambles</a>,<a href=\"https://profiles.wordpress.org/reidbusi\"> reidbusi</a>,<a href=\"https://profiles.wordpress.org/reldev\"> reldev</a>,<a href=\"https://profiles.wordpress.org/rellect\"> rellect</a>,<a href=\"https://profiles.wordpress.org/arena\"> RENAUT</a>,<a href=\"https://profiles.wordpress.org/rensw90\"> rensw90</a>,<a href=\"https://profiles.wordpress.org/reportermike\"> reportermike</a>,<a href=\"https://profiles.wordpress.org/rianrietveld\"> Rian Rietveld</a>,<a href=\"https://profiles.wordpress.org/riddhiehta02\"> Riddhi Mehta</a>,<a href=\"https://profiles.wordpress.org/aussieguy123\"> Robbie Cahill</a>,<a href=\"https://profiles.wordpress.org/sanchothefat\"> Robert O&#8217;Rourke</a>,<a href=\"https://profiles.wordpress.org/littlerchicken\"> Robin Cornett</a>,<a href=\"https://profiles.wordpress.org/runciters\"> runciters</a>,<a href=\"https://profiles.wordpress.org/ryan\"> Ryan Boren</a>,<a href=\"https://profiles.wordpress.org/welcher\"> Ryan Welcher</a>,<a href=\"https://profiles.wordpress.org/sagarjadhav\"> Sagar Jadhav</a>,<a href=\"https://profiles.wordpress.org/sagarkbhatt\"> sagarkbhatt</a>,<a href=\"https://profiles.wordpress.org/sagarprajapati\"> Sagar Prajapati</a>,<a href=\"https://profiles.wordpress.org/salcode\"> Sal Ferrarello</a>,<a href=\"https://profiles.wordpress.org/samantha-miller\"> Samantha Miller</a>,<a href=\"https://profiles.wordpress.org/samikeijonen\"> Sami Keijonen</a>,<a href=\"https://profiles.wordpress.org/samuelsidler\"> Samuel Sidler</a>,<a href=\"https://profiles.wordpress.org/sanketparmar\"> Sanket Parmar</a>,<a href=\"https://profiles.wordpress.org/sathyapulse\"> sathyapulse</a>,<a href=\"https://profiles.wordpress.org/sboisvert\"> sboisvert</a>,<a href=\"https://profiles.wordpress.org/coffee2code\"> Scott Reilly</a>,<a href=\"https://profiles.wordpress.org/seanchayes\"> Sean Hayes</a>,<a href=\"https://profiles.wordpress.org/sebastianpisula\"> Sebastian Pisula</a>,<a href=\"https://profiles.wordpress.org/sfpt\"> sfpt</a>,<a href=\"https://profiles.wordpress.org/sgolemon\"> sgolemon</a>,<a href=\"https://profiles.wordpress.org/shadyvb\"> Shady Sharaf</a>,<a href=\"https://profiles.wordpress.org/shashwatmittal\"> shashwatmittal</a>,<a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\"> shazahm1</a>,<a href=\"https://profiles.wordpress.org/shulard\"> shulard</a>,<a href=\"https://profiles.wordpress.org/slbmeh\"> slbmeh</a>,<a href=\"https://profiles.wordpress.org/soean\"> Soren Wrede</a>,<a href=\"https://profiles.wordpress.org/sstoqnov\"> Stanimir Stoyanov</a>,<a href=\"https://profiles.wordpress.org/stephdau\"> Stephane Daury (stephdau)</a>,<a href=\"https://profiles.wordpress.org/netweb\"> Stephen Edgar</a>,<a href=\"https://profiles.wordpress.org/stephenharris\"> Stephen Harris</a>,<a href=\"https://profiles.wordpress.org/stevenkword\"> Steven Word</a>,<a href=\"https://profiles.wordpress.org/stormrockwell\"> stormrockwell</a>,<a href=\"https://profiles.wordpress.org/sudar\"> Sudar Muthu</a>,<a href=\"https://profiles.wordpress.org/supercoder\"> Supercoder</a>,<a href=\"https://profiles.wordpress.org/cybr\"> Sybre Waaijer</a>,<a href=\"https://profiles.wordpress.org/szaqal21\"> szaqal21</a>,<a href=\"https://profiles.wordpress.org/gonom9\"> taggon</a>,<a href=\"https://profiles.wordpress.org/miyauchi\"> Takayuki Miyauchi</a>,<a href=\"https://profiles.wordpress.org/takayukister\"> Takayuki Miyoshi</a>,<a href=\"https://profiles.wordpress.org/technopolitica\"> technopolitica</a>,<a href=\"https://profiles.wordpress.org/teinertb\"> teinertb</a>,<a href=\"https://profiles.wordpress.org/tejas5989\"> tejas5989</a>,<a href=\"https://profiles.wordpress.org/terwdan\"> terwdan</a>,<a href=\"https://profiles.wordpress.org/tharsheblows\"> tharsheblows</a>,<a href=\"https://profiles.wordpress.org/themiked\"> theMikeD</a>,<a href=\"https://profiles.wordpress.org/thepelkus\"> thepelkus</a>,<a href=\"https://profiles.wordpress.org/tfrommen\"> Thorsten Frommen</a>,<a href=\"https://profiles.wordpress.org/timmydcrawford\"> Timmy Crawford</a>,<a href=\"https://profiles.wordpress.org/timothyblynjacobs\"> Timothy Jacobs</a>,<a href=\"https://profiles.wordpress.org/timph\"> timph</a>,<a href=\"https://profiles.wordpress.org/tmatsuur\"> tmatsuur</a>,<a href=\"https://profiles.wordpress.org/tomdxw\"> tomdxw</a>,<a href=\"https://profiles.wordpress.org/topher1kenobe\"> Topher</a>,<a href=\"https://profiles.wordpress.org/wpsmith\"> Travis Smith</a>,<a href=\"https://profiles.wordpress.org/triplejumper12\"> triplejumper12</a>,<a href=\"https://profiles.wordpress.org/truongwp\"> truongwp</a>,<a href=\"https://profiles.wordpress.org/tymvie\"> tymvie</a>,<a href=\"https://profiles.wordpress.org/grapplerulrich\"> Ulrich</a>,<a href=\"https://profiles.wordpress.org/utkarshpatel\"> Utkarsh</a>,<a href=\"https://profiles.wordpress.org/vaishuagola27\"> vaishu.agola27</a>,<a href=\"https://profiles.wordpress.org/vijustin\"> vijustin</a>,<a href=\"https://profiles.wordpress.org/vortfu\"> vortfu</a>,<a href=\"https://profiles.wordpress.org/wpfo\"> wpfo</a>,<a href=\"https://profiles.wordpress.org/xrmx\"> xrmx</a>,<a href=\"https://profiles.wordpress.org/ze3kr\"> ze3kr</a> und<a href=\"https://profiles.wordpress.org/h3llas\"> Zeljko Ascic</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 4.8 Release-Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://de.wordpress.org/2017/06/wordpress-4-8-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Jun 2017 05:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2672\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:365:\"Der zweite Release-Candidate (RC) für WordPress 4.8 ist verfügbar. Ihr könnt ihn über das »WordPress Beta Tester«-Plugin testen oder euch die ZIP herunterladen. Das Core-Team hat seit dem ersten RC eine Handvoll Änderungen vorgenommen. Nähere Infos zu den Neuerungen von 4.8 gibt es in den Beiträgen zu Beta 1, Beta 2 und Release-Candidate 1. Ihr [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1074:\"<p>Der zweite Release-Candidate (RC) für WordPress 4.8 ist verfügbar. Ihr könnt ihn über das »<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>«-Plugin testen oder euch <a href=\"https://wordpress.org/wordpress-4.8-RC2.zip\">die ZIP herunterladen</a>.</p>\n<p>Das Core-Team hat seit dem ersten RC <a href=\"https://core.trac.wordpress.org/log/trunk/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=40866&amp;stop_rev=40847\">eine Handvoll Änderungen</a> vorgenommen. Nähere Infos zu den Neuerungen von 4.8 gibt es in den Beiträgen zu <a href=\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-1/\">Beta 1</a>, <a href=\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-2/\">Beta 2</a> und <a href=\"https://de.wordpress.org/2017/05/wordpress-4-8-release-candidate/\">Release-Candidate 1</a>.</p>\n<p>Ihr glaubt einen Bug gefunden zu haben? Dann meldet ihn im Alpha-/Beta-Bereich des englischen Forums. Bereits bekannte Probleme werden in einer <a href=\"https://core.trac.wordpress.org/report/5\">Liste im Trac</a> aufgeführt.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.8 Release-Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://de.wordpress.org/2017/05/wordpress-4-8-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 May 2017 05:49:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2666\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"Der Release-Candidate für WordPress 4.8 ist verfügbar. Release-Candidate bedeutet, dass das Core-Team glaubt fertig zu sein, aber mit Millionen von Nutzern und tausenden Plugins und Themes ist es natürlich möglich, dass sie etwas übersehen haben. Der finale Release ist für Donnerstag, den 8. Juni, geplant, aber dafür wird eure Hilfe benötigt. Wenn ihr 4.8 noch [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2010:\"<p>Der Release-Candidate für WordPress 4.8 ist verfügbar. Release-Candidate bedeutet, dass das Core-Team glaubt fertig zu sein, aber mit Millionen von Nutzern und tausenden Plugins und Themes ist es natürlich möglich, dass sie etwas übersehen haben. Der finale Release ist für Donnerstag, den 8. Juni, geplant, aber dafür wird eure Hilfe benötigt. Wenn ihr 4.8 noch nicht getestet habt, ist es jetzt an der Zeit!<span id=\"more-2666\"></span></p>\n<p>Um die neue Version zu testen, könnt ihr das Plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> nutzen oder euch <a href=\"https://wordpress.org/wordpress-4.8-RC1.zip\">die ZIP</a> herunterladen. Seit der zweiten Beta gibt es <a href=\"https://core.trac.wordpress.org/log/trunk/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=40840&amp;stop_rev=40821\">ein paar Änderungen</a>, und mehr Details zu den Neuerungen von 4.8 gibt es in den Beiträgen zu <a href=\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-1/\">Beta 1</a> sowie <a href=\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-2/\">Beta 2</a>.</p>\n<p>Falls ihr glaubt einen Bug gefunden zu haben, meldet ihn bitte im <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha-/Beta-Bereich des Support-Forums</a>. Alle bekannten Probleme findet ihr <a href=\"https://core.trac.wordpress.org/report/5\">im Trac</a>.</p>\n<p>Wenn ihr ein Theme oder Plugin entwickelt habt, testet es mit 4.8 und erhöht die Version für <em>Tested up to</em> in der Plugin-Readme auf 4.8. Wenn ihr Probleme findet, schreibt es in das englische Support-Forum, damit das Core-Team sich das vor dem finalen Release anschauen kann – es arbeitet hart daran zu verhindern, dass Dinge kaputt gehen. Einen tiefgehenden Field-Guide mit Entwicklungs-spezifischen Änderungen wird es bald <a href=\"https://make.wordpress.org/core/\">im Core-Dev-Blog</a> geben.</p>\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev\">Helft mit, WordPress zu übersetzen</a>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.8 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 May 2017 06:36:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2664\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"Heute wurde die zweite Beta-Version von WordPress 4.8 veröffentlicht. Da es sich dabei noch um einen Entwicklungs-Release handelt, solltet ihr ihn nicht auf einer Live-Site einsetzen. Um 4.8 zu testen, könnt ihr das Plugin WordPress Beta Tester nutzen oder die ZIP herunterladen. Mehr Infos zu den Neuerungen in 4.8 gibt es im Beitrag zur ersten [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1401:\"<p>Heute wurde die zweite Beta-Version von WordPress 4.8 veröffentlicht. Da es sich dabei noch um einen Entwicklungs-Release handelt, solltet ihr ihn nicht auf einer Live-Site einsetzen. Um 4.8 zu testen, könnt ihr das Plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> nutzen oder <a href=\"https://wordpress.org/wordpress-4.8-beta2.zip\">die ZIP herunterladen</a>.</p>\n<p>Mehr Infos zu den Neuerungen in 4.8 gibt es im <a href=\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-1/\">Beitrag zur ersten Beta</a>. Seitdem wurden <a href=\"https://core.trac.wordpress.org/log/trunk/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=40819&amp;stop_rev=40664&amp;limit=100&amp;sfp_email=&amp;sfph_mail=\">über 50 Änderungen</a> für Beta 2 vorgenommen.</p>\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev\">Helft mit, WordPress in mehr als 100 Sprachen zu übersetzen</a>!</p>\n<p>Wenn ihr glaubt einen Bug gefunden zu haben, schreibt einen Beitrag im <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha-/Beta-Bereich</a> des englischen Support-Forums. Falls ihr euch damit auskennt, einen reproduzierbaren Bug-Report zu schreiben, könnt ihr das <a href=\"https://make.wordpress.org/core/reports/\">im Trac</a> tun – dort gibt es auch eine <a href=\"https://core.trac.wordpress.org/tickets/major\">Liste mit allen bekannten Bugs</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 4.7.5 Sicherheits- und Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://de.wordpress.org/2017/05/wordpress-4-7-5-sicherheits-und-wartungs-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 May 2017 05:45:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Sicherheit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2655\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:445:\"WordPress 4.7.5 wurde heute veröffentlicht. Da es sich dabei um ein Sicherheits-Release handelt, wird empfohlen, alle Versionen kleiner als 4.7.5 umgehend zu aktualisieren. WordPress 4.7.4 und älter sind von sechs Sicherheitslücken betroffen: Mangelhafte Weiterleitungs-Validierung in der HTTP-Klasse. Gemeldet von Ronni Skansing. Eine ungenaue Handhabung von Daten-Werten der Post-Meta in der XMPL-RPC-API. Gemeldet von Sam Thomas. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2537:\"<p>WordPress 4.7.5 wurde heute veröffentlicht. Da es sich dabei um ein Sicherheits-Release handelt, wird empfohlen, alle Versionen kleiner als 4.7.5 umgehend zu aktualisieren.</p>\n<p>WordPress 4.7.4 und älter sind von sechs Sicherheitslücken betroffen:</p>\n<p><span id=\"more-2655\"></span></p>\n<ul>\n<li>Mangelhafte Weiterleitungs-Validierung in der HTTP-Klasse. Gemeldet von <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a>.</li>\n<li>Eine ungenaue Handhabung von Daten-Werten der Post-Meta in der XMPL-RPC-API. Gemeldet von <a href=\"https://hackerone.com/jazzy2fives\">Sam Thomas</a>.</li>\n<li>Fehlerhafte Nutzerrechte-Überprüfung von Post-Meta-Daten in der XMPL-RPC-API. Gemeldet von <a href=\"https://profiles.wordpress.org/vortfu\">Ben Bidner</a>, Teil des WordPress Security Teams.</li>\n<li>Eine Schwachstelle  – Cross-Site-Request-Forgery (CRSF) –  wurde im Dateisystem des Anmelde-Dialogs (credentials dialog) entdeckt. Gemeldet von <a href=\"https://twitter.com/yorickkoster\">Yorick Koster</a>.</li>\n<li>Eine Schwachstelle – Cross-Site-Scripting (XSS) – wurde beim Versuch sehr große Dateien hochzuladen entdeckt. Gemeldet von <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a>.</li>\n<li>Eine weitere Cross-Site-Scripting-Lücke (XSS) wurde im Zusammenhang mit dem Customizer entdeckt. Gemeldet von <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, Teil des WordPress Security Teams.</li>\n</ul>\n<p>Danke an alle, die das verantwortlich gemäß dem <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a> gemeldet haben.</p>\n<p>Zusätzlich zu den bereits genannten Sicherheitslücken enthält WordPress 4.7.5 drei Bug-Fixes. Weitere Informationen findest du in den <a href=\"https://codex.wordpress.org/Version_4.7.5\">release notes</a> oder in dieser<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority\"> Liste der Änderungen</a>.</p>\n<p>Du kannst deine WordPress-Installation im Adminbereich mit Klick auf &#8222;Dashboard&#8220;, dann auf &#8222;Aktualisierungen&#8220; starten. Für WordPress-Websites, die das automatische Aktualisieren aktiviert haben, werden die Updates bereits ausgerollt.</p>\n<p>Danke an alle, die bei der Entwicklung von WordPress 4.7.5 mitgewirkt haben.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.8 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://de.wordpress.org/2017/05/wordpress-4-8-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 13 May 2017 08:01:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2649\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:464:\"Das WordPress-Core-Team plant einen kleineren Release für nächsten Monat, der folgende größere Neuigkeiten mitbringt: Eine verbesserte visuelle Experience im Editor durch ein TinyMCE-Update, das es vereinfacht, in Inline-Links hinein und heraus zu navigieren. Ein Update des WordPress-News-Widgets, wodurch zusätzlich zu den Neuigkeiten noch anstehende WordPress-Events angezeigt werden. Verschiedene neue Medien-Widgets für Bilder, Audio und Video [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:903:\"<p>Das WordPress-Core-Team plant einen kleineren Release für nächsten Monat, der folgende größere Neuigkeiten mitbringt:</p>\n<ul>\n<li>Eine verbesserte visuelle Experience im Editor durch ein TinyMCE-Update, das es vereinfacht, in Inline-Links hinein und heraus zu navigieren.</li>\n<li>Ein Update des WordPress-News-Widgets, wodurch zusätzlich zu den Neuigkeiten noch anstehende WordPress-Events angezeigt werden.</li>\n<li>Verschiedene neue Medien-Widgets für Bilder, Audio und Video sowie visuelle Bearbeitungsmöglichkeiten für das Text-Widget.</li>\n</ul>\n<p>Ihr könnt die Beta mit dem <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Beta-Tester-Plugin</a> installieren oder den Trunk nutzen, um die neuen Funktionen zu testen. Ziele des Releases sind die Arbeit mit Links im visuellen Editor intuitiver und Widgets für neue und bestehende User einfacher nutzbar zu machen.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.7.4 Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://de.wordpress.org/2017/04/wordpress-4-7-4-wartungs-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Apr 2017 19:03:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2618\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:474:\"Heute wurde die finale WordPress-Version 4.7.4 veröffentlicht. Das Wartungs-Release beinhaltet 47 Fehlerbereinigungen sowie Verbesserungen. Hervorzuheben sind insbesondere die Beseitigung eines Konflikts zwischen der kommenden Chrome-Version und dem visuellen Editor, ein Bugfix für Inkonsistenzen bei der Media-Handhabung sowie weitere Verbesserungen an der REST-API. Alle Änderungen können in den Release Notes und dieser kompletten Liste nachgelesen werden. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4978:\"<p>Heute wurde die finale <a href=\"https://wordpress.org/news/2017/04/wordpress-4-7-4/\">WordPress-Version 4.7.4 veröffentlicht</a>. Das Wartungs-Release beinhaltet 47 Fehlerbereinigungen sowie Verbesserungen. Hervorzuheben sind insbesondere die Beseitigung eines Konflikts zwischen der kommenden Chrome-Version und dem visuellen Editor, ein Bugfix für Inkonsistenzen bei der Media-Handhabung sowie weitere Verbesserungen an der REST-API. Alle Änderungen können in den <a href=\"https://codex.wordpress.org/Version_4.7.4\">Release Notes</a> und dieser <a href=\"https://core.trac.wordpress.org/log/branches/4.7?rev=40487&amp;stop_rev=40224\">kompletten Liste</a> nachgelesen werden.</p>\n<p><span id=\"more-2618\"></span></p>\n<p>Du kannst das Update auf WordPress 4.7.4 entweder im Adminbereich über das Dashboard -&gt; Aktualisierungen und dem Klick auf den Button &#8222;Jetzt aktualisieren&#8220; durchführen oder WordPress 4.7.4 <a href=\"https://wordpress.org/download/\">hier herunterladen</a>.</p>\n<p>Für Websites, bei denen die automatischen Hintergrund-Updates entsprechend <a href=\"https://de.wordpress.org/2015/04/die-hintergrund-updates-von-wordpress-was-genau-passiert-da-eigentlich/\">konfiguriert sind</a>, werden die Updates bereits ausgerollt und das System wird automatisch aktualisiert.</p>\n<p>Vielen Dank an alle, die ihren Teil zur Entwicklung von WordPress 4.7.4 beigesteuert haben:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aussieguy123/\">aussieguy123</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">Blobfolio</a>, <a href=\"https://profiles.wordpress.org/boldwater/\">boldwater</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a>, <a href=\"https://profiles.wordpress.org/chesio/\">chesio</a>, <a href=\"https://profiles.wordpress.org/curdin/\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy/\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/davidbenton/\">davidbenton</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ghosttoast/\">Gustave F. Gerhardt</a>, <a href=\"https://profiles.wordpress.org/ig_communitysites/\">ig_communitysites</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/karinedo/\">karinedo</a>, <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a>, <a href=\"https://profiles.wordpress.org/maguiar/\">maguiar</a>, <a href=\"https://profiles.wordpress.org/matheusgimenez/\">MatheusGimenez</a>, <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mayurk/\">Mayur Keshwani</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/delawski/\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pratikshrestha/\">Pratik Shrestha</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/sagarkbhatt/\">sagarkbhatt</a>, <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a>, <a href=\"https://profiles.wordpress.org/sboisvert/\">sboisvert</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford/\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, und <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 4.7.4 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://de.wordpress.org/2017/04/wordpress-4-7-4-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Apr 2017 19:52:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Entwicklung\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2610\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:416:\"Nach sechs Wochen der Entwicklung ist jetzt ein Release Candidate für WordPress 4.7.4 verfügbar. Dieser Wartungs-Release behebt 46 Bugs, die für 4.7 gemeldet wurden. Die finale Version wird voraussichtlich am Donnerstag, den 20. April 2017 veröffentlicht. Der Status Release Candidate kennzeichnet eine nahezu fertige Entwicklung, die jedoch noch letzten Überprüfungen unterzogen werden muss, um nach [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Angelika Reisiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2964:\"<p>Nach sechs Wochen der Entwicklung ist jetzt ein <a href=\"https://make.wordpress.org/core/2017/04/18/4-7-4-release-candidate/\">Release Candidate für WordPress 4.7.4</a> verfügbar. Dieser Wartungs-Release behebt 46 Bugs, die für 4.7 gemeldet wurden. Die finale Version wird voraussichtlich am Donnerstag, den 20. April 2017 veröffentlicht.</p>\n<p><span id=\"more-2610\"></span></p>\n<p>Der Status Release Candidate kennzeichnet eine nahezu fertige Entwicklung, die jedoch noch letzten Überprüfungen unterzogen werden muss, um nach Möglichkeit die Kompatibilität mit Tausenden von Plugins und Themes zu gewährleisten.</p>\n<p>Seit dem Release von WordPress 4.7 am 6. Dezember 2016 wurde die Version 4.7.x  <a href=\"https://wordpress.org/download/counter/?branch=4.7\">fast 60 Millionen Mal heruntergeladen</a>. Bitte hilf mit und teste den aktuellen Release Candidate um eventuell noch vorhandene Bugs zu finden und sicherzustellen, dass diese bis zur finalen Version behoben sind.</p>\n<h2>So kannst du mithelfen</h2>\n<p>Wie zuvor bereits angedeutet sind Release Candidates nicht für den Einsatz auf öffentlichen Websites geeignet. Jetzt ist hingegen die beste Zeit für das Testen von WordPress 4.7.4 (RC), um bereits im Vorfeld Unverträglichkeiten mit den eingesetzten Erweiterungen oder Themes zu erkennen und diese sowie auch Bugs im RC in dem<a href=\"https://wordpress.org/support/forum/alphabeta\"> Alpha/Beta Bereich</a> der Support-Foren zu melden. Installiere dafür entweder das Plugin<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> oder den<a href=\"https://wordpress.org/wordpress-4.7.4-RC1.zip\"> Release Candidate</a> (zip).</p>\n<p>Solltest du damit vertraut sein, einen reproduzierbaren Bug-Report zu schreiben, erstelle bitte ein Ticket im<a href=\"https://make.wordpress.org/core/reports/\"> WordPress Trac</a>. Dort kannst du außerdem eine<a href=\"https://make.wordpress.org/core/reports/\"> Liste aller bereits gemeldeten Fehler</a> einsehen.</p>\n<h2>Beachtenswerte Bug Fixes</h2>\n<p>Es existieren ein paar nennenswerte Probleme, die mit dem Release gefixt werden Das erste betrifft defekte Video-/Audio-Thumbnails, wenn eine Mediendatei hochgeladen wird (<a href=\"https://core.trac.wordpress.org/ticket/40075\">#40075</a>). Außerdem besteht eine Inkompatibilität zwischen der kommenden Chrome-Version und dem visuellen Editor (<a href=\"https://core.trac.wordpress.org/ticket/40305\">#40305</a>), die durch die Aktualisierung des TinyMCE-Editors behoben wurde. Ferner hat die REST-API Verbesserungen in Relation zur Daten-Handhabung erhalten (<a href=\"https://core.trac.wordpress.org/ticket/39854\">#39854</a>,<a href=\"https://core.trac.wordpress.org/ticket/40136\"> #40136</a>).</p>\n<h2>Alle Änderungen</h2>\n<p>Die Liste der geschlossenen Tickets findest du in der <a href=\"https://make.wordpress.org/core/2017/04/18/4-7-4-release-candidate/\">offiziellen Ankündigung</a> des Release Candidates.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 4.7.3 Sicherheits- und Wartungs-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://de.wordpress.org/2017/03/wordpress-4-7-3-sicherheits-und-wartungs-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Mar 2017 18:59:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Sicherheit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://de.wordpress.org/?p=2549\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:463:\"Heute wurde WordPress 4.7.3 veröffentlicht. Dabei handelt es sich um einen Sicherheits-Release für alle vorherigen Versionen, weshalb ein Update stark empfohlen wird. WordPress 4.7.2 und früher sind von sechs Sicherheitslücken betroffen: Cross-Site-Scripting-Lücke über Metadaten von Medien-Dateien. Gemeldet von Chris Andrè Dale, Yorick Koster und Simon P. Briggs. Control-Zeichen können die URL-Validierung für Redirects austricksen. Gemeldet [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Florian Brinkmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6272:\"<p>Heute wurde WordPress 4.7.3 veröffentlicht. Dabei handelt es sich um einen Sicherheits-Release für alle vorherigen Versionen, weshalb ein Update stark empfohlen wird.</p>\n<p><span id=\"more-2549\"></span></p>\n<p>WordPress 4.7.2 und früher sind von sechs Sicherheitslücken betroffen:</p>\n<ol>\n<li>Cross-Site-Scripting-Lücke über Metadaten von Medien-Dateien. Gemeldet von<a href=\"https://www.securesolutions.no/\"> Chris Andrè Dale</a>,<a href=\"https://twitter.com/yorickkoster\"> Yorick Koster</a> und Simon P. Briggs.</li>\n<li>Control-Zeichen können die URL-Validierung für Redirects austricksen. Gemeldet von <a href=\"http://www.danielchatfield.com/\">Daniel Chatfield</a>.</li>\n<li>Administratoren können ungewollte Dateien über die Löschfunktion für Plugins entfernen. Gemeldet von <a href=\"http://b.360.cn/\">xuliang</a>.</li>\n<li>Cross-Site-Scripting-Lücke via Video-URLs in YouTube-Embeds. Gemeldet von <a href=\"https://profiles.wordpress.org/ddsucurinet/\">Daniel Cid</a>.</li>\n<li>Cross-Site-Scripting-Lücke über Namen von Taxonomie-Termen. Gemeldet von <a href=\"https://profiles.wordpress.org/deltamgm2\">Delta</a>.</li>\n<li>Cross-Site-Request-Forgery in <i>Press This</i>, was zu exzessiver Nutzung von Server-Ressourcen führt. Gemeldet von Sipke Mellema.</li>\n</ol>\n<p>Vielen Dank für den <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">verantwortungsbewussten Umgang</a> mit dem Wissen über die Sicherheitslücken.</p>\n<p>Zusätzlich zu den Sicherheits-Fixes enthält WordPress 4.7.3 noch 39 Bugfixes. Für mehr Infos könnt ihr euch die <a href=\"https://codex.wordpress.org/Version_4.7.3\">Release-Notes</a> oder die <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.3&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority\">Liste aller Änderungen anschauen</a>.</p>\n<p>Falls ihr automatische Updates deaktiviert habt, oder sie noch nicht bei euch angekommen sind, könnt ihr einfach über das Backend auf die neue Version aktualisieren. <a href=\"https://de.wordpress.org/\">Herunterladen könnt ihr euch die neue Version direkt hier von der Startseite</a>.</p>\n<p>Danke an alle, die zu 4.7.3 beigetragen haben: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>,<a href=\"https://profiles.wordpress.org/adamsilverstein/\"> Adam Silverstein</a>,<a href=\"https://profiles.wordpress.org/xknown/\"> Alex Concha</a>,<a href=\"https://profiles.wordpress.org/afercia/\"> Andrea Fercia</a>,<a href=\"https://profiles.wordpress.org/azaozz/\"> Andrew Ozz</a>,<a href=\"https://profiles.wordpress.org/asalce/\"> asalce</a>,<a href=\"https://profiles.wordpress.org/blobfolio/\"> blobfolio</a>,<a href=\"https://profiles.wordpress.org/gitlost/\"> bonger</a>,<a href=\"https://profiles.wordpress.org/boonebgorges/\"> Boone Gorges</a>,<a href=\"https://profiles.wordpress.org/bor0/\"> Boro Sitnikovski</a>,<a href=\"https://profiles.wordpress.org/bradyvercher/\"> Brady Vercher</a>,<a href=\"https://profiles.wordpress.org/drrobotnik/\"> Brandon Lavigne</a>,<a href=\"https://profiles.wordpress.org/bhargavbhandari90/\"> Bunty</a>,<a href=\"https://profiles.wordpress.org/ccprog/\"> ccprog</a>,<a href=\"https://profiles.wordpress.org/ketuchetan/\"> chetansatasiya</a>,<a href=\"https://profiles.wordpress.org/davidakennedy/\"> David A. Kennedy</a>,<a href=\"https://profiles.wordpress.org/dlh/\"> David Herrera</a>,<a href=\"https://profiles.wordpress.org/dhanendran/\"> Dhanendran</a>,<a href=\"https://profiles.wordpress.org/dd32/\"> Dion Hulse</a>,<a href=\"https://profiles.wordpress.org/ocean90/\"> Dominik Schilling (ocean90)</a>,<a href=\"https://profiles.wordpress.org/drivingralle/\"> Drivingralle</a>,<a href=\"https://profiles.wordpress.org/iseulde/\"> Ella Van Dorpe</a>,<a href=\"https://profiles.wordpress.org/pento/\"> Gary Pendergast</a>,<a href=\"https://profiles.wordpress.org/iandunn/\"> Ian Dunn</a>,<a href=\"https://profiles.wordpress.org/ipstenu/\"> Ipstenu (Mika Epstein)</a>,<a href=\"https://profiles.wordpress.org/jnylen0/\"> James Nylen</a>,<a href=\"https://profiles.wordpress.org/jazbek/\"> jazbek</a>,<a href=\"https://profiles.wordpress.org/jeremyfelt/\"> Jeremy Felt</a>,<a href=\"https://profiles.wordpress.org/jpry/\"> Jeremy Pry</a>,<a href=\"https://profiles.wordpress.org/joehoyle/\"> Joe Hoyle</a>,<a href=\"https://profiles.wordpress.org/joemcgill/\"> Joe McGill</a>,<a href=\"https://profiles.wordpress.org/johnbillion/\"> John Blackbourn</a>,<a href=\"https://profiles.wordpress.org/johnjamesjacoby/\"> John James Jacoby</a>,<a href=\"https://profiles.wordpress.org/desrosj/\"> Jonathan Desrosiers</a>,<a href=\"https://profiles.wordpress.org/ryelle/\"> Kelly Dwan</a>,<a href=\"https://profiles.wordpress.org/markoheijnen/\"> Marko Heijnen</a>,<a href=\"https://profiles.wordpress.org/matheusgimenez/\"> MatheusGimenez</a>,<a href=\"https://profiles.wordpress.org/mnelson4/\"> Mike Nelson</a>,<a href=\"https://profiles.wordpress.org/mikeschroder/\"> Mike Schroder</a>,<a href=\"https://profiles.wordpress.org/codegeass/\"> Muhammet Arslan</a>,<a href=\"https://profiles.wordpress.org/celloexpressions/\"> Nick Halsey</a>,<a href=\"https://profiles.wordpress.org/swissspidy/\"> Pascal Birchler</a>,<a href=\"https://profiles.wordpress.org/pbearne/\"> Paul Bearne</a>,<a href=\"https://profiles.wordpress.org/pavelevap/\"> pavelevap</a>,<a href=\"https://profiles.wordpress.org/peterwilsoncc/\"> Peter Wilson</a>,<a href=\"https://profiles.wordpress.org/rachelbaker/\"> Rachel Baker</a>,<a href=\"https://profiles.wordpress.org/reldev/\"> reldev</a>,<a href=\"https://profiles.wordpress.org/sanchothefat/\"> Robert O’Rourke</a>,<a href=\"https://profiles.wordpress.org/welcher/\"> Ryan Welcher</a>,<a href=\"https://profiles.wordpress.org/sanketparmar/\"> Sanket Parmar</a>,<a href=\"https://profiles.wordpress.org/seanchayes/\"> Sean Hayes</a>,<a href=\"https://profiles.wordpress.org/sergeybiryukov/\"> Sergey Biryukov</a>,<a href=\"https://profiles.wordpress.org/netweb/\"> Stephen Edgar</a>,<a href=\"https://profiles.wordpress.org/triplejumper12/\"> triplejumper12</a>,<a href=\"https://profiles.wordpress.org/westonruter/\"> Weston Ruter</a> und<a href=\"https://profiles.wordpress.org/wpfo/\"> wpfo</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:47:\"https://de.wordpress.org/category/release/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 25 Aug 2017 17:04:38 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 12 Aug 2017 13:09:03 GMT\";s:4:\"link\";s:61:\"<https://de.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}}s:5:\"build\";s:14:\"20160706173034\";}", "no");
INSERT INTO `wp_options` VALUES("13573", "_transient_timeout_feed_mod_e5132d2944a7be60661ee809629a6d9c", "1503723879", "no");
INSERT INTO `wp_options` VALUES("13574", "_transient_feed_mod_e5132d2944a7be60661ee809629a6d9c", "1503680679", "no");
INSERT INTO `wp_options` VALUES("13575", "_transient_timeout_feed_8d5c87fbe8c82bb2500f5d58f08a433a", "1503723879", "no");
INSERT INTO `wp_options` VALUES("13576", "_transient_feed_8d5c87fbe8c82bb2500f5d58f08a433a", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:2:\"\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:4:\"0.92\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:37:\"\n	\n	\n	\n	\n	\n	\n\n	\n\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Deutschsprachiger Channel – WordPress Deutsch Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"http://de.planetwp.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Der Planet listet Inhalte ausgewählter Blogs auf, die regelmäßig Beiträge zu WordPress publizieren.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 19 Aug 2017 05:57:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"docs\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"http://backend.userland.com/rss092\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"de-DE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"12 Dinge, die du machen kannst, um mehr Blogleser zu bekommen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://www.elmastudio.de/12-dinge-die-du-machen-kannst-um-mehr-blogleser-zu-bekommen/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Was erwartet uns in WordPress 4.9?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://www.perun.net/2017/08/18/was-erwartet-uns-in-wordpress-4-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress-Themes mit Twig und Timber erstellen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://tracking.feedpress.it/link/14418/6526647\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Webschale: Visual Editor deaktivieren\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://webschale.de/2017/visual-editor-deaktivieren/?pk_campaign=feed&pk_kwd=visual-editor-deaktivieren\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WordPress Suche im Navigationsmenü einbauen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://themecoder.de/2017/08/17/wordpress-suche-im-navigationsmenue-einbauen/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WWP Folge 15: WordPress-Caching für Einsteiger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://www.perun.net/2017/08/16/wwp-folge-15-wordpress-caching-fuer-einsteiger/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Unscharfe Beitragsbilder nachschärfen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://die-netzialisten.de/wordpress/unscharfe-beitragsbilder-nachschaerfen/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"capital_P_odcast: CP002 – Die WordPress-Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://capital-p.de/cp002-die-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Webschale: WordPress ist nicht WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://webschale.de/2017/wordpress-ist-nicht-wordpress-com/?pk_campaign=feed&pk_kwd=wordpress-ist-nicht-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n		\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WordPress News #210 / Performance, WordPress.com und ein neuer WP Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://tracking.feedpress.it/link/14399/6491110\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:8;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:7:{s:4:\"date\";s:29:\"Fri, 25 Aug 2017 17:04:39 GMT\";s:6:\"server\";s:6:\"Apache\";s:12:\"x-powered-by\";s:9:\"PHP/7.0.0\";s:4:\"etag\";s:34:\"\"ea9a5bd31045a4437b8219b0198d5d2b\"\";s:4:\"link\";s:59:\"<http://de.planetwp.org/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"last-modified\";s:29:\"Sat, 19 Aug 2017 05:57:00 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";}}s:5:\"build\";s:14:\"20160706173034\";}", "no");
INSERT INTO `wp_options` VALUES("13577", "_transient_timeout_feed_mod_8d5c87fbe8c82bb2500f5d58f08a433a", "1503723879", "no");
INSERT INTO `wp_options` VALUES("13578", "_transient_feed_mod_8d5c87fbe8c82bb2500f5d58f08a433a", "1503680679", "no");
INSERT INTO `wp_options` VALUES("13579", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1503723882", "no");
INSERT INTO `wp_options` VALUES("13580", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Popular — WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wordpress.org/plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Plugins extend and expand the functionality of WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 Aug 2017 16:45:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.9-alpha-41314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/contact-form-7/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:43:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins-wp/contact-form-7/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5872:\"<p><!--section=description--></p>\n<p>Contact Form 7 can manage multiple contact forms, plus you can customize the form and the mail contents flexibly with simple markup. The form supports Ajax-powered submitting, CAPTCHA, Akismet spam filtering and so on.</p>\n<h4>Docs &amp; Support</h4>\n<p>You can find <a href=\"https://contactform7.com/docs/\" rel=\"nofollow\">docs</a>, <a href=\"https://contactform7.com/faq/\" rel=\"nofollow\">FAQ</a> and more detailed information about Contact Form 7 on <a href=\"https://contactform7.com/\" rel=\"nofollow\">contactform7.com</a>. If you were unable to find the answer to your question on the FAQ or in any of the documentation, you should check the <a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"nofollow\">support forum</a> on WordPress.org. If you can&#8217;t locate any topics that pertain to your particular issue, post a new topic for it.</p>\n<h4>Contact Form 7 Needs Your Support</h4>\n<p>It is hard to continue development and support for this free plugin without contributions from users like you. If you enjoy using Contact Form 7 and find it useful, please consider <a href=\"https://contactform7.com/donate/\" rel=\"nofollow\"><strong>making a donation</strong></a>. Your donation will help encourage and support the plugin&#8217;s continued development and better user support.</p>\n<h4>Recommended Plugins</h4>\n<p>The following plugins are recommended for Contact Form 7 users:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/flamingo/\">Flamingo</a> by Takayuki Miyoshi &#8211; With Flamingo, you can save submitted messages via contact forms in the database.</li>\n<li><a href=\"https://wordpress.org/plugins/postman-smtp/\">Postman</a> by<br />\nJason Hendriks &#8211; Postman is a next-generation SMTP Mailer, software that assists in the delivery of email generated by your WordPress site.</li>\n<li><a href=\"https://wordpress.org/plugins/bogo/\">Bogo</a> by Takayuki Miyoshi &#8211; Bogo is a straight-forward multilingual plugin that doesn&#8217;t cause headaches.</li>\n</ul>\n<h4>Translations</h4>\n<p>You can <a href=\"https://contactform7.com/translating-contact-form-7/\" rel=\"nofollow\">translate Contact Form 7</a> on <a href=\"https://translate.wordpress.org/projects/wp-plugins/contact-form-7\" rel=\"nofollow\"><strong>translate.wordpress.org</strong></a>.</p>\n<p><!--section=installation--></p>\n<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n</ol>\n<p>You will find &#8216;Contact&#8217; menu in your WordPress admin panel.</p>\n<p>For basic usage, you can also have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow\">plugin web site</a>.</p>\n<p><!--section=faq--></p>\n<p>Do you have questions or issues with Contact Form 7? Use these support channels appropriately.</p>\n<ol>\n<li><a href=\"https://contactform7.com/docs/\" rel=\"nofollow\">Docs</a></li>\n<li><a href=\"https://contactform7.com/faq/\" rel=\"nofollow\">FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"nofollow\">Support Forum</a></li>\n</ol>\n<p><a href=\"https://contactform7.com/support/\" rel=\"nofollow\">Support</a></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n</ol>\n<p>You will find &#8216;Contact&#8217; menu in your WordPress admin panel.</p>\n<p>For basic usage, you can also have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow\">plugin web site</a>.</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<p>For more information, see <a href=\"https://contactform7.com/category/releases/\" rel=\"nofollow\">Releases</a>.</p>\n<h4>4.9</h4>\n<ul>\n<li>Supports subscribers_only setting</li>\n<li>Changes the default value of WPCF7_VERIFY_NONCE to false</li>\n<li>WPCF7_FormTagsManager::collect_tag_types() supports invert option</li>\n<li>New filter hooks: wpcf7_verify_nonce, wpcf7_subscribers_only_notice, wpcf7_remote_ip_addr, and wpcf7_submission_is_blacklisted</li>\n<li>Fixed: Form-tag&#8217;s tabindex option did not accept 0 or negative integer values</li>\n<li>Shows a validation error when no option in a radio buttons group is checked</li>\n<li>Config validator: Adds a validation rule against the use of deprecated settings (on_sent_ok and on_submit)</li>\n<li>Allows to pass the skip_mail option through the WPCF7_ContactForm::submit() and WPCF7_Submission::get_instance() function parameters.</li>\n<li>Triggers wpcf7beforesubmit custom DOM event. You can manipulate the formData object through an event handler.</li>\n</ul>\n<h4>4.8.1</h4>\n<ul>\n<li>wpcf7.initForm JavaScript function added to isolate form initialization process.</li>\n<li>Fix response message duplication caused by repeated click on submit button.</li>\n<li>Clear $phpmailer-&gt;AltBody to avoid unintended inheritance from previous wp_mail() calls.</li>\n<li>Fix incorrect character count of textarea input.</li>\n<li>Akismet: Exclude the comment_author, comment_author_email, and comment_author_url values from the comment_content value.</li>\n<li>REST API: More reliable approach to build route URLs.</li>\n<li>Include free_text inputs into event.detail.inputs.</li>\n</ul>\n<h4>4.8</h4>\n<ul>\n<li>Stopped using jquery.form.js.</li>\n<li>Added custom REST API endpoints for Ajax form submissions.</li>\n<li>WPCF7_FormTag class implements ArrayAccess interface.</li>\n<li>WPCF7_FormTagsManager::filter() filters form-tags based on features they support.</li>\n<li>New form-tag features: do-not-store, display-block, and display-hidden</li>\n<li>Removed inappropriate content from h1 headings.</li>\n<li>Added the support of size:invisible option to the reCAPTCHA form-tag.</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/contact-form-7/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/akismet/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Oct 2005 08:57:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/plugins-wp/akismet/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Akismet checks your comments and contact form submissions against our global database of spam to&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:19395:\"<p><!--section=description--></p>\n<p>Akismet checks your comments and contact form submissions against our global database of spam to prevent your site from publishing malicious content. You can review the comment spam it catches on your blog&#8217;s &#8220;Comments&#8221; admin screen.</p>\n<p>Major features in Akismet include:</p>\n<ul>\n<li>Automatically checks all comments and filters out the ones that look like spam.</li>\n<li>Each comment has a status history, so you can easily see which comments were caught or cleared by Akismet and which were spammed or unspammed by a moderator.</li>\n<li>URLs are shown in the comment body to reveal hidden or misleading links.</li>\n<li>Moderators can see the number of approved comments for each user.</li>\n<li>A discard feature that outright blocks the worst spam, saving you disk space and speeding up your site.</li>\n</ul>\n<p>PS: You&#8217;ll need an <a href=\"https://akismet.com/get/\" rel=\"nofollow\">Akismet.com API key</a> to use it.  Keys are free for personal blogs; paid subscriptions are available for businesses and commercial sites.</p>\n<p><!--section=installation--></p>\n<p>Upload the Akismet plugin to your blog, Activate it, then enter your <a href=\"https://akismet.com/get/\" rel=\"nofollow\">Akismet.com API key</a>.</p>\n<p>1, 2, 3: You&#8217;re done!</p>\n<p><!--section=changelog--></p>\n<h4>3.3.4</h4>\n<ul>\n<li>Disabled Akismet&#8217;s debug log output by default unless AKISMET_DEBUG is defined.</li>\n<li>URL previews now begin preloading when the mouse moves near them in the comments section of wp-admin.</li>\n<li>When a comment is caught by the Comment Blacklist, Akismet will always allow it to stay in the trash even if it is spam as well.</li>\n<li>Fixed a bug that was preventing an error from being shown when a site can&#8217;t reach Akismet&#8217;s servers.</li>\n</ul>\n<h4>3.3.3</h4>\n<p><em>Release Date &#8211; 13 July 2017</em></p>\n<ul>\n<li>Reduced amount of bandwidth used by the URL Preview feature.</li>\n<li>Improved the admin UI when the API key is manually pre-defined for the site.</li>\n<li>Removed a workaround for WordPress installations older than 3.3 that will improve Akismet&#8217;s compatibility with other plugins.</li>\n<li>The number of spam blocked that is displayed on the WordPress dashboard will now be more accurate and updated more frequently.</li>\n<li>Fixed a bug in the Akismet widget that could cause PHP warnings.</li>\n</ul>\n<h4>3.3.2</h4>\n<p><em>Release Date &#8211; 10 May 2017</em></p>\n<ul>\n<li>Fixed a bug causing JavaScript errors in some browsers.</li>\n</ul>\n<h4>3.3.1</h4>\n<p><em>Release Date &#8211; 2 May 2017</em></p>\n<ul>\n<li>Improve performance by only requesting the akismet_comment_nonce option when absolutely necessary.</li>\n<li>Fixed two bugs that could cause PHP warnings.</li>\n<li>Fixed a bug that was preventing the &#8220;Remove author URL&#8221; feature from working after a comment was edited using &#8220;Quick Edit.&#8221;</li>\n<li>Fixed a bug that was preventing the URL preview feature from working after a comment was edited using &#8220;Quick Edit.&#8221;</li>\n</ul>\n<h4>3.3</h4>\n<p><em>Release Date &#8211; 23 February 2017</em></p>\n<ul>\n<li>Updated the Akismet admin pages with a new clean design.</li>\n<li>Fixed bugs preventing the <code>akismet_add_comment_nonce</code> and <code>akismet_update_alert</code> wrapper functions from working properly.</li>\n<li>Fixed bug preventing the loading indicator from appearing when re-checking all comments for spam.</li>\n<li>Added a progress indicator to the &#8220;Check for Spam&#8221; button.</li>\n<li>Added a success message after manually rechecking the Pending queue for spam.</li>\n</ul>\n<h4>3.2</h4>\n<p><em>Release Date &#8211; 6 September 2016</em></p>\n<ul>\n<li>Added a WP-CLI module. You can now check comments and recheck the moderation queue from the command line.</li>\n<li>Stopped using the deprecated jQuery function <code>.live()</code>.</li>\n<li>Fixed a bug in <code>remove_comment_author_url()</code> and <code>add_comment_author_url()</code> that could generate PHP notices.</li>\n<li>Fixed a bug that could cause an infinite loop for sites with very very very large comment IDs.</li>\n<li>Fixed a bug that could cause the Akismet widget title to be blank.</li>\n</ul>\n<h4>3.1.11</h4>\n<p><em>Release Date &#8211; 12 May 2016</em></p>\n<ul>\n<li>Fixed a bug that could cause the &#8220;Check for Spam&#8221; button to skip some comments.</li>\n<li>Fixed a bug that could prevent some spam submissions from being sent to Akismet.</li>\n<li>Updated all links to use https:// when possible.</li>\n<li>Disabled Akismet debug logging unless WP_DEBUG and WP_DEBUG_LOG are both enabled.</li>\n</ul>\n<h4>3.1.10</h4>\n<p><em>Release Date &#8211; 1 April 2016</em></p>\n<ul>\n<li>Fixed a bug that could cause comments caught as spam to be placed in the Pending queue.</li>\n<li>Fixed a bug that could have resulted in comments that were caught by the core WordPress comment blacklist not to have a corresponding History entry.</li>\n<li>Fixed a bug that could have caused avoidable PHP warnings in the error log.</li>\n</ul>\n<h4>3.1.9</h4>\n<p><em>Release Date &#8211; 28 March 2016</em></p>\n<ul>\n<li>Add compatibility with Jetpack so that Jetpack can automatically configure Akismet settings when appropriate.</li>\n<li>Fixed a bug preventing some comment data from being sent to Akismet.</li>\n</ul>\n<h4>3.1.8</h4>\n<p><em>Release Date &#8211; 4 March 2016</em></p>\n<ul>\n<li>Fixed a bug preventing Akismet from being used with some plugins that rewrite admin URLs.</li>\n<li>Reduced the amount of bandwidth used on Akismet API calls</li>\n<li>Reduced the amount of space Akismet uses in the database</li>\n<li>Fixed a bug that could cause comments caught as spam to be placed in the Pending queue.</li>\n</ul>\n<h4>3.1.7</h4>\n<p><em>Release Date &#8211; 4 January 2016</em></p>\n<ul>\n<li>Added documentation for the &#8216;akismet_comment_nonce&#8217; filter.</li>\n<li>The post-install activation button is now accessible to screen readers and keyboard-only users.</li>\n<li>Fixed a bug that was preventing the &#8220;Remove author URL&#8221; feature from working in WordPress 4.4</li>\n</ul>\n<h4>3.1.6</h4>\n<p><em>Release Date &#8211; 14 December 2015</em></p>\n<ul>\n<li>Improve the notices shown after activating Akismet.</li>\n<li>Update some strings to allow for the proper plural forms in all languages.</li>\n</ul>\n<h4>3.1.5</h4>\n<p><em>Release Date &#8211; 13 October 2015</em></p>\n<ul>\n<li>Closes a potential XSS vulnerability.</li>\n</ul>\n<h4>3.1.4</h4>\n<p><em>Release Date &#8211; 24 September 2015</em></p>\n<ul>\n<li>Fixed a bug that was preventing some users from automatically connecting using Jetpack if they didn&#8217;t have a current Akismet subscription.</li>\n<li>Fixed a bug that could cause comments caught as spam to be placed in the Pending queue.</li>\n<li>Error messages and instructions have been simplified to be more understandable.</li>\n<li>Link previews are enabled for all links inside comments, not just the author&#8217;s website link.</li>\n</ul>\n<h4>3.1.3</h4>\n<p><em>Release Date &#8211; 6 July 2015</em></p>\n<ul>\n<li>Notify users when their account status changes after previously being successfully set up. This should help any users who are seeing blank Akismet settings screens.</li>\n</ul>\n<h4>3.1.2</h4>\n<p><em>Release Date &#8211; 7 June 2015</em></p>\n<ul>\n<li>Reduced the amount of space Akismet uses in the commentmeta table.</li>\n<li>Fixed a bug where some comments with quotes in the author name weren&#8217;t getting history entries</li>\n<li>Pre-emptive security improvements to ensure that the Akismet plugin can&#8217;t be used by attackers to compromise a WordPress installation.</li>\n<li>Better UI for the key entry field: allow whitespace to be included at the beginning or end of the key and strip it out automatically when the form is submitted.</li>\n<li>When deactivating the plugin, notify the Akismet API so the site can be marked as inactive.</li>\n<li>Clearer error messages.</li>\n</ul>\n<h4>3.1.1</h4>\n<p><em>Release Date &#8211; 17th March, 2015</em></p>\n<ul>\n<li>Improvements to the &#8220;Remove comment author URL&#8221; JavaScript</li>\n<li>Include the pingback pre-check from the 2.6 branch.</li>\n</ul>\n<h4>3.1</h4>\n<p><em>Release Date &#8211; 11th March, 2015</em></p>\n<ul>\n<li>Use HTTPS by default for all requests to Akismet.</li>\n<li>Fix for a situation where Akismet might strip HTML from a comment.</li>\n</ul>\n<h4>3.0.4</h4>\n<p><em>Release Date &#8211; 11th December, 2014</em></p>\n<ul>\n<li>Fix to make .htaccess compatible with Apache 2.4.</li>\n<li>Fix to allow removal of https author URLs.</li>\n<li>Fix to avoid stripping part of the author URL when removing and re-adding.</li>\n<li>Removed the &#8220;Check for Spam&#8221; button from the &#8220;Trash&#8221; and &#8220;Approved&#8221; queues, where it would have no effect.</li>\n<li>Allow automatic API key configuration when Jetpack is installed and connected to a WordPress.com account</li>\n</ul>\n<h4>3.0.3</h4>\n<p><em>Release Date &#8211; 3rd November, 2014</em></p>\n<ul>\n<li>Fix for sending the wrong data to delete_comment action that could have prevented old spam comments from being deleted.</li>\n<li>Added a filter to disable logging of Akismet debugging information.</li>\n<li>Added a filter for the maximum comment age when deleting old spam comments.</li>\n<li>Added a filter for the number per batch when deleting old spam comments.</li>\n<li>Removed the &#8220;Check for Spam&#8221; button from the Spam folder.</li>\n</ul>\n<h4>3.0.2</h4>\n<p><em>Release Date &#8211; 18th August, 2014</em></p>\n<ul>\n<li>Performance improvements.</li>\n<li>Fixed a bug that could truncate the comment data being sent to Akismet for checking.</li>\n</ul>\n<h4>3.0.1</h4>\n<p><em>Release Date &#8211; 9th July, 2014</em></p>\n<ul>\n<li>Removed dependency on PHP&#8217;s fsockopen function</li>\n<li>Fix spam/ham reports to work when reported outside of the WP dashboard, e.g., from Notifications or the WP app</li>\n<li>Remove jQuery dependency for comment form JavaScript</li>\n<li>Remove unnecessary data from some Akismet comment meta</li>\n<li>Suspended keys will now result in all comments being put in moderation, not spam.</li>\n</ul>\n<h4>3.0.0</h4>\n<p><em>Release Date &#8211; 15th April, 2014</em></p>\n<ul>\n<li>Move Akismet to Settings menu</li>\n<li>Drop Akismet Stats menu</li>\n<li>Add stats snapshot to Akismet settings</li>\n<li>Add Akismet subscription details and status to Akismet settings</li>\n<li>Add contextual help for each page</li>\n<li>Improve Akismet setup to use Jetpack to automate plugin setup</li>\n<li>Fix &#8220;Check for Spam&#8221; to use AJAX to avoid page timing out</li>\n<li>Fix Akismet settings page to be responsive</li>\n<li>Drop legacy code</li>\n<li>Tidy up CSS and Javascript</li>\n<li>Replace the old discard setting with a new &#8220;discard pervasive spam&#8221; feature.</li>\n</ul>\n<h4>2.6.0</h4>\n<p><em>Release Date &#8211; 18th March, 2014</em></p>\n<ul>\n<li>Add ajax paging to the check for spam button to handle large volumes of comments</li>\n<li>Optimize javascript and add localization support </li>\n<li>Fix bug in link to spam comments from right now dashboard widget</li>\n<li>Fix bug with deleting old comments to avoid timeouts dealing with large volumes of comments</li>\n<li>Include X-Pingback-Forwarded-For header in outbound WordPress pingback verifications</li>\n<li>Add pre-check for pingbacks, to stop spam before an outbound verification request is made</li>\n</ul>\n<h4>2.5.9</h4>\n<p><em>Release Date &#8211; 1st August, 2013</em></p>\n<ul>\n<li>Update &#8216;Already have a key&#8217; link to redirect page rather than depend on javascript</li>\n<li>Fix some non-translatable strings to be translatable</li>\n<li>Update Activation banner in plugins page to redirect user to Akismet config page</li>\n</ul>\n<h4>2.5.8</h4>\n<p><em>Release Date &#8211; 20th January, 2013</em></p>\n<ul>\n<li>Simplify the activation process for new users</li>\n<li>Remove the reporter_ip parameter</li>\n<li>Minor preventative security improvements</li>\n</ul>\n<h4>2.5.7</h4>\n<p><em>Release Date &#8211; 13th December, 2012</em></p>\n<ul>\n<li>FireFox Stats iframe preview bug</li>\n<li>Fix mshots preview when using https</li>\n<li>Add .htaccess to block direct access to files</li>\n<li>Prevent some PHP notices</li>\n<li>Fix Check For Spam return location when referrer is empty</li>\n<li>Fix Settings links for network admins</li>\n<li>Fix prepare() warnings in WP 3.5</li>\n</ul>\n<h4>2.5.6</h4>\n<p><em>Release Date &#8211; 26th April, 2012</em></p>\n<ul>\n<li>Prevent retry scheduling problems on sites where wp_cron is misbehaving</li>\n<li>Preload mshot previews</li>\n<li>Modernize the widget code</li>\n<li>Fix a bug where comments were not held for moderation during an error condition</li>\n<li>Improve the UX and display when comments are temporarily held due to an error</li>\n<li>Make the Check For Spam button force a retry when comments are held due to an error</li>\n<li>Handle errors caused by an invalid key</li>\n<li>Don&#8217;t retry comments that are too old</li>\n<li>Improve error messages when verifying an API key</li>\n</ul>\n<h4>2.5.5</h4>\n<p><em>Release Date &#8211; 11th January, 2012</em></p>\n<ul>\n<li>Add nonce check for comment author URL remove action</li>\n<li>Fix the settings link</li>\n</ul>\n<h4>2.5.4</h4>\n<p><em>Release Date &#8211; 5th January, 2012</em></p>\n<ul>\n<li>Limit Akismet CSS and Javascript loading in wp-admin to just the pages that need it</li>\n<li>Added author URL quick removal functionality</li>\n<li>Added mShot preview on Author URL hover</li>\n<li>Added empty index.php to prevent directory listing</li>\n<li>Move wp-admin menu items under Jetpack, if it is installed</li>\n<li>Purge old Akismet comment meta data, default of 15 days</li>\n</ul>\n<h4>2.5.3</h4>\n<p><em>Release Date &#8211; 8th Febuary, 2011</em></p>\n<ul>\n<li>Specify the license is GPL v2 or later</li>\n<li>Fix a bug that could result in orphaned commentmeta entries</li>\n<li>Include hotfix for WordPress 3.0.5 filter issue</li>\n</ul>\n<h4>2.5.2</h4>\n<p><em>Release Date &#8211; 14th January, 2011</em></p>\n<ul>\n<li>Properly format the comment count for author counts</li>\n<li>Look for super admins on multisite installs when looking up user roles</li>\n<li>Increase the HTTP request timeout</li>\n<li>Removed padding for author approved count</li>\n<li>Fix typo in function name</li>\n<li>Set Akismet stats iframe height to fixed 2500px.  Better to have one tall scroll bar than two side by side.</li>\n</ul>\n<h4>2.5.1</h4>\n<p><em>Release Date &#8211; 17th December, 2010</em></p>\n<ul>\n<li>Fix a bug that caused the &#8220;Auto delete&#8221; option to fail to discard comments correctly</li>\n<li>Remove the comment nonce form field from the &#8216;Akismet Configuration&#8217; page in favor of using a filter, akismet_comment_nonce</li>\n<li>Fixed padding bug in &#8220;author&#8221; column of posts screen</li>\n<li>Added margin-top to &#8220;cleared by &#8230;&#8221; badges on dashboard</li>\n<li>Fix possible error when calling akismet_cron_recheck()</li>\n<li>Fix more PHP warnings</li>\n<li>Clean up XHTML warnings for comment nonce</li>\n<li>Fix for possible condition where scheduled comment re-checks could get stuck</li>\n<li>Clean up the comment meta details after deleting a comment</li>\n<li>Only show the status badge if the comment status has been changed by someone/something other than Akismet</li>\n<li>Show a &#8216;History&#8217; link in the row-actions</li>\n<li>Translation fixes</li>\n<li>Reduced font-size on author name</li>\n<li>Moved &#8220;flagged by&#8230;&#8221; notification to top right corner of comment container and removed heavy styling</li>\n<li>Hid &#8220;flagged by&#8230;&#8221; notification while on dashboard</li>\n</ul>\n<h4>2.5.0</h4>\n<p><em>Release Date &#8211; 7th December, 2010</em></p>\n<ul>\n<li>Track comment actions under &#8216;Akismet Status&#8217; on the edit comment screen</li>\n<li>Fix a few remaining deprecated function calls ( props Mike Glendinning ) </li>\n<li>Use HTTPS for the stats IFRAME when wp-admin is using HTTPS</li>\n<li>Use the WordPress HTTP class if available</li>\n<li>Move the admin UI code to a separate file, only loaded when needed</li>\n<li>Add cron retry feature, to replace the old connectivity check</li>\n<li>Display Akismet status badge beside each comment</li>\n<li>Record history for each comment, and display it on the edit page</li>\n<li>Record the complete comment as originally submitted in comment_meta, to use when reporting spam and ham</li>\n<li>Highlight links in comment content</li>\n<li>New option, &#8220;Show the number of comments you&#8217;ve approved beside each comment author.&#8221;</li>\n<li>New option, &#8220;Use a nonce on the comment form.&#8221;</li>\n</ul>\n<h4>2.4.0</h4>\n<p><em>Release Date &#8211; 23rd August, 2010</em></p>\n<ul>\n<li>Spell out that the license is GPLv2</li>\n<li>Fix PHP warnings</li>\n<li>Fix WordPress deprecated function calls</li>\n<li>Fire the delete_comment action when deleting comments</li>\n<li>Move code specific for older WP versions to legacy.php</li>\n<li>General code clean up</li>\n</ul>\n<h4>2.3.0</h4>\n<p><em>Release Date &#8211; 5th June, 2010</em></p>\n<ul>\n<li>Fix &#8220;Are you sure&#8221; nonce message on config screen in WPMU</li>\n<li>Fix XHTML compliance issue in sidebar widget</li>\n<li>Change author link; remove some old references to WordPress.com accounts</li>\n<li>Localize the widget title (core ticket #13879)</li>\n</ul>\n<h4>2.2.9</h4>\n<p><em>Release Date &#8211; 2nd June, 2010</em></p>\n<ul>\n<li>Eliminate a potential conflict with some plugins that may cause spurious reports</li>\n</ul>\n<h4>2.2.8</h4>\n<p><em>Release Date &#8211; 27th May, 2010</em></p>\n<ul>\n<li>Fix bug in initial comment check for ipv6 addresses</li>\n<li>Report comments as ham when they are moved from spam to moderation</li>\n<li>Report comments as ham when clicking undo after spam</li>\n<li>Use transition_comment_status action when available instead of older actions for spam/ham submissions</li>\n<li>Better diagnostic messages when PHP network functions are unavailable</li>\n<li>Better handling of comments by logged-in users</li>\n</ul>\n<h4>2.2.7</h4>\n<p><em>Release Date &#8211; 17th December, 2009</em></p>\n<ul>\n<li>Add a new AKISMET_VERSION constant</li>\n<li>Reduce the possibility of over-counting spam when another spam filter plugin is in use</li>\n<li>Disable the connectivity check when the API key is hard-coded for WPMU</li>\n</ul>\n<h4>2.2.6</h4>\n<p><em>Release Date &#8211; 20th July, 2009</em></p>\n<ul>\n<li>Fix a global warning introduced in 2.2.5</li>\n<li>Add changelog and additional readme.txt tags</li>\n<li>Fix an array conversion warning in some versions of PHP</li>\n<li>Support a new WPCOM_API_KEY constant for easier use with WordPress MU</li>\n</ul>\n<h4>2.2.5</h4>\n<p><em>Release Date &#8211; 13th July, 2009</em></p>\n<ul>\n<li>Include a new Server Connectivity diagnostic check, to detect problems caused by firewalls</li>\n</ul>\n<h4>2.2.4</h4>\n<p><em>Release Date &#8211; 3rd June, 2009</em></p>\n<ul>\n<li>Fixed a key problem affecting the stats feature in WordPress MU</li>\n<li>Provide additional blog information in Akismet API calls</li>\n</ul>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<p>Upload the Akismet plugin to your blog, Activate it, then enter your <a href=\"https://akismet.com/get/\" rel=\"nofollow\">Akismet.com API key</a>.</p>\n<p>1, 2, 3: You&#8217;re done!</p>\n</dd>\n</dl>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/plugins/akismet/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n		\n		\n		\n		\n		\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Oct 2010 20:55:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins-wp/wordpress-seo/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16914:\"<p><!--section=description--></p>\n<p>WordPress out of the box is already technically quite a good platform for SEO. This was true when Joost wrote his original <a href=\"https://yoast.com/articles/wordpress-seo/\" rel=\"nofollow\">WordPress SEO</a> article in 2008 (updated every few months) and it&#8217;s still true today, but that doesn&#8217;t mean you can&#8217;t improve it further! This plugin is written from the ground up by Joost de Valk and his team at <a href=\"https://yoast.com/\" rel=\"nofollow\">Yoast</a> to improve your site&#8217;s SEO on <em>all</em> needed aspects. While this <a href=\"https://yoast.com/wordpress/plugins/seo/\" rel=\"nofollow\">Yoast SEO plugin</a> goes the extra mile to take care of all the technical optimization, more on that below, it first and foremost helps you write better content.  Yoast SEO forces you to choose a focus keyword when you&#8217;re writing your articles, and then makes sure you use that focus keyword everywhere.</p>\n<blockquote>\n<p><strong>Premium Support</strong><br />\n  The Yoast team does not always provide active support for the Yoast SEO plugin on the WordPress.org forums. One-on-one email support is available to people who bought the <a href=\"https://yoast.com/wordpress/plugins/seo-premium/\" rel=\"nofollow\">Premium Yoast SEO plugin</a> only.<br />\n  Note that the Premium SEO plugin has several extra features too, including the option to have multiple focus keywords and a redirect manager, so it might be well worth your investment!</p>\n<p>You should also check out the <a href=\"https://yoast.com/wordpress/plugins/local-seo/\" rel=\"nofollow\">Yoast Local SEO</a>, <a href=\"https://yoast.com/wordpress/plugins/news-seo/\" rel=\"nofollow\">Yoast News SEO</a> and <a href=\"https://yoast.com/wordpress/plugins/video-seo/\" rel=\"nofollow\">Yoast Video SEO</a> extensions to Yoast SEO. These of course come with support too.</p>\n<p><strong>Bug Reports</strong><br />\n  Bug reports for Yoast SEO are <a href=\"https://github.com/Yoast/wordpress-seo\" rel=\"nofollow\">welcomed on GitHub</a>. Please note GitHub is <em>not</em> a support forum, and issues that aren&#8217;t properly qualified as bugs will be closed.</p>\n</blockquote>\n<h4>Write better content with Yoast SEO</h4>\n<p>Using the snippet preview, you can see a rendering of what your post or page will look like in the search results, whether your title is too long or too short, and whether your meta description makes sense in the context of a search result. This way the plugin will help you not only increase rankings but also increase the click through rate for organic search results.</p>\n<h4>Page Analysis</h4>\n<p>The Yoast SEO plugins <a href=\"https://yoast.com/content-seo-wordpress-linkdex/\" rel=\"nofollow\">Page Analysis</a> functionality checks simple things you&#8217;re bound to forget. It checks, for instance, if you have images in your post and whether they have an alt tag containing the focus keyword for that post. It also checks whether your posts are long enough, whether you&#8217;ve written a meta description and if that meta description contains your focus keyword, if you&#8217;ve used any subheadings within your post, etc. etc.</p>\n<p>The plugin also allows you to write meta titles and descriptions for all your category, tag and custom taxonomy archives, giving you the option to further optimize those pages.</p>\n<p>Combined, this plugin makes sure that your content is the type of content search engines will love!</p>\n<h4>Technical WordPress Search Engine Optimization</h4>\n<p>While out of the box WordPress is pretty good for SEO, it needs some tweaks here and there. This Yoast SEO plugin guides you through some of the settings needed, for instance by reminding you to enable pretty permalinks. But it also goes beyond that, by automatically optimizing and inserting the meta tags and link elements that Google and other search engines like so much:</p>\n<h4>Meta &amp; Link Elements</h4>\n<p>With the Yoast SEO plugin you can control which pages Google shows in its search results and which pages it doesn&#8217;t show. By default, it will tell search engines to index all of your pages, including category and tag archives, but to only show the first pages in the search results. It&#8217;s not very useful for a user to end up on the third page of your &#8220;personal&#8221; category, right?</p>\n<p>WordPress itself only shows canonical link elements on single pages, but Yoast SEO makes it output canonical link elements everywhere. Google has recently announced they would also use <code>rel=\"next\"</code> and <code>rel=\"prev\"</code> link elements in the <code>head</code> section of your paginated archives. This plugin adds those automatically. See <a href=\"https://yoast.com/rel-next-prev-paginated-archives/\" rel=\"nofollow\">this post</a> for more info.</p>\n<h4>XML Sitemaps</h4>\n<p>The Yoast SEO plugin has the most advanced XML Sitemaps functionality in any WordPress plugin. Once you check the box, it automatically creates XML sitemaps and notifies Google &amp; Bing of the sitemaps&#8217; existence. These XML sitemaps include the images in your posts &amp; pages too, so that your images may be found better in the search engines too.</p>\n<p>These XML Sitemaps will even work on large sites, because of how they&#8217;re created, using one index sitemap that links to sub-sitemaps for each 1,000 posts. They will also work with custom post types and custom taxonomies automatically, while giving you the option to remove those from the XML sitemap should you wish to.</p>\n<p>Because of using <a href=\"https://yoast.com/xsl-stylesheet-xml-sitemap/\" rel=\"nofollow\">XSL stylesheets for these XML Sitemaps</a>, the XML sitemaps are easily readable for the human eye too, so you can spot things that shouldn&#8217;t be in there.</p>\n<h4>RSS Optimization</h4>\n<p>Are you being outranked by scrapers? Instead of cursing at them, use them to your advantage! By automatically adding a link to your RSS feed pointing back to the original article, you&#8217;re telling the search engine where they should be looking for the original. This way, the Yoast SEO plugin increases your own chance of ranking for your chosen keywords and gets rid of scrapers in one go!</p>\n<h4>Breadcrumbs</h4>\n<p>If your theme is compatible, and themes based on for instance Genesis or by WooThemes often are, you can use the built-in Breadcrumbs functionality. This allows you to create an easy navigation that is great for both users and search engines, and will support the search engines in understanding the structure of your site.</p>\n<p>Making your theme compatible isn&#8217;t hard either, check <a href=\"https://kb.yoast.com/kb/implement-wordpress-seo-breadcrumbs/\" rel=\"nofollow\">these instructions</a>.</p>\n<h4>Edit your .htaccess and robots.txt file</h4>\n<p>Using the built-in file editor, you can edit your WordPress blog&#8217;s <code>.htaccess</code> and <code>robots.txt</code> file, giving you direct access to the two most powerful files, from an SEO perspective, in your WordPress install.</p>\n<h4>Social Integration</h4>\n<p>SEO and Social Media are heavily intertwined. That&#8217;s why this plugin also comes with a Facebook OpenGraph implementation and will soon also support Google+ sharing tags.</p>\n<h4>Multi-Site Compatible</h4>\n<p>The Yoast SEO plugin, unlike some others, is fully Multi-Site compatible. The XML Sitemaps work fine in all setups and you even have the option, in the Network settings, to copy the settings from one blog to another, or make blogs default to the settings for a specific blog.</p>\n<h4>Import &amp; Export functionality</h4>\n<p>If you have multiple blogs, setting up plugins like this one on all of them might seem like a daunting task. Except that it&#8217;s not, because what you can do is simple: you set up the plugin once. You then export your settings and simply import them on all your other sites. It&#8217;s that simple!</p>\n<h4>Import functionality for other WordPress SEO plugins</h4>\n<p>If you&#8217;ve used All In One SEO Pack or HeadSpace2 before using this plugin, you might want to import all your old titles and descriptions. You can do that easily using the built-in import functionality. There&#8217;s also import functionality for some of the older Yoast plugins, like Robots Meta and RSS footer.</p>\n<p>Should you have a need to import from another SEO plugin to Yoast SEO, or from a theme like Genesis or Thesis, you can use the <a href=\"https://wordpress.org/extend/plugins/seo-data-transporter/\" rel=\"nofollow\">SEO Data Transporter</a> plugin, which will easily convert your SEO meta data from and to a whole set of plugins like Platinum SEO, SEO Ultimate, Greg&#8217;s High Performance SEO, and themes like Headway, Hybrid, WooFramework, Catalyst etc.</p>\n<p>Read <a href=\"https://yoast.com/all-in-one-seo-pack-migration/\" rel=\"nofollow\">this migration guide</a> if you still have questions about migrating from another SEO plugin to Yoast SEO.</p>\n<h4>Yoast SEO Plugin in your Language!</h4>\n<p>Currently a huge translation project is underway, translating Yoast SEO in as much as 24 languages. So far, the translations for French and Dutch are complete, but we still need help on a lot of other languages, so if you&#8217;re good at translating, please join us at <a href=\"http://translate.yoast.com\" rel=\"nofollow\">translate.yoast.com</a>.</p>\n<h4>News SEO</h4>\n<p>Be sure to also check out the premium <a href=\"https://yoast.com/wordpress/plugins/news-seo/\" rel=\"nofollow\">News SEO module</a> if you need Google News Sitemaps. It tightly integrates with Yoast SEO to give you the combined power of News Sitemaps and full Search Engine Optimization.</p>\n<h4>Further Reading</h4>\n<p>For more info, check out the following articles:</p>\n<ul>\n<li>The <a href=\"https://kb.yoast.com/kb/category/yoast-seo/\" rel=\"nofollow\">Yoast SEO Knowledgebase</a>.</li>\n<li><a href=\"https://yoast.com/articles/wordpress-seo/\" rel=\"nofollow\">WordPress SEO &#8211; The definitive Guide by Yoast</a>.</li>\n<li>Once you have great SEO, you&#8217;ll need the <a href=\"https://yoast.com/articles/wordpress-hosting/\" rel=\"nofollow\">best WordPress Hosting</a>.</li>\n<li>The <a href=\"https://yoast.com/wordpress/plugins/seo/\" rel=\"nofollow\">Yoast SEO Plugin</a> official homepage.</li>\n<li>Other <a href=\"https://yoast.com/wordpress/plugins/\" rel=\"nofollow\">WordPress Plugins</a> by the same team.</li>\n<li>Follow Yoast on <a href=\"https://facebook.com/yoast\" rel=\"nofollow\">Facebook</a> &amp; <a href=\"http://twitter.com/yoast\" rel=\"nofollow\">Twitter</a>.</li>\n</ul>\n<h3>From within WordPress</h3>\n<ol>\n<li>Visit &#8216;Plugins &gt; Add New&#8217;</li>\n<li>Search for &#8216;Yoast SEO&#8217;</li>\n<li>Activate Yoast SEO from your Plugins page.</li>\n<li>Go to &#8220;after activation&#8221; below.</li>\n</ol>\n<h3>Manually</h3>\n<ol>\n<li>Upload the <code>wordpress-seo</code> folder to the <code>/wp-content/plugins/</code> directory</li>\n<li>Activate the Yoast SEO plugin through the &#8216;Plugins&#8217; menu in WordPress</li>\n<li>Go to &#8220;after activation&#8221; below.</li>\n</ol>\n<h3>After activation</h3>\n<ol>\n<li>You should see (a notice to start) the Yoast SEO configuration wizard.</li>\n<li>Go through the configuration wizard and set up the plugin for your site.</li>\n<li>You&#8217;re done!</li>\n</ol>\n<p><!--section=faq--></p>\n<p>You&#8217;ll find answers to many of your questions on <a href=\"https://kb.yoast.com/kb/category/yoast-seo/\" rel=\"nofollow\">kb.yoast.com</a>.</p>\n<p><!--section=changelog--></p>\n<h4>5.3.2</h4>\n<p>Release Date: August 23th, 2017</p>\n<ul>\n<li>Bugfixes\n<ul>\n<li>Fixes a bug where an invalid license notification could be shown in certain situations.</li>\n</ul>\n</li>\n</ul>\n<h4>5.3.1</h4>\n<p>Release Date: August 22nd, 2017</p>\n<ul>\n<li>Bugfixes\n<ul>\n<li>Fixes a bug where &#8220;mark as fixed&#8221; on the search console page didn&#8217;t work.</li>\n<li>Fixes a bug where the configuration wizard JavaScript file was too large.</li>\n</ul>\n</li>\n</ul>\n<h4>5.3.0</h4>\n<p>Release Date: August 22nd, 2017</p>\n<ul>\n<li>\n<p>Enhancements</p>\n<ul>\n<li>Adds missing I18n function call to make a string translatable</li>\n<li>Adds XML schema for image sitemap, props: <a href=\"https://github.com/stodorovic\" rel=\"nofollow\">stodorovic</a></li>\n<li>Adds schema.org meta-data on every page, instead of only on the homepage</li>\n<li>Adds the possibility to filter posts by readability score.</li>\n<li>Exposes tinyMCEHelper as window.YoastSEO.wp._tinyMCEHelper in JavaScript</li>\n<li>Exposes the ReplaceVar class in YoastReplaceVarPlugin as window.YoastReplaceVarPlugin.ReplaceVar in JavaScript</li>\n</ul>\n</li>\n<li>\n<p>Bugfixes</p>\n<ul>\n<li>Adds sanitization for the Twitter Image meta field</li>\n<li>Fixes use of <code>register_meta</code> for usage in WordPress 4.6 and higher</li>\n<li>Initialize the providers on hook <code>after_theme_setup</code> to make sure custom providers are added properly, props: <a href=\"https://github.com/stodorovic\" rel=\"nofollow\">stodorovic</a></li>\n<li>Changes the label of the &#8220;Bad&#8221; score to &#8220;Needs improvement&#8221; while filtering on SEO or readability scores.</li>\n</ul>\n</li>\n</ul>\n<h4>5.2.0</h4>\n<p>Release Date: August 8th, 2017</p>\n<ul>\n<li>\n<p>Enhancements</p>\n<ul>\n<li>Added wpseo_pre_adjacent_rel_links filter to bypass built-in rel prev/next functionality.</li>\n<li>Introduces classes to allow collecting data in the Premium plugin.</li>\n<li>Renamed OnPage.org to Ryte.</li>\n<li>Allow WordPress WHIP messages to be dismissed for a period of 4 weeks.</li>\n<li>Adds a filter for word combinations that consist of a single one-character word.</li>\n<li>Adds aria-current to the onboarding wizard active step.</li>\n</ul>\n</li>\n<li>\n<p>Bugfixes</p>\n<ul>\n<li>Removes JQMIGRATE JavaScript warnings.</li>\n</ul>\n</li>\n</ul>\n<h4>5.1.0</h4>\n<p>Release Date: July 25th, 2017</p>\n<ul>\n<li>\n<p>Enhancements</p>\n<ul>\n<li>Adds the post-type and taxonomy identifiers on the titles and metas settings tab.</li>\n<li>Adds support for importing of Jetpack SEO data.</li>\n<li>Improves the readability feature for Dutch, English, French, German, Italian and Spanish.</li>\n<li>Adds a WordPress SEO Premium motivation box on Yoast SEO settings pages.</li>\n<li>Adds a WordPress SEO Premium motivation on the social tabs.</li>\n<li>Adds support for third party sitemaps providers to be registered and used.</li>\n<li>Changes the column titles in the taxonomy list table to icons.</li>\n<li>Adds a subheader on the notification dashboard to clarify problems and issues which are muted.</li>\n<li>Improves avatars on the credit page, props <a href=\"https://github.com/mikedehart\" rel=\"nofollow\">Mike DeHart</a></li>\n</ul>\n</li>\n<li>\n<p>Bugfixes</p>\n<ul>\n<li>Fixes a bug where <code>remove_meta_if_default</code> and <code>dont_save_meta_if_default</code> don&#8217;t return the given input value as default.</li>\n<li>Fixes a performance issue related to calculating text link counts when saving a post.</li>\n<li>Fixes a typo in the readme.txt, props <a href=\"https://github.com/rayrutjes\" rel=\"nofollow\">Raymond Rutjes</a></li>\n</ul>\n</li>\n</ul>\n<h4>5.0.2</h4>\n<p>Release Date: July 13th, 2017</p>\n<ul>\n<li>Only load babel polyfill if it hasn&#8217;t been loaded by another plugin yet.</li>\n<li>Adds a feature toggle to disable the link counter tool &amp; link columns.</li>\n<li>Fixes a compatibility issue with WordPress 4.6.</li>\n<li>Fixes an issue where the link columns would disappear after quick-editing a post.</li>\n</ul>\n<h4>5.0.1</h4>\n<p>Release Date: July 6th, 2017</p>\n<ul>\n<li>Fixes a fatal error that could occur when trying to save a post that has <code>&lt;a&gt;</code>-tags with invalid URLs in it.</li>\n</ul>\n<h4>5.0.0</h4>\n<p>Release Date: July 6th, 2017</p>\n<ul>\n<li>\n<p>Bugfixes</p>\n<ul>\n<li>Fixes a bug where images via <code>https</code> were not working, props <a href=\"https://github.com/apfelbox\" rel=\"nofollow\">Jannik Zschiesche</a>.</li>\n<li>Fixes a bug where the whip notification can be shown multiple times.</li>\n</ul>\n</li>\n<li>\n<p>Enhancements</p>\n<ul>\n<li>Introduces a module that counts links in the content.</li>\n<li>Adds Flesch Reading for Italian.</li>\n<li>Changes &#8216;page title&#8217; to &#8216;seo title&#8217; in the snippet preview.</li>\n<li>Changes recommended maximum sentence length for Italian from 20 to 25 words, based on more in-depth research.</li>\n<li>Implements the extracted version of the Algolia Search which is now present in <code>yoast-components</code>.</li>\n<li>\n<p>Adds a banner for the structured data course.</p>\n</li>\n<li>\n<p>Under the hood</p>\n</li>\n<li>Introduces a database table to keep track of the linking structure. If the table cannot be created, a notification will be shown.</li>\n<li>When there are posts or pages to reindex, a notice will be shown.</li>\n</ul>\n</li>\n</ul>\n<h4>Earlier versions</h4>\n<p>For the changelog of earlier versions, please refer to the separate changelog.txt file.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/jetpack/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/plugins-wp/jetpack/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"The one plugin you need for stats, related posts, search engine optimization, social sharing, protection,&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9087:\"<p><!--section=description--></p>\n<p>Keep any WordPress site secure, increase traffic, and engage your readers.</p>\n<h4>Traffic and SEO Tools</h4>\n<p>Traffic is the lifeblood of any website. Jetpack includes:</p>\n<ul>\n<li>[free] Site stats and analytics</li>\n<li>[free] Automatic sharing on Facebook, Twitter, LinkedIn, Tumblr, Reddit, and WhatsApp</li>\n<li>[free] Related posts</li>\n<li>[paid] Search engine optimization tools for Google, Bing, Twitter, Facebook, and WordPress.com</li>\n<li>[paid] Advertising program that includes the best of AdSense, Facebook Ads, AOL, Amazon, Google AdX, and Yahoo</li>\n</ul>\n<h4>Security and Backup Services</h4>\n<p>Stop worrying about data loss, downtime, and hacking. Jetpack provides:</p>\n<ul>\n<li>[free] Brute force attack protection</li>\n<li>[free] Downtime and uptime monitoring</li>\n<li>[free] Secured logins and two-factor authentication</li>\n<li>[paid] Malware scanning, code scanning, and threat resolution</li>\n<li>[paid] Site backups, restores, and migrations</li>\n</ul>\n<h4>Content Creation</h4>\n<p>Add rich, beautifully-presented media &#8212; no graphic design expertise necessary:</p>\n<ul>\n<li>[free] A high-speed CDN for your images</li>\n<li>[free] Carousels, slideshows, and tiled galleries</li>\n<li>[free] Simple embeds from YouTube, Google Documents, Spotify and more</li>\n<li>[free] Sidebar customization including Facebook, Twitter, and RSS feeds</li>\n<li>[free] Extra sidebar widgets including blog stats, calendar, and author widgets</li>\n<li>[paid] High-speed, ad-free, and high-definition video hosting</li>\n</ul>\n<h4>Discussion and Community</h4>\n<p>Create a connection with your readers and keep them coming back to your site with:</p>\n<ul>\n<li>[free] Email subscriptions</li>\n<li>[free] Comment login with Facebook, Twitter, and Google</li>\n<li>[free] Fully-customizable contact forms</li>\n<li>[free] Infinite scroll for your posts</li>\n</ul>\n<h4>Expert Support</h4>\n<p>We have an entire team of Happiness Engineers ready to help you. Ask your questions in the support forum, or <a href=\"https://jetpack.com/contact-support\" rel=\"nofollow\">contact us directly</a>.</p>\n<h4>Paid Services</h4>\n<p>Most of Jetpack&#8217;s features and services are free. Jetpack also provides advanced security and backup services, video hosting, site monetization, priority support, and more SEO tools in three <a href=\"https://jetpack.com/pricing?from=wporg\" rel=\"nofollow\">simple and affordable plans</a>.</p>\n<h4>Get Started</h4>\n<p>Installation is free, quick, and easy. Set up <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">the free plan</a> in minutes.</p>\n<p><!--section=installation--></p>\n<h4>Automated Installation</h4>\n<p>Installation is free, quick, and easy. <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">Install Jetpack from our site</a> in minutes.</p>\n<h4>Manual Alternatives</h4>\n<p>Alternatively, install Jetpack via the plugin directory, or upload the files manually to your server and follow the on-screen instructions. If you need additional help <a href=\"https://jetpack.com/support/installing-jetpack/\" rel=\"nofollow\">read our detailed instructions</a>.</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<h4>Automated Installation</h4>\n<p>Installation is free, quick, and easy. <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">Install Jetpack from our site</a> in minutes.</p>\n<h4>Manual Alternatives</h4>\n<p>Alternatively, install Jetpack via the plugin directory, or upload the files manually to your server and follow the on-screen instructions. If you need additional help <a href=\"https://jetpack.com/support/installing-jetpack/\" rel=\"nofollow\">read our detailed instructions</a>.</p>\n</dd>\n<dt>Is Jetpack Free?</dt>\n<dd>\n<p>Yes! Jetpack&#8217;s core features are and always will be free.</p>\n<p>These include: <a href=\"https://jetpack.com/features/traffic/site-stats\" rel=\"nofollow\">site stats</a>, a <a href=\"https://jetpack.com/features/writing/content-delivery-network/\" rel=\"nofollow\">high-speed CDN</a> for images, <a href=\"https://jetpack.com/features/traffic/related-posts\" rel=\"nofollow\">related posts</a>, <a href=\"https://jetpack.com/features/security/downtime-monitoring\" rel=\"nofollow\">downtime monitoring</a>, brute force <a href=\"https://jetpack.com/features/security/brute-force-attack-protection\" rel=\"nofollow\">attack protection</a>, <a href=\"https://jetpack.com/features/traffic/automatic-publishing/\" rel=\"nofollow\">automated sharing</a> to social networks, <a href=\"https://jetpack.com/features/writing/sidebar-customization/\" rel=\"nofollow\">sidebar customization</a>, and many more.</p>\n</dd>\n<dt>Should I purchase a paid plan?</dt>\n<dd>\n<p>Jetpack&#8217;s paid services include automated backups, security scanning, spam filtering, video hosting, site monetization, SEO tools, and priority support.</p>\n<p>If you&#8217;re interested in learning more about the extra layers of protection and advanced tools available, learn more about our <a href=\"https://jetpack.com/pricing?from=wporg\" rel=\"nofollow\">paid plans</a>.</p>\n</dd>\n<dt>Why do I need a WordPress.com account?</dt>\n<dd>\n<p>Since Jetpack and its services are provided and hosted by WordPress.com, a WordPress.com account is required for Jetpack to function.</p>\n</dd>\n<dt>I already have a WordPress account, but Jetpack isn&#8217;t working. What&#8217;s going on?</dt>\n<dd>\n<p>A WordPress.com account is different from the account you use to log into your self-hosted WordPress. If you can log into <a href=\"https://wordpress.com\" rel=\"nofollow\">WordPress.com</a>, then you already have a WordPress.com account. If you can&#8217;t, you can easily create one <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">during installation</a>.</p>\n</dd>\n<dt>How do I view my stats?</dt>\n<dd>\n<p>Once you&#8217;ve installed Jetpack your stats will be available on <a href=\"https://wordpress.com/stats\" rel=\"nofollow\">WordPress.com/Stats</a>, on the official <a href=\"https://apps.wordpress.com/mobile/\" rel=\"nofollow\">WordPress mobile apps</a>, and on your Jetpack dashboard.</p>\n</dd>\n<dt>How do I contribute to Jetpack?</dt>\n<dd>\n<p>There are opportunities for developers at all levels to contribute. <a href=\"https://jetpack.com/contribute\" rel=\"nofollow\">Learn more about contributing to Jetpack</a> or consider <a href=\"https://jetpack.com/beta\" rel=\"nofollow\">joining our beta program</a>.</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>5.2.1</h4>\n<ul>\n<li>Release date: August 2, 2017</li>\n<li>Release post: https://jetpack.com/?p=22686</li>\n</ul>\n<p><strong>Bug fixes</strong><br />\n* Solves an issue that caused widgets to lose their content when saved in WP Admin or Customizer.</p>\n<h4>5.2</h4>\n<ul>\n<li>Release date: August 1, 2017</li>\n<li>Release post: https://jetpack.com/?p=22509</li>\n</ul>\n<p><strong>Major Enhancements</strong><br />\n* Contact Forms now sports a fancy new interface that allows you to visually compose your form in the editor.<br />\n* We have a new and slick way to showcase and explain the features we recommend to activate to new users.</p>\n<p><strong>Enhancements</strong><br />\n* Reduced 500kb from plugin zip file, which means faster updates.<br />\n* Refactored and reduced code for Comment Likes so it&#8217;s faster and lighter.</p>\n<p><strong>Bug fixes</strong><br />\n* An inconsistency experienced in WordPress.com dashboard when Related Posts settings were set in the local site&#8217;s WP Admin is now fixed.<br />\n* Fixed a 404 when loading Open Sans font from a stylesheet plus now it&#8217;s only enqueued if it will be used.<br />\n* Solve PHP warnings when Image widget wasn&#8217;t migrated.</p>\n<h4>5.1</h4>\n<ul>\n<li>Release date: July 5th, 2017</li>\n<li>Release post: https://jetpack.com/?p=20888</li>\n</ul>\n<p><strong>Major Enhancements</strong><br />\n* You and your readers can now show appreciation to particularly clever comments with the new Comment Likes feature.</p>\n<p><strong>Enhancements</strong><br />\n* Quickly visit your current site&#8217;s front-end directly from the Masterbar&#8217;s new &#8220;View Site&#8221; item.<br />\n* Site data fetch from /me/sites REST API endpoint now includes <code>blog_public</code> in the list of returned options.<br />\n* The Flickr widget now automatically displays images in a grid if there&#8217;s enough room.<br />\n* E-mail sharing is now disabled by default unless it&#8217;s explicitly enabled by a filter or Akismet is active.</p>\n<p><strong>Compatibility Improvements</strong></p>\n<ul>\n<li>Updated instructions in Flickr widget to reflect recent changes to the Flickr UI.</li>\n</ul>\n<p><strong>Bug fixes</strong></p>\n<ul>\n<li>EU Cookie Law Banner cookie no longer cached.</li>\n<li>WP Admin menu can now be accessed in mobile when Masterbar is displayed.</li>\n<li>We now sync the <code>order_id</code> for <code>order_items</code> in older WooCommerce versions.</li>\n<li>UI now handles VaultPress connection or registration problems gracefully.</li>\n<li>Photon now works correctly with images uploaded before WordPress 2.7.</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/plugins/jetpack/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 18:48:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins-wp/wordpress-importer/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4618:\"<p><!--section=description--></p>\n<p>The WordPress Importer will import the following content from a WordPress export file:</p>\n<ul>\n<li>Posts, pages and other custom post types</li>\n<li>Comments</li>\n<li>Custom fields and post meta</li>\n<li>Categories, tags and terms from custom taxonomies</li>\n<li>Authors</li>\n</ul>\n<p>For further information and instructions please see the <a href=\"https://codex.wordpress.org/Importing_Content#WordPress\" rel=\"nofollow\">Codex page on Importing Content</a></p>\n<h3>Filters</h3>\n<p>The importer has a couple of filters to allow you to completely enable/block certain features:</p>\n<ul>\n<li><code>import_allow_create_users</code>: return false if you only want to allow mapping to existing users</li>\n<li><code>import_allow_fetch_attachments</code>: return false if you do not wish to allow importing and downloading of attachments</li>\n<li><code>import_attachment_size_limit</code>: return an integer value for the maximum file size in bytes to save (default is 0, which is unlimited)</li>\n</ul>\n<p>There are also a few actions available to hook into:</p>\n<ul>\n<li><code>import_start</code>: occurs after the export file has been uploaded and author import settings have been chosen</li>\n<li><code>import_end</code>: called after the last output from the importer</li>\n</ul>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<p>The quickest method for installing the importer is:</p>\n<ol>\n<li>Visit Tools -&gt; Import in the WordPress dashboard</li>\n<li>Click on the WordPress link in the list of importers</li>\n<li>Click &#8220;Install Now&#8221;</li>\n<li>Finally click &#8220;Activate Plugin &amp; Run Importer&#8221;</li>\n</ol>\n<p>If you would prefer to do things manually then follow these instructions:</p>\n<ol>\n<li>Upload the <code>wordpress-importer</code> folder to the <code>/wp-content/plugins/</code> directory</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress</li>\n<li>Go to the Tools -&gt; Import screen, click on WordPress</li>\n</ol>\n</dd>\n<dt>Help! I&#8217;m getting out of memory errors or a blank screen.</dt>\n<dd>\n<p>If your exported file is very large, the import script may run into your host&#8217;s configured memory limit for PHP.</p>\n<p>A message like &#8220;Fatal error: Allowed memory size of 8388608 bytes exhausted&#8221; indicates that the script can&#8217;t successfully import your XML file under the current PHP memory limit. If you have access to the php.ini file, you can manually increase the limit; if you do not (your WordPress installation is hosted on a shared server, for instance), you might have to break your exported XML file into several smaller pieces and run the import script one at a time.</p>\n<p>For those with shared hosting, the best alternative may be to consult hosting support to determine the safest approach for running the import. A host may be willing to temporarily lift the memory limit and/or run the process directly from their end.</p>\n<p>&#8212; <a href=\"https://codex.wordpress.org/Importing_Content#Before_Importing\" rel=\"nofollow\">WordPress Codex: Importing Content</a></p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>0.6.3</h4>\n<ul>\n<li>Add support for import term metadata.</li>\n<li>Fix bug that caused slashes to be stripped from imported content.</li>\n<li>Fix bug that caused characters to be stripped inside of CDATA in some cases.</li>\n<li>Fix PHP notices.</li>\n</ul>\n<h4>0.6.2</h4>\n<ul>\n<li>Add wp_import_existing_post filter. See: https://core.trac.wordpress.org/ticket/33721</li>\n</ul>\n<h4>0.6</h4>\n<ul>\n<li>Support for WXR 1.2 and multiple CDATA sections</li>\n<li>Post aren&#8217;t duplicates if their post_type&#8217;s are different</li>\n</ul>\n<h4>0.5.2</h4>\n<ul>\n<li>Double check that the uploaded export file exists before processing it. This prevents incorrect error messages when<br />\nan export file is uploaded to a server with bad permissions and WordPress 3.3 or 3.3.1 is being used.</li>\n</ul>\n<h4>0.5</h4>\n<ul>\n<li>Import comment meta (requires export from WordPress 3.2)</li>\n<li>Minor bugfixes and enhancements</li>\n</ul>\n<h4>0.4</h4>\n<ul>\n<li>Map comment user_id where possible</li>\n<li>Import attachments from <code>wp:attachment_url</code></li>\n<li>Upload attachments to correct directory</li>\n<li>Remap resized image URLs correctly</li>\n</ul>\n<h4>0.3</h4>\n<ul>\n<li>Use an XML Parser if possible</li>\n<li>Proper import support for nav menus</li>\n<li>&#8230; and much more, see <a href=\"https://core.trac.wordpress.org/ticket/15197\" rel=\"nofollow\">Trac ticket #15197</a></li>\n</ul>\n<h4>0.1</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/woocommerce/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Sep 2011 15:32:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins-wp/woocommerce/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:23662:\"<p><!--section=description--></p>\n<p>WooCommerce is a free eCommerce plugin that allows you to sell anything, beautifully. Built to integrate seamlessly with WordPress, WooCommerce is the world’s favorite eCommerce solution that gives both store owners and developers complete control.</p>\n<p>With endless flexibility and access to hundreds of free and premium WordPress extensions, WooCommerce now powers 30% of all online stores &#8212; more than any other platform.</p>\n<iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/1KahlicghaE?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe>\n<h4>Sell anything, anywhere</h4>\n<p>With WooCommerce, you can sell both physical and digital goods in all shapes and sizes, offer product variations, multiple configurations, and instant downloads to shoppers, and even sell affiliate goods from online marketplaces.</p>\n<p>With premium extensions, you can offer bookings, memberships, and recurring subscriptions. Perhaps you’d like to sell monthly subscriptions for physical goods, or offer your members a discount on digital downloads? It’s all possible.</p>\n<h4>Ship wherever you like</h4>\n<p>Offer free shipping, flat rate shipping, or make real-time calculations. Limit your shipments to specific countries, or open your store up to the world. Shipping is highly configurable, and WooCommerce even supports drop shipping.</p>\n<h4>Extensive payment options</h4>\n<p>WooCommerce comes bundled with the ability to accept major credit cards, PayPal, BACS (bank transfers), and cash on delivery. Need additional options? More than 140 region-specific gateways integrate with WooCommerce, including popular choices like Stripe, Authorize.Net, and Amazon Payments.</p>\n<h4>You control it all &#8212; forever</h4>\n<p>WooCommerce gives you complete control of your store, from taxes to stock levels to customer accounts. Add and remove extensions, change your design, and switch settings as you please. It’s all under your control.</p>\n<p>One of the biggest risks of using a hosted eCommerce platform is what happens to your store if the provider closes up shop. With WooCommerce, you have complete control, so there’s never any reason to worry. Your data belongs to you &#8212; and it’s kept secure, thanks to regular audits by industry leaders.</p>\n<h4>Define your style with Storefront</h4>\n<p><a href=\"https://wordpress.org/themes/storefront/\" rel=\"nofollow\">Storefront</a> is a free WordPress theme available to any WooCommerce store. Along with deep WooCommerce integration, Storefront prioritizes speed and uptime while eliminating theme and plugin conflicts during major updates.</p>\n<p>Define your style even further by customizing Storefront to your liking or choosing from one of our several <a href=\"https://woocommerce.com/product-category/themes/storefront-child-theme-themes/\" rel=\"nofollow\">Storefront child themes</a>. It’s all up to you, and all open source.</p>\n<h4>Built with developers in mind</h4>\n<p>Extendable, adaptable, and open source &#8212; WooCommerce was created with developers in mind. With its strong, robust framework, you can scale your client’s store all the way from basic to high-end (infinity and beyond).</p>\n<p>Built with a REST API, WooCommerce can integrate with virtually any service. Your store’s data can be accessed anywhere, anytime, 100% securely. WooCommerce allows developers to easily create, modify, and grow a store that meets their specifications.</p>\n<p>No matter the size of the store you want to build, WooCommerce will scale to meet your requirements. With a growing collection of more than 300 extensions, you can enhance each store’s features to meet your client’s unique needs &#8212; or even create your own solution.</p>\n<p>If security is a concern, rest easy. WooCommerce is audited by a dedicated team of developers working around the clock to identify and patch any and all discovered bugs.</p>\n<p>We also support WooCommerce and all its extensions with comprehensive, easily-accessible documentation. With our docs, you’ll learn how to create the exact site your client needs.</p>\n<h4>Extensions galore</h4>\n<p>WordPress.org is home to some amazing extensions for WooCommerce, including:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-google-analytics-integration/\">Google Analytics</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-delivery-notes/\">Delivery Notes</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-pdf-invoices-packing-slips/\">PDF Invoices and Packing Slips</a></li>\n<li><a href=\"https://wordpress.org/plugins/affiliates-woocommerce-light/\">Affiliates Integration Light</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-new-product-badge/\">New Product Badges</a></li>\n</ul>\n<p>Keen to see them all? Search WordPress.org for ‘WooCommerce’ to dive in.</p>\n<p>If you’re looking for something endorsed and maintained by the developers who built WooCommerce, there are a plethora of premium eCommerce extensions, the most popular of which include:</p>\n<ul>\n<li><a href=\"https://woocommerce.com/products/woocommerce-subscriptions/\" rel=\"nofollow\">WooCommerce Subscriptions</a></li>\n<li><a href=\"https://woocommerce.com/products/woocommerce-memberships/\" rel=\"nofollow\">WooCommerce Memberships</a></li>\n<li><a href=\"https://woocommerce.com/products/woocommerce-bookings/\" rel=\"nofollow\">WooCommerce Bookings</a></li>\n<li><a href=\"https://woocommerce.com/products/dynamic-pricing/\" rel=\"nofollow\">Dynamic Pricing</a></li>\n<li><a href=\"https://woocommerce.com/products/table-rate-shipping/\" rel=\"nofollow\">Table Rate Shipping</a></li>\n<li><a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">Product CSV Import Suite</a></li>\n</ul>\n<p>And there’s plenty more where they came from. Visit our <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/\" rel=\"nofollow\">extensions page</a> to find out everything you’re capable of and all that&#8217;s possible with premium WooCommerce extensions.</p>\n<h4>Join our growing community</h4>\n<p>When you download WooCommerce, you join a community of more than a million store owners, developers, and WordPress enthusiasts. We’re one of the fastest-growing open source communities online, and whether you’re a n00b or a Ninja, we’d love to have you!</p>\n<p>If you’re interested in contributing to WooCommerce we’ve got more than 350 contributors, and there’s always room for more. Head over to the <a href=\"https://github.com/woocommerce/woocommerce\" rel=\"nofollow\">WooCommerce GitHub Repository</a> to find out how you can pitch in.</p>\n<p>Want to add a new language to WooCommerce? Swell! You can contribute via <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce\" rel=\"nofollow\">translate.wordpress.org</a>.</p>\n<p>And, finally, consider joining or spearheading a WooCommerce Meetup locally, more about those <a href=\"https://woocommerce.com/woocommerce/meetups/\" rel=\"nofollow\">here</a>.</p>\n<p><!--section=installation--></p>\n<h4>Minimum Requirements</h4>\n<ul>\n<li>PHP version 5.2.4 or greater (PHP 5.6 or greater is recommended)</li>\n<li>MySQL version 5.0 or greater (MySQL 5.6 or greater is recommended)</li>\n<li>Some payment gateways require fsockopen support (for IPN access)</li>\n<li>WooCommerce 2.5 requires WordPress 4.1+</li>\n<li>WooCommerce 2.6 requires WordPress 4.4+</li>\n</ul>\n<p>Visit the <a href=\"https://docs.woocommerce.com/document/server-requirements/\" rel=\"nofollow\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.</p>\n<p>In the search field type “WooCommerce” and click Search Plugins. Once you’ve found our eCommerce plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.</p>\n<h4>Manual installation</h4>\n<p>The manual installation method involves downloading our eCommerce plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains <a href=\"https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation\" rel=\"nofollow\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work like a charm; as always though, ensure you backup your site just in case.</p>\n<p>If on the off-chance you do encounter issues with the shop/category pages after an update you simply need to flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting &#8216;save&#8217;. That should return things to normal.</p>\n<h4>Dummy data</h4>\n<p>WooCommerce comes with some dummy data you can use to see how products look; either import dummy_data.xml via the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> or use our <a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">CSV Import Suite plugin</a> to import dummy_data.csv and dummy_data_variations.csv.</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<h4>Minimum Requirements</h4>\n<ul>\n<li>PHP version 5.2.4 or greater (PHP 5.6 or greater is recommended)</li>\n<li>MySQL version 5.0 or greater (MySQL 5.6 or greater is recommended)</li>\n<li>Some payment gateways require fsockopen support (for IPN access)</li>\n<li>WooCommerce 2.5 requires WordPress 4.1+</li>\n<li>WooCommerce 2.6 requires WordPress 4.4+</li>\n</ul>\n<p>Visit the <a href=\"https://docs.woocommerce.com/document/server-requirements/\" rel=\"nofollow\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.</p>\n<p>In the search field type “WooCommerce” and click Search Plugins. Once you’ve found our eCommerce plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.</p>\n<h4>Manual installation</h4>\n<p>The manual installation method involves downloading our eCommerce plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains <a href=\"https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation\" rel=\"nofollow\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work like a charm; as always though, ensure you backup your site just in case.</p>\n<p>If on the off-chance you do encounter issues with the shop/category pages after an update you simply need to flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting &#8216;save&#8217;. That should return things to normal.</p>\n<h4>Dummy data</h4>\n<p>WooCommerce comes with some dummy data you can use to see how products look; either import dummy_data.xml via the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> or use our <a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">CSV Import Suite plugin</a> to import dummy_data.csv and dummy_data_variations.csv.</p>\n</dd>\n<dt>Where can I find WooCommerce documentation and user guides?</dt>\n<dd>\n<p>For help setting up and configuring WooCommerce please refer to our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/getting-started/\" rel=\"nofollow\">user guide</a></p>\n<p>For extending or theming WooCommerce, see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/\" rel=\"nofollow\">codex</a>.</p>\n</dd>\n<dt>Where can I get support or talk to other users?</dt>\n<dd>\n<p>If you get stuck, you can ask for help in the <a href=\"https://wordpress.org/support/plugin/woocommerce\" rel=\"nofollow\">WooCommerce Plugin Forum</a>.</p>\n<p>For help with premium extensions from WooThemes, use <a href=\"https://support.woothemes.com/\" rel=\"nofollow\">our helpdesk</a>.</p>\n</dd>\n<dt>Will WooCommerce work with my theme?</dt>\n<dd>\n<p>Yes; WooCommerce will work with any theme, but may require some styling to make it match nicely. Please see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/\" rel=\"nofollow\">codex</a> for help. If you&#8217;re looking for a theme with built in WooCommerce integration we recommend <a href=\"https://woocommerce.com/storefront/\" rel=\"nofollow\">Storefront</a>.</p>\n</dd>\n<dt>Where can I request new features, eCommerce themes and extensions?</dt>\n<dd>\n<p>You can vote on and request new features and extensions in our <a href=\"http://ideas.woothemes.com/forums/133476-woocommerce\" rel=\"nofollow\">WooIdeas board</a></p>\n</dd>\n<dt>Where can I report bugs or contribute to the project?</dt>\n<dd>\n<p>Bugs can be reported either in our support forum or preferably on the <a href=\"https://github.com/woocommerce/woocommerce/issues\" rel=\"nofollow\">WooCommerce GitHub repository</a>.</p>\n</dd>\n<dt>Where can I find the REST API documentation?</dt>\n<dd>\n<p>You can find the documentation of our REST API on the <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/\" rel=\"nofollow\">WooCommerce REST API Docs</a>.</p>\n</dd>\n<dt>WooCommerce is awesome! Can I contribute?</dt>\n<dd>\n<p>Yes you can! Join in on our <a href=\"http://github.com/woocommerce/woocommerce/\" rel=\"nofollow\">GitHub repository</a> <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>3.1.2 &#8211; 2017-08-15</h4>\n<ul>\n<li>Fix &#8211; Importer: Prevent multiple placeholders being created when mixing IDs and SKUs.</li>\n<li>Fix &#8211; Importer: correctly set stock management props.</li>\n<li>Fix &#8211; Importer: Allow &#8220;unfiltered_html&#8221; for name, description and short description fields.</li>\n<li>Fix &#8211; Fix filename image handling.</li>\n<li>Fix &#8211; Rest API: Allow OPTIONS requests.</li>\n<li>Fix &#8211; Fixed missing reviews in product_page shortcode when querying by SKU.</li>\n<li>Fix &#8211; Don&#8217;t subtract negative taxes in net sales report.</li>\n<li>Fix &#8211; Sort by order + zone ID as a fallback in shipping zones so the zones always match in the same order.</li>\n<li>Fix &#8211; Corrected subject and heading in customer refunded email.</li>\n<li>Fix &#8211; Corrected handling of custom checkbox fields in checkout get_posted_data method.</li>\n<li>Fix &#8211; Fix admin help videos async property.</li>\n<li>Fix &#8211; Fixed price filters by introducing precision.</li>\n<li>Fix &#8211; Improved customer IP address detection.</li>\n<li>Fix &#8211; Fix dark theme readability.</li>\n<li>Fix &#8211; CLI tools command.</li>\n<li>Fix &#8211; Adjusted shop manager role to prevent unfiltered HTML being used.</li>\n<li>Fix &#8211; Various notices/warnings.</li>\n<li>Dev &#8211; Correctly invalidate cache after saving order items.</li>\n<li>Dev &#8211; Added <code>woocommerce_data_store_wp_{$this-&gt;meta_type}_read_meta</code> filter.</li>\n</ul>\n<h4>3.1.1 &#8211; 2017-07-11</h4>\n<ul>\n<li>Fix &#8211; Product importer: fixed handling of non UTF8 characters in descriptions.</li>\n<li>Fix &#8211; Product importer: Allow times in date fields.</li>\n<li>Fix &#8211; Product exporter: fixed meta data checkbox option.</li>\n<li>Fix &#8211; Helper: Styling and connect button in non-english languages.</li>\n<li>Fix &#8211; Tweak terms and conditions template to check for disallowed shortcodes.</li>\n<li>Fix &#8211; Fixed order helper queries when before_date and after_date args are both, corrected use of &#8220;paged&#8221;, and corrected use of filters.</li>\n<li>Fix &#8211; Gallery; Trigger resize after main image loads to ensure correct gallery size.</li>\n<li>Fix &#8211; Prevent extra slashes being added to meta values when using the CRUD.</li>\n<li>Fix &#8211; Appends &#8220;where&#8221; clauses in the comment feed to prevent a notice.</li>\n<li>Fix &#8211; Fixed structured data output for variable product prices.</li>\n<li>Fix &#8211; 3.x issue: Changed state validation logic to work for MX states.</li>\n<li>Fix &#8211; 3.x issue: 7day reports should start from midnight, not the current time.</li>\n<li>Fix &#8211; 3.x issue: Status changes made by admin should be marked as a manual in the order notes.</li>\n<li>Fix &#8211; 3.x issue: Allow unsetting product shipping class in REST API.</li>\n<li>Fix &#8211; 3.x issue: Corrected error handling in zones shippingMethodView.</li>\n<li>Tweak &#8211; Avoid CloudFlare email obfuscation in admin.</li>\n<li>Tweak &#8211; Improved detection of DOING_AUTOSAVE in admin meta box code.</li>\n<li>Tweak &#8211; Improved my-account redirects and fallbacks.</li>\n<li>Tweak &#8211; Add <code>cart_subtotal</code> to the shipping package so prices are recalculated when needed.</li>\n<li>Dev &#8211; Add search_customers() filter in customer data store.</li>\n<li>Dev &#8211; Product exporter: woocommerce_product_export_skip_meta_keys filter to control what gets exported.</li>\n<li>Dev &#8211; Pass correct value to woocommerce_shipping_classes_save_class when inserting a new term</li>\n</ul>\n<h4>3.1.0 &#8211; 2017-06-28</h4>\n<ul>\n<li>Feature &#8211; Built-in product CSV importer and exporter for products.</li>\n<li>Feature &#8211; Display (toggle-able) terms inline on the checkout rather than showing a link.</li>\n<li>Feature &#8211; On the &#8220;pay for order&#8221; page, if logged out show a login form rather than an error message.</li>\n<li>Feature &#8211; Enabled oembed support for product short descriptions.</li>\n<li>Feature &#8211; Added bulk variation update for stock status.</li>\n<li>Feature &#8211; On customer profiles: added a button to copy billing address to shipping address.</li>\n<li>Feature &#8211; Setup Wizard &#8211; Automatic Shipping Zone Creation In Setup Wizard for the base location.</li>\n<li>Feature &#8211; Setup Wizard &#8211; Added a new optional Storefront Theme step if you&#8217;re using a non-WooCommerce compatible theme.</li>\n<li>Feature &#8211; Made it possible to manage extension licenses purchased from WooCommerce.com on the extensions screen.</li>\n<li>Tweak &#8211; Gallery &#8211; Added a data-caption for captions to support both captions and titles for SEO.</li>\n<li>Tweak &#8211; Gallery &#8211; Used smoothHeight setting to better support images of different heights.</li>\n<li>Tweak &#8211; UI &#8211; Added blank states for API keys &amp; webhooks.</li>\n<li>Tweak &#8211; UI &#8211; Made Product submenu labels consistent in admin.</li>\n<li>Tweak &#8211; UI &#8211; Changed street address field label and placeholder to minimize user error on checkout.</li>\n<li>Tweak &#8211; UI &#8211; Added a confirmation before deleting log files.</li>\n<li>Tweak &#8211; If prices are the same for all variations, use price not priceSpecification in structured data.</li>\n<li>Tweak &#8211; Added variable so shipping calculator is shown on first row only when showing multiple shipping packages.</li>\n<li>Tweak &#8211; Updated mini-cart HTML to use a list.</li>\n<li>Tweak &#8211; Allow linking to single product additional_information tab from url hash.</li>\n<li>Tweak &#8211; Re-included WooCommerce endpoints on the appearance &gt; menus screens.</li>\n<li>Tweak &#8211; Always sync incorrect titles on variation read regardless of version.</li>\n<li>Tweak &#8211; Standardize rating HTML in all templates.</li>\n<li>Tweak &#8211; When searching, disable WC sort order so results are sorted by relevance.</li>\n<li>Tweak &#8211; Update price sorting code to use min or max for variable products depending on sorting direction.</li>\n<li>Tweak &#8211; Utilize $product method to get thumbnail in loops.</li>\n<li>Tweak &#8211; Check for an existing display name before updating a user on checkout. Adds display_name prop to the CRUD.</li>\n<li>Tweak &#8211; Adapt variable product price used in sorting based on direction of sort.</li>\n<li>Tweak &#8211; Made state validation less strict for keys.</li>\n<li>Tweak &#8211; For COD orders, force payment complete status to be completed.</li>\n<li>Fix &#8211; Use get_max_purchase_quantity in cart template and fix logic when stock management is off.</li>\n<li>Fix &#8211; Added log_id as the secondary sorting column to log list so log entries sort correctly.</li>\n<li>Fix &#8211; Fix shop page when using shop base and UTF8 shop page slug.</li>\n<li>Fix &#8211; Added handles so drag and drop does not break edit on mobile when sorting categories.</li>\n<li>Fix &#8211; Added ABSPATH checks to all files.</li>\n<li>Fix &#8211; Fixed how to flush rewrite rules after saving the shop main page.</li>\n<li>Fix &#8211; Emails sent via admin should switch to global locale.</li>\n<li>Fix &#8211; Set and restore wp_query so product page functions think it&#8217;s a real product page.</li>\n<li>Fix &#8211; Variation default value of &#8216;0&#8217; fails to save on product.</li>\n<li>Fix &#8211; Prevent locations being added to the &#8220;Rest Of The World&#8221; shipping zone via the API.</li>\n<li>Dev &#8211; Allow date created to be set in wc_create_refund.</li>\n<li>Dev &#8211; Introduced a <a href=\"https://github.com/woocommerce/woocommerce/wiki/wc_get_orders-and-WC_Order_Query\" rel=\"nofollow\">WC_Order_Query class</a> for finding/searching orders.</li>\n<li>Dev &#8211; Added &#8220;restored&#8221; webhook.</li>\n<li>Dev &#8211; Support floats for the custom attribute name sorting function.</li>\n<li>Dev &#8211; Updated Emogrifier to version 1.2.</li>\n<li>Dev &#8211; Sort product data tabs by priority in admin screen.</li>\n<li>Dev &#8211; Added new hooks for: dashboard reviews widget, product and category sorting events, woocommerce_add_to_cart_sold_individually_found_in_cart, cart empty messages.</li>\n<li>Dev &#8211; Added filters for zoom / flexslider / photoswipe enabling.</li>\n<li>Dev &#8211; Added filter for cookie name.</li>\n<li>Dev &#8211; Added ability to filter Photoswipe lightbox options.</li>\n<li>Dev &#8211; Added new filter for product thumbnail size.</li>\n<li>Dev &#8211; Added action for displaying custom data for fees in admin.</li>\n<li>Dev &#8211; Changed build_payload from private to public in webhook system.</li>\n<li>Dev &#8211; Added deprecated notice to WC_Order_Item_Meta (deprecated in 3.0).</li>\n<li>Dev &#8211; Added namespace to jQuery events that are removed in VariationForm.</li>\n<li>Dev &#8211; Made WC_Checkout::get_posted_data() public.</li>\n<li>Dev &#8211; Add custom message for custom system status tools.</li>\n<li>Dev &#8211; Added filters to change which order items are created and loaded to support custom item types.</li>\n<li>Dev &#8211; Updated jQuery payment and serializejson libraries.</li>\n<li>Localization &#8211; Added Bolivian states.</li>\n<li>Localization &#8211; Use VAT for Norway instead of Tax.</li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/master/CHANGELOG.txt\" rel=\"nofollow\">See changelog for all versions</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/woocommerce/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/all-in-one-seo-pack/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 19:30:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins-wp/all-in-one-seo-pack/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"The original SEO plugin for WordPress, downloaded over 30,000,000 times since 2007.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4934:\"<p><!--section=description--></p>\n<p>Use <strong>All in One SEO Pack</strong> to optimize your WordPress site for SEO. It&#8217;s easy and works out of the box for beginners, and has advanced features and an API for developers.</p>\n<p><strong><a href=\"http://semperplugins.com/plugins/all-in-one-seo-pack-pro-version/?loc=readme_utpv\" rel=\"nofollow\">Upgrade to Pro Version</a></strong></p>\n<p><a href=\"http://semperplugins.com/support/?loc=readme_ps\" rel=\"nofollow\">Premium Support</a></p>\n<p>First created in 2007, see why AIOSEO is one of the all time most downloaded plugins for WordPress.</p>\n<ul>\n<li>XML Sitemap support &#8211; submit your sitemap to Google and Bing and improve your SEO</li>\n<li>Google AMP support (Accelerated Mobile Pages)</li>\n<li>Google Analytics support</li>\n<li>Support for SEO on Custom Post Types</li>\n<li>Advanced Canonical URLs</li>\n<li>Redirect attachment pages to parent post</li>\n<li>Automatically notifies search engines like Google and Bing about changes to your site</li>\n<li>Built-in API so other plugins/themes can access and extend functionality</li>\n<li>ONLY free plugin to provide SEO Integration for e-Commerce sites, including WooCommerce</li>\n<li>Nonce Security built into All in One SEO Pack</li>\n<li>Automatically optimizes your <strong>titles</strong> for Google and other search engines</li>\n<li>Generates <strong>META tags automatically</strong></li>\n<li>Avoids the typical duplicate content found on WordPress blogs</li>\n<li>For beginners, you don&#8217;t even have to look at the options, it works out-of-the-box. Just install.</li>\n<li>For advanced users, you can fine-tune everything to optimize your SEO</li>\n<li>You can override any title and set any META description and any META keywords you want.</li>\n<li>Compatibility with many other plugins</li>\n<li>Translated into 57 languages</li>\n<li>PHP 7 100% Compatible</li>\n</ul>\n<p>Follow me on Twitter to keep up with the latest updates <a href=\"http://twitter.com/michaeltorbert/\" rel=\"nofollow\">Michael<br />\nTorbert</a></p>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/46MR4FboMaA?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n<h4>Tags</h4>\n<p>seo, SEO, All in One, google, meta, meta description, search engine optimization, xml sitemap, xml sitemaps, google sitemap, sitemap, sitemaps, robots meta, rss, rss footer, yahoo, bing, widget, Post, plugin, admin, posts, shortcode, sidebar, twitter, page, images, comments, image, news sitemaps, XML News Sitemaps, WordPress SEO, multisite, canonical, nofollow, noindex, keywords, meta keywords, description, webmaster tools, google webmaster tools, seo pack, schema.org, search engines, custom post types, custom taxonomies, canonical</p>\n<p><!--section=faq--></p>\n<p>Please visit our complete <strong><a href=\"http://semperplugins.com/documentation/\" rel=\"nofollow\">Documentation</a></strong> before requesting support for SEO from the<br />\n<strong><a href=\"http://semperplugins.com/support/\" rel=\"nofollow\">All in One SEO Pack Support Forum</a></strong></p>\n<p><a href=\"http://semperfiwebdesign.com/documentation/all-in-one-seo-pack/translations-for-all-in-one-seo-pack/\" rel=\"nofollow\">Translations</a></p>\n<dl>\n<dt>General Settings</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/uGt6CVbA5bI?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n<dt>XML Sitemaps</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/zvNU92Low8A?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n<dt>Social Meta</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/Dfe49FiiAog?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n<dt>Performance</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/A0VKinM5s00?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<p>All in One SEO Pack <a href=\"http://semperfiwebdesign.com/documentation/all-in-one-seo-pack/all-in-one-seo-pack-release-history/\" rel=\"nofollow\">Changelog</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/all-in-one-seo-pack/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/google-sitemap-generator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/plugins/google-sitemap-generator/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Jun 2005 09:33:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins-wp/google-sitemap-generator/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"This plugin will improve SEO by helping search enginess better index your site using sitemaps.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:27964:\"<p><!--section=description--></p>\n<p>Use this plugin to greatly improve SEO to create special XML sitemaps which will help search engines like Google, Bing, Yahoo and Ask.com to better index your site.</p>\n<p>With such a sitemap, it&#8217;s much easier for the crawlers to see the complete structure of your site and retrieve it more efficiently. The plugin supports all kinds of WordPress generated pages as well as custom URLs. Additionally it notifies all major search engines every time you create a post about the new content.</p>\n<p>Supported since <em>over 9 years</em> and rated as the <a href=\"https://wordpress.org/plugins/browse/top-rated/\">best WordPress plugin</a>, it will do exactly what it&#8217;s supposed to do &#8211; providing a complete XML sitemap for search engines. It will not break your site, slow it down or annoy you. Guaranteed!</p>\n<blockquote>\n<p>If you like the plugin, feel free to rate it (on the right side of this page)! <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</blockquote>\n<p>Related Links:</p>\n<ul>\n<li><a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\" title=\"Google XML Sitemaps Plugin for WordPress\" rel=\"nofollow\">Plugin Homepage</a></li>\n<li><a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/changelog/\" title=\"Changelog of the Google XML Sitemaps Plugin for WordPress\" rel=\"nofollow\">Changelog</a></li>\n<li><a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/help/\" title=\"Google Sitemaps FAQ\" rel=\"nofollow\">Plugin help and sitemaps FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/topic/read-before-opening-a-new-support-topic\" rel=\"nofollow\">Support Forum</a></li>\n</ul>\n<h3>License</h3>\n<p>Good news, this plugin is free for everyone! Since it&#8217;s released under the GPL, you can use it free of charge on your personal or commercial site.</p>\n<h3>Translations</h3>\n<p>The plugin comes with various translations, please refer to the <a href=\"https://codex.wordpress.org/Installing_WordPress_in_Your_Language\" title=\"Installing WordPress in Your Language\" rel=\"nofollow\">WordPress Codex</a> for more information about activating the translation. If you want to help to translate the plugin to your language, please have a look at the sitemap.pot file which contains all definitions and may be used with a <a href=\"http://www.gnu.org/software/gettext/\" rel=\"nofollow\">gettext</a> editor like <a href=\"http://www.poedit.net/\" rel=\"nofollow\">Poedit</a> (Windows).</p>\n<p><!--section=installation--></p>\n<ol>\n<li>Install the plugin like you always install plugins, either by uploading it via FTP or by using the &#8220;Add Plugin&#8221; function of WordPress.</li>\n<li>Activate the plugin at the plugin administration page</li>\n<li>If you want: Open the plugin configuration page, which is located under Settings -&gt; XML-Sitemap and customize settings like priorities and change frequencies.</li>\n<li>The plugin will automatically update your sitemap of you publish a post, so there is nothing more to do <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></li>\n</ol>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<ol>\n<li>Install the plugin like you always install plugins, either by uploading it via FTP or by using the &#8220;Add Plugin&#8221; function of WordPress.</li>\n<li>Activate the plugin at the plugin administration page</li>\n<li>If you want: Open the plugin configuration page, which is located under Settings -&gt; XML-Sitemap and customize settings like priorities and change frequencies.</li>\n<li>The plugin will automatically update your sitemap of you publish a post, so there is nothing more to do <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></li>\n</ol>\n</dd>\n<dt>Where can I find the options page of the plugin?</dt>\n<dd>\n<p>It is under Settings &gt; XML Sitemap. I know nowadays many plugins add top-level menu items, but in most of the cases it is just not necessary. I&#8217;ve seen WP installations which looked like an Internet Explorer ten years ago with 20 toolbars installed. <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</dd>\n<dt>Do I have to create a sitemap.xml and sitemap.xml.gz by myself?</dt>\n<dd>\n<p>Not anymore. Since version 4, these files are dynamically generated. <em>There must be no sitemap.xml or sitemap.xml.gz in your site directory anymore!</em> The plugin will try to rename them to sitemap.xml.bak if they still exists.</p>\n</dd>\n<dt>Does this plugin use static files or &#8220;I can&#8217;t find the sitemap.xml file!&#8221;</dt>\n<dd>\n<p>Not anymore. Since version 4, these files are dynamically generated just like any other WordPress content.</p>\n</dd>\n<dt>There are no comments yet (or I&#8217;ve disabled them) and all my postings have a priority of zero!</dt>\n<dd>\n<p>Please disable automatic priority calculation and define a static priority for posts.</p>\n</dd>\n<dt>So many configuration options&#8230; Do I need to change them?</dt>\n<dd>\n<p>No, only if you want to. Default values are ok for most sites.</p>\n</dd>\n<dt>Does this plugin work with all WordPress versions?</dt>\n<dd>\n<p>This version works with WordPress 3.3 and better. If you&#8217;re using an older version, please check the <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\" title=\"Google (XML) Sitemap Generator Plugin Homepage\" rel=\"nofollow\">Google Sitemaps Plugin Homepage</a> for the legacy releases. There is a working release for every WordPress version since 1.5, but you really should consider updating your WordPress installation!</p>\n</dd>\n<dt>My question isn&#8217;t answered here</dt>\n<dd>\n<p>Most of the plugin options are described at the <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\" rel=\"nofollow\">plugin homepage</a> as well as the dedicated <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/help/\" title=\"List of common questions / problems regarding Google (XML) Sitemaps\" rel=\"nofollow\">Google Sitemaps FAQ</a>.</p>\n</dd>\n<dt>My question isn&#8217;t even answered there</dt>\n<dd>\n<p>Please post your question at the <a href=\"https://wordpress.org/support/topic/read-before-opening-a-new-support-topic\" rel=\"nofollow\">WordPress support forum</a> and tag your post with &#8220;google-sitemap-generator&#8221;.</p>\n</dd>\n<dt>What&#8217;s new in the latest version?</dt>\n<dd>\n<p>The changelog is maintained <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/changelog/\" title=\"Google (XML) Sitemap Generator Plugin Changelog\" rel=\"nofollow\">here</a></p>\n</dd>\n<dt>Why is the changelog on a separate page and not here?</dt>\n<dd>\n<p>The WordPress.org repository is just another place to download this plugin. I don&#8217;t want to maintain too many pages with the same content. Thank you for your understanding!</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>4.0.9 (2017-07-24)</h4>\n<ul>\n<li>Fixed security issue related to donation functionality.</li>\n</ul>\n<h4>4.0.8 (2014-11-15)</h4>\n<ul>\n<li>Fixed bug regarding the exclude categories feature, thanks to Claus Schöffel!</li>\n</ul>\n<h4>4.0.7.1 (2014-09-02)</h4>\n<ul>\n<li>Sorry, no new features this time… This release only updates the Compatibility-Tag to WordPress 4.0. Unfortunately there is no way to do this anymore without a new version</li>\n</ul>\n<h4>4.0.7 (2014-06-23)</h4>\n<ul>\n<li>Better compatibility with GoDaddy managed WP hosting</li>\n<li>Better compatibility with QuickCache</li>\n<li>Removed WordPress version from the sitemap</li>\n<li>Corrected link to WordPress privacy settings (if search engines are blocked)</li>\n<li>Changed hook which is being used for sitemap pings to avoid pings on draft edit</li>\n</ul>\n<h4>4.0.6 (2014-06-03)</h4>\n<ul>\n<li>Added option to disable automatic gzipping</li>\n<li>Fixed bug with duplicated external sitemap entries</li>\n<li>Don’t gzip if behind Varnish since Varnish can do that</li>\n</ul>\n<h4>4.0.5 (2014-05-18)</h4>\n<ul>\n<li>Added function to manually start ping for main-sitemap or all sub-sitemaps</li>\n<li>Added support for changing the base of the sitemap URL to another URL (for WP installations in sub-folders)</li>\n<li>Fixed issue with empty post sitemaps (related to GMT/local time offset)</li>\n<li>Fixed some timing issues in archives</li>\n<li>Improved check for possible problems before gzipping</li>\n<li>Fixed empty archives and author sitemaps in case there were no posts</li>\n<li>Fixed bug which caused the Priority Provider to disappear in recent PHP versions</li>\n<li>Plugin will also ping with the corresponding sub-sitemap in case a post was modified</li>\n<li>Better checking for empty external urls</li>\n<li>Changed text in XSL template to be more clear about sitemap-index and sub-sitemaps</li>\n<li>Changed content type to text/xml to improve compatibility with caching plugins</li>\n<li>Changed query parameters to is_feed=true to improve compatibility with caching plugins</li>\n<li>Switched from using WP_Query to load posts to a custom SQL statement to avoid problems with other plugin filters</li>\n<li>Added caching of some SQL statements</li>\n<li>Added support feed for more help topics</li>\n<li>Added link to new help page</li>\n<li>Cleaned up code and renamed variables to be more readable</li>\n<li>Updated Japanese Translation, thanks to Daisuke Takahashi</li>\n</ul>\n<h4>4.0.4 (2014-04-19)</h4>\n<ul>\n<li>Removed deprecated get_page call</li>\n<li>Changed last modification time of sub-sitemaps to the last modification date of the posts instead of the publish date</li>\n<li>Removed information window if the statistic option has not been activated</li>\n<li>Added link regarding new sitemap format</li>\n<li>Updated Portuguese translation, thanks to Pedro Martinho</li>\n<li>Updated German translation</li>\n</ul>\n<h4>4.0.3 (2014-04-13)</h4>\n<ul>\n<li>Fixed compression if an gzlib handler was already active</li>\n<li>Help regarding permalinks for Nginx users</li>\n<li>Fix with gzip compression in case there was other output before already</li>\n<li>Return 404 for HTML sitemaps if the option has been disabled</li>\n<li>Updated translations</li>\n</ul>\n<h4>4.0.2 (2014-04-01)</h4>\n<ul>\n<li>Fixed warning if an gzip handler is already active</li>\n</ul>\n<h4>4.0.1 (2014-03-31)</h4>\n<ul>\n<li>Fixed bug with custom post types including a &#8220;-&#8220;</li>\n<li>Fixed some 404 Not Found Errors</li>\n</ul>\n<h4>4.0 (2014-03-30)</h4>\n<ul>\n<li>No static files anymore, sitemap is created on the fly!</li>\n<li>Sitemap is split-up into sub-sitemaps by month, allowing up to 50.000 posts per month! <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/google-xml-sitemap-generator-new-sitemap-format/\" rel=\"nofollow\">More information</a></li>\n<li>Support for custom post types and custom taxonomis!</li>\n<li>100% Multisite compatible, including by-blog and network activation.</li>\n<li>Reduced server resource usage due to less content per request.</li>\n<li>New API allows other plugins to add their own, separate sitemaps.</li>\n<li>Note: PHP 5.1 and WordPress 3.3 is required! The plugin will not work with lower versions!</li>\n<li>Note: This version will try to rename your old sitemap files to *-old.xml. If that doesn’t work, please delete them manually since no static files are needed anymore!</li>\n</ul>\n<h4>3.4.1 (2014-04-10)</h4>\n<ul>\n<li>Compatibility with mysqli</li>\n</ul>\n<h4>Version 3.4 (2013-11-24)</h4>\n<ul>\n<li>Fixed deprecation warnings in PHP 5.4, thanks to Dion Hulse!</li>\n</ul>\n<h4>3.3 (2013-09-28)</h4>\n<ul>\n<li>Fixed problem with file permission checking</li>\n<li>Filter out hashs (#) in URLs</li>\n</ul>\n<h4>3.2.9 (2013-01-11)</h4>\n<ul>\n<li>Fixed security issue with change frequencies and filename of sitemap file. Exploit was only possible with admin account.</li>\n</ul>\n<h4>3.2.8 (2012-08-08)</h4>\n<ul>\n<li>Fixed wrong custom taxonomy URLs, thanks to ramon fincken of the wordpress.org forum!</li>\n<li>Removed ASK ping since they shut down their service.</li>\n<li>Exclude post_format taxonomy from custom taxonomy list</li>\n</ul>\n<h4>3.2.7 (2012-04-24)</h4>\n<ul>\n<li>Fixed custom post types, thanks to clearsite of the wordpress.org forum!</li>\n<li>Fixed broken admin layout on WP 3.4</li>\n</ul>\n<h4>3.2.6 (2011-09-19)</h4>\n<ul>\n<li>Removed YAHOO ping since YAHOO uses bing now</li>\n<li>Removed deprecated function call</li>\n</ul>\n<h4>3.2.5 (2011-07-11)</h4>\n<ul>\n<li>Backported Bing ping success fix from beta</li>\n<li>Added friendly hint to try out the new beta</li>\n</ul>\n<h4>3.2.4 (2010-05-29)</h4>\n<ul>\n<li>Added (GMT) to date column in sitemap xslt template to avoid confusion with different time zones</li>\n<li>Fixed wrong SQL statement for author pages, thanks to twoenoug</li>\n<li>Fixed several deprecated function calls</li>\n<li>Note: This release does not support the new multisite feature of WordPress yet and will not be active when multisite is enabled.</li>\n</ul>\n<h4>3.2.3 (2010-04-02)</h4>\n<ul>\n<li>Fixed that all pages were missing in the sitemap if the “Uncategorized” category was excluded</li>\n</ul>\n<h4>3.2.2 (2009-12-19)</h4>\n<ul>\n<li>Updated compatibility tag to WordPress 2.9</li>\n<li>Fixed PHP4 problems</li>\n</ul>\n<h4>3.2.1 (2009-12-16)</h4>\n<ul>\n<li>Notes and update messages at the top of the admin page could interfere with the manual build function</li>\n<li>Help links in the WP contextual help were not shown anymore since the last update</li>\n<li>IE 7 sometimes displayed a cached admin page</li>\n<li>Removed invalid link to config page from the plugin description (The link lead to a &#8220;Not enough permission error&#8221;)</li>\n<li>Improved performance of getting the current plugin version by caching</li>\n<li>Updated Spanish language files</li>\n</ul>\n<h4>3.2 (2009-11-23)</h4>\n<ul>\n<li>Added function to show the actual results of a ping instead of only linking to the url</li>\n<li>Added new hook (sm_rebuild) for third party plugins to start building the sitemap</li>\n<li>Fixed bug which showed the wrong URL for the latest Google ping result</li>\n<li>Added some missing documentation</li>\n<li>Removed hardcoded php name for sitemap file in admin urls</li>\n<li>Uses KSES for showing ping test results</li>\n<li>Ping test fixed for WP &lt; 2.3</li>\n</ul>\n<h4>3.1.9 (2009-11-13)</h4>\n<ul>\n<li>Fixed MySQL Error if author pages were included</li>\n</ul>\n<h4>3.1.8 (2009-11-07)</h4>\n<ul>\n<li>Improved custom taxonomy handling and fixed wrong last modification date</li>\n<li>Fixed fatal error in WordPress versions lower than 2.3</li>\n<li>Fixed Update Notice for WordPress 2.8 and higher</li>\n<li>Added warning if blog privacy is activated</li>\n<li>Fixed priorities of additional pages were shown as 0 instead of 1</li>\n</ul>\n<h4>3.1.7 (2009-10-21)</h4>\n<ul>\n<li>Added support for custom taxonomies. Thanks to Lee!</li>\n</ul>\n<h4>3.1.6 (2009-08-31)</h4>\n<ul>\n<li>Fixed PHP error “Only variables can be passed by reference”</li>\n<li>Fixed wrong URLS of multi-page posts (Thanks artstorm!)</li>\n<li>Updated many language files</li>\n</ul>\n<h4>3.1.5 (2009-08-24)</h4>\n<ul>\n<li>Added option to completely disable the last modification time</li>\n<li>Fixed problem with HTTPS url for the XSL stylesheet if the sitemap was build via the admin panel</li>\n<li>Improved handling of homepage entry if a single page was set for it</li>\n<li>Fixed mktime warning which appeared sometimes</li>\n<li>Fixed bug which caused inf. reloads after rebuilding the sitemap via the admin panel</li>\n<li>Improved handling of missing sitemaps files if WP was moved to another location</li>\n</ul>\n<h4>3.1.4 (2009-06-22)</h4>\n<ul>\n<li>Fixed bug which broke all pings in WP older than 2.7</li>\n<li>Added more output in debug mode if pings fail</li>\n<li>Moved global post variable so other plugins can use it in get_permalink()</li>\n<li>Added small icon for ozh admin menu</li>\n<li>Added more help links in UI</li>\n</ul>\n<h4>3.1.3 (2009-06-07)</h4>\n<ul>\n<li>Changed MSN Live Search to Bing</li>\n<li>Exclude categories also now exludes the category itself and not only the posts</li>\n<li>Pings now use the new WordPress HTTP API instead of Snoopy</li>\n<li>Fixed bug that in localized WP installations priorities could not be saved</li>\n<li>The sitemap cron job is now cleared after a manual rebuild or after changing the config</li>\n<li>Adjusted style of admin area for WP 2.8 and refreshed icons</li>\n<li>Disabled the “Exclude categories” feature for WP 2.5.1, since it doesn’t have the required functions yet</li>\n</ul>\n<h4>3.1.2 (2008-12-26)</h4>\n<ul>\n<li>Changed the way the stylesheet is saved (default / custom stylesheet)</li>\n<li>Sitemap is now rebuild when a page is published</li>\n<li>Removed support for static robots.txt files, this is now handled via WordPress functions</li>\n<li>Added compat. exceptions for WP 2.0 and WP 2.1</li>\n</ul>\n<h4>3.1.1 (2008-12-21)</h4>\n<ul>\n<li>Fixed redirect issue if wp-admin is rewritten via mod_rewrite, thanks to macjoost</li>\n<li>Fixed wrong path to assets, thanks PozHonks</li>\n<li>Fixed wrong plugin URL if wp-content was renamed / redirected, thanks to wnorris</li>\n<li>Updated WP User Interface for 2.7</li>\n<li>Various other small things</li>\n</ul>\n<h4>3.1.0.1 (2008-05-27)</h4>\n<ul>\n<li>Extracted UI JS to external file</li>\n<li>Enabled the option to include following pages of multi-page posts</li>\n<li>Script tries to raise memory and time limit if active</li>\n</ul>\n<h4>3.1 (2008-05-22)</h4>\n<ul>\n<li>Marked as stable</li>\n</ul>\n<h4>3.1b3 (2008-05-19)</h4>\n<ul>\n<li>Cleaned up plugin directory and moved img files to subfolders</li>\n<li>Fixed background building bug in WP 2.1</li>\n<li>Removed auto-update plugin link for WP &lt; 2.5</li>\n</ul>\n<h4>3.1b2 (2008-05-18)</h4>\n<ul>\n<li>Fixed critical bug with the build in background option</li>\n<li>Added notification if a build is scheduled</li>\n</ul>\n<h4>3.1b1 (2008-05-08)</h4>\n<ul>\n<li>Splitted plugin in loader, generator and user interface to save memory</li>\n<li>Generator and UI will only be loaded when needed</li>\n<li>Secured all admin actions with nonces</li>\n<li>Improved WP 2.5 handling</li>\n<li>New &#8220;Suggest a Feature&#8221; link</li>\n</ul>\n<h4>3.0.3.3 (2008-04-29)</h4>\n<ul>\n<li>Fixed author pages</li>\n<li>Enhanced background building and increased delay to 15 seconds</li>\n<li>Enabled background building by default</li>\n</ul>\n<h4>3.0.3.2 (2008-04-28)</h4>\n<ul>\n<li>Improved WP 2.5 handling (fixes blank screens and timeouts)</li>\n</ul>\n<h4>3.0.3.1 (2008-03-30)</h4>\n<ul>\n<li>Added compatibility CSS for WP 2.5</li>\n</ul>\n<h4>3.0.3 (2007-12-30)</h4>\n<ul>\n<li>Added option to ping MSN Live Search</li>\n<li>Removed some WordPress hooks (the sitemap isn’t updates with every comment anymore)</li>\n</ul>\n<h4>3.0.2.1 (2007-11-28)</h4>\n<ul>\n<li>Fixed wrong XML Schema Location (Thanks to Emanuele Tessore)</li>\n<li>Added Russian Language files by Sergey http://ryvkin.ru</li>\n</ul>\n<h4>3.0.2 (2007-11-25)</h4>\n<ul>\n<li>Fixed bug which caused that some settings were not saved correctly</li>\n<li>Added option to exclude pages or post by ID</li>\n<li>Restored YAHOO ping service with API key since the other one is to unreliable</li>\n</ul>\n<h4>3.0.1 (2007-11-03)</h4>\n<ul>\n<li>Changed HTTP client for ping requests to Snoopy</li>\n<li>Added &#8220;safemode&#8221; for SQL which doesn’t use unbuffered results</li>\n<li>Added option to run the building process in background using wp-cron</li>\n<li>Added links to test the ping if it failed</li>\n</ul>\n<h4>3.0 final (2007-09-24)</h4>\n<ul>\n<li>Marked as stable</li>\n<li>Removed useless functions</li>\n</ul>\n<h4>3.0b11 (2007-09-23)</h4>\n<ul>\n<li>Changed mysql queries to unbuffered queries</li>\n<li>Uses MUCH less memory</li>\n<li>Option to limit the number of posts</li>\n</ul>\n<h4>3.0b10 (2007-09-04)</h4>\n<ul>\n<li>Added category support for WordPress 2.3</li>\n<li>Fixed bug with empty URLs in sitemap</li>\n<li>Repaired GET building</li>\n</ul>\n<h4>3.0b9 (2007-09-02)</h4>\n<ul>\n<li>Added tag support for WordPress 2.3</li>\n<li>Fixed archive bug with static pages (Thanks to Peter Claus Lamprecht)</li>\n<li>Fixed some missing translation strings, thanks to Kirin Lin</li>\n</ul>\n<h4>3.0b8 (2007-07-22)</h4>\n<ul>\n<li>Fixed bug with empty categories</li>\n<li>Fixed bug with translation plugins</li>\n<li>Added support for robots.txt</li>\n<li>Switched YAHOO ping API from YAHOO Web Services to the “normal” ping service</li>\n<li>Search engines will only be pinged if the sitemap file has changed</li>\n</ul>\n<h4>3.0b7 (2007-05-17)</h4>\n<ul>\n<li>Added Ask.com notification</li>\n<li>Added option to include the author pages like /author/john</li>\n<li>Fixed WP 2.1 / Pre 2.1 post / pages database changes</li>\n<li>Added check to not build the sitemap if importing posts</li>\n<li>Fixed wrong XSLT location (Thanks froosh)</li>\n<li>Small enhancements and bug fixes</li>\n</ul>\n<h4>3.0b6 (2007-01-23)</h4>\n<ul>\n<li>sitemap.xml.gz was not compressed</li>\n<li>YAHOO update-notification was PHP5 only (Thanks to Joseph Abboud!)</li>\n<li>More WP 2.1 optimizations</li>\n<li>Reduced memory usage with PHP5</li>\n</ul>\n<h4>3.0b5 (2007-01-19)</h4>\n<ul>\n<li>WordPress 2 Design</li>\n<li>YAHOO update notification</li>\n<li>New status report, removed ugly logfiles</li>\n<li>Added option to define a XSLT stylesheet and added a default one</li>\n<li>Fixed bug with sub-pages, thanks to <a href=\"http://baptiste.us/\" rel=\"nofollow\">Mike</a>, <a href=\"http://fastagent.de/\" rel=\"nofollow\">Peter</a> and <a href=\"http://publicityship.com.au/\" rel=\"nofollow\">Glenn</a></li>\n<li>Improved file handling, thanks to <a href=\"http://www.vjtd3.com/\" rel=\"nofollow\">VJTD3</a></li>\n<li>WP 2.1 improvements</li>\n</ul>\n<h4>3.0b4 (2006-11-16)</h4>\n<ul>\n<li>Fixed some smaller bugs</li>\n<li>Decreased memory usage which should solve timeout and memory problems</li>\n<li>Updated namespace to support YAHOO and MSN</li>\n</ul>\n<h4>3.0b2 (2006-01-14)</h4>\n<ul>\n<li>Fixed several bugs reported by users</li>\n</ul>\n<h4>3.0b (2005-11-25)</h4>\n<ul>\n<li>WordPress 2.0 (Beta, RC1) compatible</li>\n<li>Added different priority calculation modes and introduced an API to create custom ones (Some people didn’t like the way to calculate the post priority based on the count of user comments. This will give you the possibility to develop custom priority providers which fit your needs.)</li>\n<li>Added support to use the <a href=\"http://www.alexking.org/blog/2005/07/27/popularity-contest-11/\" rel=\"nofollow\">Popularity Contest</a> plugin by <a href=\"http://www.alexking.org/\" rel=\"nofollow\">Alex King</a> to calculate post priority (If you are already using the Popularity Contest plugin, this will be the best way to determine the priority of the posts. Uses to new priority API noted above.)</li>\n<li>Added option to exclude password protected posts (This was one of the most requested features.)</li>\n<li>Posts and pages marked for publish with a date in the future won’t be included</li>\n<li>Added function to start sitemap creation via GET and a secret key (If you are using external software which directly writes into the database without using the WordPress API, you can rebuild the sitemap with a simple HTTP Request. This can be made with a cron job for example.)</li>\n<li>Improved compatibility with other plugins (There should no longer be problems with other plugins now which checked for existence of a specified function to determine if you are in the control panel or not.)</li>\n<li>Recoded plugin architecture which is now fully OOP (The code is now cleaner and better to understand which makes it easier to modify. This should also avoid namespace problems.)</li>\n<li>Improved speed and optimized settings handling (Settings and pages are only loaded if the sitemap generation process starts and not every time a page loads. This saves one MySQL Query on every request.)</li>\n<li>Added Button to restore default configuration (Messed up the config? You’ll need just one click to restore all settings.)</li>\n<li>Added log file to check everything is running (In the new log window you can see when your sitemap was rebuilt or if there was any error.)</li>\n<li>Improved user-interface</li>\n<li>Added several links to homepage and support (This includes the Notify List about new releases and the WordPress support forum.)</li>\n</ul>\n<h4>2.7 (2005-11-25)</h4>\n<ul>\n<li>Added Polish Translation by <a href=\"http://kubazwolinski.com/\" rel=\"nofollow\">kuba</a></li>\n</ul>\n<h4>2.7 (2005-11-01)</h4>\n<ul>\n<li>Added French Translation by <a href=\"http://www.chezthierry.info/\" rel=\"nofollow\">Thierry Lanfranchi</a></li>\n</ul>\n<h4>2.7 (2005-07-21)</h4>\n<ul>\n<li>Fixed bug with incorrect date in additional pages (wrong format)</li>\n<li>Added Swedish Translation by <a href=\"http://tobiasbergius.se/\" rel=\"nofollow\">Tobias Bergius</a></li>\n</ul>\n<h4>2.6 (2005-07-16)</h4>\n<ul>\n<li>Included Chinese (Simplified) language files by <a href=\"http://www.june6.cn/\" rel=\"nofollow\">june6</a></li>\n</ul>\n<h4>2.6 (2005-07-04)</h4>\n<ul>\n<li>Added support to store the files at a custom location</li>\n<li>Changed the home URL to have a slash at the end</li>\n<li>Fixed errors with wp-mail</li>\n<li>Added support for other plugins to add content to the sitemap</li>\n</ul>\n<h4>2.5 (2005-06-15)</h4>\n<ul>\n<li>You can include now external pages which aren’t generated by WordPress or are not recognized by this plugin</li>\n<li>You can define a minimum post priority, which will overrride the calculated value if it’s too low</li>\n<li>The plugin will automatically ping Google whenever the sitemap gets regenerated</li>\n<li>Update 1: Included Spanish translations by <a href=\"http://www.cesargomez.org/\" rel=\"nofollow\">Cesar Gomez Martin</a></li>\n<li>Update 2: Included Italian translations by <a href=\"http://wordpress-it.it/\" rel=\"nofollow\">Stefano Aglietti</a></li>\n<li>Update 3: Included Traditional Chinese translations by <a href=\"http://kirin-lin.idv.tw/\" rel=\"nofollow\">Kirin Lin</a></li>\n</ul>\n<h4>2.2 (2005-06-08)</h4>\n<ul>\n<li>Language file support: <a href=\"http://hiromasa.zone.ne.jp/\" rel=\"nofollow\">Hiromasa</a> from <a href=\"http://hiromasa.zone.ne.jp/\" rel=\"nofollow\">http://hiromasa.zone.ne.jp</a> sent me a japanese version of the user interface and modified the script to support it! Thanks for this! Check <a href=\"https://codex.wordpress.org/WordPress_Localization\" rel=\"nofollow\">the WordPress Codex</a> how to set the language in WordPress.</li>\n<li>Added Japanese user interface by <a href=\"http://hiromasa.zone.ne.jp/\" rel=\"nofollow\">Hiromasa</a></li>\n<li>Added German user interface by me</li>\n</ul>\n<h4>2.12 (2005-06-07)</h4>\n<ul>\n<li>Changed SQL Statement for categories that it also works on MySQL 3</li>\n</ul>\n<h4>2.11 (2005-06-07)</h4>\n<ul>\n<li>Fixed a hardcoded tablename which made a SQL error</li>\n</ul>\n<h4>2.1 (2005-06-07)</h4>\n<ul>\n<li>Can also generate a gzipped version of the xml file (sitemap.xml.gz)</li>\n<li>Uses correct last modification dates for categories and archives. (Thanks to thx <a href=\"http://www.shupe.ca/\" rel=\"nofollow\">Rodney Shupe</a> for the SQL)</li>\n<li>Supports now different WordPress / Blog directories</li>\n<li>Fixed bug which ignored different post/page priorities (Reported by <a href=\"http://h3h.net/\" rel=\"nofollow\">Brad</a>)</li>\n</ul>\n<h4>2.01 (2005-06-07)</h4>\n<ul>\n<li>Fixed compatibility for PHP installations which are not configured to use short open tags</li>\n<li>Changed Line 147 from _e($i); to _e(strval($i));</li>\n<li>Thanks to <a href=\"http://publicvoidblog.de/\" rel=\"nofollow\">Christian Aust</a> for reporting this!</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/google-sitemap-generator/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Limit Login Attempts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/limit-login-attempts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/limit-login-attempts/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jan 2009 14:20:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins-wp/limit-login-attempts/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Limit rate of login attempts, including by way of cookies, for each IP. Fully customizable.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"johanee\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11518:\"<p><!--section=description--></p>\n<p>Limit the number of login attempts possible both through normal login as well as using auth cookies.</p>\n<p>By default WordPress allows unlimited login attempts either through the login page or by sending special cookies. This allows passwords (or hashes) to be brute-force cracked with relative ease.</p>\n<p>Limit Login Attempts blocks an Internet address from making further attempts after a specified limit on retries is reached, making a brute-force attack difficult or impossible.</p>\n<p>Features</p>\n<ul>\n<li>Limit the number of retry attempts when logging in (for each IP). Fully customizable</li>\n<li>Limit the number of attempts to log in using auth cookies in same way</li>\n<li>Informs user about remaining retries or lockout time on login page</li>\n<li>Optional logging, optional email notification</li>\n<li>Handles server behind reverse proxy</li>\n<li>It is possible to whitelist IPs using a filter. But you probably shouldn&#8217;t. 🙂</li>\n</ul>\n<p>Translations: Bulgarian, Brazilian Portuguese, Catalan, Chinese (Traditional), Czech, Dutch, Finnish, French, German, Hungarian, Norwegian, Persian, Romanian, Russian, Spanish, Swedish, Turkish</p>\n<p>Plugin uses standard actions and filters only.</p>\n<p><!--section=installation--></p>\n<ol>\n<li>Download and extract plugin files to a wp-content/plugin directory.</li>\n<li>Activate the plugin through the WordPress admin interface.</li>\n<li>Customize the settings on the options page, if desired. If your server is located behind a reverse proxy make sure to change this setting.</li>\n</ol>\n<p>If you have any questions or problems please make a post here: https://wordpress.org/tags/limit-login-attempts</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Why not reset failed attempts on a successful login?</dt>\n<dd>\n<p>This is very much by design. Otherwise you could brute force the &#8220;admin&#8221; password by logging in as your own user every 4th attempt.</p>\n</dd>\n<dt>What is this option about site connection and reverse proxy?</dt>\n<dd>\n<p>A reverse proxy is a server in between the site and the Internet (perhaps handling caching or load-balancing). This makes getting the correct client IP to block slightly more complicated.</p>\n<p>The option default to NOT being behind a proxy &#8212; which should be by far the common case.</p>\n</dd>\n<dt>How do I know if my site is behind a reverse proxy?</dt>\n<dd>\n<p>You probably are not or you would know. We show a pretty good guess on the option page. Set the option using this unless you are sure you know better.</p>\n</dd>\n<dt>Can I whitelist my IP so I don&#8217;t get locked out?</dt>\n<dd>\n<p>First please consider if you really need this. Generally speaking it is not a good idea to have exceptions to your security policies.</p>\n<p>That said, there is now a filter which allows you to do it: &#8220;limit_login_whitelist_ip&#8221;.</p>\n<p>Example:<br />\nfunction my_ip_whitelist($allow, $ip) {<br />\n     return ($ip == &#8216;my-ip&#8217;) ? true : $allow;<br />\n}<br />\nadd_filter(&#8216;limit_login_whitelist_ip&#8217;, &#8216;my_ip_whitelist&#8217;, 10, 2);</p>\n<p>Note that we still do notification and logging as usual. This is meant to allow you to be aware of any suspicious activity from whitelisted IPs.</p>\n</dd>\n<dt>I locked myself out testing this thing, what do I do?</dt>\n<dd>\n<p>Either wait, or:</p>\n<p>If you know how to edit / add to PHP files you can use the IP whitelist functionality described above. You should then use the &#8220;Restore Lockouts&#8221; button on the plugin settings page and remove the whitelist function again.</p>\n<p>If you have ftp / ssh access to the site rename the file &#8220;wp-content/plugins/limit-login-attempts/limit-login-attempts.php&#8221; to deactivate the plugin.</p>\n<p>If you have access to the database (for example through phpMyAdmin) you can clear the limit_login_lockouts option in the wordpress options table. In a default setup this would work: &#8220;UPDATE wp_options SET option_value = &#8221; WHERE option_name = &#8216;limit_login_lockouts\'&#8221;</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>1.7.1</h4>\n<p>This version fixes a security bug in version 1.6.2 and 1.7.0. Please upgrade immediately.</p>\n<p>&#8220;Auth cookies&#8221; are special cookies set at login that authenticating you to the system. It is how WordPress &#8220;remembers&#8221; that you are logged in between page loads.</p>\n<p>During lockout these are supposed to be cleared, but a change in 1.6.2 broke this. It allowed an attacker to keep trying to break these cookies during a lockout.</p>\n<p>Lockout of normal password login attempts still worked as it should, and it appears that all &#8220;auth cookie&#8221; attempts would keep getting logged.</p>\n<p>In theory the &#8220;auth cookie&#8221; is quite resistant to brute force attack. It contains a cryptographic hash of the user password, and the difficulty to break it is not based on the password strength but instead on the cryptographic operations used and the length of the hash value. In theory it should take many many years to break this hash. As theory and practice does not always agree it is still a good idea to have working lockouts of any such attempts.</p>\n<h4>1.7.0</h4>\n<ul>\n<li>Added filter that allows whitelisting IP. Please use with care!!</li>\n<li>Update to Spanish translation, thanks to Marcelo Pedra</li>\n<li>Updated Swedish translation</li>\n<li>Tested against WordPress 3.3.2</li>\n</ul>\n<h4>1.6.2</h4>\n<ul>\n<li>Fix bug where log would not get updated after it had been cleared</li>\n<li>Do plugin setup in &#8216;init&#8217; action</li>\n<li>Small update to Spanish translation file, thanks to Marcelo Pedra</li>\n<li>Tested against WordPress 3.2.1</li>\n</ul>\n<h4>1.6.1</h4>\n<ul>\n<li>(WordPress 3.0+) An invalid cookie can sometimes get sent multiple times before it gets cleared, resulting in multiple failed attempts or even a lockout from a single invalid cookie. Store the latest failed cookie to make sure we only count it as one failed attempt</li>\n<li>Define &#8220;Text Domain&#8221; correctly</li>\n<li>Include correct Dutch tranlation file. Thanks to Martin1 for noticing. Thanks again to Bjorn Wijers for the translation</li>\n<li>Updated POT file for this version</li>\n<li>Tested against WordPress 3.1-RC4</li>\n</ul>\n<h4>1.6.0</h4>\n<ul>\n<li>Happy New Year</li>\n<li>Tested against WordPress 3.1-RC1</li>\n<li>Plugin now requires WordPress version 2.8+. Of course you should never ever use anything but the latest version</li>\n<li>Fixed deprecation warnings that had been piling up with the old version requirement. Thanks to Johannes Ruthenberg for the report that prompted this</li>\n<li>Removed auth cookie admin check for version 2.7.</li>\n<li>Make sure relevant values in $_COOKIE get cleared right away on auth cookie validation failure. There are still some problems with cookie auth handling. The lockout can trigger prematurely in rare cases, but fixing it is plugin version 2 stuff unfortunately.</li>\n<li>Changed default time for retries to reset from 24 hours to 12 hours. The security impact is very minor and it means the warning will disappear &#8220;overnight&#8221;</li>\n<li>Added question to FAQ (&#8220;Why not reset failed attempts on a successful login?&#8221;)</li>\n<li>Updated screenshots</li>\n</ul>\n<h4>1.5.2</h4>\n<ul>\n<li>Reverted minor cookie-handling cleanup which might somehow be responsible for recently reported cookie related lockouts</li>\n<li>Added version 1.x Brazilian Portuguese translation, thanks to Luciano Passuello</li>\n<li>Added Finnish translation, thanks to Ari Kontiainen</li>\n</ul>\n<h4>1.5.1</h4>\n<ul>\n<li>Further multisite &amp; WPMU support (again thanks to <a href=\"mailto:&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;\" rel=\"nofollow\">&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;</a>)</li>\n<li>Better error handling if option variables are damaged</li>\n<li>Added Traditional Chinese translation, thanks to Denny Huang <a href=\"mailto:&#x62;&#105;&#x67;&#101;&#x78;&#112;&#x6c;&#111;&#114;&#x61;&#116;&#x69;&#111;&#x6e;&#115;&#064;&#x62;&#105;&#x67;&#101;&#x78;&#112;&#108;&#x6f;&#114;&#x61;&#116;&#x69;&#111;n&#x73;&#046;&#x63;&#111;&#x6d;&#046;t&#x77;\" rel=\"nofollow\">&#x62;&#105;&#x67;&#101;&#x78;&#112;&#x6c;&#111;&#114;&#x61;&#116;&#x69;&#111;&#x6e;&#115;&#064;&#x62;&#105;&#x67;&#101;&#x78;&#112;&#108;&#x6f;&#114;&#x61;&#116;&#x69;&#111;n&#x73;&#046;&#x63;&#111;&#x6d;&#046;t&#x77;</a></li>\n</ul>\n<h4>1.5</h4>\n<ul>\n<li>Tested against WordPress 3.0</li>\n<li>Handle 3.0 login page failure &#8220;shake&#8221;</li>\n<li>Basic multisite support (parts thanks to <a href=\"mailto:&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;\" rel=\"nofollow\">&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;</a>)</li>\n<li>Added Dutch translation, thanks to Bjorn Wijers <a href=\"mailto:b&#117;&#x72;&#111;&#x62;&#x6a;&#111;&#x72;n&#064;&#x62;&#117;&#x72;&#x6f;&#098;&#x6a;&#111;&#114;&#x6e;&#046;&#x6e;l\" rel=\"nofollow\">b&#117;&#x72;&#111;&#x62;&#x6a;&#111;&#x72;n&#064;&#x62;&#117;&#x72;&#x6f;&#098;&#x6a;&#111;&#114;&#x6e;&#046;&#x6e;l</a></li>\n<li><a href=\"mailto:&#098;&#097;&#x6c;&#x69;&#110;&#116;&#x40;v&#101;&#x72;&#x65;&#115;&#107;&#x75;&#x74;&#105;&#046;&#x69;n&#102;&#x6f;\" rel=\"nofollow\">&#098;&#097;&#x6c;&#x69;&#110;&#116;&#x40;v&#101;&#x72;&#x65;&#115;&#107;&#x75;&#x74;&#105;&#046;&#x69;n&#102;&#x6f;</a></li>\n<li>Added French translation, thanks to oVa <a href=\"mailto:&#111;&#118;&#x61;&#x31;&#x33;l&#097;&#115;&#x74;&#x61;&#x72;&#064;&#103;&#109;&#097;&#x69;&#x6c;&#x2e;&#099;&#111;&#109;\" rel=\"nofollow\">&#111;&#118;&#x61;&#x31;&#x33;l&#097;&#115;&#x74;&#x61;&#x72;&#064;&#103;&#109;&#097;&#x69;&#x6c;&#x2e;&#099;&#111;&#109;</a></li>\n</ul>\n<h4>1.4.1</h4>\n<ul>\n<li>Added Turkish translation, thanks to Yazan Canarkadas</li>\n</ul>\n<h4>1.4</h4>\n<ul>\n<li>Protect admin page update using wp_nonce</li>\n<li>Added Czech translation, thanks to Jakub Jedelsky</li>\n</ul>\n<h4>1.3.2</h4>\n<ul>\n<li>Added Bulgarian translation, thanks to Hristo Chakarov</li>\n<li></li>\n<li>Added Spanish translation, thanks to Marcelo Pedra</li>\n<li>Added Persian translation, thanks to Mostafa Soufi</li>\n<li>Added Russian translation, thanks to Jack Leonid (http://studio-xl.com)</li>\n</ul>\n<h4>1.3.1</h4>\n<ul>\n<li>Added Catalan translation, thanks to Robert Buj</li>\n<li>Added Romanian translation, thanks to Robert Tudor</li>\n</ul>\n<h4>1.3</h4>\n<ul>\n<li>Support for getting the correct IP for clients while server is behind reverse proxy, thanks to Michael Skerwiderski</li>\n<li>Added German translation, thanks to Michael Skerwiderski</li>\n</ul>\n<h4>1.2</h4>\n<ul>\n<li>No longer replaces pluggable function when cookie handling active. Re-implemented using available actions and filters</li>\n<li>Filter error messages during login to avoid information leak regarding available usernames</li>\n<li>Do not show retries or lockout messages except for login (registration, lost password pages). No change in actual enforcement</li>\n<li>Slightly more aggressive in trimming old retries data</li>\n</ul>\n<h4>1.1</h4>\n<ul>\n<li>Added translation support</li>\n<li>Added Swedish translation</li>\n<li>During lockout, filter out all other login errors</li>\n<li>Minor cleanups</li>\n</ul>\n<h4>1.0</h4>\n<ul>\n<li>Initial version</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/limit-login-attempts/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/tinymce-advanced/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/tinymce-advanced/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Jun 2007 06:02:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins-wp/tinymce-advanced/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10701:\"<p><!--section=description--></p>\n<p>This plugin will let you add, remove and arrange the buttons that are shown on the Visual Editor toolbar. You can configure up to four rows of buttons including Font Sizes, Font Family, text and background colors, tables, etc. It will also let you enable the editor menu, see the <a href=\"screenshots\" rel=\"nofollow\">screenshots</a>.</p>\n<p>It includes 15 plugins for <a href=\"http://tinymce.com/\" rel=\"nofollow\">TinyMCE</a> that are automatically enabled or disabled depending on the buttons you have chosen. In addition this plugin adds some commonly used options as keeping the paragraph tags in the Text editor and importing the CSS classes from the theme&#8217;s editor-style.css.</p>\n<h4>Some of the features added by this plugin</h4>\n<ul>\n<li>Support for creating and editing tables.</li>\n<li>More options when inserting lists.</li>\n<li>Search and Replace in the editor.</li>\n<li>Ability to set Font Family and Font Sizes.</li>\n<li>And many others.</li>\n</ul>\n<p>With this plugin you can also enable the TinyMCE menu above the toolbars. This will make the editor even more powerful and convenient.</p>\n<p><!--section=installation--></p>\n<p>Best is to install directly from WordPress. If manual installation is required, please make sure that the plugin files are in a folder named &#8220;tinymce-advanced&#8221; (not two nested folders) in the WordPress plugins folder, usually &#8220;wp-content/plugins&#8221;.</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<p>Best is to install directly from WordPress. If manual installation is required, please make sure that the plugin files are in a folder named &#8220;tinymce-advanced&#8221; (not two nested folders) in the WordPress plugins folder, usually &#8220;wp-content/plugins&#8221;.</p>\n</dd>\n<dt>No styles are imported in the Formats sub-menu.</dt>\n<dd>\n<p>These styles are imported from your current theme editor-style.css file. However some themes do not have this functionality. For these themes TinyMCE Advanced has the option to let you add a customized editor-style.css and import it into the editor.</p>\n</dd>\n<dt>I have just installed this plugin, but it does not do anything.</dt>\n<dd>\n<p>Change some buttons on one of the toolbars, save your changes, clear your browser cache, and try again. If that does not work try reloding the Edit page several times while holding down Shift or Ctrl. There may also be a network cache somewhere between you and your host. You may need to wait for a few hours until this cache expires.</p>\n</dd>\n<dt>When I add &#8220;Smilies&#8221;, they do not show in the editor.</dt>\n<dd>\n<p>The &#8220;Emoticons&#8221; button in TinyMCE adds the codes for the smilies. The actual images are added by WordPress when viewing the Post. Make sure the checkbox &#8220;Convert emoticons to graphics on display&#8221; in &#8220;Options &#8211; Writing&#8221; is checked.</p>\n</dd>\n<dt>The plugin does not add any buttons.</dt>\n<dd>\n<p>Make sure the &#8220;Disable the visual editor when writing&#8221; checkbox under &#8220;Users &#8211; Your Profile&#8221; is <strong>not</strong> checked.</p>\n</dd>\n<dt>I still see the &#8220;old&#8221; buttons in the editor</dt>\n<dd>\n<p>Click the &#8220;Restore Default Settings&#8221; button on the plugin settings page and then set the buttons again and save.</p>\n</dd>\n<dt>Other questions? More screenshots?</dt>\n<dd>\n<p>Please post on the support forum or visit the homepage for <a href=\"http://www.laptoptips.ca/projects/tinymce-advanced/\" rel=\"nofollow\">TinyMCE Advanced</a>.</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>4.6.3</h4>\n<ul>\n<li>Updated for WordPress 4.8 and TinyMCE 4.6.3.</li>\n</ul>\n<h4>4.5.6</h4>\n<ul>\n<li>Updated for WordPress 4.7.4 and TinyMCE 4.5.6.</li>\n<li>Fixed PHP notice after importing settings.</li>\n</ul>\n<h4>4.4.3</h4>\n<ul>\n<li>Updated for WordPress 4.7 and TinyMCE 4.4.3.</li>\n<li>Fixed missing &#8220;Source code&#8221; button bug.</li>\n</ul>\n<h4>4.4.1</h4>\n<ul>\n<li>Updated for WordPress 4.6 and TinyMCE 4.4.1.</li>\n<li>Fixed multisite saving bug.</li>\n<li>Added new button in the Text editor to add or reset the line breaks. Adds line breaks only between tags. Works only when it detects that line breaks are missing so it doesn&#8217;t reformat posts with removed paragraphs.</li>\n</ul>\n<h4>4.3.10.1</h4>\n<ul>\n<li>Fixed adding paragraph tags when loading posts that were saved before turning autop off.</li>\n<li>Disabled the (new) inline toolbar for tables as it was overlapping the table in some cases.</li>\n</ul>\n<h4>4.3.10</h4>\n<ul>\n<li>Updated for WordPress 4.5.1 and TinyMCE 4.3.10.</li>\n<li>Fixed support for adding editor-style.css to themes that don&#8217;t have it.</li>\n</ul>\n<h4>4.3.8</h4>\n<ul>\n<li>Updated for WordPress 4.5 and TinyMCE 4.3.8.</li>\n<li>Separated standard options and admin options.</li>\n<li>Added settings that can disable the plugin for the main editor, other editors in wp-admin or editors on the front-end.</li>\n<li>Korean translation by Josh Kim and Greek translation by Stathis Mellios.</li>\n</ul>\n<h4>4.2.8</h4>\n<ul>\n<li>Updated for WordPress 4.4 and TinyMCE 4.2.8.</li>\n<li>Japanese translation by Manabu Miwa.</li>\n</ul>\n<h4>4.2.5</h4>\n<ul>\n<li>Updated for WordPress 4.3.1 and TinyMCE 4.2.5.</li>\n<li>Fixed text domain and plugin headers.</li>\n</ul>\n<h4>4.2.3.1</h4>\n<ul>\n<li>Fix error with removing the &#8216;textpattern&#8217; plugin.</li>\n</ul>\n<h4>4.2.3</h4>\n<ul>\n<li>Updated for WordPress 4.3 and TinyMCE 4.2.3.</li>\n<li>Removed the &#8216;textpattern&#8217; plugin as WordPress 4.3 includes similar functionality by default.</li>\n<li>French translation by Nicolas Schneider.</li>\n</ul>\n<h4>4.1.9</h4>\n<ul>\n<li>Updated for WordPress 4.2 and TinyMCE 4.1.9.</li>\n<li>Fixed bugs with showing oEmbed previews when pasting an URL.</li>\n<li>Fixed bugs with getting the content from TinyMCE with line breaks.</li>\n</ul>\n<h4>4.1.7</h4>\n<ul>\n<li>Updated for WordPress 4.1 and TinyMCE 4.1.7.</li>\n<li>Fixed bug where consecutive caption shortcodes may be split with an empty paragraph tag.</li>\n</ul>\n<h4>4.1.1</h4>\n<ul>\n<li>Fix bug with image captions when wpautop is disabled.</li>\n<li>Add translation support to the settings page. Button names/descriptions are translated from JS using the existing WordPress translation, so this part of the settings page will be translated by default. The other text still needs separate translation.</li>\n</ul>\n<h4>4.1</h4>\n<ul>\n<li>Updated for WordPress 4.0 and TinyMCE 4.1.</li>\n<li>Add the &#8216;textpattern&#8217; plugin that supports some of the markdown syntax while typing, <a href=\"http://www.tinymce.com/wiki.php/Configuration:textpattern_patterns\" rel=\"nofollow\">(more info)</a>.</li>\n<li>Add the updated &#8216;table&#8217; plugin that supports background and border color.</li>\n</ul>\n<h4>4.0.2</h4>\n<ul>\n<li>Fix showing of the second, third and forth button rows when the Toolbar Toggle button is not used.</li>\n<li>Fix adding the &#8221;directionality&#8221; plugin when RTL or LTR button is selected.</li>\n<li>Show the &#8221;Advanced Options&#8221; to super admins on multisite installs.</li>\n<li>Add the &#8221;link&#8221; plugin including link rel setting. Replaces the Insert/Edit Link dialog when enabled.</li>\n<li>Include updated &#8221;table&#8221; plugin that has support for vertical align for cells.</li>\n</ul>\n<h4>4.0.1</h4>\n<p>Fix warnings on pages other than Edit Post. Update the description.</p>\n<h4>4.0</h4>\n<p>Updated for WordPress 3.9 and TinyMCE 4.0. Refreshed the settings screen. Added support for exporting and importing of the settings.</p>\n<h4>3.5.9.1</h4>\n<p>Updated for WordPress 3.8, fixed auto-embedding of single line URLs when not removing paragraph tags.</p>\n<h4>3.5.9</h4>\n<p>Updated for WordPress 3.7 and TinyMCE 3.5.9.</p>\n<h4>3.5.8</h4>\n<p>Updated for WordPress 3.5 and TinyMCE 3.5.8.</p>\n<h4>3.4.9</h4>\n<p>Updated for WordPress 3.4 and TinyMCE 3.4.9.</p>\n<h4>3.4.5.1</h4>\n<p>Fixed a bug preventing TinyMCE from importing CSS classes from editor-style.css.</p>\n<h4>3.4.5</h4>\n<p>Updated for WordPress 3.3 or later and TinyMCE 3.4.5.</p>\n<h4>3.4.2.1</h4>\n<p>Fix the removal of the <em>media</em> plugin so it does not require re-saving the settings.</p>\n<h4>3.4.2</h4>\n<p>Compatibility with WordPress 3.2 and TinyMCE 3.4.2, removed the options for support for iframe and HTML 5.0 elements as they are supported by default in WordPress 3.2, removed the <em>media</em> plugin as it is included by default.</p>\n<h4>3.3.9.1</h4>\n<p>Added advanced options: stop removing iframes, stop removing HTML 5.0 elements, moved the support for custom editor styles to editor-style.css in the current theme.</p>\n<p>Attention: if you have a customized tadv-mce.css file and your theme doesn&#8217;t have editor-style.css, please download tadv-mce.css, rename it to editor-style.css and upload it to your current theme directory. Alternatively you can add there the editor-style.css from the Twenty Ten theme. If your theme has editor-style.css you can add any custom styles there.</p>\n<h4>3.3.9</h4>\n<p>Compatibility with WordPress 3.1 and TinyMCE 3.3.9, improved P and BR tags option.</p>\n<h4>3.2.7</h4>\n<p>Compatibility with WordPress 2.9 and TinyMCE 3.2.7, several minor bug fixes.</p>\n<h4>3.2.4</h4>\n<p>Compatibility with WordPress 2.8 and TinyMCE 3.2.4, minor bug fixes.</p>\n<h4>3.2</h4>\n<p>Compatibility with WordPress 2.7 and TinyMCE 3.2, minor bug fixes.</p>\n<h4>3.1</h4>\n<p>Compatibility with WordPress 2.6 and TinyMCE 3.1, keeps empty paragraphs when disabling the removal of P and BR tags, the buttons for MCImageManager and MCFileManager can be arranged (if installed).</p>\n<h4>3.0.1</h4>\n<p>Compatibility with WordPress 2.5.1 and TinyMCE 3.0.7, added option to disable the removal of P and BR tags when saving and in the HTML editor (autop), added two more buttons to the HTML editor: autop and undo, fixed the removal of non-default TinyMCE buttons.</p>\n<h4>3.0</h4>\n<p>Support for WordPress 2.5 and TinyMCE 3.0.</p>\n<h4>2.2</h4>\n<p>Deactivate/Uninstall option page, font size drop-down menu and other small changes.</p>\n<h4>2.1</h4>\n<p>Improved language selection, improved compatibility with WordPress 2.3 and TinyMCE 2.1.1.1, option to override some of the imported css classes and other small improvements and bugfixes.</p>\n<h4>2.0</h4>\n<p>Includes an admin page for arranging the TinyMCE toolbar buttons, easy installation, a lot of bugfixes, customized &#8220;Smilies&#8221; plugin that uses the built-in WordPress smilies, etc. The admin page uses jQuery and jQuery UI that lets you &#8220;drag and drop&#8221; the TinyMCE buttons to arrange your own toolbars and enables/disables the corresponding plugins depending on the used buttons.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/tinymce-advanced/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:50:\"https://wordpress.org/plugins/browse/popular/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 25 Aug 2017 17:04:42 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 25 Aug 2017 16:45:02 GMT\";s:4:\"link\";s:66:\"<https://wordpress.org/plugins/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}}s:5:\"build\";s:14:\"20160706173034\";}", "no");
INSERT INTO `wp_options` VALUES("13581", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1503723882", "no");
INSERT INTO `wp_options` VALUES("13582", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1503680682", "no");
INSERT INTO `wp_options` VALUES("13583", "_transient_timeout_plugin_slugs", "1503813557", "no");
INSERT INTO `wp_options` VALUES("13584", "_transient_plugin_slugs", "a:6:{i:0;s:29:\"antispam-bee/antispam_bee.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:37:\"onclick-scroll-to-top-button/init.php\";i:4;s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `wp_options` VALUES("13585", "_transient_timeout_dash_898c881de4a92ca37616885905bba3b7", "1503723882", "no");
INSERT INTO `wp_options` VALUES("13586", "_transient_dash_898c881de4a92ca37616885905bba3b7", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://de.wordpress.org/2017/08/wordpress-4-8-1/\'>WordPress 4.8.1 Wartungs-Release</a> <span class=\"rss-date\">3. August 2017</span><div class=\"rssSummary\">Vor Kurzem wurde WordPress 4.8.1 veröffentlicht. Die neue Version beinhaltet 29 Bugfixes und Verbesserungen – darunter Fehlerbehebungen für das Text-Widget sowie die Einführung eines HTML-Widgets. Alle vorgenommenen Änderungen findet ihr in den Release-Notes, den geschlossenen Tickets und der Liste aller Änderungen. Ihr könnt die neue Version herunterladen oder ein Update für eine bestehende Site im [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://www.elmastudio.de/12-dinge-die-du-machen-kannst-um-mehr-blogleser-zu-bekommen/\'>12 Dinge, die du machen kannst, um mehr Blogleser zu bekommen</a></li><li><a class=\'rsswidget\' href=\'https://www.perun.net/2017/08/18/was-erwartet-uns-in-wordpress-4-9/\'>Was erwartet uns in WordPress 4.9?</a></li><li><a class=\'rsswidget\' href=\'http://tracking.feedpress.it/link/14418/6526647\'>WordPress-Themes mit Twig und Timber erstellen</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Beliebtes Plugin:</span> WooCommerce&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;_wpnonce=f3ade01b1f&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Installiere WooCommerce\">(Installieren)</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("13616", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("13617", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("13618", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("13619", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("13628", "wpstg_installDate", "2017-08-25 05:58:14", "yes");
INSERT INTO `wp_options` VALUES("13629", "wpstg_version", "2.1.1", "yes");
INSERT INTO `wp_options` VALUES("13630", "wpstg_version_upgraded_from", "", "yes");
INSERT INTO `wp_options` VALUES("13634", "_transient_timeout_dash_v2_898c881de4a92ca37616885905bba3b7", "1503727561", "no");
INSERT INTO `wp_options` VALUES("13635", "_transient_dash_v2_898c881de4a92ca37616885905bba3b7", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://de.wordpress.org/2017/08/wordpress-4-8-1/\'>WordPress 4.8.1 Wartungs-Release</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://www.elmastudio.de/12-dinge-die-du-machen-kannst-um-mehr-blogleser-zu-bekommen/\'>12 Dinge, die du machen kannst, um mehr Blogleser zu bekommen</a></li><li><a class=\'rsswidget\' href=\'https://www.perun.net/2017/08/18/was-erwartet-uns-in-wordpress-4-9/\'>Was erwartet uns in WordPress 4.9?</a></li><li><a class=\'rsswidget\' href=\'http://tracking.feedpress.it/link/14418/6526647\'>WordPress-Themes mit Twig und Timber erstellen</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("13636", "_site_transient_timeout_community-events-534371a03d3c99a1519e577ded3c06cd", "1503727562", "no");
INSERT INTO `wp_options` VALUES("13637", "_site_transient_community-events-534371a03d3c99a1519e577ded3c06cd", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"92.231.228.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:23:\"WordPress Meetup Berlin\";s:3:\"url\";s:64:\"https://www.meetup.com/Berlin-WordPress-Meetup/events/236766202/\";s:6:\"meetup\";s:23:\"WordPress Meetup Berlin\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Berlin-WordPress-Meetup/\";s:4:\"date\";s:19:\"2017-08-31 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Berlin, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:52.51676599999999695000951760448515415191650390625;s:9:\"longitude\";d:13.39045899999999988949639373458921909332275390625;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:50:\"#wpdm - WordPress Meetup Potsdam im September 2017\";s:3:\"url\";s:57:\"https://www.meetup.com/wpmeetup-potsdam/events/241721641/\";s:6:\"meetup\";s:24:\"WordPress Meetup Potsdam\";s:10:\"meetup_url\";s:40:\"https://www.meetup.com/wpmeetup-potsdam/\";s:4:\"date\";s:19:\"2017-09-19 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:16:\"Potsdam, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:52.39795699999999811780071468092501163482666015625;s:9:\"longitude\";d:13.060776000000000607315087108872830867767333984375;}}i:2;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:23:\"WordPress Meetup Berlin\";s:3:\"url\";s:64:\"https://www.meetup.com/Berlin-WordPress-Meetup/events/236766230/\";s:6:\"meetup\";s:23:\"WordPress Meetup Berlin\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Berlin-WordPress-Meetup/\";s:4:\"date\";s:19:\"2017-09-28 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Berlin, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:52.51676599999999695000951760448515415191650390625;s:9:\"longitude\";d:13.39045899999999988949639373458921909332275390625;}}i:3;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:34:\"Global WordPress Translation Day 3\";s:3:\"url\";s:64:\"https://www.meetup.com/Berlin-WordPress-Meetup/events/242064535/\";s:6:\"meetup\";s:23:\"WordPress Meetup Berlin\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Berlin-WordPress-Meetup/\";s:4:\"date\";s:19:\"2017-09-30 10:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:23:\"Berlin, Berlin, Germany\";s:7:\"country\";s:2:\"DE\";s:8:\"latitude\";d:52.5200004577639987246584496460855007171630859375;s:9:\"longitude\";d:13.380000114440999681164612411521375179290771484375;}}i:4;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:23:\"WordPress Meetup Berlin\";s:3:\"url\";s:64:\"https://www.meetup.com/Berlin-WordPress-Meetup/events/236766245/\";s:6:\"meetup\";s:23:\"WordPress Meetup Berlin\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Berlin-WordPress-Meetup/\";s:4:\"date\";s:19:\"2017-10-26 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Berlin, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:52.51676599999999695000951760448515415191650390625;s:9:\"longitude\";d:13.39045899999999988949639373458921909332275390625;}}}}", "no");
INSERT INTO `wp_options` VALUES("13638", "_transient_is_multi_author", "0", "yes");
INSERT INTO `wp_options` VALUES("13640", "_transient_tinyframework_categories", "2", "yes");
INSERT INTO `wp_options` VALUES("13641", "_transient_timeout_yst_sm_1_1:5yM9C_5IXgu", "1503772442", "no");
INSERT INTO `wp_options` VALUES("13642", "_transient_yst_sm_1_1:5yM9C_5IXgu", "C:24:\"WPSEO_Sitemap_Cache_Data\":538:{a:2:{s:6:\"status\";s:2:\"ok\";s:3:\"xml\";s:491:\"<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<sitemap>\n		<loc>http://keep-it-short-and-simple.de/post-sitemap.xml</loc>\n		<lastmod>2016-07-19T19:34:36+02:00</lastmod>\n	</sitemap>\n	<sitemap>\n		<loc>http://keep-it-short-and-simple.de/page-sitemap.xml</loc>\n		<lastmod>2017-08-25T20:09:19+02:00</lastmod>\n	</sitemap>\n	<sitemap>\n		<loc>http://keep-it-short-and-simple.de/category-sitemap.xml</loc>\n		<lastmod>2016-07-19T19:34:36+02:00</lastmod>\n	</sitemap>\n</sitemapindex>\";}}", "no");
INSERT INTO `wp_options` VALUES("13648", "_transient_timeout_wpseo-dashboard-totals", "1503778433", "no");
INSERT INTO `wp_options` VALUES("13649", "_transient_wpseo-dashboard-totals", "a:1:{i:1;a:1:{i:3;a:5:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"title\";s:28:\"Beiträge ohne Fokus-Keyword\";s:5:\"class\";s:15:\"wpseo-glance-na\";s:10:\"icon_class\";s:2:\"na\";s:5:\"count\";s:2:\"18\";}}}", "no");
INSERT INTO `wp_options` VALUES("13651", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1503737913", "no");
INSERT INTO `wp_options` VALUES("13652", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4366;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2495;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2369;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:2266;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1828;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1599;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1586;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1437;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1357;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1349;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1335;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1272;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1270;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1127;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1054;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1047;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:998;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:943;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:814;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:811;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:807;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:772;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:768;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:669;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:668;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:663;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:654;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:643;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:642;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:637;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:620;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:606;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:594;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:593;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:588;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:580;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:574;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:574;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:559;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:551;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:540;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:534;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:521;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:514;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:501;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:500;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:493;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:483;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:475;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:472;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:470;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:470;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:446;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:440;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:439;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:437;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:436;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:431;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:418;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:418;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:408;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:405;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:404;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:402;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:401;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:396;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:383;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:382;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:379;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:369;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:353;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:345;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:334;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:332;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:332;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:331;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:331;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:327;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:324;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:323;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:321;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:320;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:319;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:306;}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";i:300;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:299;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:296;}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";i:291;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:290;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:286;}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";i:283;}s:6:\"author\";a:3:{s:4:\"name\";s:6:\"author\";s:4:\"slug\";s:6:\"author\";s:5:\"count\";i:282;}s:7:\"adsense\";a:3:{s:4:\"name\";s:7:\"adsense\";s:4:\"slug\";s:7:\"adsense\";s:5:\"count\";i:282;}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";i:280;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:279;}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";i:275;}s:7:\"tinymce\";a:3:{s:4:\"name\";s:7:\"tinyMCE\";s:4:\"slug\";s:7:\"tinymce\";s:5:\"count\";i:270;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:269;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:269;}s:7:\"captcha\";a:3:{s:4:\"name\";s:7:\"captcha\";s:4:\"slug\";s:7:\"captcha\";s:5:\"count\";i:268;}}", "no");
INSERT INTO `wp_options` VALUES("13654", "_site_transient_timeout_theme_roots", "1503728946", "no");
INSERT INTO `wp_options` VALUES("13655", "_site_transient_theme_roots", "a:5:{s:22:\"tiny-framework - kopie\";s:7:\"/themes\";s:14:\"tiny-framework\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("13656", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/de_DE/wordpress-4.8.1.zip\";s:6:\"locale\";s:5:\"de_DE\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/de_DE/wordpress-4.8.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.8.1\";s:7:\"version\";s:5:\"4.8.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1503727154;s:15:\"version_checked\";s:5:\"4.8.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("13657", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1503727156;s:7:\"checked\";a:6:{s:29:\"antispam-bee/antispam_bee.php\";s:5:\"2.7.1\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:3:\"4.9\";s:25:\"duplicator/duplicator.php\";s:6:\"1.2.20\";s:37:\"onclick-scroll-to-top-button/init.php\";s:5:\"1.0.0\";s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";s:5:\"1.3.2\";s:24:\"wordpress-seo/wp-seo.php\";s:5:\"5.3.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:29:\"antispam-bee/antispam_bee.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:26:\"w.org/plugins/antispam-bee\";s:4:\"slug\";s:12:\"antispam-bee\";s:6:\"plugin\";s:29:\"antispam-bee/antispam_bee.php\";s:11:\"new_version\";s:5:\"2.7.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/antispam-bee/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/antispam-bee.2.7.1.zip\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:3:\"4.9\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.20\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.20.zip\";}s:37:\"onclick-scroll-to-top-button/init.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:42:\"w.org/plugins/onclick-scroll-to-top-button\";s:4:\"slug\";s:28:\"onclick-scroll-to-top-button\";s:6:\"plugin\";s:37:\"onclick-scroll-to-top-button/init.php\";s:11:\"new_version\";s:5:\"1.0.0\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/onclick-scroll-to-top-button/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/onclick-scroll-to-top-button.zip\";}s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:38:\"w.org/plugins/responsive-lightbox-lite\";s:4:\"slug\";s:24:\"responsive-lightbox-lite\";s:6:\"plugin\";s:53:\"responsive-lightbox-lite/responsive-lightbox-lite.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/responsive-lightbox-lite/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/responsive-lightbox-lite.1.3.2.zip\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"5.3.2\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.5.3.2.zip\";}}}", "no");
INSERT INTO `wp_options` VALUES("13658", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1503727156;s:7:\"checked\";a:5:{s:22:\"tiny-framework - kopie\";s:5:\"2.1.1\";s:14:\"tiny-framework\";s:5:\"2.1.1\";s:13:\"twentyfifteen\";s:3:\"1.5\";s:14:\"twentyfourteen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.2\";}s:8:\"response\";a:4:{s:14:\"tiny-framework\";a:4:{s:5:\"theme\";s:14:\"tiny-framework\";s:11:\"new_version\";s:5:\"2.3.1\";s:3:\"url\";s:44:\"https://wordpress.org/themes/tiny-framework/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/tiny-framework.2.3.1.zip\";}s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.1.8.zip\";}s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.2.0.zip\";}s:13:\"twentysixteen\";a:4:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.1.3.zip\";}}s:12:\"translations\";a:0:{}}", "no");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("2", "4", "_form", "<p> Name <br />\n    [text* your-name] </p>\n\n<p> Email <br />\n    [email* your-email] </p>\n\n<p>Betreff<br />\n    [text your-subject] </p>\n\n<p>Mitteilung<br />\n    [textarea your-message] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO `wp_postmeta` VALUES("3", "4", "_mail", "a:8:{s:7:\"subject\";s:38:\"mein kleiner yogakurs \"[your-subject]\"\";s:6:\"sender\";s:32:\"[your-name] <freefeeling@web.de>\";s:4:\"body\";s:193:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://keep-it-short-and-simple.de)\";s:9:\"recipient\";s:18:\"freefeeling@web.de\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("4", "4", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:38:\"mein kleiner yogakurs \"[your-subject]\"\";s:6:\"sender\";s:42:\"mein kleiner yogakurs <freefeeling@web.de>\";s:4:\"body\";s:135:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://keep-it-short-and-simple.de)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:28:\"Reply-To: freefeeling@web.de\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("5", "4", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:31:\"Das Datumsformat ist ungültig.\";s:14:\"date_too_early\";s:47:\"Das Datum liegt vor dem ersten erlaubten Datum.\";s:13:\"date_too_late\";s:48:\"Das Datum liegt nach dem letzen erlaubten Datum.\";s:13:\"upload_failed\";s:57:\"Ein unbekannter Fehler trat beim Hochladen der Datei auf.\";s:24:\"upload_file_type_invalid\";s:64:\"Du hast nicht die Berechtigung, Dateien dieses Typs hochzuladen.\";s:21:\"upload_file_too_large\";s:23:\"Die Datei ist zu groß.\";s:23:\"upload_failed_php_error\";s:48:\"Es trat ein Fehler beim Hochladen der Datei auf.\";s:14:\"invalid_number\";s:31:\"Das Zahlenformat ist ungültig.\";s:16:\"number_too_small\";s:48:\"Die Zahl ist niedriger als das erlaubte Minimum.\";s:16:\"number_too_large\";s:47:\"Die Zahl ist größer als das erlaubte Maximum.\";s:23:\"quiz_answer_not_correct\";s:35:\"Die Antwort zu dem Quiz ist falsch.\";s:17:\"captcha_not_match\";s:33:\"Ihr eingegebener Code ist falsch.\";s:13:\"invalid_email\";s:45:\"Die eingegebene E-Mail-Adresse ist ungültig.\";s:11:\"invalid_url\";s:22:\"Die URL ist ungültig.\";s:11:\"invalid_tel\";s:32:\"Die Telefonnummer ist ungültig.\";}");
INSERT INTO `wp_postmeta` VALUES("6", "4", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("7", "4", "_locale", "de_DE");
INSERT INTO `wp_postmeta` VALUES("11", "6", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("12", "6", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("13", "6", "_edit_lock", "1476791134:1");
INSERT INTO `wp_postmeta` VALUES("17", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("18", "12", "_edit_lock", "1476791283:1");
INSERT INTO `wp_postmeta` VALUES("21", "12", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("26", "18", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27", "18", "_edit_lock", "1482738890:1");
INSERT INTO `wp_postmeta` VALUES("28", "18", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("37", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("38", "21", "_edit_lock", "1469963038:1");
INSERT INTO `wp_postmeta` VALUES("39", "21", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("102", "30", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("103", "30", "_edit_lock", "1468949536:1");
INSERT INTO `wp_postmeta` VALUES("107", "32", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("108", "32", "_edit_lock", "1468949484:1");
INSERT INTO `wp_postmeta` VALUES("180", "69", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("181", "69", "_edit_lock", "1468949431:1");
INSERT INTO `wp_postmeta` VALUES("208", "86", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("209", "86", "_edit_lock", "1476790359:1");
INSERT INTO `wp_postmeta` VALUES("210", "86", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("245", "95", "_wp_attached_file", "2016/06/yoga-1.png");
INSERT INTO `wp_postmeta` VALUES("246", "95", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:180;s:6:\"height\";i:180;s:4:\"file\";s:18:\"2016/06/yoga-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"yoga-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("247", "96", "_wp_attached_file", "2016/06/titelbild.png");
INSERT INTO `wp_postmeta` VALUES("248", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:170;s:4:\"file\";s:21:\"2016/06/titelbild.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"titelbild-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("249", "101", "_wp_attached_file", "2016/06/titel_spiegel-e1466675769263.png");
INSERT INTO `wp_postmeta` VALUES("250", "101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:170;s:4:\"file\";s:40:\"2016/06/titel_spiegel-e1466675769263.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"titel_spiegel-e1466675769263-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("251", "101", "_wp_attachment_backup_sizes", "a:2:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:165;s:6:\"height\";i:170;s:4:\"file\";s:17:\"titel_spiegel.png\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:25:\"titel_spiegel-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}");
INSERT INTO `wp_postmeta` VALUES("257", "114", "_wp_attached_file", "2016/06/head.jpg");
INSERT INTO `wp_postmeta` VALUES("258", "114", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:4288;s:6:\"height\";i:1428;s:4:\"file\";s:16:\"2016/06/head.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"head-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"head-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"head-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"head-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"head-960x320.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("259", "114", "_wp_attachment_custom_header_last_used_tiny-forge", "1467119052");
INSERT INTO `wp_postmeta` VALUES("260", "114", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("263", "117", "_wp_attached_file", "2016/06/ARM-1.png");
INSERT INTO `wp_postmeta` VALUES("264", "117", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:182;s:4:\"file\";s:17:\"2016/06/ARM-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"ARM-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("265", "118", "_wp_attached_file", "2016/06/AUF.png");
INSERT INTO `wp_postmeta` VALUES("266", "118", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:246;s:6:\"height\";i:120;s:4:\"file\";s:15:\"2016/06/AUF.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"AUF-150x120.png\";s:5:\"width\";i:150;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("267", "119", "_wp_attached_file", "2016/06/AUGEN-1.png");
INSERT INTO `wp_postmeta` VALUES("268", "119", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:302;s:6:\"height\";i:96;s:4:\"file\";s:19:\"2016/06/AUGEN-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"AUGEN-1-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"AUGEN-1-300x95.png\";s:5:\"width\";i:300;s:6:\"height\";i:95;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("269", "120", "_wp_attached_file", "2016/06/BAUM.png");
INSERT INTO `wp_postmeta` VALUES("270", "120", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:135;s:6:\"height\";i:274;s:4:\"file\";s:16:\"2016/06/BAUM.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"BAUM-135x150.png\";s:5:\"width\";i:135;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("271", "121", "_wp_attached_file", "2016/06/BEIN.png");
INSERT INTO `wp_postmeta` VALUES("272", "121", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:232;s:6:\"height\";i:255;s:4:\"file\";s:16:\"2016/06/BEIN.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"BEIN-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("275", "123", "_wp_attached_file", "2016/06/BRUEXPA.png");
INSERT INTO `wp_postmeta` VALUES("276", "123", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:183;s:4:\"file\";s:19:\"2016/06/BRUEXPA.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"BRUEXPA-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("277", "124", "_wp_attached_file", "2016/06/GESPREI.png");
INSERT INTO `wp_postmeta` VALUES("278", "124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:109;s:4:\"file\";s:19:\"2016/06/GESPREI.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"GESPREI-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"GESPREI-300x86.png\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("279", "125", "_wp_attached_file", "2016/06/HALTUNG.png");
INSERT INTO `wp_postmeta` VALUES("280", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:205;s:4:\"file\";s:19:\"2016/06/HALTUNG.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"HALTUNG-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("281", "126", "_wp_attached_file", "2016/06/JAPSITZ.png");
INSERT INTO `wp_postmeta` VALUES("282", "126", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:152;s:6:\"height\";i:233;s:4:\"file\";s:19:\"2016/06/JAPSITZ.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"JAPSITZ-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("285", "128", "_wp_attached_file", "2016/06/KOBRA.png");
INSERT INTO `wp_postmeta` VALUES("286", "128", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:191;s:4:\"file\";s:17:\"2016/06/KOBRA.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"KOBRA-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"KOBRA-300x151.png\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("289", "130", "_wp_attached_file", "2016/06/NACKEN.png");
INSERT INTO `wp_postmeta` VALUES("290", "130", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:379;s:6:\"height\";i:92;s:4:\"file\";s:18:\"2016/06/NACKEN.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"NACKEN-150x92.png\";s:5:\"width\";i:150;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"NACKEN-300x73.png\";s:5:\"width\";i:300;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("291", "131", "_wp_attached_file", "2016/06/PFLUG.png");
INSERT INTO `wp_postmeta` VALUES("292", "131", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:255;s:6:\"height\";i:156;s:4:\"file\";s:17:\"2016/06/PFLUG.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"PFLUG-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("295", "133", "_wp_attached_file", "2016/06/ZUBLATT.png");
INSERT INTO `wp_postmeta` VALUES("296", "133", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:239;s:6:\"height\";i:88;s:4:\"file\";s:19:\"2016/06/ZUBLATT.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ZUBLATT-150x88.png\";s:5:\"width\";i:150;s:6:\"height\";i:88;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("335", "145", "_wp_attached_file", "2016/06/jungfer-im-grünen.jpg");
INSERT INTO `wp_postmeta` VALUES("336", "145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:31:\"2016/06/jungfer-im-grünen.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"jungfer-im-grünen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"jungfer-im-grünen-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("337", "146", "_wp_attached_file", "2016/06/küchenshcelle.jpg");
INSERT INTO `wp_postmeta` VALUES("338", "146", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:210;s:6:\"height\";i:149;s:4:\"file\";s:27:\"2016/06/küchenshcelle.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"küchenshcelle-150x149.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:149;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("343", "149", "_wp_attached_file", "2016/06/jungfer-im-grünen-1.jpg");
INSERT INTO `wp_postmeta` VALUES("344", "149", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-1-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("345", "150", "_wp_attached_file", "2016/06/küchenshcelle-1.jpg");
INSERT INTO `wp_postmeta` VALUES("346", "150", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:210;s:6:\"height\";i:149;s:4:\"file\";s:29:\"2016/06/küchenshcelle-1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"küchenshcelle-1-150x149.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:149;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("351", "146", "_wp_attachment_image_alt", "küchenschelle");
INSERT INTO `wp_postmeta` VALUES("354", "157", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("355", "157", "_edit_lock", "1468949396:1");
INSERT INTO `wp_postmeta` VALUES("356", "158", "_wp_attached_file", "2016/06/BAUM-1.png");
INSERT INTO `wp_postmeta` VALUES("357", "158", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:135;s:6:\"height\";i:274;s:4:\"file\";s:18:\"2016/06/BAUM-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"BAUM-1-135x150.png\";s:5:\"width\";i:135;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("358", "158", "_wp_attachment_image_alt", "baum");
INSERT INTO `wp_postmeta` VALUES("371", "164", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("372", "164", "_edit_lock", "1468949336:1");
INSERT INTO `wp_postmeta` VALUES("375", "166", "_wp_attached_file", "2016/06/BEIN-1.png");
INSERT INTO `wp_postmeta` VALUES("376", "166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:232;s:6:\"height\";i:255;s:4:\"file\";s:18:\"2016/06/BEIN-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"BEIN-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("377", "166", "_wp_attachment_image_alt", "beinüberschlag");
INSERT INTO `wp_postmeta` VALUES("392", "30", "_wp_old_slug", "arm-heben");
INSERT INTO `wp_postmeta` VALUES("403", "157", "_wp_old_slug", "baum");
INSERT INTO `wp_postmeta` VALUES("447", "189", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("448", "189", "_edit_lock", "1468949298:1");
INSERT INTO `wp_postmeta` VALUES("458", "192", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("459", "192", "_edit_lock", "1468949264:1");
INSERT INTO `wp_postmeta` VALUES("487", "21", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("488", "209", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("489", "209", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("490", "209", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("491", "209", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("492", "209", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("493", "209", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("494", "209", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("495", "209", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("497", "210", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("498", "210", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("499", "210", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("500", "210", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("501", "210", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("502", "210", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("503", "210", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("504", "210", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("551", "216", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("552", "216", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("553", "216", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("554", "216", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("555", "216", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("556", "216", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("557", "216", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("558", "216", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("560", "217", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("561", "217", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("562", "217", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("563", "217", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("564", "217", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("565", "217", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("566", "217", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("567", "217", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("569", "218", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("570", "218", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("571", "218", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("572", "218", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("573", "218", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("574", "218", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("575", "218", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("576", "218", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("578", "86", "_yoast_wpseo_content_score", "90");
INSERT INTO `wp_postmeta` VALUES("579", "4", "_config_errors", "a:1:{s:11:\"mail.sender\";i:103;}");
INSERT INTO `wp_postmeta` VALUES("582", "222", "title", "NextGEN Basic Thumbnails");
INSERT INTO `wp_postmeta` VALUES("583", "222", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_gallery/static/thumb_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("584", "222", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("585", "222", "view_order", "10000");
INSERT INTO `wp_postmeta` VALUES("586", "222", "name", "photocrati-nextgen_basic_thumbnails");
INSERT INTO `wp_postmeta` VALUES("587", "222", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("588", "222", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("589", "222", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("590", "222", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("591", "222", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("592", "222", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("593", "222", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJpbWFnZXNfcGVyX3BhZ2UiOiIyMCIsIm51bWJlcl9vZl9jb2x1bW5zIjowLCJ0aHVtYm5haWxfd2lkdGgiOjI0MCwidGh1bWJuYWlsX2hlaWdodCI6MTYwLCJzaG93X2FsbF9pbl9saWdodGJveCI6MCwiYWpheF9wYWdpbmF0aW9uIjowLCJ1c2VfaW1hZ2Vicm93c2VyX2VmZmVjdCI6MCwidGVtcGxhdGUiOiIiLCJkaXNwbGF5X25vX2ltYWdlc19lcnJvciI6MSwiZGlzYWJsZV9wYWdpbmF0aW9uIjowLCJzaG93X3NsaWRlc2hvd19saW5rIjoxLCJzbGlkZXNob3dfbGlua190ZXh0IjoiW1plaWdlIGVpbmUgU2xpZGVzaG93XSIsIm92ZXJyaWRlX3RodW1ibmFpbF9zZXR0aW5ncyI6MCwidGh1bWJuYWlsX3F1YWxpdHkiOiIxMDAiLCJ0aHVtYm5haWxfY3JvcCI6MSwidGh1bWJuYWlsX3dhdGVybWFyayI6MCwibmdnX3RyaWdnZXJzX2Rpc3BsYXkiOiJuZXZlciJ9");
INSERT INTO `wp_postmeta` VALUES("594", "223", "title", "NextGEN Basic Slideshow");
INSERT INTO `wp_postmeta` VALUES("595", "223", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_gallery/static/slideshow_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("596", "223", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("597", "223", "view_order", "10010");
INSERT INTO `wp_postmeta` VALUES("598", "223", "name", "photocrati-nextgen_basic_slideshow");
INSERT INTO `wp_postmeta` VALUES("599", "223", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("600", "223", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("601", "223", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("602", "223", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("603", "223", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("604", "223", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("605", "223", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJ5X3dpZHRoIjo2MDAsImdhbGxlcnlfaGVpZ2h0Ijo0MDAsInRodW1ibmFpbF93aWR0aCI6MjQwLCJ0aHVtYm5haWxfaGVpZ2h0IjoxNjAsImN5Y2xlX2ludGVydmFsIjoxMCwiY3ljbGVfZWZmZWN0IjpudWxsLCJlZmZlY3RfY29kZSI6ImNsYXNzPVwibmdnLWZhbmN5Ym94XCIgcmVsPVwiJUdBTExFUllfTkFNRSVcIiIsInNob3dfdGh1bWJuYWlsX2xpbmsiOjEsInRodW1ibmFpbF9saW5rX3RleHQiOiJbWmVpZ2UgVm9yc2NoYXViaWxkZXJdIiwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("606", "224", "title", "NextGEN Basic ImageBrowser");
INSERT INTO `wp_postmeta` VALUES("607", "224", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_imagebrowser/static/preview.jpg");
INSERT INTO `wp_postmeta` VALUES("608", "224", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("609", "224", "view_order", "10020");
INSERT INTO `wp_postmeta` VALUES("610", "224", "name", "photocrati-nextgen_basic_imagebrowser");
INSERT INTO `wp_postmeta` VALUES("611", "224", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("612", "224", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("613", "224", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("614", "224", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("615", "224", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("616", "224", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("617", "224", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJ0ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifQ==");
INSERT INTO `wp_postmeta` VALUES("618", "225", "title", "NextGEN Basic SinglePic");
INSERT INTO `wp_postmeta` VALUES("619", "225", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_singlepic/static/preview.gif");
INSERT INTO `wp_postmeta` VALUES("620", "225", "default_source", "galleries");
INSERT INTO `wp_postmeta` VALUES("621", "225", "view_order", "10060");
INSERT INTO `wp_postmeta` VALUES("622", "225", "hidden_from_ui", "1");
INSERT INTO `wp_postmeta` VALUES("623", "225", "name", "photocrati-nextgen_basic_singlepic");
INSERT INTO `wp_postmeta` VALUES("624", "225", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("625", "225", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("626", "225", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("627", "225", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("628", "225", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("629", "225", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJ3aWR0aCI6IiIsImhlaWdodCI6IiIsIm1vZGUiOiIiLCJkaXNwbGF5X3dhdGVybWFyayI6MCwiZGlzcGxheV9yZWZsZWN0aW9uIjowLCJmbG9hdCI6IiIsImxpbmsiOiIiLCJsaW5rX3RhcmdldCI6Il9ibGFuayIsInF1YWxpdHkiOjEwMCwiY3JvcCI6MCwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("630", "226", "title", "NextGEN Basic TagCloud");
INSERT INTO `wp_postmeta` VALUES("631", "226", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_tagcloud/static/preview.gif");
INSERT INTO `wp_postmeta` VALUES("632", "226", "default_source", "tags");
INSERT INTO `wp_postmeta` VALUES("633", "226", "view_order", "10100");
INSERT INTO `wp_postmeta` VALUES("634", "226", "name", "photocrati-nextgen_basic_tagcloud");
INSERT INTO `wp_postmeta` VALUES("635", "226", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("636", "226", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("637", "226", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("638", "226", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("639", "226", "entity_types", "WyJpbWFnZSJd");
INSERT INTO `wp_postmeta` VALUES("640", "226", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("641", "226", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJkaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsIm51bWJlciI6NDUsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifQ==");
INSERT INTO `wp_postmeta` VALUES("642", "227", "title", "NextGEN Basic Compact Album");
INSERT INTO `wp_postmeta` VALUES("643", "227", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_album/static/compact_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("644", "227", "default_source", "albums");
INSERT INTO `wp_postmeta` VALUES("645", "227", "view_order", "10200");
INSERT INTO `wp_postmeta` VALUES("646", "227", "name", "photocrati-nextgen_basic_compact_album");
INSERT INTO `wp_postmeta` VALUES("647", "227", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("648", "227", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("649", "227", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("650", "227", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("651", "227", "entity_types", "WyJhbGJ1bSIsImdhbGxlcnkiXQ==");
INSERT INTO `wp_postmeta` VALUES("652", "227", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("653", "227", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJpZXNfcGVyX3BhZ2UiOjAsImVuYWJsZV9icmVhZGNydW1icyI6MSwiZGlzYWJsZV9wYWdpbmF0aW9uIjowLCJ0ZW1wbGF0ZSI6IiIsImdhbGxlcnlfZGlzcGxheV90eXBlIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3RodW1ibmFpbHMiLCJnYWxsZXJ5X2Rpc3BsYXlfdGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("654", "228", "title", "NextGEN Basic Extended Album");
INSERT INTO `wp_postmeta` VALUES("655", "228", "preview_image_relpath", "/nextgen-gallery/products/photocrati_nextgen/modules/nextgen_basic_album/static/extended_preview.jpg");
INSERT INTO `wp_postmeta` VALUES("656", "228", "default_source", "albums");
INSERT INTO `wp_postmeta` VALUES("657", "228", "view_order", "10210");
INSERT INTO `wp_postmeta` VALUES("658", "228", "name", "photocrati-nextgen_basic_extended_album");
INSERT INTO `wp_postmeta` VALUES("659", "228", "installed_at_version", "2.1.46");
INSERT INTO `wp_postmeta` VALUES("660", "228", "hidden_from_ui", "");
INSERT INTO `wp_postmeta` VALUES("661", "228", "__defaults_set", "1");
INSERT INTO `wp_postmeta` VALUES("662", "228", "filter", "raw");
INSERT INTO `wp_postmeta` VALUES("663", "228", "entity_types", "WyJhbGJ1bSIsImdhbGxlcnkiXQ==");
INSERT INTO `wp_postmeta` VALUES("664", "228", "id_field", "ID");
INSERT INTO `wp_postmeta` VALUES("665", "228", "settings", "eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJpZXNfcGVyX3BhZ2UiOjAsImVuYWJsZV9icmVhZGNydW1icyI6MSwiZGlzYWJsZV9wYWdpbmF0aW9uIjowLCJ0ZW1wbGF0ZSI6IiIsIm92ZXJyaWRlX3RodW1ibmFpbF9zZXR0aW5ncyI6MCwidGh1bWJuYWlsX3dpZHRoIjoyNDAsInRodW1ibmFpbF9oZWlnaHQiOjE2MCwidGh1bWJuYWlsX3F1YWxpdHkiOjEwMCwidGh1bWJuYWlsX2Nyb3AiOnRydWUsInRodW1ibmFpbF93YXRlcm1hcmsiOjAsImdhbGxlcnlfZGlzcGxheV90eXBlIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3RodW1ibmFpbHMiLCJnYWxsZXJ5X2Rpc3BsYXlfdGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0=");
INSERT INTO `wp_postmeta` VALUES("673", "149", "_wp_attachment_image_alt", "jungfer im grünen");
INSERT INTO `wp_postmeta` VALUES("711", "241", "_wp_attached_file", "2016/06/jungfer-im-grünen-2.jpg");
INSERT INTO `wp_postmeta` VALUES("712", "241", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-2-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("713", "242", "_wp_attached_file", "2016/06/Küchenschelle.jpg");
INSERT INTO `wp_postmeta` VALUES("714", "242", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:27:\"2016/06/Küchenschelle.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Küchenschelle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"Küchenschelle-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("719", "245", "_wp_attached_file", "2016/06/jungfer-im-grünen-3.jpg");
INSERT INTO `wp_postmeta` VALUES("720", "245", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-3.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-3-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("730", "248", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("731", "248", "_edit_lock", "1468949229:1");
INSERT INTO `wp_postmeta` VALUES("736", "248", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("737", "248", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("742", "192", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("743", "192", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("770", "189", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("771", "189", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("778", "259", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("781", "259", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("782", "259", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("783", "259", "_edit_lock", "1468949204:1");
INSERT INTO `wp_postmeta` VALUES("784", "261", "_wp_attached_file", "2016/06/HALTUNG-2.png");
INSERT INTO `wp_postmeta` VALUES("785", "261", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:205;s:4:\"file\";s:21:\"2016/06/HALTUNG-2.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"HALTUNG-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("786", "261", "_wp_attachment_image_alt", "haltungsgriff");
INSERT INTO `wp_postmeta` VALUES("797", "264", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("800", "264", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("801", "264", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("802", "264", "_edit_lock", "1468949176:1");
INSERT INTO `wp_postmeta` VALUES("816", "269", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("819", "269", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("820", "269", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("821", "269", "_edit_lock", "1468949145:1");
INSERT INTO `wp_postmeta` VALUES("834", "275", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("837", "275", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("838", "275", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("839", "275", "_edit_lock", "1468949098:1");
INSERT INTO `wp_postmeta` VALUES("845", "279", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("848", "279", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("849", "279", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("850", "279", "_edit_lock", "1468950543:1");
INSERT INTO `wp_postmeta` VALUES("872", "285", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("873", "285", "_edit_lock", "1468948870:1");
INSERT INTO `wp_postmeta` VALUES("876", "285", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("877", "285", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("887", "290", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("888", "290", "_edit_lock", "1468948839:1");
INSERT INTO `wp_postmeta` VALUES("891", "290", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("892", "290", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("902", "296", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("903", "296", "_edit_lock", "1468948810:1");
INSERT INTO `wp_postmeta` VALUES("906", "296", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("907", "296", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("920", "303", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("921", "303", "_edit_lock", "1468948778:1");
INSERT INTO `wp_postmeta` VALUES("924", "303", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("925", "303", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("939", "311", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("940", "311", "_edit_lock", "1468948741:1");
INSERT INTO `wp_postmeta` VALUES("943", "311", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("944", "311", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("984", "30", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("985", "30", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("988", "32", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("989", "32", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("992", "69", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("993", "69", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("996", "157", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("997", "157", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("1002", "164", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("1003", "164", "_yoast_wpseo_primary_category", "");
INSERT INTO `wp_postmeta` VALUES("1034", "245", "_edit_lock", "1467208415:1");
INSERT INTO `wp_postmeta` VALUES("1035", "123", "_wp_attachment_image_alt", "brustexpander");
INSERT INTO `wp_postmeta` VALUES("1039", "355", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1040", "355", "_edit_lock", "1483214850:1");
INSERT INTO `wp_postmeta` VALUES("1045", "358", "_wp_attached_file", "2016/06/jungfer-im-grünen-4.jpg");
INSERT INTO `wp_postmeta` VALUES("1046", "358", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:33:\"2016/06/jungfer-im-grünen-4.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"jungfer-im-grünen-4-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1047", "359", "_wp_attached_file", "2016/06/küchenschelle.jpg");
INSERT INTO `wp_postmeta` VALUES("1048", "359", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:27:\"2016/06/küchenschelle.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"küchenschelle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"küchenschelle-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1055", "358", "_wp_attachment_image_alt", "jungfer im grünen");
INSERT INTO `wp_postmeta` VALUES("1056", "359", "_wp_attachment_image_alt", "küchenschelle");
INSERT INTO `wp_postmeta` VALUES("1059", "355", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1069", "355", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1114", "6", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("1115", "387", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1116", "387", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1117", "387", "_menu_item_object_id", "6");
INSERT INTO `wp_postmeta` VALUES("1118", "387", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1119", "387", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1120", "387", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1121", "387", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1122", "387", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1124", "388", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1125", "388", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1126", "388", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("1127", "388", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1128", "388", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1129", "388", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1130", "388", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1131", "388", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1133", "389", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1134", "389", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1135", "389", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("1136", "389", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1137", "389", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1138", "389", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1139", "389", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1140", "389", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1142", "390", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1143", "390", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1144", "390", "_menu_item_object_id", "86");
INSERT INTO `wp_postmeta` VALUES("1145", "390", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1146", "390", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1147", "390", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1148", "390", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1149", "390", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1151", "391", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1152", "391", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1153", "391", "_menu_item_object_id", "355");
INSERT INTO `wp_postmeta` VALUES("1154", "391", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1155", "391", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1156", "391", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1157", "391", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1158", "391", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1160", "392", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1161", "392", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1162", "392", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("1163", "392", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1164", "392", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1165", "392", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1166", "392", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1167", "392", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1169", "114", "_wp_attachment_custom_header_last_used_tiny-framework", "1467271401");
INSERT INTO `wp_postmeta` VALUES("1170", "394", "_wp_attached_file", "2016/06/ZUBLATT-1.png");
INSERT INTO `wp_postmeta` VALUES("1171", "394", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:239;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2016/06/ZUBLATT-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"ZUBLATT-1-150x88.png\";s:5:\"width\";i:150;s:6:\"height\";i:88;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1172", "394", "_wp_attachment_image_alt", "zusammengerolltes blatt");
INSERT INTO `wp_postmeta` VALUES("1175", "397", "_wp_attached_file", "2016/06/SITHELD.png");
INSERT INTO `wp_postmeta` VALUES("1176", "397", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:200;s:6:\"height\";i:224;s:4:\"file\";s:19:\"2016/06/SITHELD.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"SITHELD-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1177", "397", "_wp_attachment_image_alt", "sitzender held");
INSERT INTO `wp_postmeta` VALUES("1180", "399", "_wp_attached_file", "2016/06/PFLUG-1.png");
INSERT INTO `wp_postmeta` VALUES("1181", "399", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:255;s:6:\"height\";i:156;s:4:\"file\";s:19:\"2016/06/PFLUG-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"PFLUG-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1182", "399", "_wp_attachment_image_alt", "pflug");
INSERT INTO `wp_postmeta` VALUES("1185", "401", "_wp_attached_file", "2016/06/PERSITZ.png");
INSERT INTO `wp_postmeta` VALUES("1186", "401", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:160;s:6:\"height\";i:168;s:4:\"file\";s:19:\"2016/06/PERSITZ.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"PERSITZ-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1187", "401", "_wp_attachment_image_alt", "perfekter sitz");
INSERT INTO `wp_postmeta` VALUES("1190", "403", "_wp_attached_file", "2016/06/NACKEN-1.png");
INSERT INTO `wp_postmeta` VALUES("1191", "403", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:379;s:6:\"height\";i:92;s:4:\"file\";s:20:\"2016/06/NACKEN-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"NACKEN-1-150x92.png\";s:5:\"width\";i:150;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"NACKEN-1-300x73.png\";s:5:\"width\";i:300;s:6:\"height\";i:73;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1192", "403", "_wp_attachment_image_alt", "nacken rollen");
INSERT INTO `wp_postmeta` VALUES("1195", "405", "_wp_attached_file", "2016/06/KOPF.png");
INSERT INTO `wp_postmeta` VALUES("1196", "405", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:150;s:6:\"height\";i:278;s:4:\"file\";s:16:\"2016/06/KOPF.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"KOPF-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1199", "407", "_wp_attached_file", "2016/06/KOBRA-1.png");
INSERT INTO `wp_postmeta` VALUES("1200", "407", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:191;s:4:\"file\";s:19:\"2016/06/KOBRA-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"KOBRA-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"KOBRA-1-300x151.png\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1201", "407", "_wp_attachment_image_alt", "kobra");
INSERT INTO `wp_postmeta` VALUES("1204", "409", "_wp_attached_file", "2016/06/KERZE.png");
INSERT INTO `wp_postmeta` VALUES("1205", "409", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:153;s:6:\"height\";i:268;s:4:\"file\";s:17:\"2016/06/KERZE.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"KERZE-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1206", "409", "_wp_attachment_image_alt", "kerze");
INSERT INTO `wp_postmeta` VALUES("1209", "411", "_wp_attached_file", "2016/06/JAPSITZ-1.png");
INSERT INTO `wp_postmeta` VALUES("1210", "411", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:152;s:6:\"height\";i:233;s:4:\"file\";s:21:\"2016/06/JAPSITZ-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"JAPSITZ-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1211", "411", "_wp_attachment_image_alt", "japanischer sitz");
INSERT INTO `wp_postmeta` VALUES("1214", "413", "_wp_attached_file", "2016/06/GESPREI-1.png");
INSERT INTO `wp_postmeta` VALUES("1215", "413", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:109;s:4:\"file\";s:21:\"2016/06/GESPREI-1.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"GESPREI-1-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"GESPREI-1-300x86.png\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1216", "413", "_wp_attachment_image_alt", "gespreizte beinstreckung");
INSERT INTO `wp_postmeta` VALUES("1219", "415", "_wp_attached_file", "2016/06/BRUEXPA-1.png");
INSERT INTO `wp_postmeta` VALUES("1220", "415", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:183;s:4:\"file\";s:21:\"2016/06/BRUEXPA-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"BRUEXPA-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1221", "415", "_wp_attachment_image_alt", "brustexpander");
INSERT INTO `wp_postmeta` VALUES("1224", "417", "_wp_attached_file", "2016/06/BOGEN.png");
INSERT INTO `wp_postmeta` VALUES("1225", "417", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:228;s:6:\"height\";i:180;s:4:\"file\";s:17:\"2016/06/BOGEN.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BOGEN-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1226", "417", "_wp_attachment_image_alt", "bogen");
INSERT INTO `wp_postmeta` VALUES("1229", "419", "_wp_attached_file", "2016/06/AUGEN.png");
INSERT INTO `wp_postmeta` VALUES("1230", "419", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:302;s:6:\"height\";i:96;s:4:\"file\";s:17:\"2016/06/AUGEN.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"AUGEN-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"AUGEN-300x95.png\";s:5:\"width\";i:300;s:6:\"height\";i:95;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1231", "419", "_wp_attachment_image_alt", "augen rollen");
INSERT INTO `wp_postmeta` VALUES("1234", "421", "_wp_attached_file", "2016/06/AUF-1.png");
INSERT INTO `wp_postmeta` VALUES("1235", "421", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:246;s:6:\"height\";i:120;s:4:\"file\";s:17:\"2016/06/AUF-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"AUF-1-150x120.png\";s:5:\"width\";i:150;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1236", "421", "_wp_attachment_image_alt", "aufsetzen");
INSERT INTO `wp_postmeta` VALUES("1239", "423", "_wp_attached_file", "2016/06/ARM.png");
INSERT INTO `wp_postmeta` VALUES("1240", "423", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:165;s:6:\"height\";i:182;s:4:\"file\";s:15:\"2016/06/ARM.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"ARM-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1241", "423", "_wp_attachment_image_alt", "arm heben");
INSERT INTO `wp_postmeta` VALUES("1242", "426", "_wp_attached_file", "2016/06/distel.jpg");
INSERT INTO `wp_postmeta` VALUES("1243", "426", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:396;s:6:\"height\";i:524;s:4:\"file\";s:18:\"2016/06/distel.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"distel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"distel-227x300.jpg\";s:5:\"width\";i:227;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1244", "427", "_wp_attached_file", "2016/06/jacobsleiter.jpg");
INSERT INTO `wp_postmeta` VALUES("1245", "427", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:396;s:6:\"height\";i:524;s:4:\"file\";s:24:\"2016/06/jacobsleiter.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"jacobsleiter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"jacobsleiter-227x300.jpg\";s:5:\"width\";i:227;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1246", "428", "_wp_attached_file", "2016/06/jungfer-im-gruenen.jpg");
INSERT INTO `wp_postmeta` VALUES("1247", "428", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:30:\"2016/06/jungfer-im-gruenen.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"jungfer-im-gruenen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"jungfer-im-gruenen-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1248", "429", "_wp_attached_file", "2016/06/kuechenschelle.jpg");
INSERT INTO `wp_postmeta` VALUES("1249", "429", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:26:\"2016/06/kuechenschelle.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"kuechenschelle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"kuechenschelle-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1250", "430", "_wp_attached_file", "2016/06/mohn.jpg");
INSERT INTO `wp_postmeta` VALUES("1251", "430", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:353;s:4:\"file\";s:16:\"2016/06/mohn.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"mohn-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"mohn-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1252", "431", "_wp_attached_file", "2016/06/pfingstose.jpg");
INSERT INTO `wp_postmeta` VALUES("1253", "431", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:396;s:4:\"file\";s:22:\"2016/06/pfingstose.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"pfingstose-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"pfingstose-300x227.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1254", "426", "_wp_attachment_image_alt", "distel");
INSERT INTO `wp_postmeta` VALUES("1255", "430", "_wp_attachment_image_alt", "mohn");
INSERT INTO `wp_postmeta` VALUES("1256", "429", "_wp_attachment_image_alt", "kuechenschelle");
INSERT INTO `wp_postmeta` VALUES("1257", "428", "_wp_attachment_image_alt", "jungfer-im-gruenen");
INSERT INTO `wp_postmeta` VALUES("1258", "427", "_wp_attachment_image_alt", "jacobsleiter");
INSERT INTO `wp_postmeta` VALUES("1259", "431", "_wp_attachment_image_alt", "pfingstose");
INSERT INTO `wp_postmeta` VALUES("1262", "18", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1263", "450", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1264", "450", "_edit_lock", "1490977597:1");
INSERT INTO `wp_postmeta` VALUES("1265", "450", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1266", "451", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("1267", "451", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1268", "451", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1269", "451", "_menu_item_object_id", "450");
INSERT INTO `wp_postmeta` VALUES("1270", "451", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1271", "451", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1272", "451", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1273", "451", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1274", "451", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1275", "450", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1296", "6", "_oembed_9ff7de9b029e9386255d7f090a1ddc38", "<blockquote data-secret=\"zJwwFIggxP\" class=\"wp-embedded-content\"><a href=\"http://keep-it-short-and-simple.de/mehr-zum-thema-yoga/\">mehr zum thema yoga</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"http://keep-it-short-and-simple.de/mehr-zum-thema-yoga/embed/#?secret=zJwwFIggxP\" data-secret=\"zJwwFIggxP\" width=\"600\" height=\"338\" title=\"&#8222;mehr zum thema yoga&#8220; &#8212; keep it short and simple\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("1297", "6", "_oembed_time_9ff7de9b029e9386255d7f090a1ddc38", "1468470877");
INSERT INTO `wp_postmeta` VALUES("1307", "86", "_oembed_118529652409e6fbdb2038dd6044d44b", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("1308", "501", "_wp_attached_file", "2016/07/moeven.jpg");
INSERT INTO `wp_postmeta` VALUES("1309", "501", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:243;s:4:\"file\";s:18:\"2016/07/moeven.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"moeven-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"moeven-300x76.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"moeven-768x194.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:194;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"moeven-960x243.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"14\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D810\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"90\";s:3:\"iso\";s:4:\"1250\";s:13:\"shutter_speed\";s:7:\"0.00125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1310", "501", "_wp_attachment_custom_header_last_used_tiny-framework", "1468648761");
INSERT INTO `wp_postmeta` VALUES("1311", "501", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("1312", "12", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1349", "577", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1350", "577", "_edit_lock", "1482262389:1");
INSERT INTO `wp_postmeta` VALUES("1351", "578", "_wp_attached_file", "2016/07/projekt_fertig.jpg");
INSERT INTO `wp_postmeta` VALUES("1352", "578", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:639;s:4:\"file\";s:26:\"2016/07/projekt_fertig.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"projekt_fertig-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"projekt_fertig-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"projekt_fertig-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:26:\"projekt_fertig-960x639.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:639;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1353", "577", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1354", "579", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1355", "579", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1356", "579", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1357", "579", "_menu_item_object_id", "577");
INSERT INTO `wp_postmeta` VALUES("1358", "579", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1359", "579", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1360", "579", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1361", "579", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1362", "579", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1363", "577", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1364", "584", "_wp_attached_file", "2016/07/fisch_1mal.gif");
INSERT INTO `wp_postmeta` VALUES("1365", "584", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:468;s:4:\"file\";s:22:\"2016/07/fisch_1mal.gif\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"fisch_1mal-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"fisch_1mal-250x300.gif\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1366", "586", "_wp_attached_file", "2016/07/fisch_3mal-2.gif");
INSERT INTO `wp_postmeta` VALUES("1367", "586", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:468;s:4:\"file\";s:24:\"2016/07/fisch_3mal-2.gif\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"fisch_3mal-2-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"fisch_3mal-2-250x300.gif\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1368", "586", "_edit_lock", "1469547411:1");
INSERT INTO `wp_postmeta` VALUES("1369", "588", "_wp_attached_file", "2016/07/fisch_3mal.gif");
INSERT INTO `wp_postmeta` VALUES("1370", "588", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:390;s:6:\"height\";i:468;s:4:\"file\";s:22:\"2016/07/fisch_3mal.gif\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"fisch_3mal-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"fisch_3mal-250x300.gif\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1371", "588", "_edit_lock", "1473490578:1");
INSERT INTO `wp_postmeta` VALUES("1372", "588", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1373", "588", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1376", "614", "_wp_attached_file", "2016/07/augen.pdf");
INSERT INTO `wp_postmeta` VALUES("1404", "625", "_wp_attached_file", "2016/07/augen.jpg");
INSERT INTO `wp_postmeta` VALUES("1405", "625", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:17:\"2016/07/augen.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"augen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"augen-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1406", "630", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1407", "630", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1408", "630", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1409", "630", "_edit_lock", "1477340000:1");
INSERT INTO `wp_postmeta` VALUES("1410", "630", "_oembed_b348afa036690f2f70a444c6989cfe30", "<blockquote data-secret=\"Gg55HQkjUx\" class=\"wp-embedded-content\"><a href=\"http://keep-it-short-and-simple.de/augen/\">augen</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"http://keep-it-short-and-simple.de/augen/embed/#?secret=Gg55HQkjUx\" data-secret=\"Gg55HQkjUx\" width=\"600\" height=\"338\" title=\"&#8222;augen&#8220; &#8212; keep it short and simple\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("1411", "630", "_oembed_time_b348afa036690f2f70a444c6989cfe30", "1469965416");
INSERT INTO `wp_postmeta` VALUES("1424", "642", "_wp_attached_file", "2016/07/buchprojekt.pdf");
INSERT INTO `wp_postmeta` VALUES("1425", "648", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1426", "648", "_edit_lock", "1476790245:1");
INSERT INTO `wp_postmeta` VALUES("1427", "649", "_wp_attached_file", "2016/07/buch_nacht.jpg");
INSERT INTO `wp_postmeta` VALUES("1428", "649", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:861;s:6:\"height\";i:427;s:4:\"file\";s:22:\"2016/07/buch_nacht.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"buch_nacht-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"buch_nacht-300x149.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:149;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"buch_nacht-768x381.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:381;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1429", "650", "_wp_attached_file", "2016/07/buch_strand.jpg");
INSERT INTO `wp_postmeta` VALUES("1430", "650", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:856;s:6:\"height\";i:428;s:4:\"file\";s:23:\"2016/07/buch_strand.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"buch_strand-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"buch_strand-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"buch_strand-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1431", "651", "_wp_attached_file", "2016/07/buch_wald.jpg");
INSERT INTO `wp_postmeta` VALUES("1432", "651", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:853;s:6:\"height\";i:427;s:4:\"file\";s:21:\"2016/07/buch_wald.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"buch_wald-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"buch_wald-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"buch_wald-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1433", "648", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1443", "648", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1444", "663", "_wp_attached_file", "2016/07/augen-1.pdf");
INSERT INTO `wp_postmeta` VALUES("1445", "667", "_wp_attached_file", "2016/07/logo.jpg");
INSERT INTO `wp_postmeta` VALUES("1446", "667", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:792;s:6:\"height\";i:1040;s:4:\"file\";s:16:\"2016/07/logo.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"logo-228x300.jpg\";s:5:\"width\";i:228;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"logo-768x1008.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1008;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"logo-780x1024.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1457", "679", "_wp_attached_file", "2016/07/abend.png");
INSERT INTO `wp_postmeta` VALUES("1458", "679", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:792;s:6:\"height\";i:1040;s:4:\"file\";s:17:\"2016/07/abend.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"abend-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"abend-228x300.png\";s:5:\"width\";i:228;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"abend-768x1008.png\";s:5:\"width\";i:768;s:6:\"height\";i:1008;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"abend-780x1024.png\";s:5:\"width\";i:780;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1459", "679", "_edit_lock", "1469988391:1");
INSERT INTO `wp_postmeta` VALUES("1460", "679", "_wp_attachment_image_alt", "logo");
INSERT INTO `wp_postmeta` VALUES("1461", "679", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1462", "679", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1463", "690", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1464", "690", "_edit_lock", "1476790310:1");
INSERT INTO `wp_postmeta` VALUES("1465", "691", "_wp_attached_file", "2016/08/collage.jpg");
INSERT INTO `wp_postmeta` VALUES("1466", "691", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:733;s:6:\"height\";i:492;s:4:\"file\";s:19:\"2016/08/collage.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"collage-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"collage-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1467", "692", "_wp_attached_file", "2016/08/stille.jpg");
INSERT INTO `wp_postmeta` VALUES("1468", "692", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:729;s:6:\"height\";i:395;s:4:\"file\";s:18:\"2016/08/stille.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"stille-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"stille-300x163.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:163;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1469", "690", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1479", "690", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1483", "733", "_wp_attached_file", "2016/07/hibiskus_web.jpg");
INSERT INTO `wp_postmeta` VALUES("1484", "733", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:738;s:6:\"height\";i:738;s:4:\"file\";s:24:\"2016/07/hibiskus_web.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"hibiskus_web-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"hibiskus_web-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1485", "753", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1486", "753", "_edit_lock", "1483515853:1");
INSERT INTO `wp_postmeta` VALUES("1487", "754", "_wp_attached_file", "2016/08/dienstag_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1488", "754", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:22:\"2016/08/dienstag_2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"dienstag_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"dienstag_2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1489", "755", "_wp_attached_file", "2016/08/dienstag.jpg");
INSERT INTO `wp_postmeta` VALUES("1490", "755", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:20:\"2016/08/dienstag.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"dienstag-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"dienstag-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1491", "756", "_wp_attached_file", "2016/08/donnerstag_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1492", "756", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:24:\"2016/08/donnerstag_2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"donnerstag_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"donnerstag_2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1493", "757", "_wp_attached_file", "2016/08/donnerstag.jpg");
INSERT INTO `wp_postmeta` VALUES("1494", "757", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:22:\"2016/08/donnerstag.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"donnerstag-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"donnerstag-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1495", "758", "_wp_attached_file", "2016/08/freitag.jpg");
INSERT INTO `wp_postmeta` VALUES("1496", "758", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:19:\"2016/08/freitag.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"freitag-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"freitag-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1497", "759", "_wp_attached_file", "2016/08/mittwoch_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1498", "759", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:22:\"2016/08/mittwoch_2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"mittwoch_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"mittwoch_2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1499", "760", "_wp_attached_file", "2016/08/mittwoch.jpg");
INSERT INTO `wp_postmeta` VALUES("1500", "760", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:20:\"2016/08/mittwoch.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"mittwoch-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"mittwoch-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1501", "761", "_wp_attached_file", "2016/08/montag_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1502", "761", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:20:\"2016/08/montag_2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"montag_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"montag_2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1503", "762", "_wp_attached_file", "2016/08/montag.jpg");
INSERT INTO `wp_postmeta` VALUES("1504", "762", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:420;s:6:\"height\";i:420;s:4:\"file\";s:18:\"2016/08/montag.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"montag-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"montag-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1505", "763", "_wp_attached_file", "2016/08/freitag_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1506", "763", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:425;s:4:\"file\";s:21:\"2016/08/freitag_2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"freitag_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"freitag_2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1507", "753", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1517", "753", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1518", "799", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1519", "799", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1520", "799", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1521", "799", "_edit_lock", "1483469299:1");
INSERT INTO `wp_postmeta` VALUES("1531", "809", "_wp_attached_file", "2016/09/unbenannt-2.jpg");
INSERT INTO `wp_postmeta` VALUES("1532", "809", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:375;s:6:\"height\";i:500;s:4:\"file\";s:23:\"2016/09/unbenannt-2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-2-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472121552\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:1:{i:0;s:4:\"baum\";}}}");
INSERT INTO `wp_postmeta` VALUES("1533", "810", "_wp_attached_file", "2016/09/unbenannt-3.jpg");
INSERT INTO `wp_postmeta` VALUES("1534", "810", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:23:\"2016/09/unbenannt-3.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472121687\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:1:{i:0;s:5:\"teoch\";}}}");
INSERT INTO `wp_postmeta` VALUES("1535", "811", "_wp_attached_file", "2016/09/unbenannt-4.jpg");
INSERT INTO `wp_postmeta` VALUES("1536", "811", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:23:\"2016/09/unbenannt-4.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472122348\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"20\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1537", "812", "_wp_attached_file", "2016/09/unbenannt-5.jpg");
INSERT INTO `wp_postmeta` VALUES("1538", "812", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:23:\"2016/09/unbenannt-5.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-5-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472122497\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1539", "813", "_wp_attached_file", "2016/09/unbenannt-6.jpg");
INSERT INTO `wp_postmeta` VALUES("1540", "813", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:333;s:4:\"file\";s:23:\"2016/09/unbenannt-6.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472122546\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:1:{i:0;s:7:\"krähen\";}}}");
INSERT INTO `wp_postmeta` VALUES("1541", "814", "_wp_attached_file", "2016/09/unbenannt-7.jpg");
INSERT INTO `wp_postmeta` VALUES("1542", "814", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:23:\"2016/09/unbenannt-7.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-7-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123144\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1543", "815", "_wp_attached_file", "2016/09/unbenannt-8.jpg");
INSERT INTO `wp_postmeta` VALUES("1544", "815", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:23:\"2016/09/unbenannt-8.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-8-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472122745\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"14\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1545", "816", "_wp_attached_file", "2016/09/unbenannt-9.jpg");
INSERT INTO `wp_postmeta` VALUES("1546", "816", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:23:\"2016/09/unbenannt-9.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"unbenannt-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"unbenannt-9-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472121822\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"37\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:1:{i:0;s:4:\"gras\";}}}");
INSERT INTO `wp_postmeta` VALUES("1547", "817", "_wp_attached_file", "2016/09/unbenannt-10.jpg");
INSERT INTO `wp_postmeta` VALUES("1548", "817", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:375;s:6:\"height\";i:500;s:4:\"file\";s:24:\"2016/09/unbenannt-10.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-10-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124611\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1549", "818", "_wp_attached_file", "2016/09/unbenannt-11.jpg");
INSERT INTO `wp_postmeta` VALUES("1550", "818", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-11.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-11-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124846\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1551", "819", "_wp_attached_file", "2016/09/unbenannt-12.jpg");
INSERT INTO `wp_postmeta` VALUES("1552", "819", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-12.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-12-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472121926\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1553", "820", "_wp_attached_file", "2016/09/unbenannt-13.jpg");
INSERT INTO `wp_postmeta` VALUES("1554", "820", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-13.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-13-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124840\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1555", "821", "_wp_attached_file", "2016/09/unbenannt-14.jpg");
INSERT INTO `wp_postmeta` VALUES("1556", "821", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:375;s:6:\"height\";i:500;s:4:\"file\";s:24:\"2016/09/unbenannt-14.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-14-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124513\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"14\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1557", "822", "_wp_attached_file", "2016/09/unbenannt-15.jpg");
INSERT INTO `wp_postmeta` VALUES("1558", "822", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-15.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-15-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472931035\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1559", "823", "_wp_attached_file", "2016/09/unbenannt-16.jpg");
INSERT INTO `wp_postmeta` VALUES("1560", "823", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-16.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-16-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472127559\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.002\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1561", "824", "_wp_attached_file", "2016/09/unbenannt-17.jpg");
INSERT INTO `wp_postmeta` VALUES("1562", "824", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-17.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-17-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472127536\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1563", "825", "_wp_attached_file", "2016/09/unbenannt-18.jpg");
INSERT INTO `wp_postmeta` VALUES("1564", "825", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:375;s:6:\"height\";i:500;s:4:\"file\";s:24:\"2016/09/unbenannt-18.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-18-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472122250\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1565", "826", "_wp_attached_file", "2016/09/unbenannt-19.jpg");
INSERT INTO `wp_postmeta` VALUES("1566", "826", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-19.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-19-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123308\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1567", "827", "_wp_attached_file", "2016/09/unbenannt-20.jpg");
INSERT INTO `wp_postmeta` VALUES("1568", "827", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-20.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-20-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124777\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1569", "828", "_wp_attached_file", "2016/09/unbenannt-21.jpg");
INSERT INTO `wp_postmeta` VALUES("1570", "828", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:375;s:6:\"height\";i:500;s:4:\"file\";s:24:\"2016/09/unbenannt-21.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-21-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-21-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123822\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1571", "829", "_wp_attached_file", "2016/09/unbenannt-22.jpg");
INSERT INTO `wp_postmeta` VALUES("1572", "829", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-22.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-22-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-22-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124800\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1573", "830", "_wp_attached_file", "2016/09/unbenannt-23.jpg");
INSERT INTO `wp_postmeta` VALUES("1574", "830", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-23.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-23-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-23-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123504\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1575", "831", "_wp_attached_file", "2016/09/unbenannt-24.jpg");
INSERT INTO `wp_postmeta` VALUES("1576", "831", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-24.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-24-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-24-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123853\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1577", "832", "_wp_attached_file", "2016/09/unbenannt-25.jpg");
INSERT INTO `wp_postmeta` VALUES("1578", "832", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-25.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-25-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-25-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472126128\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:4:\"0.02\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1579", "833", "_wp_attached_file", "2016/09/unbenannt-26.jpg");
INSERT INTO `wp_postmeta` VALUES("1580", "833", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-26.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-26-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-26-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124819\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1581", "834", "_wp_attached_file", "2016/09/unbenannt-27.jpg");
INSERT INTO `wp_postmeta` VALUES("1582", "834", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-27.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-27-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-27-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"9\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472125384\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1583", "835", "_wp_attached_file", "2016/09/unbenannt-28.jpg");
INSERT INTO `wp_postmeta` VALUES("1584", "835", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-28.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-28-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-28-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472124883\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1585", "836", "_wp_attached_file", "2016/09/unbenannt-29.jpg");
INSERT INTO `wp_postmeta` VALUES("1586", "836", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-29.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-29-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-29-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123238\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"14\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1587", "837", "_wp_attached_file", "2016/09/unbenannt-30.jpg");
INSERT INTO `wp_postmeta` VALUES("1588", "837", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-30.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-30-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-30-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472126338\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1589", "838", "_wp_attached_file", "2016/09/unbenannt-31.jpg");
INSERT INTO `wp_postmeta` VALUES("1590", "838", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-31.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-31-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-31-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472126591\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.002\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1591", "839", "_wp_attached_file", "2016/09/unbenannt-32.jpg");
INSERT INTO `wp_postmeta` VALUES("1592", "839", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-32.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-32-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-32-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123357\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"39\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1593", "840", "_wp_attached_file", "2016/09/unbenannt-33.jpg");
INSERT INTO `wp_postmeta` VALUES("1594", "840", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-33.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-33-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-33-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123548\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1595", "841", "_wp_attached_file", "2016/09/unbenannt-34.jpg");
INSERT INTO `wp_postmeta` VALUES("1596", "841", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-34.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-34-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-34-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472132480\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1597", "842", "_wp_attached_file", "2016/09/unbenannt-35.jpg");
INSERT INTO `wp_postmeta` VALUES("1598", "842", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/09/unbenannt-35.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"unbenannt-35-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"unbenannt-35-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472914912\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1599", "843", "_wp_attached_file", "2016/09/unbenannt.jpg");
INSERT INTO `wp_postmeta` VALUES("1600", "843", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:21:\"2016/09/unbenannt.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"unbenannt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"unbenannt-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472128842\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"19\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1601", "843", "_wp_attachment_image_alt", "tor");
INSERT INTO `wp_postmeta` VALUES("1602", "842", "_wp_attachment_image_alt", "blaue glockenblume");
INSERT INTO `wp_postmeta` VALUES("1603", "810", "_wp_attachment_image_alt", "landschaft mit teich");
INSERT INTO `wp_postmeta` VALUES("1604", "811", "_wp_attachment_image_alt", "haus mit baum");
INSERT INTO `wp_postmeta` VALUES("1605", "812", "_wp_attachment_image_alt", "apfelbaum");
INSERT INTO `wp_postmeta` VALUES("1606", "813", "_wp_attachment_image_alt", "eisentor");
INSERT INTO `wp_postmeta` VALUES("1607", "814", "_wp_attachment_image_alt", "graeser");
INSERT INTO `wp_postmeta` VALUES("1608", "809", "_wp_attachment_image_alt", "platane");
INSERT INTO `wp_postmeta` VALUES("1609", "815", "_wp_attachment_image_alt", "bank");
INSERT INTO `wp_postmeta` VALUES("1610", "816", "_wp_attachment_image_alt", "graeser");
INSERT INTO `wp_postmeta` VALUES("1611", "817", "_wp_attachment_image_alt", "wiese");
INSERT INTO `wp_postmeta` VALUES("1612", "818", "_wp_attachment_image_alt", "margarite");
INSERT INTO `wp_postmeta` VALUES("1613", "819", "_wp_attachment_image_alt", "loewenzahn");
INSERT INTO `wp_postmeta` VALUES("1614", "820", "_wp_attachment_image_alt", "sumpfdotterblume");
INSERT INTO `wp_postmeta` VALUES("1615", "821", "_wp_attachment_image_alt", "baeume");
INSERT INTO `wp_postmeta` VALUES("1616", "822", "_wp_attachment_image_alt", "gelbe blumen");
INSERT INTO `wp_postmeta` VALUES("1617", "823", "_wp_attachment_image_alt", "gelbe blueten, schmetterling");
INSERT INTO `wp_postmeta` VALUES("1618", "824", "_wp_attachment_image_alt", "orange blume");
INSERT INTO `wp_postmeta` VALUES("1619", "825", "_wp_attachment_image_alt", "roter sonnenhut");
INSERT INTO `wp_postmeta` VALUES("1620", "826", "_wp_attachment_image_alt", "baeume, bruecke");
INSERT INTO `wp_postmeta` VALUES("1621", "827", "_wp_attachment_image_alt", "blumen weiss");
INSERT INTO `wp_postmeta` VALUES("1622", "828", "_wp_attachment_image_alt", "laerche");
INSERT INTO `wp_postmeta` VALUES("1623", "829", "_wp_attachment_image_alt", "dolde mit samen");
INSERT INTO `wp_postmeta` VALUES("1624", "830", "_wp_attachment_image_alt", "rote beeren");
INSERT INTO `wp_postmeta` VALUES("1625", "831", "_wp_attachment_image_alt", "weymutskiefer");
INSERT INTO `wp_postmeta` VALUES("1626", "832", "_wp_attachment_image_alt", "eibe mit roten beeren");
INSERT INTO `wp_postmeta` VALUES("1627", "833", "_wp_attachment_image_alt", "rotklee");
INSERT INTO `wp_postmeta` VALUES("1628", "834", "_wp_attachment_image_alt", "dolde mit samen");
INSERT INTO `wp_postmeta` VALUES("1629", "835", "_wp_attachment_image_alt", "lila blumen");
INSERT INTO `wp_postmeta` VALUES("1630", "836", "_wp_attachment_image_alt", "blaetter, baeume");
INSERT INTO `wp_postmeta` VALUES("1631", "837", "_wp_attachment_image_alt", "mariendistel");
INSERT INTO `wp_postmeta` VALUES("1632", "838", "_wp_attachment_image_alt", "kleine rote nelke");
INSERT INTO `wp_postmeta` VALUES("1633", "839", "_wp_attachment_image_alt", "lila blueten");
INSERT INTO `wp_postmeta` VALUES("1634", "840", "_wp_attachment_image_alt", "blaue blueten");
INSERT INTO `wp_postmeta` VALUES("1635", "841", "_wp_attachment_image_alt", "teich mit enten");
INSERT INTO `wp_postmeta` VALUES("1636", "848", "_wp_attached_file", "2016/07/rote-graeser.jpg");
INSERT INTO `wp_postmeta` VALUES("1637", "848", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:24:\"2016/07/rote-graeser.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"rote-graeser-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"rote-graeser-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:5:\"E-510\";s:7:\"caption\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:17:\"created_timestamp\";s:10:\"1472123073\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"42\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:22:\"OLYMPUS DIGITAL CAMERA\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1638", "863", "_wp_attached_file", "2016/09/titel.jpg");
INSERT INTO `wp_postmeta` VALUES("1639", "863", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:17:\"2016/09/titel.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"titel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"titel-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1640", "843", "_edit_lock", "1473490228:1");
INSERT INTO `wp_postmeta` VALUES("1644", "848", "_edit_lock", "1483468924:1");
INSERT INTO `wp_postmeta` VALUES("1645", "848", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1646", "848", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1647", "848", "_wp_old_slug", "olympus-digital-camera-36");
INSERT INTO `wp_postmeta` VALUES("1648", "843", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1649", "843", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1650", "843", "_wp_old_slug", "olympus-digital-camera-35");
INSERT INTO `wp_postmeta` VALUES("1651", "842", "_edit_lock", "1473489867:1");
INSERT INTO `wp_postmeta` VALUES("1652", "842", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1653", "842", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1654", "842", "_wp_old_slug", "olympus-digital-camera-34");
INSERT INTO `wp_postmeta` VALUES("1655", "841", "_edit_lock", "1473490482:1");
INSERT INTO `wp_postmeta` VALUES("1656", "841", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1657", "841", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1658", "841", "_wp_old_slug", "olympus-digital-camera-33");
INSERT INTO `wp_postmeta` VALUES("1659", "840", "_edit_lock", "1473489663:1");
INSERT INTO `wp_postmeta` VALUES("1660", "840", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1661", "840", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1662", "840", "_wp_old_slug", "olympus-digital-camera-32");
INSERT INTO `wp_postmeta` VALUES("1663", "839", "_edit_lock", "1473488357:1");
INSERT INTO `wp_postmeta` VALUES("1664", "839", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1665", "839", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1666", "839", "_wp_old_slug", "olympus-digital-camera-31");
INSERT INTO `wp_postmeta` VALUES("1667", "838", "_edit_lock", "1473488216:1");
INSERT INTO `wp_postmeta` VALUES("1668", "838", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1669", "838", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1670", "838", "_wp_old_slug", "olympus-digital-camera-30");
INSERT INTO `wp_postmeta` VALUES("1671", "837", "_edit_lock", "1473488375:1");
INSERT INTO `wp_postmeta` VALUES("1672", "837", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1673", "837", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1674", "837", "_wp_old_slug", "olympus-digital-camera-29");
INSERT INTO `wp_postmeta` VALUES("1675", "836", "_edit_lock", "1473488869:1");
INSERT INTO `wp_postmeta` VALUES("1676", "836", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1677", "836", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1678", "836", "_wp_old_slug", "olympus-digital-camera-28");
INSERT INTO `wp_postmeta` VALUES("1679", "835", "_edit_lock", "1473488499:1");
INSERT INTO `wp_postmeta` VALUES("1680", "835", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1681", "835", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1682", "835", "_wp_old_slug", "olympus-digital-camera-27");
INSERT INTO `wp_postmeta` VALUES("1683", "834", "_edit_lock", "1473488688:1");
INSERT INTO `wp_postmeta` VALUES("1684", "833", "_edit_lock", "1473488712:1");
INSERT INTO `wp_postmeta` VALUES("1685", "832", "_edit_lock", "1473488920:1");
INSERT INTO `wp_postmeta` VALUES("1686", "831", "_edit_lock", "1473488897:1");
INSERT INTO `wp_postmeta` VALUES("1687", "830", "_edit_lock", "1473486937:1");
INSERT INTO `wp_postmeta` VALUES("1688", "829", "_edit_lock", "1473487002:1");
INSERT INTO `wp_postmeta` VALUES("1689", "828", "_edit_lock", "1473488980:1");
INSERT INTO `wp_postmeta` VALUES("1690", "827", "_edit_lock", "1473489494:1");
INSERT INTO `wp_postmeta` VALUES("1691", "826", "_edit_lock", "1473489483:1");
INSERT INTO `wp_postmeta` VALUES("1692", "825", "_edit_lock", "1473489589:1");
INSERT INTO `wp_postmeta` VALUES("1693", "824", "_edit_lock", "1473489754:1");
INSERT INTO `wp_postmeta` VALUES("1694", "824", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1695", "824", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1696", "824", "_wp_old_slug", "olympus-digital-camera-16");
INSERT INTO `wp_postmeta` VALUES("1697", "823", "_edit_lock", "1473489719:1");
INSERT INTO `wp_postmeta` VALUES("1698", "822", "_edit_lock", "1473489702:1");
INSERT INTO `wp_postmeta` VALUES("1699", "822", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1700", "822", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1701", "822", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1702", "822", "_yoast_wpseo_linkdex", "22");
INSERT INTO `wp_postmeta` VALUES("1703", "822", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1704", "822", "_wp_old_slug", "olympus-digital-camera-14");
INSERT INTO `wp_postmeta` VALUES("1705", "848", "_yoast_wpseo_focuskw_text_input", "graeser");
INSERT INTO `wp_postmeta` VALUES("1706", "848", "_yoast_wpseo_focuskw", "graeser");
INSERT INTO `wp_postmeta` VALUES("1707", "848", "_yoast_wpseo_linkdex", "22");
INSERT INTO `wp_postmeta` VALUES("1708", "842", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1709", "842", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1710", "842", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1711", "840", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1712", "840", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1713", "840", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1714", "838", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1715", "838", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1716", "838", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1717", "837", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1718", "837", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1719", "837", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1720", "833", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1721", "833", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1722", "833", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1723", "833", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1724", "833", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1725", "833", "_wp_old_slug", "olympus-digital-camera-25");
INSERT INTO `wp_postmeta` VALUES("1726", "843", "_yoast_wpseo_focuskw_text_input", "tor");
INSERT INTO `wp_postmeta` VALUES("1727", "843", "_yoast_wpseo_focuskw", "tor");
INSERT INTO `wp_postmeta` VALUES("1728", "843", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1729", "841", "_yoast_wpseo_focuskw_text_input", "teich, enten");
INSERT INTO `wp_postmeta` VALUES("1730", "841", "_yoast_wpseo_focuskw", "teich, enten");
INSERT INTO `wp_postmeta` VALUES("1731", "841", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1732", "836", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1733", "836", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1734", "836", "_yoast_wpseo_linkdex", "22");
INSERT INTO `wp_postmeta` VALUES("1735", "834", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1736", "834", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1737", "834", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1738", "834", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1739", "834", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1740", "834", "_wp_old_slug", "olympus-digital-camera-26");
INSERT INTO `wp_postmeta` VALUES("1741", "832", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1742", "832", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1743", "832", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1744", "832", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1745", "832", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1746", "832", "_wp_old_slug", "olympus-digital-camera-24");
INSERT INTO `wp_postmeta` VALUES("1747", "831", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1748", "831", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1749", "831", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1750", "831", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1751", "831", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1752", "831", "_wp_old_slug", "olympus-digital-camera-23");
INSERT INTO `wp_postmeta` VALUES("1753", "828", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1754", "828", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1755", "828", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1756", "828", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1757", "828", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1758", "828", "_wp_old_slug", "olympus-digital-camera-20");
INSERT INTO `wp_postmeta` VALUES("1759", "827", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1760", "827", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1761", "827", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1762", "827", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1763", "827", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1764", "827", "_wp_old_slug", "olympus-digital-camera-19");
INSERT INTO `wp_postmeta` VALUES("1765", "826", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1766", "826", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1767", "826", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1768", "826", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1769", "826", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1770", "826", "_wp_old_slug", "olympus-digital-camera-18");
INSERT INTO `wp_postmeta` VALUES("1771", "825", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1772", "825", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1773", "825", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1774", "825", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1775", "825", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1776", "825", "_wp_old_slug", "olympus-digital-camera-17");
INSERT INTO `wp_postmeta` VALUES("1777", "824", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1778", "824", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1779", "824", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1780", "823", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1781", "823", "_yoast_wpseo_focuskw_text_input", "blueten");
INSERT INTO `wp_postmeta` VALUES("1782", "823", "_yoast_wpseo_focuskw", "blueten");
INSERT INTO `wp_postmeta` VALUES("1783", "823", "_yoast_wpseo_linkdex", "22");
INSERT INTO `wp_postmeta` VALUES("1784", "823", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1785", "823", "_wp_old_slug", "olympus-digital-camera-15");
INSERT INTO `wp_postmeta` VALUES("1786", "821", "_edit_lock", "1473489807:1");
INSERT INTO `wp_postmeta` VALUES("1787", "821", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1788", "821", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1789", "821", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1790", "821", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1791", "821", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1792", "821", "_wp_old_slug", "olympus-digital-camera-13");
INSERT INTO `wp_postmeta` VALUES("1793", "820", "_edit_lock", "1473489853:1");
INSERT INTO `wp_postmeta` VALUES("1794", "819", "_edit_lock", "1473489931:1");
INSERT INTO `wp_postmeta` VALUES("1795", "819", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1796", "819", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1797", "819", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1798", "819", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1799", "819", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1800", "819", "_wp_old_slug", "olympus-digital-camera-11");
INSERT INTO `wp_postmeta` VALUES("1801", "818", "_edit_lock", "1473489971:1");
INSERT INTO `wp_postmeta` VALUES("1802", "818", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1803", "818", "_yoast_wpseo_focuskw_text_input", "blumen");
INSERT INTO `wp_postmeta` VALUES("1804", "818", "_yoast_wpseo_focuskw", "blumen");
INSERT INTO `wp_postmeta` VALUES("1805", "818", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1806", "818", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1807", "818", "_wp_old_slug", "olympus-digital-camera-10");
INSERT INTO `wp_postmeta` VALUES("1808", "817", "_edit_lock", "1473490017:1");
INSERT INTO `wp_postmeta` VALUES("1809", "817", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1810", "817", "_yoast_wpseo_focuskw_text_input", "wiese");
INSERT INTO `wp_postmeta` VALUES("1811", "817", "_yoast_wpseo_focuskw", "wiese");
INSERT INTO `wp_postmeta` VALUES("1812", "817", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1813", "817", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1814", "817", "_wp_old_slug", "olympus-digital-camera-9");
INSERT INTO `wp_postmeta` VALUES("1815", "816", "_edit_lock", "1473490079:1");
INSERT INTO `wp_postmeta` VALUES("1816", "815", "_edit_lock", "1473490120:1");
INSERT INTO `wp_postmeta` VALUES("1817", "815", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1818", "815", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1819", "815", "_wp_old_slug", "olympus-digital-camera-7");
INSERT INTO `wp_postmeta` VALUES("1820", "815", "_yoast_wpseo_focuskw_text_input", "bank");
INSERT INTO `wp_postmeta` VALUES("1821", "815", "_yoast_wpseo_focuskw", "bank");
INSERT INTO `wp_postmeta` VALUES("1822", "815", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1823", "814", "_edit_lock", "1473490165:1");
INSERT INTO `wp_postmeta` VALUES("1824", "814", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1825", "814", "_yoast_wpseo_focuskw_text_input", "graeser");
INSERT INTO `wp_postmeta` VALUES("1826", "814", "_yoast_wpseo_focuskw", "graeser");
INSERT INTO `wp_postmeta` VALUES("1827", "814", "_yoast_wpseo_linkdex", "27");
INSERT INTO `wp_postmeta` VALUES("1828", "814", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1829", "814", "_wp_old_slug", "olympus-digital-camera-6");
INSERT INTO `wp_postmeta` VALUES("1830", "813", "_edit_lock", "1473490207:1");
INSERT INTO `wp_postmeta` VALUES("1831", "812", "_edit_lock", "1473490289:1");
INSERT INTO `wp_postmeta` VALUES("1832", "812", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1833", "812", "_yoast_wpseo_focuskw_text_input", "baeume");
INSERT INTO `wp_postmeta` VALUES("1834", "812", "_yoast_wpseo_focuskw", "baeume");
INSERT INTO `wp_postmeta` VALUES("1835", "812", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1836", "812", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1837", "812", "_wp_old_slug", "olympus-digital-camera-4");
INSERT INTO `wp_postmeta` VALUES("1838", "811", "_edit_lock", "1473490343:1");
INSERT INTO `wp_postmeta` VALUES("1839", "811", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1840", "811", "_yoast_wpseo_focuskw_text_input", "haus, baeume");
INSERT INTO `wp_postmeta` VALUES("1841", "811", "_yoast_wpseo_focuskw", "haus, b");
INSERT INTO `wp_postmeta` VALUES("1842", "811", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1843", "811", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1844", "811", "_wp_old_slug", "olympus-digital-camera-3");
INSERT INTO `wp_postmeta` VALUES("1845", "810", "_edit_lock", "1473490413:1");
INSERT INTO `wp_postmeta` VALUES("1846", "810", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1847", "810", "_yoast_wpseo_focuskw_text_input", "landschaft, teich");
INSERT INTO `wp_postmeta` VALUES("1848", "810", "_yoast_wpseo_focuskw", "landschaft, teich");
INSERT INTO `wp_postmeta` VALUES("1849", "810", "_yoast_wpseo_linkdex", "11");
INSERT INTO `wp_postmeta` VALUES("1850", "810", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1851", "810", "_wp_old_slug", "olympus-digital-camera-2");
INSERT INTO `wp_postmeta` VALUES("1852", "809", "_edit_lock", "1473490460:1");
INSERT INTO `wp_postmeta` VALUES("1853", "809", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1854", "809", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1855", "809", "_wp_old_slug", "olympus-digital-camera");
INSERT INTO `wp_postmeta` VALUES("1856", "763", "_edit_lock", "1473490511:1");
INSERT INTO `wp_postmeta` VALUES("1857", "925", "_wp_attached_file", "2016/07/astern_blau_klein.jpg");
INSERT INTO `wp_postmeta` VALUES("1858", "925", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1063;s:6:\"height\";i:1124;s:4:\"file\";s:29:\"2016/07/astern_blau_klein.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"astern_blau_klein-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"astern_blau_klein-284x300.jpg\";s:5:\"width\";i:284;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"astern_blau_klein-768x812.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:812;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"astern_blau_klein-968x1024.jpg\";s:5:\"width\";i:968;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:30:\"astern_blau_klein-960x1015.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1015;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1859", "926", "_wp_attached_file", "2016/07/blaetter_klein.jpg");
INSERT INTO `wp_postmeta` VALUES("1860", "926", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1063;s:6:\"height\";i:1050;s:4:\"file\";s:26:\"2016/07/blaetter_klein.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"blaetter_klein-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"blaetter_klein-300x296.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:296;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"blaetter_klein-768x759.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:759;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"blaetter_klein-1024x1011.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1011;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:26:\"blaetter_klein-960x948.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:948;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1861", "6", "_yoast_wpseo_focuskw_text_input", "die kleinen dinge des lebens");
INSERT INTO `wp_postmeta` VALUES("1862", "6", "_yoast_wpseo_focuskw", "die kleinen dinge des lebens");
INSERT INTO `wp_postmeta` VALUES("1863", "6", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1864", "6", "_yoast_wpseo_linkdex", "38");
INSERT INTO `wp_postmeta` VALUES("1865", "450", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1866", "648", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1867", "799", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1868", "690", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1869", "86", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1870", "577", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1871", "753", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1872", "12", "_yoast_wpseo_metadesc", "die kleinen dinge des lebens, bilder, traumgärten, einfachheit, wesentliches, weltanschauung, buddhismus, gesundheit, yoga-übungen");
INSERT INTO `wp_postmeta` VALUES("1873", "955", "_wp_attached_file", "2016/10/cropped-mistel_3.jpg");
INSERT INTO `wp_postmeta` VALUES("1874", "955", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:727;s:4:\"file\";s:28:\"2016/10/cropped-mistel_3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"cropped-mistel_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"cropped-mistel_3-300x109.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:109;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"cropped-mistel_3-768x279.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:279;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"cropped-mistel_3-1024x372.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:372;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:28:\"cropped-mistel_3-960x349.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:349;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1875", "955", "_wp_attachment_custom_header_last_used_tiny-framework", "1477128592");
INSERT INTO `wp_postmeta` VALUES("1876", "955", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("1885", "960", "_wp_attached_file", "2016/07/herbst.jpg");
INSERT INTO `wp_postmeta` VALUES("1886", "960", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1676;s:6:\"height\";i:2732;s:4:\"file\";s:18:\"2016/07/herbst.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"herbst-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"herbst-184x300.jpg\";s:5:\"width\";i:184;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"herbst-768x1252.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1252;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"herbst-628x1024.jpg\";s:5:\"width\";i:628;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:19:\"herbst-960x1565.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1565;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1887", "965", "_wp_attached_file", "2016/07/aepfel.jpg");
INSERT INTO `wp_postmeta` VALUES("1888", "965", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:988;s:4:\"file\";s:18:\"2016/07/aepfel.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"aepfel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"aepfel-243x300.jpg\";s:5:\"width\";i:243;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"aepfel-768x948.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:948;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1889", "984", "_wp_attached_file", "2016/07/kahl.jpg");
INSERT INTO `wp_postmeta` VALUES("1890", "984", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:16:\"2016/07/kahl.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"kahl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"kahl-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"kahl-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"kahl-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1891", "987", "_wp_attached_file", "2016/07/blaetter.jpg");
INSERT INTO `wp_postmeta` VALUES("1892", "987", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:762;s:4:\"file\";s:20:\"2016/07/blaetter.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"blaetter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"blaetter-300x286.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:286;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"blaetter-768x732.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:732;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1896", "999", "_wp_attached_file", "2016/07/RIMG0054.jpg");
INSERT INTO `wp_postmeta` VALUES("1897", "999", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0054.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0054-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0054-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104056483\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:3:\"5.7\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1898", "1000", "_wp_attached_file", "2016/07/RIMG0055.jpg");
INSERT INTO `wp_postmeta` VALUES("1899", "1000", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0055.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0055-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0055-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104056527\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:3:\"5.7\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:18:\"0.0090909090909091\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1900", "1001", "_wp_attached_file", "2016/07/RIMG0065.jpg");
INSERT INTO `wp_postmeta` VALUES("1901", "1001", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0065.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0065-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0065-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104058943\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:3:\"5.7\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:17:\"0.014285714285714\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1902", "1002", "_wp_attached_file", "2016/07/RIMG0067.jpg");
INSERT INTO `wp_postmeta` VALUES("1903", "1002", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0067.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0067-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0067-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.7\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104059012\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:4:\"16.3\";s:3:\"iso\";s:3:\"154\";s:13:\"shutter_speed\";s:4:\"0.04\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1904", "1003", "_wp_attached_file", "2016/07/RIMG0070.jpg");
INSERT INTO `wp_postmeta` VALUES("1905", "1003", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0070.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0070-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0070-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104059161\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:3:\"5.7\";s:3:\"iso\";s:3:\"130\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1906", "1004", "_wp_attached_file", "2016/07/RIMG0071.jpg");
INSERT INTO `wp_postmeta` VALUES("1907", "1004", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0071.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0071-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0071-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104059332\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:3:\"5.7\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1908", "1005", "_wp_attached_file", "2016/07/RIMG0077.jpg");
INSERT INTO `wp_postmeta` VALUES("1909", "1005", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2016/07/RIMG0077.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"RIMG0077-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"RIMG0077-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:15:\"CaplioG3 modelS\";s:7:\"caption\";s:128:\"????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????\";s:17:\"created_timestamp\";s:10:\"1104059643\";s:9:\"copyright\";s:25:\"(C) Caplio G3 modelS User\";s:12:\"focal_length\";s:3:\"9.9\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:17:\"0.013333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1910", "999", "_wp_attachment_image_alt", "raureif_1");
INSERT INTO `wp_postmeta` VALUES("1911", "1000", "_wp_attachment_image_alt", "raureif_2");
INSERT INTO `wp_postmeta` VALUES("1912", "1001", "_wp_attachment_image_alt", "raureif_3");
INSERT INTO `wp_postmeta` VALUES("1913", "1005", "_edit_lock", "1479051423:1");
INSERT INTO `wp_postmeta` VALUES("1914", "1005", "_wp_attachment_image_alt", "raureif_7");
INSERT INTO `wp_postmeta` VALUES("1915", "1005", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1916", "1005", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1917", "1004", "_wp_attachment_image_alt", "raureif_6");
INSERT INTO `wp_postmeta` VALUES("1918", "1003", "_wp_attachment_image_alt", "raureif_5");
INSERT INTO `wp_postmeta` VALUES("1919", "1002", "_wp_attachment_image_alt", "raureif_4");
INSERT INTO `wp_postmeta` VALUES("1920", "1031", "_wp_attached_file", "2016/07/himmel.jpg");
INSERT INTO `wp_postmeta` VALUES("1921", "1031", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:18:\"2016/07/himmel.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"himmel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"himmel-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"himmel-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"himmel-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1922", "1043", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1923", "1043", "_edit_lock", "1483483428:1");
INSERT INTO `wp_postmeta` VALUES("1924", "1043", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1934", "1043", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("1935", "1046", "_wp_attached_file", "2016/07/leuchter.jpg");
INSERT INTO `wp_postmeta` VALUES("1936", "1046", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:672;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2016/07/leuchter.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"leuchter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"leuchter-202x300.jpg\";s:5:\"width\";i:202;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1937", "1046", "_wp_attachment_image_alt", "leuchter, ein licht");
INSERT INTO `wp_postmeta` VALUES("1938", "1055", "_wp_attached_file", "2016/07/engel.jpg");
INSERT INTO `wp_postmeta` VALUES("1939", "1055", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:636;s:4:\"file\";s:17:\"2016/07/engel.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"engel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"engel-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"engel-768x488.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:488;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"engel-960x611.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:611;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1940", "1055", "_wp_attachment_image_alt", "engel");
INSERT INTO `wp_postmeta` VALUES("1941", "1072", "_wp_attached_file", "2016/07/stern.jpg");
INSERT INTO `wp_postmeta` VALUES("1942", "1072", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:877;s:4:\"file\";s:17:\"2016/07/stern.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"stern-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"stern-300x263.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:263;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"stern-768x674.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"stern-960x842.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:842;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1943", "1072", "_wp_attachment_image_alt", "spiegelung stern");
INSERT INTO `wp_postmeta` VALUES("1944", "1086", "_wp_attached_file", "2016/07/schmetterling.jpg");
INSERT INTO `wp_postmeta` VALUES("1945", "1086", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1070;s:4:\"file\";s:25:\"2016/07/schmetterling.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"schmetterling-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"schmetterling-280x300.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"schmetterling-768x822.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:822;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"schmetterling-957x1024.jpg\";s:5:\"width\";i:957;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:26:\"schmetterling-960x1027.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1027;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1946", "1087", "_wp_attached_file", "2016/07/marienkaefer.jpg");
INSERT INTO `wp_postmeta` VALUES("1947", "1087", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1052;s:4:\"file\";s:24:\"2016/07/marienkaefer.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"marienkaefer-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"marienkaefer-285x300.jpg\";s:5:\"width\";i:285;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"marienkaefer-768x808.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:808;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"marienkaefer-973x1024.jpg\";s:5:\"width\";i:973;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:25:\"marienkaefer-960x1010.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1010;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1948", "1099", "_wp_attached_file", "2016/07/advent_4-2.jpg");
INSERT INTO `wp_postmeta` VALUES("1949", "1099", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:22:\"2016/07/advent_4-2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"advent_4-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"advent_4-2-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"advent_4-2-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"advent_4-2-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:23:\"advent_4-2-960x1280.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1950", "1100", "_wp_attached_file", "2016/07/advent_4.jpg");
INSERT INTO `wp_postmeta` VALUES("1951", "1100", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2016/07/advent_4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"advent_4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"advent_4-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"advent_4-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"advent_4-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"advent_4-960x1280.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1952", "1101", "_wp_attached_file", "2016/07/advent_4_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1953", "1101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1288;s:4:\"file\";s:22:\"2016/07/advent_4_2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"advent_4_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"advent_4_2-233x300.jpg\";s:5:\"width\";i:233;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"advent_4_2-768x989.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:989;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"advent_4_2-795x1024.jpg\";s:5:\"width\";i:795;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:23:\"advent_4_2-960x1236.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1236;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1954", "1112", "_wp_attached_file", "2016/12/see.jpg");
INSERT INTO `wp_postmeta` VALUES("1955", "1112", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:215;s:4:\"file\";s:15:\"2016/12/see.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"see-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"see-300x65.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:65;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"see-768x165.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:15:\"see-960x206.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1956", "1112", "_wp_attachment_custom_header_last_used_tiny-framework", "1482216864");
INSERT INTO `wp_postmeta` VALUES("1957", "1112", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("1958", "1115", "_wp_attached_file", "2016/07/mistel.jpg");
INSERT INTO `wp_postmeta` VALUES("1959", "1115", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:18:\"2016/07/mistel.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"mistel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"mistel-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"mistel-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"mistel-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1962", "1119", "_wp_attached_file", "2016/12/IMG_8476.jpg");
INSERT INTO `wp_postmeta` VALUES("1963", "1119", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2016/12/IMG_8476.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8476-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8476-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482058960\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1964", "1120", "_wp_attached_file", "2016/12/IMG_8483.jpg");
INSERT INTO `wp_postmeta` VALUES("1965", "1120", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8483.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8483-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8483-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482059330\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1966", "1121", "_wp_attached_file", "2016/12/IMG_8486.jpg");
INSERT INTO `wp_postmeta` VALUES("1967", "1121", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8486.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8486-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8486-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482065772\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:6:\"18.353\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1968", "1122", "_wp_attached_file", "2016/12/IMG_8492.jpg");
INSERT INTO `wp_postmeta` VALUES("1969", "1122", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8492.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8492-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8492-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482065842\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"13.74\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1970", "1123", "_wp_attached_file", "2016/12/IMG_8494.jpg");
INSERT INTO `wp_postmeta` VALUES("1971", "1123", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8494.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8494-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8494-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482066324\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1972", "1124", "_wp_attached_file", "2016/12/IMG_8497.jpg");
INSERT INTO `wp_postmeta` VALUES("1973", "1124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8497.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8497-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8497-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482066805\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:6:\"11.759\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.02\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1974", "1125", "_wp_attached_file", "2016/12/IMG_8498.jpg");
INSERT INTO `wp_postmeta` VALUES("1975", "1125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8498.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8498-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8498-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482066870\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1976", "1126", "_wp_attached_file", "2016/12/IMG_8500.jpg");
INSERT INTO `wp_postmeta` VALUES("1977", "1126", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8500.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8500-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8500-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482066895\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1978", "1127", "_wp_attached_file", "2016/12/IMG_8504.jpg");
INSERT INTO `wp_postmeta` VALUES("1979", "1127", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8504.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8504-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8504-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482067112\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"23.2\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1980", "1128", "_wp_attached_file", "2016/12/IMG_8506.jpg");
INSERT INTO `wp_postmeta` VALUES("1981", "1128", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8506.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8506-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8506-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482071564\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1982", "1129", "_wp_attached_file", "2016/12/IMG_8542.jpg");
INSERT INTO `wp_postmeta` VALUES("1983", "1129", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2016/12/IMG_8542.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8542-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8542-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482073479\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"13.74\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1984", "1130", "_wp_attached_file", "2016/12/IMG_8546.jpg");
INSERT INTO `wp_postmeta` VALUES("1985", "1130", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8546.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8546-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8546-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482073606\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:6:\"18.353\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1986", "1131", "_wp_attached_file", "2016/12/IMG_8550.jpg");
INSERT INTO `wp_postmeta` VALUES("1987", "1131", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8550.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8550-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8550-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482073783\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1988", "1132", "_wp_attached_file", "2016/12/IMG_8561.jpg");
INSERT INTO `wp_postmeta` VALUES("1989", "1132", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2016/12/IMG_8561.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8561-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8561-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482073966\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"13.74\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1990", "1133", "_wp_attached_file", "2016/12/IMG_8565.jpg");
INSERT INTO `wp_postmeta` VALUES("1991", "1133", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2016/12/IMG_8565.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8565-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8565-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482074004\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"13.74\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:3:\"0.1\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1992", "1134", "_wp_attached_file", "2016/12/IMG_8572.jpg");
INSERT INTO `wp_postmeta` VALUES("1993", "1134", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8572.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8572-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8572-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482074179\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1994", "1135", "_wp_attached_file", "2016/12/IMG_8591.jpg");
INSERT INTO `wp_postmeta` VALUES("1995", "1135", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8591.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8591-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8591-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482074677\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"13.74\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.04\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1996", "1136", "_wp_attached_file", "2016/12/IMG_8601.jpg");
INSERT INTO `wp_postmeta` VALUES("1997", "1136", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8601.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8601-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8601-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482074807\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"13.74\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1998", "1137", "_wp_attached_file", "2016/12/IMG_8607.jpg");
INSERT INTO `wp_postmeta` VALUES("1999", "1137", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8607.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8607-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8607-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482074934\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:6:\"15.783\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2000", "1138", "_wp_attached_file", "2016/12/IMG_8614.jpg");
INSERT INTO `wp_postmeta` VALUES("2001", "1138", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:600;s:4:\"file\";s:20:\"2016/12/IMG_8614.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8614-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8614-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1482075081\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"23.2\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.04\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2002", "1139", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2003", "1139", "_edit_lock", "1483084286:1");
INSERT INTO `wp_postmeta` VALUES("2004", "1139", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2014", "1139", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("2018", "1168", "_wp_attached_file", "2016/07/schmetterling-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2019", "1168", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:719;s:4:\"file\";s:27:\"2016/07/schmetterling-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"schmetterling-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"schmetterling-1-300x216.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"schmetterling-1-768x552.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:552;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:27:\"schmetterling-1-960x690.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:690;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2020", "1180", "_wp_attached_file", "2016/07/stein.jpg");
INSERT INTO `wp_postmeta` VALUES("2021", "1180", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:707;s:4:\"file\";s:17:\"2016/07/stein.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"stein-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"stein-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"stein-768x543.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:543;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"stein-960x679.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:679;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2022", "1189", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2023", "1189", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2024", "1190", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("2025", "1190", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2026", "1190", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2027", "1190", "_menu_item_object_id", "1189");
INSERT INTO `wp_postmeta` VALUES("2028", "1190", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2029", "1190", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2030", "1190", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2031", "1190", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2032", "1190", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2033", "1189", "_yoast_wpseo_content_score", "60");
INSERT INTO `wp_postmeta` VALUES("2034", "1189", "_edit_lock", "1503684560:1");
INSERT INTO `wp_postmeta` VALUES("2035", "1196", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2036", "1196", "_edit_lock", "1483470190:1");
INSERT INTO `wp_postmeta` VALUES("2037", "1196", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2038", "1197", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("2039", "1197", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2040", "1197", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2041", "1197", "_menu_item_object_id", "1196");
INSERT INTO `wp_postmeta` VALUES("2042", "1197", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2043", "1197", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2044", "1197", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2045", "1197", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2046", "1197", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2047", "1196", "_yoast_wpseo_content_score", "30");
INSERT INTO `wp_postmeta` VALUES("2048", "1132", "_edit_lock", "1483470036:1");
INSERT INTO `wp_postmeta` VALUES("2049", "1233", "_wp_attached_file", "2017/01/IMG_8789.jpg");
INSERT INTO `wp_postmeta` VALUES("2050", "1233", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8789.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8789-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8789-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485086799\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"7.889\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:6:\"0.0005\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2051", "1234", "_wp_attached_file", "2017/01/IMG_8798.jpg");
INSERT INTO `wp_postmeta` VALUES("2052", "1234", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8798.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8798-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8798-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087771\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:6:\"0.0005\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2053", "1235", "_wp_attached_file", "2017/01/IMG_8802.jpg");
INSERT INTO `wp_postmeta` VALUES("2054", "1235", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8802.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8802-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8802-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087827\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2055", "1236", "_wp_attached_file", "2017/01/IMG_8805.jpg");
INSERT INTO `wp_postmeta` VALUES("2056", "1236", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8805.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8805-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8805-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087859\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2057", "1237", "_wp_attached_file", "2017/01/IMG_8807.jpg");
INSERT INTO `wp_postmeta` VALUES("2058", "1237", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8807.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8807-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8807-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087865\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2059", "1238", "_wp_attached_file", "2017/01/IMG_8818.jpg");
INSERT INTO `wp_postmeta` VALUES("2060", "1238", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8818.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8818-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8818-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087908\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2061", "1239", "_wp_attached_file", "2017/01/IMG_8819.jpg");
INSERT INTO `wp_postmeta` VALUES("2062", "1239", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8819.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8819-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8819-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087912\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2063", "1240", "_wp_attached_file", "2017/01/IMG_8822.jpg");
INSERT INTO `wp_postmeta` VALUES("2064", "1240", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:20:\"2017/01/IMG_8822.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8822-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8822-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1485087922\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2065", "1233", "_wp_attachment_image_alt", "am see");
INSERT INTO `wp_postmeta` VALUES("2066", "1234", "_wp_attachment_image_alt", "moeven_1");
INSERT INTO `wp_postmeta` VALUES("2067", "1235", "_wp_attachment_image_alt", "moeven_2");
INSERT INTO `wp_postmeta` VALUES("2068", "1236", "_wp_attachment_image_alt", "moeven_3");
INSERT INTO `wp_postmeta` VALUES("2069", "1237", "_wp_attachment_image_alt", "moeven_4");
INSERT INTO `wp_postmeta` VALUES("2070", "1238", "_wp_attachment_image_alt", "moeven_5");
INSERT INTO `wp_postmeta` VALUES("2071", "1239", "_wp_attachment_image_alt", "moeven_6");
INSERT INTO `wp_postmeta` VALUES("2072", "1240", "_wp_attachment_image_alt", "moeven_7");
INSERT INTO `wp_postmeta` VALUES("2073", "1244", "_wp_attached_file", "2017/01/eis.jpg");
INSERT INTO `wp_postmeta` VALUES("2074", "1244", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:15:\"2017/01/eis.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"eis-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"eis-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"eis-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:15:\"eis-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2075", "1245", "_wp_attached_file", "2017/01/eis_2.jpg");
INSERT INTO `wp_postmeta` VALUES("2076", "1245", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:17:\"2017/01/eis_2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"eis_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"eis_2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"eis_2-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"eis_2-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2077", "1244", "_wp_attachment_image_alt", "zugefrorener see");
INSERT INTO `wp_postmeta` VALUES("2078", "1245", "_wp_attachment_image_alt", "zugefrorener see");
INSERT INTO `wp_postmeta` VALUES("2079", "1263", "_wp_attached_file", "2017/01/nebel.jpg");
INSERT INTO `wp_postmeta` VALUES("2080", "1263", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:796;s:4:\"file\";s:17:\"2017/01/nebel.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"nebel-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"nebel-300x239.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:239;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"nebel-768x611.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:611;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"nebel-960x764.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:764;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2081", "1282", "_wp_attached_file", "2017/01/fruehling.jpg");
INSERT INTO `wp_postmeta` VALUES("2082", "1282", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:688;s:4:\"file\";s:21:\"2017/01/fruehling.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"fruehling-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"fruehling-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"fruehling-768x528.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"fruehling-960x660.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:660;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2083", "1283", "_wp_attached_file", "2017/01/denkmal.jpg");
INSERT INTO `wp_postmeta` VALUES("2084", "1283", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:665;s:6:\"height\";i:1000;s:4:\"file\";s:19:\"2017/01/denkmal.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"denkmal-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"denkmal-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2085", "1292", "_wp_attached_file", "2017/01/dohle.jpg");
INSERT INTO `wp_postmeta` VALUES("2086", "1292", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:929;s:4:\"file\";s:17:\"2017/01/dohle.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"dohle-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"dohle-300x279.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:279;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"dohle-768x713.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:713;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"dohle-960x892.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:892;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2087", "1295", "_wp_attached_file", "2017/01/IMG_9084.jpg");
INSERT INTO `wp_postmeta` VALUES("2088", "1295", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:941;s:4:\"file\";s:20:\"2017/01/IMG_9084.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_9084-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_9084-300x282.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:282;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"IMG_9084-768x723.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:723;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:20:\"IMG_9084-960x903.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:903;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2089", "1307", "_wp_attached_file", "2017/03/segelboot.jpg");
INSERT INTO `wp_postmeta` VALUES("2090", "1307", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:562;s:4:\"file\";s:21:\"2017/03/segelboot.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"segelboot-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"segelboot-300x84.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"segelboot-768x216.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"segelboot-1024x288.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:288;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"segelboot-960x270.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2091", "1307", "_wp_attachment_custom_header_last_used_tiny-framework", "1488645715");
INSERT INTO `wp_postmeta` VALUES("2092", "1307", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("2095", "1318", "_wp_attached_file", "2017/01/baum.jpg");
INSERT INTO `wp_postmeta` VALUES("2096", "1318", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:771;s:4:\"file\";s:16:\"2017/01/baum.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"baum-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"baum-300x231.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"baum-768x592.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:592;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"baum-960x740.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:740;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2097", "1321", "_wp_attached_file", "2017/01/kaktus.jpg");
INSERT INTO `wp_postmeta` VALUES("2098", "1321", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:18:\"2017/01/kaktus.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"kaktus-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"kaktus-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"kaktus-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"kaktus-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2099", "1324", "_wp_attached_file", "2017/01/elster.jpg");
INSERT INTO `wp_postmeta` VALUES("2100", "1324", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:773;s:4:\"file\";s:18:\"2017/01/elster.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"elster-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"elster-300x290.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"elster-768x742.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:742;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2101", "1333", "_wp_attached_file", "2017/01/elster_nest.jpg");
INSERT INTO `wp_postmeta` VALUES("2102", "1333", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:969;s:4:\"file\";s:23:\"2017/01/elster_nest.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"elster_nest-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"elster_nest-300x291.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:291;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"elster_nest-768x744.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:744;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:23:\"elster_nest-960x930.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:930;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2103", "1350", "_wp_attached_file", "2017/01/magnolie.jpg");
INSERT INTO `wp_postmeta` VALUES("2104", "1350", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2017/01/magnolie.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"magnolie-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"magnolie-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"magnolie-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"magnolie-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"magnolie-960x1280.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2105", "1358", "_wp_attached_file", "2017/04/IMG_9472.jpg");
INSERT INTO `wp_postmeta` VALUES("2106", "1358", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:523;s:4:\"file\";s:20:\"2017/04/IMG_9472.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_9472-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"IMG_9472-300x78.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:78;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"IMG_9472-768x201.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_9472-1024x268.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:268;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:20:\"IMG_9472-960x251.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:251;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2107", "1358", "_wp_attachment_custom_header_last_used_tiny-framework", "1492017142");
INSERT INTO `wp_postmeta` VALUES("2108", "1358", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("2111", "1380", "_wp_attached_file", "2017/01/DSCF6671.jpg");
INSERT INTO `wp_postmeta` VALUES("2112", "1380", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2017/01/DSCF6671.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DSCF6671-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DSCF6671-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"DSCF6671-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:20:\"DSCF6671-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S3200\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1003164265\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"20.4\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:18:\"0.0041666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2113", "1382", "_wp_attached_file", "2017/01/magnolie-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2114", "1382", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:4:\"file\";s:22:\"2017/01/magnolie-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"magnolie-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"magnolie-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"magnolie-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"magnolie-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:22:\"magnolie-1-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2116", "1358", "_edit_lock", "1493057542:1");
INSERT INTO `wp_postmeta` VALUES("2118", "1388", "_wp_attached_file", "2017/01/kater.jpg");
INSERT INTO `wp_postmeta` VALUES("2119", "1388", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1145;s:6:\"height\";i:864;s:4:\"file\";s:17:\"2017/01/kater.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"kater-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"kater-300x226.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:226;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"kater-768x580.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:580;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"kater-1024x773.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:773;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"kater-960x724.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:724;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2120", "1407", "_wp_attached_file", "2017/01/baum-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2121", "1407", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:18:\"2017/01/baum-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"baum-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"baum-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"baum-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"baum-1-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2122", "1408", "_wp_attached_file", "2017/01/bank.jpg");
INSERT INTO `wp_postmeta` VALUES("2123", "1408", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:4:\"file\";s:16:\"2017/01/bank.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"bank-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"bank-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"bank-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"bank-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"bank-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2124", "1415", "_wp_attached_file", "2017/01/see.jpg");
INSERT INTO `wp_postmeta` VALUES("2125", "1415", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1478;s:4:\"file\";s:15:\"2017/01/see.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"see-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"see-300x222.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:222;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"see-768x568.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:568;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:16:\"see-1024x757.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:757;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:15:\"see-960x709.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:709;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2127", "1458", "_wp_attached_file", "2017/01/hausboote.jpg");
INSERT INTO `wp_postmeta` VALUES("2128", "1458", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1298;s:4:\"file\";s:21:\"2017/01/hausboote.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hausboote-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hausboote-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"hausboote-768x498.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:498;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"hausboote-1024x665.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:665;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"hausboote-960x623.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:623;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2130", "1492", "_wp_attached_file", "2017/01/taborkirche.jpg");
INSERT INTO `wp_postmeta` VALUES("2131", "1492", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:23:\"2017/01/taborkirche.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"taborkirche-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"taborkirche-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"taborkirche-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:23:\"taborkirche-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2132", "1494", "_wp_attached_file", "2017/01/blauregen.jpg");
INSERT INTO `wp_postmeta` VALUES("2133", "1494", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:21:\"2017/01/blauregen.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"blauregen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"blauregen-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"blauregen-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"blauregen-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:22:\"blauregen-960x1280.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2135", "1514", "_wp_attached_file", "2017/05/segelboot.jpg");
INSERT INTO `wp_postmeta` VALUES("2136", "1514", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:477;s:4:\"file\";s:21:\"2017/05/segelboot.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"segelboot-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"segelboot-300x72.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:72;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"segelboot-768x183.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"segelboot-1024x244.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:244;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"segelboot-960x229.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:229;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2137", "1514", "_wp_attachment_custom_header_last_used_tiny-framework", "1496246507");
INSERT INTO `wp_postmeta` VALUES("2138", "1514", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("2143", "1538", "_wp_attached_file", "2017/01/waldkap.jpg");
INSERT INTO `wp_postmeta` VALUES("2144", "1538", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:775;s:4:\"file\";s:19:\"2017/01/waldkap.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"waldkap-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"waldkap-300x233.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:233;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"waldkap-768x595.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:595;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:19:\"waldkap-960x744.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:744;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2146", "1538", "_edit_lock", "1496343688:1");
INSERT INTO `wp_postmeta` VALUES("2147", "1549", "_wp_attached_file", "2017/01/rahnsdorf.jpg");
INSERT INTO `wp_postmeta` VALUES("2148", "1549", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:21:\"2017/01/rahnsdorf.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"rahnsdorf-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"rahnsdorf-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"rahnsdorf-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"rahnsdorf-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:22:\"rahnsdorf-960x1280.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2149", "1552", "_wp_attached_file", "2017/01/ahorn.jpg");
INSERT INTO `wp_postmeta` VALUES("2150", "1552", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:17:\"2017/01/ahorn.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"ahorn-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"ahorn-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"ahorn-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"ahorn-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"ahorn-960x1280.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1280;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2151", "1565", "_wp_attached_file", "2017/01/rose.jpg");
INSERT INTO `wp_postmeta` VALUES("2152", "1565", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:788;s:4:\"file\";s:16:\"2017/01/rose.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"rose-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"rose-300x236.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:236;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"rose-768x605.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:605;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"rose-960x756.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:756;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2153", "1573", "_wp_attached_file", "2017/01/lake.jpg");
INSERT INTO `wp_postmeta` VALUES("2154", "1573", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:16:\"2017/01/lake.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"lake-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"lake-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"lake-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"lake-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2155", "1581", "_wp_attached_file", "2017/01/see-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2156", "1581", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:17:\"2017/01/see-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"see-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"see-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"see-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:17:\"see-1-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2157", "1588", "_wp_attached_file", "2017/01/schafe.jpg");
INSERT INTO `wp_postmeta` VALUES("2158", "1588", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1217;s:4:\"file\";s:18:\"2017/01/schafe.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"schafe-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"schafe-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"schafe-768x623.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:623;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"schafe-1024x831.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:831;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"schafe-960x779.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:779;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2159", "1589", "_wp_attached_file", "2017/01/fahrrad.jpg");
INSERT INTO `wp_postmeta` VALUES("2160", "1589", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1131;s:4:\"file\";s:19:\"2017/01/fahrrad.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"fahrrad-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"fahrrad-300x226.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:226;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"fahrrad-768x579.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:579;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"fahrrad-1024x772.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:19:\"fahrrad-960x724.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:724;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2161", "1594", "_wp_attached_file", "2017/01/regenbogen.jpg");
INSERT INTO `wp_postmeta` VALUES("2162", "1594", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1108;s:4:\"file\";s:22:\"2017/01/regenbogen.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"regenbogen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"regenbogen-300x222.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:222;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"regenbogen-768x567.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:567;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"regenbogen-1024x756.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:756;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:22:\"regenbogen-960x709.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:709;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2163", "1610", "_wp_attached_file", "2017/01/hauptmann.jpg");
INSERT INTO `wp_postmeta` VALUES("2164", "1610", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:4:\"file\";s:21:\"2017/01/hauptmann.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"hauptmann-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"hauptmann-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"hauptmann-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"hauptmann-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:21:\"hauptmann-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2165", "1636", "_wp_attached_file", "2017/01/tor.jpg");
INSERT INTO `wp_postmeta` VALUES("2166", "1636", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:15:\"2017/01/tor.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"tor-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"tor-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"tor-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:15:\"tor-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2167", "1639", "_wp_attached_file", "2017/08/wein.jpg");
INSERT INTO `wp_postmeta` VALUES("2168", "1639", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:297;s:4:\"file\";s:16:\"2017/08/wein.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"wein-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"wein-300x89.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:89;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"wein-768x228.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:228;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:16:\"wein-960x285.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2169", "1639", "_wp_attachment_custom_header_last_used_tiny-framework", "1501678422");
INSERT INTO `wp_postmeta` VALUES("2170", "1639", "_wp_attachment_is_custom_header", "tiny-framework");
INSERT INTO `wp_postmeta` VALUES("2171", "1640", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("2172", "1640", "_wp_trash_meta_time", "1501678422");
INSERT INTO `wp_postmeta` VALUES("2173", "1646", "_wp_attached_file", "2017/01/erpe_wasser.jpg");
INSERT INTO `wp_postmeta` VALUES("2174", "1646", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:23:\"2017/01/erpe_wasser.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"erpe_wasser-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"erpe_wasser-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"erpe_wasser-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:23:\"erpe_wasser-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1501836822\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2175", "1647", "_wp_attached_file", "2017/01/erpetal_wasser.jpg");
INSERT INTO `wp_postmeta` VALUES("2176", "1647", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:26:\"2017/01/erpetal_wasser.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"erpetal_wasser-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"erpetal_wasser-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"erpetal_wasser-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:26:\"erpetal_wasser-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1501829613\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"9.817\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2177", "1648", "_wp_attached_file", "2017/01/rinder_2.jpg");
INSERT INTO `wp_postmeta` VALUES("2178", "1648", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2017/01/rinder_2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"rinder_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"rinder_2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"rinder_2-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:20:\"rinder_2-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1501823758\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"23.2\";s:3:\"iso\";s:3:\"250\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2179", "1649", "_wp_attached_file", "2017/01/rinder_3.jpg");
INSERT INTO `wp_postmeta` VALUES("2180", "1649", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2017/01/rinder_3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"rinder_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"rinder_3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"rinder_3-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:20:\"rinder_3-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1501823792\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2181", "1650", "_wp_attached_file", "2017/01/rinder.jpg");
INSERT INTO `wp_postmeta` VALUES("2182", "1650", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:18:\"2017/01/rinder.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"rinder-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"rinder-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"rinder-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"rinder-960x720.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon PowerShot A560\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1501829892\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"23.2\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2185", "1675", "_wp_attached_file", "2017/01/schwaene_klein.jpg");
INSERT INTO `wp_postmeta` VALUES("2186", "1675", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:695;s:4:\"file\";s:26:\"2017/01/schwaene_klein.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"schwaene_klein-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"schwaene_klein-300x209.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"schwaene_klein-768x534.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:534;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:26:\"schwaene_klein-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2187", "1680", "_wp_attached_file", "2017/01/pilze.jpg");
INSERT INTO `wp_postmeta` VALUES("2188", "1680", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1417;s:4:\"file\";s:17:\"2017/01/pilze.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"pilze-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"pilze-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"pilze-768x1088.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1088;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"pilze-723x1024.jpg\";s:5:\"width\";i:723;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:18:\"pilze-960x1360.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:1360;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2189", "1695", "_wp_attached_file", "2017/01/hibiskus_rot.jpg");
INSERT INTO `wp_postmeta` VALUES("2190", "1695", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:826;s:4:\"file\";s:24:\"2017/01/hibiskus_rot.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"hibiskus_rot-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"hibiskus_rot-300x248.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:248;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"hibiskus_rot-768x634.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:634;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"custom-header-image\";a:4:{s:4:\"file\";s:24:\"hibiskus_rot-960x793.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:793;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("4", "1", "2016-06-21 11:26:01", "2016-06-21 09:26:01", "<p> Name <br />\r\n    [text* your-name] </p>\r\n\r\n<p> Email <br />\r\n    [email* your-email] </p>\r\n\r\n<p>Betreff<br />\r\n    [text your-subject] </p>\r\n\r\n<p>Mitteilung<br />\r\n    [textarea your-message] </p>\r\n\r\n<p>[submit \"Send\"]</p>\nmein kleiner yogakurs \"[your-subject]\"\n[your-name] <freefeeling@web.de>\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://keep-it-short-and-simple.de)\nfreefeeling@web.de\nReply-To: [your-email]\n\n\n\n\nmein kleiner yogakurs \"[your-subject]\"\nmein kleiner yogakurs <freefeeling@web.de>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on mein kleiner yogakurs (http://keep-it-short-and-simple.de)\n[your-email]\nReply-To: freefeeling@web.de\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nDas Datumsformat ist ungültig.\nDas Datum liegt vor dem ersten erlaubten Datum.\nDas Datum liegt nach dem letzen erlaubten Datum.\nEin unbekannter Fehler trat beim Hochladen der Datei auf.\nDu hast nicht die Berechtigung, Dateien dieses Typs hochzuladen.\nDie Datei ist zu groß.\nEs trat ein Fehler beim Hochladen der Datei auf.\nDas Zahlenformat ist ungültig.\nDie Zahl ist niedriger als das erlaubte Minimum.\nDie Zahl ist größer als das erlaubte Maximum.\nDie Antwort zu dem Quiz ist falsch.\nIhr eingegebener Code ist falsch.\nDie eingegebene E-Mail-Adresse ist ungültig.\nDie URL ist ungültig.\nDie Telefonnummer ist ungültig.", "Contact form 1", "", "publish", "closed", "closed", "", "contact-form-1", "", "", "2016-06-28 09:36:03", "2016-06-28 07:36:03", "", "0", "http://keep-it-short-and-simple.de/?post_type=wpcf7_contact_form&#038;p=4", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2016-06-21 11:37:56", "2016-06-21 09:37:56", "<img class=\"wp-image-96 size-full alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\r\n<p style=\"text-align: left;\">Keine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.</p>\r\n<p style=\"text-align: left;\"><a href=\"http://keep-it-short-and-simple.de/mehr-zum-thema-yoga/\">mehr zum thema yoga</a></p>", "yoga für alle", "", "publish", "closed", "closed", "", "keep-it-short-and-simple-de", "", "", "2016-10-18 11:06:43", "2016-10-18 09:06:43", "", "0", "http://keep-it-short-and-simple.de/?page_id=6", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2016-06-21 11:30:41", "2016-06-21 09:30:41", "", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:30:41", "2016-06-21 09:30:41", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2016-06-21 11:31:57", "2016-06-21 09:31:57", "<strong>Yoga für alle</strong>\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:31:57", "2016-06-21 09:31:57", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2016-06-21 11:32:51", "2016-06-21 09:32:51", "<strong>Yoga für alle</strong>\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:32:51", "2016-06-21 09:32:51", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2016-06-21 11:36:35", "2016-06-21 09:36:35", "<strong>Yoga für alle</strong>\r\n\r\n<img class=\"alignright wp-image-10 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/yoga.png\" alt=\"schneidersitz\" width=\"180\" height=\"180\" />\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "yoga für alle", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 11:36:35", "2016-06-21 09:36:35", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2016-06-21 11:47:33", "2016-06-21 09:47:33", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                    </strong><img class=\"wp-image-13 size-full alignnone\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /><strong>                               </strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut?</strong></p>\r\n<p style=\"text-align: left;\">festigt Unterarme</p>\r\n<p style=\"text-align: left;\">stärkt und festigt Brustmuskulatur</p>\r\n<p style=\"text-align: left;\">schafft Erleichterung bei verspanneten Schultern</p>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li style=\"text-align: left;\">Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li style=\"text-align: left;\">Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li style=\"text-align: left;\">Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li style=\"text-align: left;\">Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li style=\"text-align: left;\">Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li style=\"text-align: left;\">Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li style=\"text-align: left;\">Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "publish", "closed", "closed", "", "yoga-uebungen", "", "", "2016-10-18 13:36:36", "2016-10-18 11:36:36", "", "0", "http://keep-it-short-and-simple.de/?page_id=12", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2016-06-21 11:44:06", "2016-06-21 09:44:06", "<strong>Arm-Heben </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>festigt Unterarme<img class=\"alignright wp-image-13 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /></li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 11:44:06", "2016-06-21 09:44:06", "", "12", "http://keep-it-short-and-simple.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2016-06-21 11:47:33", "2016-06-21 09:47:33", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                                                    Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme<img class=\"alignleft wp-image-13 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" />\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 11:47:33", "2016-06-21 09:47:33", "", "12", "http://keep-it-short-and-simple.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2016-06-21 11:49:53", "2016-06-21 09:49:53", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                                                    Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme<img class=\"wp-image-13 size-full alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" />\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "yoga übungen", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 11:49:53", "2016-06-21 09:49:53", "", "12", "http://keep-it-short-and-simple.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2016-06-21 12:10:13", "2016-06-21 10:10:13", "Christine Dreßler\r\nKarl-Pokern-Straße 45\r\n12587 Berlin\r\n\r\nTelefon: 0176 - 21878640\r\n\r\nE-Mail:  kontakt@christine-dressler.de\r\n\r\n<strong>Haftungshinweis</strong>\r\nTrotz sorgfältiger inhaltlicher Kontrolle übernehme ich keine Haftung für die Inhalte externer Links. Für den Inhalt der verlinkten Seiten sind ausschließlich deren Betreiber verantwortlich.\r\n\r\n<strong>Urheberrecht / Copyright</strong>\r\nAlle Seiten des Webauftrittes unterliegen dem Urheberrecht (Copyright). Dies gilt im Besonderen für Texte und Bilder. Eine Vervielfältigung oder Verwendung von Teilen oder der ganzen Webseite ist nicht gestattet.\r\n\r\n<strong> </strong>\r\n\r\n&nbsp;", "impressum", "", "publish", "closed", "closed", "", "impressum", "", "", "2016-12-26 08:54:49", "2016-12-26 07:54:49", "", "0", "http://keep-it-short-and-simple.de/?page_id=18", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2016-06-21 12:10:13", "2016-06-21 10:10:13", "wer\r\n\r\nwarum\r\n\r\nwo", "impressum", "", "inherit", "closed", "closed", "", "18-revision-v1", "", "", "2016-06-21 12:10:13", "2016-06-21 10:10:13", "", "18", "http://keep-it-short-and-simple.de/18-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2016-06-21 12:10:53", "2016-06-21 10:10:53", "[contact-form-7 id=\"121\" title=\"Contact form 1\"]\r\n\r\n&nbsp;", "kontakt", "", "publish", "closed", "closed", "", "kontakt", "", "", "2016-06-28 09:36:58", "2016-06-28 07:36:58", "", "0", "http://keep-it-short-and-simple.de/?page_id=21", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2016-06-21 12:10:53", "2016-06-21 10:10:53", "formular\r\n\r\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-21 12:10:53", "2016-06-21 10:10:53", "", "21", "http://keep-it-short-and-simple.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2016-06-21 12:18:10", "2016-06-21 10:18:10", "&nbsp;\r\n\r\n<strong><img class=\"size-full wp-image-423 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.png\" alt=\"arm heben\" width=\"165\" height=\"182\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n<p style=\"text-align: left;\">Setzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.</p>", "arm-heben", "", "publish", "closed", "closed", "", "arm-hebung", "", "", "2016-07-19 19:34:36", "2016-07-19 17:34:36", "", "0", "http://keep-it-short-and-simple.de/?p=30", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2016-06-21 12:18:10", "2016-06-21 10:18:10", "<strong>Arm-Hebung </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "arm-hebung", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:18:10", "2016-06-21 10:18:10", "", "30", "http://keep-it-short-and-simple.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2016-06-21 12:20:01", "2016-06-21 10:20:01", "<strong><img class=\"size-full wp-image-421 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF-1.png\" alt=\"aufsetzen\" width=\"246\" height=\"120\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n<p style=\"text-align: left;\">Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.</p>", "aufsetzen", "", "publish", "closed", "closed", "", "aufsetzen", "", "", "2016-07-19 19:33:24", "2016-07-19 17:33:24", "", "0", "http://keep-it-short-and-simple.de/?p=32", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2016-06-21 12:20:01", "2016-06-21 10:20:01", "<strong>Aufsetzen </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:20:01", "2016-06-21 10:20:01", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2016-06-21 12:21:51", "2016-06-21 10:21:51", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" />Aufsetzen </strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:21:51", "2016-06-21 10:21:51", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2016-06-21 12:22:55", "2016-06-21 10:22:55", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "aufsetzen", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:22:55", "2016-06-21 10:22:55", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2016-06-21 12:23:24", "2016-06-21 10:23:24", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "arm-hebung", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:23:24", "2016-06-21 10:23:24", "", "30", "http://keep-it-short-and-simple.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2016-06-21 12:33:55", "2016-06-21 10:33:55", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.</li>\r\n 	<li>Legen Sie die Hände auf die Schenkel.</li>\r\n 	<li>Heben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden in dieser Pose.</li>\r\n 	<li>Jetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Enspannen.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>\r\n&nbsp;", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 12:33:55", "2016-06-21 10:33:55", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2016-06-21 12:35:04", "2016-06-21 10:35:04", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:35:04", "2016-06-21 10:35:04", "", "30", "http://keep-it-short-and-simple.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2016-06-21 12:36:46", "2016-06-21 10:36:46", "<strong>Yoga für alle</strong>\r\n\r\n<img class=\"alignright wp-image-10 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/yoga.png\" alt=\"schneidersitz\" width=\"180\" height=\"180\" />\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 12:36:46", "2016-06-21 10:36:46", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2016-06-21 12:38:21", "2016-06-21 10:38:21", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                                                    Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme<img class=\"wp-image-13 size-full alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" />\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "YOGA ÜBUNGEN", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 12:38:21", "2016-06-21 10:38:21", "", "12", "http://keep-it-short-and-simple.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2016-06-21 12:38:59", "2016-06-21 10:38:59", "<strong>Arm-Heben </strong>\r\n\r\n<strong>                    </strong><img class=\"wp-image-13 size-full alignnone\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"ARM\" width=\"165\" height=\"182\" /><strong>                               </strong>\r\n\r\n<strong>Wofür ist das gut?</strong>\r\n\r\nfestigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "YOGA ÜBUNGEN", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2016-06-21 12:38:59", "2016-06-21 10:38:59", "", "12", "http://keep-it-short-and-simple.de/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2016-06-21 12:51:55", "2016-06-21 10:51:55", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />festigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz.</li>\r\n 	<li>Heben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Heben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.</li>\r\n 	<li>Jetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.</li>\r\n 	<li>Atmen Sie während der Übung so normal, wie möglich.</li>\r\n 	<li>Drei bis fünfmal wiederholen.</li>\r\n</ol>", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 12:51:55", "2016-06-21 10:51:55", "", "30", "http://keep-it-short-and-simple.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2016-06-21 12:54:00", "2016-06-21 10:54:00", "<img class=\"alignright wp-image-10 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/yoga.png\" alt=\"schneidersitz\" width=\"180\" height=\"180\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-21 12:54:00", "2016-06-21 10:54:00", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2016-06-21 14:19:12", "2016-06-21 12:19:12", "<img class=\"size-full wp-image-419 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN.png\" alt=\"augen rollen\" width=\"302\" height=\"96\" />\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannendx</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung:</strong></p>\r\n<p style=\"text-align: left;\">Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.</p>", "augen rollen", "", "publish", "closed", "closed", "", "augen-rollen", "", "", "2016-07-19 19:32:51", "2016-07-19 17:32:51", "", "0", "http://keep-it-short-and-simple.de/?p=69", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2016-06-21 14:19:12", "2016-06-21 12:19:12", "<strong>Wofür ist das gut? <img class=\"alignnone size-medium wp-image-70\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-1-300x95.gif\" alt=\"augen rollen\" width=\"300\" height=\"95\" /></strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "Augen Rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:19:12", "2016-06-21 12:19:12", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2016-06-21 14:46:05", "2016-06-21 12:46:05", "<img class=\"alignright wp-image-72 size-medium\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" /><strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "Augen Rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:46:05", "2016-06-21 12:46:05", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("75", "1", "2016-06-21 14:49:28", "2016-06-21 12:49:28", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nhilft bei angespannten und übermüdeten Augen\r\n\r\nstärkt die Augenmuskeln\r\n\r\nlindert Kopfschmerzen\r\n\r\nwirkt allgemein entspannend\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "Augen Rollen", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:49:28", "2016-06-21 12:49:28", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("76", "1", "2016-06-21 14:52:46", "2016-06-21 12:52:46", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nhilft bei angespannten und übermüdeten Augen\r\n\r\nstärkt die Augenmuskeln\r\n\r\nlindert Kopfschmerzen\r\n\r\nwirkt allgemein entspannend\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.</li>\r\n 	<li>Schauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.</li>\r\n 	<li>Schauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.</li>\r\n 	<li>Stellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).</li>\r\n 	<li>Jetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.</li>\r\n 	<li>Wiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).</li>\r\n 	<li>Die Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.</li>\r\n</ol>\r\n&nbsp;", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:52:46", "2016-06-21 12:52:46", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2016-06-21 14:56:06", "2016-06-21 12:56:06", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nhilft bei angespannten und übermüdeten Augen\r\n\r\nstärkt die Augenmuskeln\r\n\r\nlindert Kopfschmerzen\r\n\r\nwirkt allgemein entspannend\r\n\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 14:56:06", "2016-06-21 12:56:06", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2016-06-21 14:56:55", "2016-06-21 12:56:55", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-13 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.gif\" alt=\"arm-hebung\" width=\"165\" height=\"182\" />festigt Unterarme\r\n\r\nstärkt und festigt Brustmuskulatur\r\n\r\nschafft Erleichterung bei verspanneten Schultern\r\n\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 14:56:55", "2016-06-21 12:56:55", "", "30", "http://keep-it-short-and-simple.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("79", "1", "2016-06-21 14:57:39", "2016-06-21 12:57:39", "<strong><img class=\"alignright wp-image-34 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"246\" height=\"120\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-21 14:57:39", "2016-06-21 12:57:39", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("80", "1", "2016-06-21 15:02:51", "2016-06-21 13:02:51", "<strong>Wofür ist das gut? <img class=\"alignnone size-full wp-image-81\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.png\" alt=\"ARM\" width=\"165\" height=\"182\" /></strong>\n<ul>\n 	<li>festigt Unterarme</li>\n 	<li>stärkt und festigt Brustmuskulatur</li>\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\n</ul>\n&nbsp;\n\n<strong> </strong>\n\n<strong>Ausführung: </strong>\n\nSetzen Sie sich bequem in den Schneidersitz.\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\nAtmen Sie während der Übung so normal, wie möglich.\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-autosave-v1", "", "", "2016-06-21 15:02:51", "2016-06-21 13:02:51", "", "30", "http://keep-it-short-and-simple.de/30-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2016-06-21 15:03:30", "2016-06-21 13:03:30", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-81 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM.png\" alt=\"ARM\" width=\"165\" height=\"182\" /></strong>\r\n<ul>\r\n 	<li>festigt Unterarme</li>\r\n 	<li>stärkt und festigt Brustmuskulatur</li>\r\n 	<li>schafft Erleichterung bei verspanneten Schultern</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem in den Schneidersitz.\r\nHeben Sie die Hände in Schulterhöhe, die Handflächen nach oben, die Finger in Richtung Hals und die Ellenbogen nach außen.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nHeben Sie ganz langsam Ihre Hände, als müßten Sie ein großes Gewicht nach oben drücken, bis die Arme gestreckt sind.\r\nJetzt die Arme wieder einknicken und die Hände mit dem gleichen \"Gegendruck\" wieder senken.\r\nAtmen Sie während der Übung so normal, wie möglich.\r\nDrei bis fünfmal wiederholen.", "ARM-HEBEN", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2016-06-21 15:03:30", "2016-06-21 13:03:30", "", "30", "http://keep-it-short-and-simple.de/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("83", "1", "2016-06-21 15:05:32", "2016-06-21 13:05:32", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 15:05:32", "2016-06-21 13:05:32", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("84", "1", "2016-06-21 15:06:08", "2016-06-21 13:06:08", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 15:06:08", "2016-06-21 13:06:08", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2016-06-21 15:06:29", "2016-06-21 13:06:29", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-21 15:06:29", "2016-06-21 13:06:29", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2016-06-22 08:55:06", "2016-06-22 06:55:06", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />\r\n</strong></h4>\r\n<p style=\"text-align: left;\">Die Meisten haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier aber nicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur etwas für junge Leute.</p>\r\n<p style=\"text-align: left;\">Die Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechniken und körperlichen Übungen. Yoga entspannt und reguliert die Körperfunktionen und gibt Energie. Die Muskeln werden gedehnt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hier nicht um den Vergleich mit Anderen.</p>\r\n<p style=\"text-align: left;\"><strong>Warum sollten Sie Yoga machen?</strong></p>\r\n<p style=\"text-align: left;\">Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!</p>\r\n<p style=\"text-align: left;\">Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt. Es geht ganz einfach um Ihr Wohlbefinden.</p>\r\n<p style=\"text-align: left;\"><strong>Wie sollten Sie die Übungen machen?</strong></p>\r\n<p style=\"text-align: left;\">Diese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen! In der Endstellung verharrt man dann einige Sekunden. Wiederholungen nach einer kurzen Pause.</p>\r\n<p style=\"text-align: left;\"><strong>Zeit</strong></p>\r\n<p style=\"text-align: left;\">Am besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar noch etwas steif, aber es ist ein guter Beginn. Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.</p>\r\n<p style=\"text-align: left;\"><strong>Ort</strong></p>\r\n<p style=\"text-align: left;\">Möglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein - entweder ein Teppich oder eine gefaltete Decke auf dem Boden - es gibt natürlich auch entsprechende einfache yogamatten.</p>\r\n<p style=\"text-align: left;\"><strong>Essen</strong></p>\r\n<p style=\"text-align: left;\">Nach einer reichhaltigen Mahlzeit bis zu drei oder vier Stunden und nach einem leichten Imbiss etwa eine Stunde warten.</p>\r\n<p style=\"text-align: left;\">Trinken vor den Übungen schadet nicht.</p>\r\n<p style=\"text-align: left;\"><strong>Krankheiten und Beschwerden</strong></p>\r\n<p style=\"text-align: left;\">Bitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.</p>\r\n<p style=\"text-align: left;\"><a href=\"http://keep-it-short-and-simple.de/yoga-uebungen/\">yoga übungen</a></p>\r\n&nbsp;", "mehr zum thema yoga", "", "publish", "closed", "closed", "", "mehr-zum-thema-yoga", "", "", "2016-10-18 13:35:00", "2016-10-18 11:35:00", "", "0", "http://keep-it-short-and-simple.de/?page_id=86", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2016-06-22 08:55:06", "2016-06-22 06:55:06", "links zu ausgewählen seiten", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-22 08:55:06", "2016-06-22 06:55:06", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2016-06-23 09:11:23", "2016-06-23 07:11:23", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Skunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung (die Uhr rückwärts laufen lassen).\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden - zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-23 09:11:23", "2016-06-23 07:11:23", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2016-06-23 11:26:59", "2016-06-23 09:26:59", "", "yoga", "", "inherit", "open", "closed", "", "yoga-2", "", "", "2016-06-23 11:26:59", "2016-06-23 09:26:59", "", "6", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/yoga-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("96", "1", "2016-06-23 11:28:04", "2016-06-23 09:28:04", "", "titelbild", "", "inherit", "open", "closed", "", "titelbild", "", "", "2016-06-23 11:28:04", "2016-06-23 09:28:04", "", "6", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titelbild.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2016-06-23 11:29:02", "2016-06-23 09:29:02", "<img class=\"wp-image-96 size-full alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titelbild.png\" alt=\"titelbild\" width=\"165\" height=\"170\" />\r\n\r\nKeine Angst - Sie brauchen dafür weder ein Studium der Acrobatik noch die Mitgliedschaft in irgend welchen Sekten.\r\nEs geht in diesem Kurs um einfache Übungen, die jeder kann und jeder so gut ausführt, wie es ihm möglich ist - ohne Streß, Konkurrenzdruck und falschen Ehrgeiz.\r\nWenn man es richtig macht, bekommt man nicht einmal Muskelkater und tut doch eine Menge für sich und seinen Körper.\r\nEs ist auch nicht nötig, alle Übungen \"abzuarbeiten\", sondern jeder sucht sich heraus, was für ihn gut ist.", "YOGA FÜR ALLE", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2016-06-23 11:29:02", "2016-06-23 09:29:02", "", "6", "http://keep-it-short-and-simple.de/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2016-06-23 11:48:45", "2016-06-23 09:48:45", "<strong>Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um die erste Gruppe.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\n&nbsp;\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nWie sollten Sie die Übungen machen?\r\n\r\n&nbsp;\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\nZeit\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\nOrt\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\nEssen\r\n\r\nNach einer reichhaltigen Mahlzeit bis zwei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n&nbsp;\r\n\r\nHoher Blutdruck\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 11:48:45", "2016-06-23 09:48:45", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2016-06-23 11:54:59", "2016-06-23 09:54:59", "", "titel_spiegel", "", "inherit", "open", "closed", "", "titel_spiegel", "", "", "2016-06-23 11:54:59", "2016-06-23 09:54:59", "", "86", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2016-06-23 11:56:33", "2016-06-23 09:56:33", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um die erste Gruppe.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\n&nbsp;\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nWie sollten Sie die Übungen machen?\r\n\r\n&nbsp;\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\nZeit\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\nOrt\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\nEssen\r\n\r\nNach einer reichhaltigen Mahlzeit bis zwei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n&nbsp;\r\n\r\nHoher Blutdruck\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 11:56:33", "2016-06-23 09:56:33", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2016-06-23 12:10:37", "2016-06-23 10:10:37", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\nOrt\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:10:37", "2016-06-23 10:10:37", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2016-06-23 12:12:48", "2016-06-23 10:12:48", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:12:48", "2016-06-23 10:12:48", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2016-06-23 12:13:09", "2016-06-23 10:13:09", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden:\r\n\r\nHatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es wieder fünf Formen gibt, von denen man die für sich selbstpassendste aussuchen kann.\r\n\r\nIn unserem Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n&nbsp;\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n&nbsp;\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:13:09", "2016-06-23 10:13:09", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2016-06-23 12:15:39", "2016-06-23 10:15:39", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute. Es ist egal, wie alt manist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.\r\n\r\nSie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!\r\n\r\nDie Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.\r\n\r\nEs geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!\r\n\r\nIn der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.\r\n\r\nAbends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n<strong> Alphabetische Liste der Übungen</strong>\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:15:39", "2016-06-23 10:15:39", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2016-06-23 12:18:32", "2016-06-23 10:18:32", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:18:32", "2016-06-23 10:18:32", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2016-06-23 12:19:28", "2016-06-23 10:19:28", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.<!--more-->\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n<!--more-->\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:19:28", "2016-06-23 10:19:28", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2016-06-23 12:22:34", "2016-06-23 10:22:34", "<strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong>\r\n\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:22:34", "2016-06-23 10:22:34", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("110", "1", "2016-06-23 12:23:01", "2016-06-23 10:23:01", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-23 12:23:01", "2016-06-23 10:23:01", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2016-06-23 12:37:29", "2016-06-23 10:37:29", "", "head", "", "inherit", "open", "closed", "", "head", "", "", "2016-06-23 12:37:29", "2016-06-23 10:37:29", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/head.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2016-06-24 15:47:42", "2016-06-24 13:47:42", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\nAlphabetische Liste der Übungen\r\n\r\nArm-Heben\r\n\r\nAufsetzen\r\n\r\nAugenrollen\r\n\r\nBaum\r\n\r\nBein - Überschlag\r\n\r\nBogen\r\n\r\nBrust-Expander\r\n\r\nGespreizte Beinstreckung\r\n\r\nHaltungsgriff\r\n\r\nJapanischer Sitz\r\n\r\nKerze\r\n\r\nKobra\r\n\r\nKopfstand\r\n\r\nNacken-Rollen\r\n\r\nPerfekter Sitz\r\n\r\nPflug\r\n\r\nSitzender Held\r\n\r\nZusammengerolltes Blatt", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-24 15:47:42", "2016-06-24 13:47:42", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2016-06-24 19:25:14", "2016-06-24 17:25:14", "", "ARM", "arme heben", "inherit", "open", "closed", "", "arm-3", "", "", "2016-06-24 19:28:04", "2016-06-24 17:28:04", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ARM-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2016-06-24 19:25:17", "2016-06-24 17:25:17", "", "AUF", "aufsetzen", "inherit", "open", "closed", "", "auf-3", "", "", "2016-06-24 19:28:10", "2016-06-24 17:28:10", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2016-06-24 19:25:18", "2016-06-24 17:25:18", "", "AUGEN", "augenrollen", "inherit", "open", "closed", "", "augen-4", "", "", "2016-06-24 19:28:19", "2016-06-24 17:28:19", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2016-06-24 19:25:20", "2016-06-24 17:25:20", "", "BAUM", "baum", "inherit", "open", "closed", "", "baum-2", "", "", "2016-06-24 19:28:27", "2016-06-24 17:28:27", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2016-06-24 19:25:22", "2016-06-24 17:25:22", "", "BEIN", "beinüberschlag", "inherit", "open", "closed", "", "bein-2", "", "", "2016-06-24 19:28:44", "2016-06-24 17:28:44", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BEIN.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2016-06-24 19:25:24", "2016-06-24 17:25:24", "", "BRUEXPA", "brustexpander", "inherit", "open", "closed", "", "bruexpa-2", "", "", "2016-06-29 15:57:06", "2016-06-29 13:57:06", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BRUEXPA.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2016-06-24 19:25:25", "2016-06-24 17:25:25", "", "GESPREI", "gespreizte beinstreckung", "inherit", "open", "closed", "", "gesprei-2", "", "", "2016-06-24 19:29:21", "2016-06-24 17:29:21", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/GESPREI.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2016-06-24 19:25:26", "2016-06-24 17:25:26", "", "HALTUNG", "haltungsgriff", "inherit", "open", "closed", "", "haltung-2", "", "", "2016-06-24 19:29:35", "2016-06-24 17:29:35", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/HALTUNG.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2016-06-24 19:25:27", "2016-06-24 17:25:27", "", "JAPSITZ", "japansitz", "inherit", "open", "closed", "", "japsitz-2", "", "", "2016-06-24 19:29:54", "2016-06-24 17:29:54", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/JAPSITZ.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2016-06-24 19:25:29", "2016-06-24 17:25:29", "", "KOBRA", "kobra", "inherit", "open", "closed", "", "kobra-2", "", "", "2016-06-24 19:30:07", "2016-06-24 17:30:07", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KOBRA.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2016-06-24 19:25:31", "2016-06-24 17:25:31", "", "NACKEN", "nacken rollen", "inherit", "open", "closed", "", "nacken-2", "", "", "2016-06-24 19:30:30", "2016-06-24 17:30:30", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/NACKEN.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("131", "1", "2016-06-24 19:25:31", "2016-06-24 17:25:31", "", "PFLUG", "pflug", "inherit", "open", "closed", "", "pflug-2", "", "", "2016-06-24 19:30:38", "2016-06-24 17:30:38", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PFLUG.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2016-06-24 19:25:33", "2016-06-24 17:25:33", "", "ZUBLATT", "zusammengerolltes blatt", "inherit", "open", "closed", "", "zublatt-2", "", "", "2016-06-24 19:31:09", "2016-06-24 17:31:09", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/ZUBLATT.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2016-06-24 20:25:25", "2016-06-24 18:25:25", "", "jungfer im grünen", "", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen", "", "", "2016-06-24 20:25:25", "2016-06-24 18:25:25", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/jungfer-im-grünen.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("146", "1", "2016-06-24 20:25:51", "2016-06-24 18:25:51", "küchenschelle", "küchenschelle", "Küchenschelle", "inherit", "open", "closed", "", "ku%cc%88chenshcelle", "", "", "2016-06-28 20:06:12", "2016-06-28 18:06:12", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/küchenshcelle.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("149", "1", "2016-06-24 20:26:39", "2016-06-24 18:26:39", "jungfer im grünen", "jungfer im grünen", "jungfer im grüne", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-2", "", "", "2016-06-28 19:40:30", "2016-06-28 17:40:30", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/jungfer-im-grünen-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("150", "1", "2016-06-24 20:26:40", "2016-06-24 18:26:40", "", "küchenshcelle", "", "inherit", "open", "closed", "", "ku%cc%88chenshcelle-2", "", "", "2016-06-24 20:26:40", "2016-06-24 18:26:40", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/küchenshcelle-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("155", "1", "2016-06-24 22:33:18", "2016-06-24 20:33:18", "<img class=\"wp-image-72 size-medium alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUGEN-300x95.png\" alt=\"AUGEN\" width=\"300\" height=\"95\" />\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei angespannten und übermüdeten Augen</li>\r\n 	<li>stärkt die Augenmuskeln</li>\r\n 	<li>lindert Kopfschmerzen</li>\r\n 	<li>wirkt allgemein entspannend</li>\r\n</ul>\r\n<strong>Ausführung:</strong>\r\n\r\nSetzen Sie sich bequem (in den Schneidersitz), und schauen Sie geradeaus.\r\nSchauen Sie so weit wie möglich nach rechts, ohne den Kopf zu bewegen - fünf Sekunden lang.\r\nSchauen Sie jetzt so weit wie möglich nach links (Kopf nicht bewegen) auch fünf Sekunden lang.\r\nSchauen Sie nach oben und auf die Nase - jeweils auch fünf Sekunden.\r\nStellen Sie sich eine Riesenuhr vor (die Zwölf liegt unter der Augenbraue, die sechs auf dem Boden).\r\nJetzt mit den Augen wie ein Sekundenzeiger ruckweise ringsherum um eine Sekunde vorspringen.\r\nWiederholen Sie in entgegengesetzter Richtung  - die Uhr rückwärts laufen lassen.\r\nDie Augen mit den Handflächen bedecken - etwa dreißig Sekunden zum Ausruhen.", "AUGEN ROLLEN", "", "inherit", "closed", "closed", "", "69-revision-v1", "", "", "2016-06-24 22:33:18", "2016-06-24 20:33:18", "", "69", "http://keep-it-short-and-simple.de/69-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2016-06-27 09:51:26", "2016-06-27 07:51:26", "<strong><img class=\"wp-image-158 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"125\" height=\"266\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut\r\n</strong></p>\r\n<p style=\"text-align: left;\">fördert die Durchblutung der unteren Extremitäten</p>\r\n<p style=\"text-align: left;\">verbessert Gleichgewicht und Körperhaltung</p>\r\n<p style=\"text-align: left;\">kräftigt Beinmuskulatur</p>\r\n<p style=\"text-align: left;\"></p>\r\n<p style=\"text-align: left;\"></p>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li style=\"text-align: left;\">Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li style=\"text-align: left;\">Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li style=\"text-align: left;\">Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li style=\"text-align: left;\">So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li style=\"text-align: left;\">Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li style=\"text-align: left;\">Wiederholung mit dem linken Fuß.</li>\r\n 	<li style=\"text-align: left;\">Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "publish", "closed", "closed", "", "157-2", "", "", "2016-07-19 19:32:12", "2016-07-19 17:32:12", "", "0", "http://keep-it-short-and-simple.de/?p=157", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("158", "1", "2016-06-27 09:50:35", "2016-06-27 07:50:35", "baum", "BAUM", "", "inherit", "open", "closed", "", "baum-3", "", "", "2016-06-27 09:51:17", "2016-06-27 07:51:17", "", "157", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2016-06-27 09:51:26", "2016-06-27 07:51:26", "<strong>Wofür ist das gut  <img class=\"alignnone size-thumbnail wp-image-158\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1-135x150.png\" alt=\"baum\" width=\"135\" height=\"150\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:51:26", "2016-06-27 07:51:26", "", "157", "http://keep-it-short-and-simple.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("160", "1", "2016-06-27 09:52:57", "2016-06-27 07:52:57", "<strong>Wofür ist das gut  <img class=\"alignnone wp-image-158 size-thumbnail\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1-135x150.png\" alt=\"baum\" width=\"135\" height=\"150\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:52:57", "2016-06-27 07:52:57", "", "157", "http://keep-it-short-and-simple.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("161", "1", "2016-06-27 09:54:26", "2016-06-27 07:54:26", "<strong>Wofür ist das gut  <img class=\"alignnone wp-image-158 size-thumbnail\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1-135x150.png\" alt=\"baum\" width=\"135\" height=\"150\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:54:26", "2016-06-27 07:54:26", "", "157", "http://keep-it-short-and-simple.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("162", "1", "2016-06-27 09:57:33", "2016-06-27 07:57:33", "<strong>Wofür ist das gut  <img class=\"alignnone wp-image-158 size-full\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "baum", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:57:33", "2016-06-27 07:57:33", "", "157", "http://keep-it-short-and-simple.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("163", "1", "2016-06-27 09:59:30", "2016-06-27 07:59:30", "<strong>Wofür ist das gut  <img class=\"wp-image-158 size-full alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 09:59:30", "2016-06-27 07:59:30", "", "157", "http://keep-it-short-and-simple.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("164", "1", "2016-06-27 10:02:46", "2016-06-27 08:02:46", "<strong><img class=\"size-full wp-image-166 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li style=\"text-align: left;\">Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li style=\"text-align: left;\">Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li style=\"text-align: left;\">Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li style=\"text-align: left;\">Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li style=\"text-align: left;\">Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li style=\"text-align: left;\">Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "bein-überschlag", "", "publish", "closed", "closed", "", "bein-ueberschlag", "", "", "2016-07-19 19:31:04", "2016-07-19 17:31:04", "", "0", "http://keep-it-short-and-simple.de/?p=164", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("165", "1", "2016-06-27 10:02:46", "2016-06-27 08:02:46", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-revision-v1", "", "", "2016-06-27 10:02:46", "2016-06-27 08:02:46", "", "164", "http://keep-it-short-and-simple.de/164-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("166", "1", "2016-06-27 10:03:39", "2016-06-27 08:03:39", "beinüberschlag", "BEIN", "", "inherit", "open", "closed", "", "bein-3", "", "", "2016-06-27 10:04:20", "2016-06-27 08:04:20", "", "164", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BEIN-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("167", "1", "2016-06-27 10:04:48", "2016-06-27 08:04:48", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-166 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\n<ul>\n 	<li>baut Fettpolster ab</li>\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\n 	<li>fördert Verdauung</li>\n 	<li>festigt Unterleibsorgane</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-autosave-v1", "", "", "2016-06-27 10:04:48", "2016-06-27 08:04:48", "", "164", "http://keep-it-short-and-simple.de/164-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("168", "1", "2016-06-27 10:05:21", "2016-06-27 08:05:21", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-166 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BEIN-1.png\" alt=\"beinüberschlag\" width=\"232\" height=\"255\" /></strong>\r\n<ul>\r\n 	<li>baut Fettpolster ab</li>\r\n 	<li>massiert Leber, Bauchspeicheldrüse, Milz</li>\r\n 	<li>fördert Verdauung</li>\r\n 	<li>festigt Unterleibsorgane</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Rücken, Arme zur Seite.</li>\r\n 	<li>Langsam linkes Bein gestreckt heben, bis es senkrecht nach oben zeigt.</li>\r\n 	<li>Das Bein nach rechts über den Körper hinweg (gestreckt) führen und versuchen, mit dem Fuß auf den Boden zu kommmen (oder in Richtung Boden).</li>\r\n 	<li>Schultern fest auf dem Boden lassen, nicht auf die Seite rollen.</li>\r\n 	<li>Kopf entgegengesetzt zum Bein seitlich drehen (soweit es geht)</li>\r\n 	<li>Das gleiche mit dem rechten Bein (Bein nach links, Kopf nach rechts).</li>\r\n 	<li>Jetzt mit beiden Beinen gleichzeitig (den Kopf immer entgegengesetzt zu den Beinen drehen).</li>\r\n</ol>", "BEIN-ÜBERSCHLAG", "", "inherit", "closed", "closed", "", "164-revision-v1", "", "", "2016-06-27 10:05:21", "2016-06-27 08:05:21", "", "164", "http://keep-it-short-and-simple.de/164-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("189", "1", "2016-06-27 11:54:05", "2016-06-27 09:54:05", "<strong><img class=\"size-full wp-image-417 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BOGEN.png\" alt=\"bogen\" width=\"228\" height=\"180\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut?\r\n</strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li style=\"text-align: left;\">Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li style=\"text-align: left;\">Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li style=\"text-align: left;\">Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li style=\"text-align: left;\">Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li style=\"text-align: left;\">Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li style=\"text-align: left;\">Zweimal wiederholen.</li>\r\n</ol>", "bogen", "", "publish", "closed", "closed", "", "bogen", "", "", "2016-07-19 19:30:35", "2016-07-19 17:30:35", "", "0", "http://keep-it-short-and-simple.de/?p=189", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("191", "1", "2016-06-27 11:54:05", "2016-06-27 09:54:05", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-190 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"228\" height=\"180\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "bogen", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-27 11:54:05", "2016-06-27 09:54:05", "", "189", "http://keep-it-short-and-simple.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("192", "1", "2016-06-27 12:02:58", "2016-06-27 10:02:58", "&nbsp;\r\n<p style=\"text-align: left;\"><strong><img class=\"size-full wp-image-415 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BRUEXPA-1.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />Wofür ist das gut?\r\n</strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li style=\"text-align: left;\">Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li style=\"text-align: left;\">Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li style=\"text-align: left;\">Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li style=\"text-align: left;\">Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li style=\"text-align: left;\">Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li style=\"text-align: left;\">Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "publish", "closed", "closed", "", "brust-expander", "", "", "2016-07-19 19:29:58", "2016-07-19 17:29:58", "", "0", "http://keep-it-short-and-simple.de/?p=192", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("193", "1", "2016-06-27 12:02:58", "2016-06-27 10:02:58", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:02:58", "2016-06-27 10:02:58", "", "192", "http://keep-it-short-and-simple.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("196", "1", "2016-06-27 12:04:35", "2016-06-27 10:04:35", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "brust-expander", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:04:35", "2016-06-27 10:04:35", "", "192", "http://keep-it-short-and-simple.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("197", "1", "2016-06-27 12:20:22", "2016-06-27 10:20:22", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:20:22", "2016-06-27 10:20:22", "", "192", "http://keep-it-short-and-simple.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("198", "1", "2016-06-27 12:20:35", "2016-06-27 10:20:35", "<strong>Wofür ist das gut? <img class=\"size-full wp-image-190 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"228\" height=\"180\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BOGEN", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-27 12:20:35", "2016-06-27 10:20:35", "", "189", "http://keep-it-short-and-simple.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("199", "1", "2016-06-27 12:28:45", "2016-06-27 10:28:45", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-27 12:28:45", "2016-06-27 10:28:45", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("200", "1", "2016-06-27 12:34:37", "2016-06-27 10:34:37", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-27 12:34:37", "2016-06-27 10:34:37", "", "192", "http://keep-it-short-and-simple.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("201", "1", "2016-06-27 12:35:57", "2016-06-27 10:35:57", "<strong>Wofür ist das gut  <img class=\"wp-image-158 size-full alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BAUM-1.png\" alt=\"baum\" width=\"135\" height=\"274\" />\r\n</strong>\r\n\r\nfördert die Durchblutung der unteren Extremitäten\r\n\r\nverbessert Gleichgewicht und Körperhaltung\r\n\r\nkräftigt Beinmuskulatur\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Stellen Sie sich mit geschlossenen Füßen hin. Die Arme sind seitlich ausgestreckt.</li>\r\n 	<li>Knicken Sie das rechte Bein ein und bringen Sie die Fußsohle innen an den Schenkel.</li>\r\n 	<li>Gehen Sie so weit wie möglich mit der Ferse zum Schritt, das Knie zeigt zur Seite.</li>\r\n 	<li>Legen Sie die Handflächen aneinander und heben die Haände und Arme ausgestreckt über den Kopf.</li>\r\n 	<li>So lange wie möglich balancieren, tief atmen.</li>\r\n 	<li>Fuß und Hände ganz langsam senken, entspannen.</li>\r\n 	<li>Wiederholung mit dem linken Fuß.</li>\r\n 	<li>Wiederholung zwei mal pro Seite.</li>\r\n</ol>", "BAUM", "", "inherit", "closed", "closed", "", "157-revision-v1", "", "", "2016-06-27 12:35:57", "2016-06-27 10:35:57", "", "157", "http://keep-it-short-and-simple.de/157-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("202", "1", "2016-06-27 12:37:20", "2016-06-27 10:37:20", "<strong><img class=\"wp-image-34  alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-27 12:37:20", "2016-06-27 10:37:20", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("203", "1", "2016-06-27 12:37:54", "2016-06-27 10:37:54", "<strong><img class=\"wp-image-34 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2016-06-27 12:37:54", "2016-06-27 10:37:54", "", "32", "http://keep-it-short-and-simple.de/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("204", "1", "2016-06-29 15:45:11", "2016-06-29 13:45:11", "<strong><img class=\"aligncenter wp-image-34\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/AUF.gif\" alt=\"AUF\" width=\"267\" height=\"139\" /></strong>\r\n\r\n<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>stärkt ganz behutsam den Rücken</li>\r\n 	<li>ist eine der besten Übungen, um die Bauchmuskulatur zu festigen, kräftigen und zu straffen</li>\r\n 	<li>festigt und strafft das Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n\r\nLegen Sie sich auf den Rücken. Die Knie sind nur soweit angewinkelt, daß die Fußsohlen noch flach am Boden stehen.\r\nLegen Sie die Hände auf die Schenkel.\r\nHeben Sie ganz langsam den Kopf und den Oberkörper, bis er etwa einen 30°-Winkel zum Boden bildet. Die Hände gleiten dabei Richtung Knie, bis die Fingerspietzen den Anfang der Kniescheibe berühren.\r\nVerharren Sie fünf bis dreißig Sekunden in dieser Pose.\r\nJetzt das Ganze umgekehrt - langsam in die Ausgangsstellung zurückkehren.\r\nEnspannen.\r\nDrei bis fünfmal wiederholen.", "AUFSETZEN", "", "inherit", "closed", "closed", "", "32-autosave-v1", "", "", "2016-06-29 15:45:11", "2016-06-29 13:45:11", "", "32", "http://keep-it-short-and-simple.de/32-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("205", "1", "2016-06-27 14:43:28", "2016-06-27 12:43:28", "<h4><strong><img class=\"size-full wp-image-101 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-27 14:43:28", "2016-06-27 12:43:28", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("206", "1", "2016-06-27 14:49:16", "2016-06-27 12:49:16", "Kontakt\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-autosave-v1", "", "", "2016-06-27 14:49:16", "2016-06-27 12:49:16", "", "21", "http://keep-it-short-and-simple.de/21-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("207", "1", "2016-06-27 14:52:41", "2016-06-27 12:52:41", "Kontakt\r\n\r\n&nbsp;\r\n\r\n[contact-form-7 id=\"4\" title=\"Contact form 1\"]", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-27 14:52:41", "2016-06-27 12:52:41", "", "21", "http://keep-it-short-and-simple.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("208", "1", "2016-06-27 14:56:40", "2016-06-27 12:56:40", "Kontakt\r\n\r\n[contact-form-7 id=\"121\" title=\"Contact form 1\"]\r\n\r\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-27 14:56:40", "2016-06-27 12:56:40", "", "21", "http://keep-it-short-and-simple.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("209", "1", "2016-06-28 09:14:28", "2016-06-28 07:14:28", " ", "", "", "publish", "closed", "closed", "", "209", "", "", "2016-06-28 09:17:24", "2016-06-28 07:17:24", "", "0", "http://keep-it-short-and-simple.de/?p=209", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("210", "1", "2016-06-28 09:14:28", "2016-06-28 07:14:28", " ", "", "", "publish", "closed", "closed", "", "210", "", "", "2016-06-28 09:17:24", "2016-06-28 07:17:24", "", "0", "http://keep-it-short-and-simple.de/?p=210", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("216", "1", "2016-06-28 09:20:14", "2016-06-28 07:20:14", " ", "", "", "publish", "closed", "closed", "", "216", "", "", "2017-01-03 19:53:41", "2017-01-03 18:53:41", "", "0", "http://keep-it-short-and-simple.de/?p=216", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("217", "1", "2016-06-28 09:32:04", "2016-06-28 07:32:04", " ", "", "", "publish", "closed", "closed", "", "217", "", "", "2017-01-03 19:53:41", "2017-01-03 18:53:41", "", "0", "http://keep-it-short-and-simple.de/?p=217", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("218", "1", "2016-06-28 09:32:04", "2016-06-28 07:32:04", " ", "", "", "publish", "closed", "closed", "", "218", "", "", "2017-01-03 19:53:41", "2017-01-03 18:53:41", "", "0", "http://keep-it-short-and-simple.de/?p=218", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("219", "1", "2016-06-28 09:34:14", "2016-06-28 07:34:14", "<h4><strong><img class=\"size-full wp-image-101 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/titel_spiegel-e1466675769263.png\" alt=\"titel_spiegel\" width=\"165\" height=\"170\" />Was ist Yoga?\r\n</strong></h4>\r\nDie meisten von Ihnen haben diesen Begriff sicher schon gehört und haben bestimmte Vorstellungen damit verknüpft. Es geht hier abernicht um Fanatiker, die ständig Kopfstehen und auf Nagelbrettern liegen und es ist auch nicht nur für junge Leute.Es ist egal, wie alt man ist, welchen Geschlechts oder welcher Religion, jeder findet etwas für sich.\r\n\r\nZwei große Bereiche werden unterschieden: Hatha-Yoga, mit seinen Asanas (Körperstellungen) und Meditation, wobei es mehrere Formen gibt. In unserem kleinen Kurs geht es um den ersten Bereich.\r\n\r\nDie Kunst des Yoga ist ca. 5000 Jahre alt und befaßt sich mit Atemtechnik und körperlichen Übungen. Yoga entspannt und reguliert dieKörperfunktionen und gibt Energie. Die Muskeln werden gestreckt und nicht wie bei Turnübungen angespannt. Schmerz ist als Warnung zuverstehen - da sollten Sie aufhören und nichts übertreiben. Durch Übung klappt es dann aber mit der Zeit immer besser und es geht hiernicht um den Vergleich mit anderen\r\n\r\n<strong>Warum sollten Sie Yoga machen?</strong>\r\n\r\nDie Übungen ergänzen einander und helfen Ihnen dabei, gesund zu bleiben.Sie sind so alt, wie Ihre Wirbelsäule gelenkig ist - tun Sie etwas dafür!Die Durchblutung wird verbessert, Muskeln trainiert, die Hormonproduktion angeregt.Es geht ganz einfach um Ihr Wohlbefinden.\r\n\r\n<strong>Wie sollten Sie die Übungen machen?</strong>\r\n\r\nDiese Übungen werden ganz langsam ausgeführt - keine ruckartigen Bewegungen!In der Endstellung verharrt man dann einige Sekunden.\r\n\r\n<strong>Zeit</strong>\r\n\r\nam besten nach dem Aufstehen oder vor dem Schlafengehen. Morgens ist man zwar\r\nnoch etwas steif, aber es ist ein guter Beginn.Abends geht es leichter und die Entspannung sorgt für einen guten Schlaf.\r\n\r\n<strong>Ort</strong>\r\n\r\nMöglichst ungestört, Konzentration ist wichtig. Die Unterlage sollte nicht zu weich sein -\r\nentweder ein Teppich oder eine gefaltete Decke auf dem Boden.\r\n\r\n<strong>Essen</strong>\r\n\r\nNach einer reichhaltigen Mahlzeit bis zu drei Stunden und nach einem leichten Imbiß etwa\r\neine Stunde warten. Trinken vor den Übungen schadet nicht.\r\n\r\n<strong>Krankheiten und Beschwerden</strong>\r\n\r\nBitte unbedingt vorher Ihren Arzt fragen, anfangs keine Umkehr-Stellungen.\r\n\r\n&nbsp;", "mehr zum thema yoga", "", "inherit", "closed", "closed", "", "86-revision-v1", "", "", "2016-06-28 09:34:14", "2016-06-28 07:34:14", "", "86", "http://keep-it-short-and-simple.de/86-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("220", "1", "2016-06-28 09:36:58", "2016-06-28 07:36:58", "[contact-form-7 id=\"121\" title=\"Contact form 1\"]\r\n\r\n&nbsp;", "kontakt", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2016-06-28 09:36:58", "2016-06-28 07:36:58", "", "21", "http://keep-it-short-and-simple.de/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("222", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGh1bWJuYWlscyIsImVudGl0eV90eXBlcyI6WyJpbWFnZSJdLCJwcmV2aWV3X2ltYWdlX3JlbHBhdGgiOiJcL25leHRnZW4tZ2FsbGVyeVwvcHJvZHVjdHNcL3Bob3RvY3JhdGlfbmV4dGdlblwvbW9kdWxlc1wvbmV4dGdlbl9iYXNpY19nYWxsZXJ5XC9zdGF0aWNcL3RodW1iX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwiaW1hZ2VzX3Blcl9wYWdlIjoiMjAiLCJudW1iZXJfb2ZfY29sdW1ucyI6MCwidGh1bWJuYWlsX3dpZHRoIjoyNDAsInRodW1ibmFpbF9oZWlnaHQiOjE2MCwic2hvd19hbGxfaW5fbGlnaHRib3giOjAsImFqYXhfcGFnaW5hdGlvbiI6MCwidXNlX2ltYWdlYnJvd3Nlcl9lZmZlY3QiOjAsInRlbXBsYXRlIjoiIiwiZGlzcGxheV9ub19pbWFnZXNfZXJyb3IiOjEsImRpc2FibGVfcGFnaW5hdGlvbiI6MCwic2hvd19zbGlkZXNob3dfbGluayI6MSwic2xpZGVzaG93X2xpbmtfdGV4dCI6IltaZWlnZSBlaW5lIFNsaWRlc2hvd10iLCJvdmVycmlkZV90aHVtYm5haWxfc2V0dGluZ3MiOjAsInRodW1ibmFpbF9xdWFsaXR5IjoiMTAwIiwidGh1bWJuYWlsX2Nyb3AiOjEsInRodW1ibmFpbF93YXRlcm1hcmsiOjAsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "NextGEN Basic Thumbnails", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGh1bWJuYWlscyIsImVudGl0eV90eXBlcyI6WyJpbWFnZSJdLCJwcmV2aWV3X2ltYWdlX3JlbHBhdGgiOiJcL25leHRnZW4tZ2FsbGVyeVwvcHJvZHVjdHNcL3Bob3RvY3JhdGlfbmV4dGdlblwvbW9kdWxlc1wvbmV4dGdlbl9iYXNpY19nYWxsZXJ5XC9zdGF0aWNcL3RodW1iX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwiaW1hZ2VzX3Blcl9wYWdlIjoiMjAiLCJudW1iZXJfb2ZfY29sdW1ucyI6MCwidGh1bWJuYWlsX3dpZHRoIjoyNDAsInRodW1ibmFpbF9oZWlnaHQiOjE2MCwic2hvd19hbGxfaW5fbGlnaHRib3giOjAsImFqYXhfcGFnaW5hdGlvbiI6MCwidXNlX2ltYWdlYnJvd3Nlcl9lZmZlY3QiOjAsInRlbXBsYXRlIjoiIiwiZGlzcGxheV9ub19pbWFnZXNfZXJyb3IiOjEsImRpc2FibGVfcGFnaW5hdGlvbiI6MCwic2hvd19zbGlkZXNob3dfbGluayI6MSwic2xpZGVzaG93X2xpbmtfdGV4dCI6IltaZWlnZSBlaW5lIFNsaWRlc2hvd10iLCJvdmVycmlkZV90aHVtYm5haWxfc2V0dGluZ3MiOjAsInRodW1ibmFpbF9xdWFsaXR5IjoiMTAwIiwidGh1bWJuYWlsX2Nyb3AiOjEsInRodW1ibmFpbF93YXRlcm1hcmsiOjAsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=222", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("223", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2xpZGVzaG93IiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2dhbGxlcnlcL3N0YXRpY1wvc2xpZGVzaG93X3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19zbGlkZXNob3ciLCJpbnN0YWxsZWRfYXRfdmVyc2lvbiI6IjIuMS40NiIsImlkX2ZpZWxkIjoiSUQiLCJzZXR0aW5ncyI6eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJ5X3dpZHRoIjo2MDAsImdhbGxlcnlfaGVpZ2h0Ijo0MDAsInRodW1ibmFpbF93aWR0aCI6MjQwLCJ0aHVtYm5haWxfaGVpZ2h0IjoxNjAsImN5Y2xlX2ludGVydmFsIjoxMCwiY3ljbGVfZWZmZWN0IjpudWxsLCJlZmZlY3RfY29kZSI6ImNsYXNzPVwibmdnLWZhbmN5Ym94XCIgcmVsPVwiJUdBTExFUllfTkFNRSVcIiIsInNob3dfdGh1bWJuYWlsX2xpbmsiOjEsInRodW1ibmFpbF9saW5rX3RleHQiOiJbWmVpZ2UgVm9yc2NoYXViaWxkZXJdIiwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "NextGEN Basic Slideshow", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2xpZGVzaG93IiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2dhbGxlcnlcL3N0YXRpY1wvc2xpZGVzaG93X3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJnYWxsZXJpZXMiLCJ2aWV3X29yZGVyIjoxMDAxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19zbGlkZXNob3ciLCJpbnN0YWxsZWRfYXRfdmVyc2lvbiI6IjIuMS40NiIsImlkX2ZpZWxkIjoiSUQiLCJzZXR0aW5ncyI6eyJ1c2VfbGlnaHRib3hfZWZmZWN0Ijp0cnVlLCJnYWxsZXJ5X3dpZHRoIjo2MDAsImdhbGxlcnlfaGVpZ2h0Ijo0MDAsInRodW1ibmFpbF93aWR0aCI6MjQwLCJ0aHVtYm5haWxfaGVpZ2h0IjoxNjAsImN5Y2xlX2ludGVydmFsIjoxMCwiY3ljbGVfZWZmZWN0IjpudWxsLCJlZmZlY3RfY29kZSI6ImNsYXNzPVwibmdnLWZhbmN5Ym94XCIgcmVsPVwiJUdBTExFUllfTkFNRSVcIiIsInNob3dfdGh1bWJuYWlsX2xpbmsiOjEsInRodW1ibmFpbF9saW5rX3RleHQiOiJbWmVpZ2UgVm9yc2NoYXViaWxkZXJdIiwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=223", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("224", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgSW1hZ2VCcm93c2VyIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2ltYWdlYnJvd3Nlclwvc3RhdGljXC9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwMjAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfaW1hZ2Vicm93c2VyIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "NextGEN Basic ImageBrowser", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgSW1hZ2VCcm93c2VyIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2ltYWdlYnJvd3Nlclwvc3RhdGljXC9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwMjAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfaW1hZ2Vicm93c2VyIiwiaW5zdGFsbGVkX2F0X3ZlcnNpb24iOiIyLjEuNDYiLCJpZF9maWVsZCI6IklEIiwic2V0dGluZ3MiOnsidXNlX2xpZ2h0Ym94X2VmZmVjdCI6dHJ1ZSwidGVtcGxhdGUiOiIiLCJuZ2dfdHJpZ2dlcnNfZGlzcGxheSI6Im5ldmVyIn0sImhpZGRlbl9mcm9tX3VpIjpmYWxzZSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=224", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("225", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2luZ2xlUGljIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpY1wvc3RhdGljXC9wcmV2aWV3LmdpZiIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwNjAsImhpZGRlbl9mcm9tX3VpIjp0cnVlLCJuYW1lIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpYyIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsIndpZHRoIjoiIiwiaGVpZ2h0IjoiIiwibW9kZSI6IiIsImRpc3BsYXlfd2F0ZXJtYXJrIjowLCJkaXNwbGF5X3JlZmxlY3Rpb24iOjAsImZsb2F0IjoiIiwibGluayI6IiIsImxpbmtfdGFyZ2V0IjoiX2JsYW5rIiwicXVhbGl0eSI6MTAwLCJjcm9wIjowLCJ0ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "NextGEN Basic SinglePic", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgU2luZ2xlUGljIiwiZW50aXR5X3R5cGVzIjpbImltYWdlIl0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpY1wvc3RhdGljXC9wcmV2aWV3LmdpZiIsImRlZmF1bHRfc291cmNlIjoiZ2FsbGVyaWVzIiwidmlld19vcmRlciI6MTAwNjAsImhpZGRlbl9mcm9tX3VpIjp0cnVlLCJuYW1lIjoicGhvdG9jcmF0aS1uZXh0Z2VuX2Jhc2ljX3NpbmdsZXBpYyIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsIndpZHRoIjoiIiwiaGVpZ2h0IjoiIiwibW9kZSI6IiIsImRpc3BsYXlfd2F0ZXJtYXJrIjowLCJkaXNwbGF5X3JlZmxlY3Rpb24iOjAsImZsb2F0IjoiIiwibGluayI6IiIsImxpbmtfdGFyZ2V0IjoiX2JsYW5rIiwicXVhbGl0eSI6MTAwLCJjcm9wIjowLCJ0ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiX19kZWZhdWx0c19zZXQiOnRydWV9", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=225", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("226", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGFnQ2xvdWQiLCJlbnRpdHlfdHlwZXMiOlsiaW1hZ2UiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfdGFnY2xvdWRcL3N0YXRpY1wvcHJldmlldy5naWYiLCJkZWZhdWx0X3NvdXJjZSI6InRhZ3MiLCJ2aWV3X29yZGVyIjoxMDEwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190YWdjbG91ZCIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImRpc3BsYXlfdHlwZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwibnVtYmVyIjo0NSwibmdnX3RyaWdnZXJzX2Rpc3BsYXkiOiJuZXZlciJ9LCJoaWRkZW5fZnJvbV91aSI6ZmFsc2UsIl9fZGVmYXVsdHNfc2V0Ijp0cnVlfQ==", "NextGEN Basic TagCloud", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgVGFnQ2xvdWQiLCJlbnRpdHlfdHlwZXMiOlsiaW1hZ2UiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfdGFnY2xvdWRcL3N0YXRpY1wvcHJldmlldy5naWYiLCJkZWZhdWx0X3NvdXJjZSI6InRhZ3MiLCJ2aWV3X29yZGVyIjoxMDEwMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190YWdjbG91ZCIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImRpc3BsYXlfdHlwZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY190aHVtYm5haWxzIiwibnVtYmVyIjo0NSwibmdnX3RyaWdnZXJzX2Rpc3BsYXkiOiJuZXZlciJ9LCJoaWRkZW5fZnJvbV91aSI6ZmFsc2UsIl9fZGVmYXVsdHNfc2V0Ijp0cnVlfQ==", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=226", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("227", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgQ29tcGFjdCBBbGJ1bSIsImVudGl0eV90eXBlcyI6WyJhbGJ1bSIsImdhbGxlcnkiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfYWxidW1cL3N0YXRpY1wvY29tcGFjdF9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiYWxidW1zIiwidmlld19vcmRlciI6MTAyMDAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfY29tcGFjdF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "NextGEN Basic Compact Album", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgQ29tcGFjdCBBbGJ1bSIsImVudGl0eV90eXBlcyI6WyJhbGJ1bSIsImdhbGxlcnkiXSwicHJldmlld19pbWFnZV9yZWxwYXRoIjoiXC9uZXh0Z2VuLWdhbGxlcnlcL3Byb2R1Y3RzXC9waG90b2NyYXRpX25leHRnZW5cL21vZHVsZXNcL25leHRnZW5fYmFzaWNfYWxidW1cL3N0YXRpY1wvY29tcGFjdF9wcmV2aWV3LmpwZyIsImRlZmF1bHRfc291cmNlIjoiYWxidW1zIiwidmlld19vcmRlciI6MTAyMDAsIm5hbWUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfY29tcGFjdF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=227", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("228", "1", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgRXh0ZW5kZWQgQWxidW0iLCJlbnRpdHlfdHlwZXMiOlsiYWxidW0iLCJnYWxsZXJ5Il0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2FsYnVtXC9zdGF0aWNcL2V4dGVuZGVkX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJhbGJ1bXMiLCJ2aWV3X29yZGVyIjoxMDIxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19leHRlbmRlZF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwib3ZlcnJpZGVfdGh1bWJuYWlsX3NldHRpbmdzIjowLCJ0aHVtYm5haWxfd2lkdGgiOjI0MCwidGh1bWJuYWlsX2hlaWdodCI6MTYwLCJ0aHVtYm5haWxfcXVhbGl0eSI6MTAwLCJ0aHVtYm5haWxfY3JvcCI6dHJ1ZSwidGh1bWJuYWlsX3dhdGVybWFyayI6MCwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "NextGEN Basic Extended Album", "", "draft", "closed", "closed", "", "", "", "", "2016-06-28 11:00:00", "0000-00-00 00:00:00", "eyJ0aXRsZSI6Ik5leHRHRU4gQmFzaWMgRXh0ZW5kZWQgQWxidW0iLCJlbnRpdHlfdHlwZXMiOlsiYWxidW0iLCJnYWxsZXJ5Il0sInByZXZpZXdfaW1hZ2VfcmVscGF0aCI6IlwvbmV4dGdlbi1nYWxsZXJ5XC9wcm9kdWN0c1wvcGhvdG9jcmF0aV9uZXh0Z2VuXC9tb2R1bGVzXC9uZXh0Z2VuX2Jhc2ljX2FsYnVtXC9zdGF0aWNcL2V4dGVuZGVkX3ByZXZpZXcuanBnIiwiZGVmYXVsdF9zb3VyY2UiOiJhbGJ1bXMiLCJ2aWV3X29yZGVyIjoxMDIxMCwibmFtZSI6InBob3RvY3JhdGktbmV4dGdlbl9iYXNpY19leHRlbmRlZF9hbGJ1bSIsImluc3RhbGxlZF9hdF92ZXJzaW9uIjoiMi4xLjQ2IiwiaWRfZmllbGQiOiJJRCIsInNldHRpbmdzIjp7InVzZV9saWdodGJveF9lZmZlY3QiOnRydWUsImdhbGxlcmllc19wZXJfcGFnZSI6MCwiZW5hYmxlX2JyZWFkY3J1bWJzIjoxLCJkaXNhYmxlX3BhZ2luYXRpb24iOjAsInRlbXBsYXRlIjoiIiwib3ZlcnJpZGVfdGh1bWJuYWlsX3NldHRpbmdzIjowLCJ0aHVtYm5haWxfd2lkdGgiOjI0MCwidGh1bWJuYWlsX2hlaWdodCI6MTYwLCJ0aHVtYm5haWxfcXVhbGl0eSI6MTAwLCJ0aHVtYm5haWxfY3JvcCI6dHJ1ZSwidGh1bWJuYWlsX3dhdGVybWFyayI6MCwiZ2FsbGVyeV9kaXNwbGF5X3R5cGUiOiJwaG90b2NyYXRpLW5leHRnZW5fYmFzaWNfdGh1bWJuYWlscyIsImdhbGxlcnlfZGlzcGxheV90ZW1wbGF0ZSI6IiIsIm5nZ190cmlnZ2Vyc19kaXNwbGF5IjoibmV2ZXIifSwiaGlkZGVuX2Zyb21fdWkiOmZhbHNlLCJfX2RlZmF1bHRzX3NldCI6dHJ1ZX0=", "0", "http://keep-it-short-and-simple.de/?post_type=display_type&p=228", "0", "display_type", "", "0");
INSERT INTO `wp_posts` VALUES("241", "1", "2016-06-28 20:02:58", "2016-06-28 18:02:58", "", "jungfer im grünen", "", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-3", "", "", "2016-06-28 20:02:58", "2016-06-28 18:02:58", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/jungfer-im-grünen-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("242", "1", "2016-06-28 20:02:59", "2016-06-28 18:02:59", "", "Küchenschelle", "", "inherit", "open", "closed", "", "ku%cc%88chenschelle", "", "", "2016-06-28 20:02:59", "2016-06-28 18:02:59", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/Küchenschelle.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("245", "1", "2016-06-28 20:14:48", "2016-06-28 18:14:48", "", "jungfer im grünen", "", "inherit", "open", "closed", "", "jungfer-im-gru%cc%88nen-4", "", "", "2016-06-28 20:14:48", "2016-06-28 18:14:48", "", "0", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/jungfer-im-grünen-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("248", "1", "2016-06-29 08:47:21", "2016-06-29 06:47:21", "<img class=\"size-full wp-image-413 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/GESPREI-1.png\" alt=\"gespreizte beinstreckung\" width=\"380\" height=\"109\" />\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li style=\"text-align: left;\">Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li style=\"text-align: left;\">Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li style=\"text-align: left;\">Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li style=\"text-align: left;\">Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li style=\"text-align: left;\">Noch zweimal wiederholen.</li>\r\n</ol>", "gespreizte beinstreckung", "", "publish", "closed", "closed", "", "gespreizte-beinstreckung", "", "", "2016-07-19 19:29:28", "2016-07-19 17:29:28", "", "0", "http://keep-it-short-and-simple.de/?p=248", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("250", "1", "2016-06-29 08:47:21", "2016-06-29 06:47:21", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone size-full wp-image-249\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"380\" height=\"109\" />\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "gespreizte beinstreckung", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 08:47:21", "2016-06-29 06:47:21", "", "248", "http://keep-it-short-and-simple.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("252", "1", "2016-06-29 08:49:44", "2016-06-29 06:49:44", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone size-full wp-image-249\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"380\" height=\"109\" />\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "GESPREIZTE BEINSTRECKUNG", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 08:49:44", "2016-06-29 06:49:44", "", "248", "http://keep-it-short-and-simple.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("255", "1", "2016-06-29 09:06:12", "2016-06-29 07:06:12", "<strong>Wofür ist das gut? <img class=\"wp-image-190 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"286\" height=\"212\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BOGEN", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-29 09:06:12", "2016-06-29 07:06:12", "", "189", "http://keep-it-short-and-simple.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("256", "1", "2016-06-29 09:06:58", "2016-06-29 07:06:58", "<strong>Wofür ist das gut? <img class=\"wp-image-190 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BOGEN-2.png\" alt=\"bogen\" width=\"286\" height=\"212\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>reduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BOGEN", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2016-06-29 09:06:58", "2016-06-29 07:06:58", "", "189", "http://keep-it-short-and-simple.de/189-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("257", "1", "2016-06-29 09:07:29", "2016-06-29 07:07:29", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone  wp-image-249\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/GESPREI-2.png\" alt=\"GESPREI\" width=\"348\" height=\"93\" />\r\n<ul>\r\n 	<li>dehnt und festigt die Beinsehnen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>regt Durchblutung an (Beckengegend)- hilft besonders Frauen</li>\r\n 	<li>strafft Schenkel und baut Fettpolster ab</li>\r\n 	<li>hält Wirbelsäule biegsam und gelenkig</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen sie sich mit weit gespreizten Beinen auf den Boden.</li>\r\n 	<li>Legen Sie die Hände auf die Beine und lassen sie langsam in Richtung Füße gleiten.</li>\r\n 	<li>Beugen Sie sich von der Taille aus Wirbel für Wirbel nach vorn und halten sich mit den Händen an dem Teil der Beine, den Sie zu fassen bekommen, fest.</li>\r\n 	<li>Kopf nach vorn fallen lassen (Hände gleiten zu den Füßen).</li>\r\n 	<li>Zehn bis dreißig Sekunden verharren, entspannen und ganz langsam in die Ausgangsstellung zurückkehren.</li>\r\n 	<li>Noch zweimal wiederholen.</li>\r\n</ol>", "GESPREIZTE BEINSTRECKUNG", "", "inherit", "closed", "closed", "", "248-revision-v1", "", "", "2016-06-29 09:07:29", "2016-06-29 07:07:29", "", "248", "http://keep-it-short-and-simple.de/248-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("258", "1", "2016-06-29 09:08:06", "2016-06-29 07:08:06", "<strong>Wofür ist das gut?   <img class=\"size-full wp-image-194 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/BRUEXPA-2.png\" alt=\"brustexpander\" width=\"190\" height=\"183\" />\r\n</strong>\r\n<ul>\r\n 	<li>schafft Schmerzerleichterungen bei Bandscheibenschäden</li>\r\n 	<li>formt und festigt Muskeln in Bauch, Armen, Beinen und Rücken</li>\r\n 	<li>entwickelt Brustmuskulatur</li>\r\n 	<li>stärkt Wirbelsäule und macht sie gelenkig</li>\r\n 	<li>fördert die Verdauungreduziert Polster an Hüften und Gesäß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit dem Bauch auf den Boden.</li>\r\n 	<li>Knie anwinkeln, Füße ans Gesäß.</li>\r\n 	<li>Fassen Sie ihre Knöchel und heben den Oberkörper und die Knie vom Boden, indem Sie die Hände an den Fußgelenken nach oben wegdrücken.</li>\r\n 	<li>Den Kopf gleichzeitig mit anheben (in den Nacken legen).</li>\r\n 	<li>Anfangs fünf bis zehn Sekunden verharren, später, nach mehr Übung, bis dreißig Sekunden.</li>\r\n 	<li>Langsam in die Ausgangstellung zurückkehren, entspannen, etwas ausruhen.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n</ol>", "BRUST-EXPANDER", "", "inherit", "closed", "closed", "", "192-revision-v1", "", "", "2016-06-29 09:08:06", "2016-06-29 07:08:06", "", "192", "http://keep-it-short-and-simple.de/192-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("259", "1", "2016-06-29 09:11:11", "2016-06-29 07:11:11", "<strong><img class=\"wp-image-261 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"178\" height=\"183\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li style=\"text-align: left;\">Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li style=\"text-align: left;\">Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li style=\"text-align: left;\">Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li style=\"text-align: left;\">Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li style=\"text-align: left;\">Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li style=\"text-align: left;\">Seitenverkehrt wiederholen.</li>\r\n 	<li style=\"text-align: left;\">Noch zweimal pro Seite.</li>\r\n</ol>", "haltungsgriff", "", "publish", "closed", "closed", "", "haltungsgriff", "", "", "2016-07-19 19:29:01", "2016-07-19 17:29:01", "", "0", "http://keep-it-short-and-simple.de/?p=259", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("260", "1", "2016-06-29 09:11:11", "2016-06-29 07:11:11", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-revision-v1", "", "", "2016-06-29 09:11:11", "2016-06-29 07:11:11", "", "259", "http://keep-it-short-and-simple.de/259-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("261", "1", "2016-06-29 09:11:28", "2016-06-29 07:11:28", "schneidersitz, hände fassen hinter dem rücken, ein arm von oben einer von unten", "HALTUNG", "", "inherit", "open", "closed", "", "haltung-4", "", "", "2016-06-29 09:13:04", "2016-06-29 07:13:04", "", "259", "http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/HALTUNG-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("262", "1", "2016-06-29 09:13:14", "2016-06-29 07:13:14", "<strong><img class=\"alignnone size-full wp-image-261\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"190\" height=\"205\" />Wofür ist das gut? </strong>\n<ul>\n 	<li>bringt Erleichterung für verspannte Schultern</li>\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\n 	<li>formt und stärkt die Oberarme</li>\n 	<li>erweitert den Brustkorb</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\n 	<li>Seitenverkehrt wiederholen.</li>\n 	<li>Noch zweimal pro Seite.</li>\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-autosave-v1", "", "", "2016-06-29 09:13:14", "2016-06-29 07:13:14", "", "259", "http://keep-it-short-and-simple.de/259-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("263", "1", "2016-06-29 09:13:29", "2016-06-29 07:13:29", "<strong><img class=\"wp-image-261 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/HALTUNG-2.png\" alt=\"haltungsgriff\" width=\"178\" height=\"183\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>bringt Erleichterung für verspannte Schultern</li>\r\n 	<li>verbessert die Haltung (gut bei Hängeschultern)</li>\r\n 	<li>formt und stärkt die Oberarme</li>\r\n 	<li>erweitert den Brustkorb</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem, mit geradem Rücken in den Schneidersitz.</li>\r\n 	<li>Legen Sie Ihre linke Hand auf den Rücken, die Handfläche nach außen, Finger zeigen nach oben und jetzt so weit wie möglich am Rücken nach oben schieben..</li>\r\n 	<li>Strecken Sie den Rechten Arm nach oben, Ellenbogen einknicken, und führen sie die rechte Hand nach unten.</li>\r\n 	<li>Versuchen Sie, beide Hände hinter dem Rücken zueinander zu bringen, bis sich die Finger beider Hände festhalten können.</li>\r\n 	<li>Wenn das zu Anfang noch nicht klappt, ein Handtuch als \"Bindeglied\" benutzen (nicht überanstrengen).</li>\r\n 	<li>Zehn bis dreißig Sekunden in dieser Stellung bleiben.</li>\r\n 	<li>Seitenverkehrt wiederholen.</li>\r\n 	<li>Noch zweimal pro Seite.</li>\r\n</ol>", "HALTUNGSGRIFF", "", "inherit", "closed", "closed", "", "259-revision-v1", "", "", "2016-06-29 09:13:29", "2016-06-29 07:13:29", "", "259", "http://keep-it-short-and-simple.de/259-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("264", "1", "2016-06-29 09:22:49", "2016-06-29 07:22:49", "<strong><img class=\"size-full wp-image-411 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/JAPSITZ-1.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol style=\"text-align: left;\">\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\n<p style=\"text-align: left;\">Wenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.</p>", "japanischer sitz", "", "publish", "closed", "closed", "", "japanischer-sitz", "", "", "2016-07-19 19:28:36", "2016-07-19 17:28:36", "", "0", "http://keep-it-short-and-simple.de/?p=264", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("265", "1", "2016-06-29 09:22:49", "2016-06-29 07:22:49", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 09:22:49", "2016-06-29 07:22:49", "", "264", "http://keep-it-short-and-simple.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("267", "1", "2016-06-29 09:24:16", "2016-06-29 07:24:16", "<strong><img class=\"alignnone size-full wp-image-266\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/JAPSITZ-2.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 09:24:16", "2016-06-29 07:24:16", "", "264", "http://keep-it-short-and-simple.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("268", "1", "2016-06-29 09:24:37", "2016-06-29 07:24:37", "<strong><img class=\"size-full wp-image-266 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/JAPSITZ-2.png\" alt=\"japanischer sitz\" width=\"152\" height=\"233\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei verspannten Fußknöcheln</li>\r\n 	<li>dehnt die Oberseite der Schenkel</li>\r\n 	<li>macht die Kniegelenke biegsam</li>\r\n 	<li>ist wohltuend bei Krampfadern und müden Beinen</li>\r\n 	<li>entspannt den gesamten Fuß</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Knien Sie sich aufrecht mit geschlossenen Füßen und nach hinten gerichteten Zehenspitzen hin.</li>\r\n 	<li>Setzen Sie sich langsam auf die Fersen, (evtl. mit den Händen dabei abstützen)</li>\r\n 	<li>Das gesamte Gewicht auf die Fersen verlagern, Rücken dabei gerade halten.</li>\r\n 	<li>Hände auf die Oberschenkel legen.</li>\r\n</ol>\r\nWenn Ihnen die Übung so zu leicht fällt, die Fersen auseinanderrücken (die Zehen bleiben aneinander) und sich so auf die Füße setzen.", "JAPANISCHER SITZ", "", "inherit", "closed", "closed", "", "264-revision-v1", "", "", "2016-06-29 09:24:37", "2016-06-29 07:24:37", "", "264", "http://keep-it-short-and-simple.de/264-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("269", "1", "2016-06-29 09:32:12", "2016-06-29 07:32:12", "<img class=\"size-full wp-image-409 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KERZE.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.</p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li style=\"text-align: left;\">Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li style=\"text-align: left;\">Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li style=\"text-align: left;\">Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li style=\"text-align: left;\">Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li style=\"text-align: left;\">Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li style=\"text-align: left;\">Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "kerze", "", "publish", "closed", "closed", "", "kerze", "", "", "2016-07-19 19:27:57", "2016-07-19 17:27:57", "", "0", "http://keep-it-short-and-simple.de/?p=269", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("270", "1", "2016-06-29 09:32:12", "2016-06-29 07:32:12", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 09:32:12", "2016-06-29 07:32:12", "", "269", "http://keep-it-short-and-simple.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("272", "1", "2016-06-29 09:33:15", "2016-06-29 07:33:15", "<strong>Wofür ist das gut? </strong>\n\n&nbsp;\n<ul>\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\n 	<li>mildert Krampfadern und müde Beine</li>\n 	<li>streckt die Wirbelsäule</li>\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\n</ul>\n<strong>Ausführung: </strong>\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\n<ol>\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-autosave-v1", "", "", "2016-06-29 09:33:15", "2016-06-29 07:33:15", "", "269", "http://keep-it-short-and-simple.de/269-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("273", "1", "2016-06-29 09:34:06", "2016-06-29 07:34:06", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"alignnone size-full wp-image-271\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KERZE-2.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 09:34:06", "2016-06-29 07:34:06", "", "269", "http://keep-it-short-and-simple.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("274", "1", "2016-06-29 09:34:18", "2016-06-29 07:34:18", "<strong>Wofür ist das gut? </strong>\r\n\r\n<img class=\"size-full wp-image-271 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KERZE-2.png\" alt=\"kerze\" width=\"153\" height=\"268\" />\r\n<ul>\r\n 	<li>wirkt sich positiv auf den gesamten Organismus aus</li>\r\n 	<li>Sorgt für eine gute Durchblutung des Gehirns, der Wirbelsäule und der Beckengegend (durch die umgekehrte Haltung)</li>\r\n 	<li>wirkt kräftigend und ausgleichend auf das Nervensystem</li>\r\n 	<li>befreit Bauchorgane von gegenseitigem Druck, fördert Verdauung</li>\r\n 	<li>mildert Krampfadern und müde Beine</li>\r\n 	<li>streckt die Wirbelsäule</li>\r\n 	<li>festigt die Muskulatur von Rücken, Nacken, Bauch und Beinen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie zu hohen oder zu niedrigenn Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Legen Sie sich mit gestreckten Beinen auf den Boden. Die Arme liegen mit den Handflächen nach unten nahe am Körper.</li>\r\n 	<li>Bauch und Beckenmuskulatur anspannen und die Beine langsam heben, bis sie einen rechten Winkel mit dem Boden bilden.</li>\r\n 	<li>Stützen Sie sich mit den Fingerspitzen ab.</li>\r\n 	<li>Jetzt das Gesäß und den unteren Teil des Rückens anheben, dabei mit den Händen in der Taille abstützen (Ellenbogen bleiben dicht am Körper und Daumen zeigen zum Bauch).</li>\r\n 	<li>Beine gerade ausstrecken, Gesäß einziehen (nicht verzagen, wenn es noch nicht gleich so gerade wird).</li>\r\n 	<li>Nach dem Ausbalancieren mit den Händen an den Rippen abstützen, Zehenspitzen nach oben.</li>\r\n 	<li>Anfangs zehn bis sechzig Sekunden in dieser Stellung bleiben, allmählich bis zu drei Minuten steigern.</li>\r\n</ol>", "KERZE", "", "inherit", "closed", "closed", "", "269-revision-v1", "", "", "2016-06-29 09:34:18", "2016-06-29 07:34:18", "", "269", "http://keep-it-short-and-simple.de/269-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("275", "1", "2016-06-29 09:42:06", "2016-06-29 07:42:06", "<p style=\"text-align: left;\"><strong><img class=\"size-full wp-image-407 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KOBRA-1.png\" alt=\"kobra\" width=\"380\" height=\"191\" />Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>entwickelt die Brustmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li style=\"text-align: left;\">Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li style=\"text-align: left;\">Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li style=\"text-align: left;\">Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li style=\"text-align: left;\">Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li style=\"text-align: left;\">Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li style=\"text-align: left;\">Zweimal wiederholen.</li>\r\n 	<li style=\"text-align: left;\">Während der Übung normal atmen.</li>\r\n</ol>", "kobra", "", "publish", "closed", "closed", "", "kobra", "", "", "2016-07-19 19:27:15", "2016-07-19 17:27:15", "", "0", "http://keep-it-short-and-simple.de/?p=275", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("276", "1", "2016-06-29 09:42:06", "2016-06-29 07:42:06", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "Kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-29 09:42:06", "2016-06-29 07:42:06", "", "275", "http://keep-it-short-and-simple.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("278", "1", "2016-06-29 09:43:41", "2016-06-29 07:43:41", "<strong><img class=\"wp-image-277 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KOBRA-2.png\" alt=\"kobra\" width=\"324\" height=\"176\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>entwickelt die Brusmuskulatur</li>\r\n 	<li>hilft bei Bandscheibenschäden</li>\r\n 	<li>stärkt Bauch- und Rückenmuskulatur</li>\r\n 	<li>festigt und reduziert das Gesäß</li>\r\n 	<li>stärkt das Nerversystem</li>\r\n 	<li>fördert die Verdauung</li>\r\n 	<li>lindert Unterleibsbeschwerden</li>\r\n 	<li>festigt die Kinngegend</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich auf den Bauch, die Beine sind geschlossen.</li>\r\n 	<li>Winkeln Sie die Arme an und stellen die Hände unter die Schultern</li>\r\n 	<li>Heben Sie ganz langsam den Kopf soweit es geht, dann die Schultern (die Bewegung soll von den Rückenmuskeln ausgeführt werden).</li>\r\n 	<li>Den Oberkörper soweit heben, wie Sie können, die Augen fixieren einen Punkt an der Decke.</li>\r\n 	<li>Verharren Sie fünf bis dreißig Sekunden (das Becken bleibt am Boden).</li>\r\n 	<li>Ganz langsam in die Ausgangstellung zurückkehren.</li>\r\n 	<li>Zweimal wiederholen.</li>\r\n 	<li>Während der Übung normal atmen.</li>\r\n</ol>", "Kobra", "", "inherit", "closed", "closed", "", "275-revision-v1", "", "", "2016-06-29 09:43:41", "2016-06-29 07:43:41", "", "275", "http://keep-it-short-and-simple.de/275-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("279", "1", "2016-06-29 09:44:55", "2016-06-29 07:44:55", "<strong><img class=\"size-full wp-image-405 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KOPF.png\" alt=\"KOPF\" width=\"150\" height=\"278\" /></strong>\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.</p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li style=\"text-align: left;\">Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li style=\"text-align: left;\">Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li style=\"text-align: left;\">Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li style=\"text-align: left;\">Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li style=\"text-align: left;\">Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li style=\"text-align: left;\">Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li style=\"text-align: left;\">Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li style=\"text-align: left;\">Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li style=\"text-align: left;\">Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "kopfstand", "", "publish", "closed", "closed", "", "kopfstand", "", "", "2016-07-19 19:23:58", "2016-07-19 17:23:58", "", "0", "http://keep-it-short-and-simple.de/?p=279", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("280", "1", "2016-06-29 09:44:55", "2016-06-29 07:44:55", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li></li>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 09:44:55", "2016-06-29 07:44:55", "", "279", "http://keep-it-short-and-simple.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("282", "1", "2016-06-29 09:45:49", "2016-06-29 07:45:49", "<strong><img class=\"size-full wp-image-281 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KOPF-2.png\" alt=\"kopfstand\" width=\"150\" height=\"278\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li></li>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 09:45:49", "2016-06-29 07:45:49", "", "279", "http://keep-it-short-and-simple.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("284", "1", "2016-06-29 10:14:16", "2016-06-29 08:14:16", "<strong><img class=\"size-full wp-image-281 alignright\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/KOPF-2.png\" alt=\"kopfstand\" width=\"150\" height=\"278\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>Anregung des Kreislaufs durch die umgekehrte Stellung</li>\r\n 	<li>Festigung der Bauchmuskulatur</li>\r\n 	<li>vermittelt Energie</li>\r\n 	<li>hilft bei Schlaflosigkeit, Herzklopfen</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\nWenn Sie hohem Blutdruck haben, bitte vorher Ihren Arzt fragen.\r\n<ol>\r\n 	<li>Achten Sie auf eine richtige Unterlage für Ihren Kopf -Teppich oder vierfach gefaltete Decke.</li>\r\n 	<li>Gehen Sie in den Fersensitz und beugen den Oberkörper nach vorn.</li>\r\n 	<li>Falten Sie Ihre Hände und legen sie auf den Boden, die Ellenbogen sind eine Schulterbreite voneinander entfernt.</li>\r\n 	<li>Legen Sie den Kopf so auf den Boden, daß der ganze Scheitel den Boden berührt.</li>\r\n 	<li>Jetzt die gefalteten Hände an den Kopf heranziehen.</li>\r\n 	<li>Heben Sie Ihr Gesäß, drücken die Knie durch und machen kleine Schritte mit den Fußspitzen in Richtung Kopf (so wird der Rücken gerade).</li>\r\n 	<li>Als Vorübung bis hierher üben und wenn das gut klappt, dann die Beine nach oben bringen, ohne sich abzustoßen, es muß fast von selbst gehen.</li>\r\n 	<li>Beine anwinkeln und an den Körper heranführen, dann langsam nach oben Strecken und ausbalancieren.</li>\r\n 	<li>Verharren Sie anfangs bis fünfzehn Sekunden, später dann bis zu drei Minuten.</li>\r\n 	<li>Übung in umgekehrter Weise beenden.</li>\r\n</ol>", "KOPFSTAND", "", "inherit", "closed", "closed", "", "279-revision-v1", "", "", "2016-06-29 10:14:16", "2016-06-29 08:14:16", "", "279", "http://keep-it-short-and-simple.de/279-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("285", "1", "2016-06-29 10:28:09", "2016-06-29 08:28:09", "&nbsp;\r\n<p style=\"text-align: left;\"><strong><img class=\"size-full wp-image-403 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/NACKEN-1.png\" alt=\"nacken rollen\" width=\"379\" height=\"92\" />Wofür ist das gut?  </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li style=\"text-align: left;\">Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li style=\"text-align: left;\">Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li style=\"text-align: left;\">Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li style=\"text-align: left;\">Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li style=\"text-align: left;\">Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "nacken rollen", "", "publish", "closed", "closed", "", "nacken-rollen", "", "", "2016-07-19 19:23:22", "2016-07-19 17:23:22", "", "0", "http://keep-it-short-and-simple.de/?p=285", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("286", "1", "2016-06-29 10:28:09", "2016-06-29 08:28:09", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-29 10:28:09", "2016-06-29 08:28:09", "", "285", "http://keep-it-short-and-simple.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("288", "1", "2016-06-29 10:29:11", "2016-06-29 08:29:11", "<strong>Wofür ist das gut?\n</strong>\n<ul>\n 	<li>hilft bei Nackenverspannungen</li>\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\n 	<li>reduziert Doppelkinn</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\n 	<li>Die Übung noch dreimal wiederholen.</li>\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-autosave-v1", "", "", "2016-06-29 10:29:11", "2016-06-29 08:29:11", "", "285", "http://keep-it-short-and-simple.de/285-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("289", "1", "2016-06-29 10:30:49", "2016-06-29 08:30:49", "<strong>Wofür ist das gut?  </strong>\r\n<strong><img class=\"wp-image-287 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/NACKEN-2.png\" alt=\"nacken\" width=\"344\" height=\"75\" /></strong>\r\n<ul>\r\n 	<li>hilft bei Nackenverspannungen</li>\r\n 	<li>bringt Erleichterung bei steifem Hals und oft auch bei Kopfschmerzen</li>\r\n 	<li>hilft bei Schlaflosigkeit, fördert Entspannung</li>\r\n 	<li>reduziert Doppelkinn</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich bequem in den Schneidersitz, Schultern zurückgezogen.</li>\r\n 	<li>Lassen Sie ihren Kopf vornüberkippen, daß er locker herunterhängt, verharren.</li>\r\n 	<li>Kopf aufrichten und nach hinten fallen lassen (Mund geschlossen lassen), verharren.</li>\r\n 	<li>Jetzt erst auf die eine, dann auf die andere Seite fallen lassen, dabei nach oben schauen.</li>\r\n 	<li>Anschließend vorsichtig rollen (ohne Unterbrechung), erst in die eine Richtung, dann anders herum.</li>\r\n 	<li>Die Übung noch dreimal wiederholen.</li>\r\n</ol>", "NACKEN ROLLEN", "", "inherit", "closed", "closed", "", "285-revision-v1", "", "", "2016-06-29 10:30:49", "2016-06-29 08:30:49", "", "285", "http://keep-it-short-and-simple.de/285-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("290", "1", "2016-06-29 10:35:10", "2016-06-29 08:35:10", "<p style=\"text-align: left;\"><strong><img class=\"size-full wp-image-401 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"160\" height=\"168\" />   Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li style=\"text-align: left;\">Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li style=\"text-align: left;\">Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li style=\"text-align: left;\">Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li style=\"text-align: left;\">Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li style=\"text-align: left;\">Wenn es unbequem wird, aufhören und (keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li style=\"text-align: left;\">Mit der anderen Seite wiederholen.</li>\r\n</ol>", "perfekter sitz", "", "publish", "closed", "closed", "", "perfekter-sitz", "", "", "2016-07-19 19:22:57", "2016-07-19 17:22:57", "", "0", "http://keep-it-short-and-simple.de/?p=290", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("291", "1", "2016-06-29 10:35:10", "2016-06-29 08:35:10", "<strong>   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Die Füße sollen möglichst in der Spalte, die sich zwischen Oberschenkel und Wade bildet, liegen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 10:35:10", "2016-06-29 08:35:10", "", "290", "http://keep-it-short-and-simple.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("293", "1", "2016-06-29 10:37:13", "2016-06-29 08:37:13", "<strong><img class=\"size-full wp-image-292 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"160\" height=\"168\" />   Wofür ist das gut? </strong>\n<ul>\n 	<li>ideal für längeres Sitzen</li>\n 	<li>entspannt den ganzen Körper</li>\n 	<li>streckt und kräftigt die Beine</li>\n 	<li>wohltuend für Blase und Harnwege</li>\n</ul>\n<strong>Ausführung: </strong>\n<ol>\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\n 	<li>Die Füße sollen möglichst in der Spalte, die sich zwischen Oberschenkel und Wade bildet, liegen.</li>\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\n 	<li>Mit der anderen Seite wiederholen.</li>\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-autosave-v1", "", "", "2016-06-29 10:37:13", "2016-06-29 08:37:13", "", "290", "http://keep-it-short-and-simple.de/290-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("294", "1", "2016-06-29 10:37:37", "2016-06-29 08:37:37", "<strong><img class=\" wp-image-292 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Die Füße sollen möglichst in der Spalte, die sich zwischen Oberschenkel und Wade bildet, liegen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 10:37:37", "2016-06-29 08:37:37", "", "290", "http://keep-it-short-and-simple.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("295", "1", "2016-06-29 10:39:37", "2016-06-29 08:39:37", "<strong><img class=\" wp-image-292 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PERSITZ.png\" alt=\"perfekter sitz\" width=\"173\" height=\"193\" />   Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>ideal für längeres Sitzen</li>\r\n 	<li>entspannt den ganzen Körper</li>\r\n 	<li>streckt und kräftigt die Beine</li>\r\n 	<li>wohltuend für Blase und Harnwege</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Setzen Sie sich mit ausgestreckten, weitgespreizten Beinen auf den Boden.</li>\r\n 	<li>Beugen Sie das rechte Bein und bringen die rechte Fußsohle an die Innenseite des Oberschenkels des linken Beines.</li>\r\n 	<li>Jetzt das linke Bein einknicken, die Zehen mit beiden Händen fassen und den Fuß auf den rechten legen.</li>\r\n 	<li>Wenn das noch nicht geht, die Füße dicht nebeneinander legen.</li>\r\n 	<li>Der Rücken bleibt gerade, die Knie möglichst weit am Boden lassen.</li>\r\n 	<li>Wenn es unbequem wird, aufhören(keine Gewalt anwenden, es dauert oft eine Weile, bis es richtig geht).</li>\r\n 	<li>Mit der anderen Seite wiederholen.</li>\r\n</ol>", "PERFEKTER SITZ", "", "inherit", "closed", "closed", "", "290-revision-v1", "", "", "2016-06-29 10:39:37", "2016-06-29 08:39:37", "", "290", "http://keep-it-short-and-simple.de/290-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("296", "1", "2016-06-29 10:41:59", "2016-06-29 08:41:59", "<img class=\"size-full wp-image-399 aligncenter\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PFLUG-1.png\" alt=\"pflug\" width=\"255\" height=\"156\" />\r\n<p style=\"text-align: left;\"><strong>Wofür ist das gut? </strong></p>\r\n\r\n<ul style=\"text-align: left;\">\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Ausführung: </strong></p>\r\n\r\n<ol>\r\n 	<li style=\"text-align: left;\">Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li style=\"text-align: left;\">Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li style=\"text-align: left;\">Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li style=\"text-align: left;\">Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li style=\"text-align: left;\">nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li style=\"text-align: left;\">Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li style=\"text-align: left;\">Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "pflug", "", "publish", "closed", "closed", "", "pflug", "", "", "2016-07-19 19:22:25", "2016-07-19 17:22:25", "", "0", "http://keep-it-short-and-simple.de/?p=296", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("297", "1", "2016-06-29 10:41:59", "2016-06-29 08:41:59", "<strong>Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf, bis die Fußspitzen den Boden berühren.</li>\r\n 	<li>Etwa zehn Sekunden diese Endstellung beibehalten (auch wenn die Füße den Boden noch nicht berühren).</li>\r\n 	<li>Langsam in umgekehrter Richtung die Übung beenden.</li>\r\n 	<li>nach einer kurzen Pause die Übung wiederholen.</li>\r\n 	<li>Als Variante umfassen die Hände die Fußgelenke und die Beine werden in eine weite Grätschstellung gebracht.</li>\r\n 	<li>Oder die Arme bleiben am Körper anliegend, während die gestreckten Beine hinter dem Kopf (möglichst - es wird immer besser gehen) den Boden berühren.</li>\r\n</ol>", "PFLUG", "", "inherit", "closed", "closed", "", "296-revision-v1", "", "", "2016-06-29 10:41:59", "2016-06-29 08:41:59", "", "296", "http://keep-it-short-and-simple.de/296-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("300", "1", "2016-06-29 10:45:20", "2016-06-29 08:45:20", "<strong><img class=\" wp-image-298 alignleft\" src=\"http://keep-it-short-and-simple.de/wp-content/uploads/2016/06/PFLUG-2.png\" alt=\"pflug\" width=\"239\" height=\"146\" />Wofür ist das gut? </strong>\r\n<ul>\r\n 	<li>macht die Wirbelsäule elastisch</li>\r\n 	<li>regt die Schilddrüse an</li>\r\n 	<li>stärkt und festigt die Bauchmuskulatur</li>\r\n 	<li>trainiert Schenkel und Hüften</li>\r\n 	<li>massiert Bauchorgane (Milz, Leber, Bauchspeicheldrüse, Nieren)</li>\r\n 	<li>Fördert Energie und Vitalität</li>\r\n</ul>\r\n<strong>Ausführung: </strong>\r\n<ol>\r\n 	<li>Legen Sie sich mit nach oben gestreckten Armen auf den Rücken.</li>\r\n 	<li>Heben Sie die gestreckten Beine langsam über den Kopf